/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters;

import java.sql.SQLException;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class OffsetTimeParameter
implements Cloneable,
ParameterHolder {
    private OffsetTime a;
    private boolean b;

    public OffsetTimeParameter(OffsetTime offsetTime, TimeZone timeZone, boolean bl, Options object) {
        object = timeZone == null ? ZoneOffset.systemDefault() : timeZone.toZoneId();
        if (object instanceof ZoneOffset) {
            throw new SQLException("cannot set OffsetTime, since server time zone is set to '" + timeZone.toZoneId().toString() + "' (check server variables time_zone and system_time_zone)");
        }
        this.a = offsetTime.withOffsetSameInstant((ZoneOffset)object);
        this.b = bl;
    }

    @Override
    public void writeTo(PacketOutputStream packetOutputStream) {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.b ? "HH:mm:ss.SSSSSS" : "HH:mm:ss", Locale.ENGLISH);
        packetOutputStream.write(39);
        packetOutputStream.write(dateTimeFormatter.format(this.a).getBytes());
        packetOutputStream.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 15;
    }

    @Override
    public void writeBinary(PacketOutputStream packetOutputStream) {
        if (this.b) {
            packetOutputStream.write(12);
            packetOutputStream.write(0);
            packetOutputStream.writeInt(0);
            packetOutputStream.write((byte)this.a.getHour());
            packetOutputStream.write((byte)this.a.getMinute());
            packetOutputStream.write((byte)this.a.getSecond());
            packetOutputStream.writeInt(this.a.getNano() / 1000);
            return;
        }
        packetOutputStream.write(8);
        packetOutputStream.write(0);
        packetOutputStream.writeInt(0);
        packetOutputStream.write((byte)this.a.getHour());
        packetOutputStream.write((byte)this.a.getMinute());
        packetOutputStream.write((byte)this.a.getSecond());
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.TIME;
    }

    @Override
    public String toString() {
        return "'" + this.a.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

