/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.parameters.ParameterHolder;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;

public class TimestampParameter
implements Cloneable,
ParameterHolder {
    private final Timestamp a;
    private final TimeZone b;
    private final boolean c;

    public TimestampParameter(Timestamp timestamp, TimeZone timeZone, boolean bl) {
        this.a = timestamp;
        this.b = timeZone;
        this.c = bl;
    }

    @Override
    public void writeTo(PacketOutputStream packetOutputStream) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.b != null) {
            simpleDateFormat.setTimeZone(this.b);
        }
        packetOutputStream.write(39);
        packetOutputStream.write(simpleDateFormat.format(this.a).getBytes());
        int n = this.a.getNanos() / 1000;
        if (n > 0 && this.c) {
            packetOutputStream.write(46);
            int n2 = 100000;
            while (n > 0) {
                int n3 = n / n2;
                packetOutputStream.write(n3 + 48);
                n -= n3 * n2;
                n2 /= 10;
            }
        }
        packetOutputStream.write(39);
    }

    @Override
    public int getApproximateTextProtocolLength() {
        return 27;
    }

    @Override
    public void writeBinary(PacketOutputStream packetOutputStream) {
        Calendar calendar = this.b == null ? Calendar.getInstance() : Calendar.getInstance(this.b);
        calendar.setTimeInMillis(this.a.getTime());
        packetOutputStream.write((byte)(this.c ? 11 : 7));
        packetOutputStream.writeShort((short)calendar.get(1));
        packetOutputStream.write((byte)(calendar.get(2) + 1));
        packetOutputStream.write((byte)calendar.get(5));
        packetOutputStream.write((byte)calendar.get(11));
        packetOutputStream.write((byte)calendar.get(12));
        packetOutputStream.write((byte)calendar.get(13));
        if (this.c) {
            packetOutputStream.writeInt(this.a.getNanos() / 1000);
        }
    }

    @Override
    public ColumnType getColumnType() {
        return ColumnType.DATETIME;
    }

    @Override
    public String toString() {
        return "'" + this.a.toString() + "'";
    }

    @Override
    public boolean isNullData() {
        return false;
    }

    @Override
    public boolean canBeLongData() {
        return false;
    }
}

