/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Arrays;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.ColumnType;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.Buffer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.TraceObject;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.PacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.ReadAheadBufferedStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class StandardPacketInputStream
implements PacketInputStream {
    private static final int a = 1024;
    private static final int b = 0xFFFFFF;
    private static final Logger c = LoggerFactory.getLogger(StandardPacketInputStream.class);
    private final byte[] d = new byte[4];
    private final byte[] e = new byte[1024];
    private final InputStream f;
    private final int g;
    private int h;
    private int i;
    private String j = "";
    private long k;
    private LruTraceCache l = null;

    public StandardPacketInputStream(InputStream inputStream, Options options, long l) {
        this.f = options.useReadAheadInput ? new ReadAheadBufferedStream(inputStream) : new BufferedInputStream(inputStream, 16384);
        this.g = options.maxQuerySizeToLog;
        this.k = l;
    }

    public static byte[] create(byte[] byArray) {
        if (byArray == null) {
            return new byte[]{-5};
        }
        int n = byArray.length;
        if (n < 251) {
            byte[] byArray2 = new byte[n + 1];
            byte[] byArray3 = byArray2;
            byArray2[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray3, 1, n);
            return byArray3;
        }
        if (n < 65536) {
            byte[] byArray4 = new byte[n + 3];
            byte[] byArray5 = byArray4;
            byArray4[0] = -4;
            byArray5[1] = (byte)n;
            byArray5[2] = (byte)(n >>> 8);
            System.arraycopy(byArray, 0, byArray5, 3, n);
            return byArray5;
        }
        if (n < 0x1000000) {
            byte[] byArray6 = new byte[n + 4];
            byte[] byArray7 = byArray6;
            byArray6[0] = -3;
            byArray7[1] = (byte)n;
            byArray7[2] = (byte)(n >>> 8);
            byArray7[3] = (byte)(n >>> 16);
            System.arraycopy(byArray, 0, byArray7, 4, n);
            return byArray7;
        }
        byte[] byArray8 = new byte[n + 9];
        byte[] byArray9 = byArray8;
        byArray8[0] = -2;
        byArray9[1] = (byte)n;
        byArray9[2] = (byte)(n >>> 8);
        byArray9[3] = (byte)(n >>> 16);
        byArray9[4] = (byte)(n >>> 24);
        System.arraycopy(byArray, 0, byArray9, 9, n);
        return byArray9;
    }

    public static byte[] create(byte[][] object, ColumnType[] columnTypeArray) {
        int n;
        int n2 = 0;
        Object object2 = object;
        int n3 = ((byte[][])object).length;
        for (int i = 0; i < n3; ++i) {
            byte[] byArray = object2[i];
            if (byArray == null) {
                ++n2;
                continue;
            }
            n = byArray.length;
            if (n < 251) {
                n2 += n + 1;
                continue;
            }
            if (n < 65536) {
                n2 += n + 3;
                continue;
            }
            if (n < 0x1000000) {
                n2 += n + 4;
                continue;
            }
            n2 += n + 9;
        }
        object2 = new byte[n2];
        n3 = 0;
        byte[][] byArray = object;
        int n4 = ((byte[][])object).length;
        for (n = 0; n < n4; ++n) {
            byte[] byArray2 = byArray[n];
            object = byArray2;
            if (byArray2 == null) {
                object2[n3++] = (byte[])-5;
                continue;
            }
            n2 = ((byte[][])object).length;
            if (n2 < 251) {
                object2[n3++] = (byte[])((byte)n2);
            } else if (n2 < 65536) {
                object2[n3++] = (byte[])-4;
                object2[n3++] = (byte[])((byte)n2);
                object2[n3++] = (byte[])((byte)(n2 >>> 8));
            } else if (n2 < 0x1000000) {
                object2[n3++] = (byte[])-3;
                object2[n3++] = (byte[])((byte)n2);
                object2[n3++] = (byte[])((byte)(n2 >>> 8));
                object2[n3++] = (byte[])((byte)(n2 >>> 16));
            } else {
                object2[n3++] = (byte[])-2;
                object2[n3++] = (byte[])((byte)n2);
                object2[n3++] = (byte[])((byte)(n2 >>> 8));
                object2[n3++] = (byte[])((byte)(n2 >>> 16));
                object2[n3++] = (byte[])((byte)(n2 >>> 24));
                n3 += 4;
            }
            System.arraycopy(object, 0, object2, n3, n2);
            n3 += n2;
        }
        return object2;
    }

    @Override
    public Buffer getPacket(boolean bl) {
        return new Buffer(this.getPacketArray(bl), this.i);
    }

    @Override
    public InputStream getInputStream() {
        return this.f;
    }

    @Override
    public byte[] getPacketArray(boolean n) {
        int n2;
        int n3 = 4;
        int n4 = 0;
        do {
            if ((n2 = this.f.read(this.d, n4, n3)) < 0) {
                throw new EOFException("unexpected end of stream, read " + n4 + " bytes from 4 (socket was closed by server)");
            }
            n4 += n2;
        } while ((n3 -= n2) > 0);
        this.i = (this.d[0] & 0xFF) + ((this.d[1] & 0xFF) << 8) + ((this.d[2] & 0xFF) << 16);
        this.h = this.d[3];
        byte[] byArray = n != 0 && this.i < 1024 ? this.e : new byte[this.i];
        n3 = this.i;
        n4 = 0;
        do {
            if ((n = this.f.read(byArray, n4, n3)) < 0) {
                throw new EOFException("unexpected end of stream, read " + (this.i - n3) + " bytes from " + this.i + " (socket was closed by server)");
            }
            n4 += n;
        } while ((n3 -= n) > 0);
        if (this.l != null) {
            this.l.put(new TraceObject(false, 0, this.k, Arrays.copyOfRange(this.d, 0, 4), Arrays.copyOfRange(byArray, 0, n4 > 1000 ? 1000 : n4)));
        }
        if (c.isTraceEnabled()) {
            c.trace("read: {}{}", (Object)this.j, (Object)Utils.hexdump(this.g - 4, 0, this.i, (byte[][])new byte[][]{this.d, byArray}));
        }
        if (this.i == 0xFFFFFF) {
            do {
                int n5;
                int n6;
                n3 = 4;
                n4 = 0;
                do {
                    if ((n6 = this.f.read(this.d, n4, n3)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + n4 + " bytes from 4");
                    }
                    n4 += n6;
                } while ((n3 -= n6) > 0);
                n = (this.d[0] & 0xFF) + ((this.d[1] & 0xFF) << 8) + ((this.d[2] & 0xFF) << 16);
                this.h = this.d[3];
                n6 = byArray.length;
                byte[] byArray2 = new byte[n6 + n];
                System.arraycopy(byArray, 0, byArray2, 0, n6);
                byArray = byArray2;
                n3 = n;
                n4 = n6;
                do {
                    if ((n5 = this.f.read(byArray, n4, n3)) < 0) {
                        throw new EOFException("unexpected end of stream, read " + (n - n3) + " bytes from " + n);
                    }
                    n4 += n5;
                } while ((n3 -= n5) > 0);
                if (this.l != null) {
                    this.l.put(new TraceObject(false, 0, this.k, Arrays.copyOfRange(this.d, 0, 4), Arrays.copyOfRange(byArray, 0, n4 > 1000 ? 1000 : n4)));
                }
                if (c.isTraceEnabled()) {
                    c.trace("read: {}{}", (Object)this.j, (Object)Utils.hexdump(this.g - 4, n6, n, (byte[][])new byte[][]{this.d, byArray}));
                }
                this.i += n;
            } while (n == 0xFFFFFF);
        }
        return byArray;
    }

    @Override
    public int getLastPacketSeq() {
        return this.h;
    }

    @Override
    public int getCompressLastPacketSeq() {
        return 0;
    }

    @Override
    public void close() {
        this.f.close();
    }

    @Override
    public void setServerThreadId(long l, Boolean bl) {
        this.j = "conn=" + l + (bl != null ? "(" + (bl != false ? "M" : "S") + ")" : "");
    }

    @Override
    public void setTraceCache(LruTraceCache lruTraceCache) {
        this.l = lruTraceCache;
    }
}

