/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket;

import com.sun.jna.Platform;
import java.io.IOException;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.NamedPipeSocket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.SharedMemorySocket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.SocketHandlerFunction;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket.UnixDomainSocket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;

public class SocketUtility {
    public static SocketHandlerFunction getSocketHandler() {
        try {
            Platform.getOSType();
            return (options, string) -> {
                if (options.pipe != null) {
                    return new NamedPipeSocket(string, options.pipe);
                }
                if (options.localSocket != null) {
                    try {
                        return new UnixDomainSocket(options.localSocket);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new IOException(runtimeException.getMessage(), runtimeException.getCause());
                    }
                }
                if (options.sharedMemory != null) {
                    try {
                        return new SharedMemorySocket(options.sharedMemory);
                    }
                    catch (RuntimeException runtimeException) {
                        throw new IOException(runtimeException.getMessage(), runtimeException.getCause());
                    }
                }
                return Utils.standardSocket(options, string);
            };
        }
        catch (Throwable throwable) {
            return (options, string) -> Utils.standardSocket(options, string);
        }
    }
}

