/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.socket;

import com.sun.jna.LastErrorException;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Structure;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class UnixDomainSocket
extends Socket {
    private static final int a = 1;
    private static final int b;
    private static final int c = 0;
    private final AtomicBoolean d = new AtomicBoolean();
    private final SockAddr e;
    private final int f;
    private InputStream g;
    private OutputStream h;
    private boolean i;

    public UnixDomainSocket(String string) {
        if (Platform.isWindows() || Platform.isWindowsCE()) {
            throw new IOException("Unix domain sockets are not supported on Windows");
        }
        this.e = new SockAddr(string);
        this.d.set(false);
        try {
            this.f = UnixDomainSocket.socket(1, b, 0);
            return;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("native socket() failed : " + UnixDomainSocket.b(lastErrorException));
        }
    }

    public static native int socket(int var0, int var1, int var2);

    public static native int connect(int var0, SockAddr var1, int var2);

    public static native int recv(int var0, byte[] var1, int var2, int var3);

    public static native int send(int var0, byte[] var1, int var2, int var3);

    public static native int close(int var0);

    public static native String strerror(int var0);

    private static String b(LastErrorException lastErrorException) {
        try {
            return UnixDomainSocket.strerror(lastErrorException.getErrorCode());
        }
        catch (Throwable throwable) {
            return lastErrorException.getMessage();
        }
    }

    @Override
    public boolean isConnected() {
        return this.i;
    }

    @Override
    public void close() {
        if (!this.d.getAndSet(true)) {
            try {
                UnixDomainSocket.close(this.f);
            }
            catch (LastErrorException lastErrorException) {
                throw new IOException("native close() failed : " + UnixDomainSocket.b(lastErrorException));
            }
            this.i = false;
        }
    }

    @Override
    public void connect(SocketAddress socketAddress) {
        this.connect(socketAddress, 0);
    }

    @Override
    public void connect(SocketAddress socketAddress, int n) {
        try {
            int n2 = UnixDomainSocket.connect(this.f, this.e, this.e.size());
            if (n2 != 0) {
                throw new IOException(UnixDomainSocket.strerror(Native.getLastError()));
            }
            this.i = true;
        }
        catch (LastErrorException lastErrorException) {
            throw new IOException("native connect() failed : " + UnixDomainSocket.b(lastErrorException));
        }
        this.g = new UnixSocketInputStream();
        this.h = new UnixSocketOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.g;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.h;
    }

    @Override
    public void setTcpNoDelay(boolean bl) {
    }

    @Override
    public void setKeepAlive(boolean bl) {
    }

    @Override
    public void setReceiveBufferSize(int n) {
    }

    @Override
    public void setSendBufferSize(int n) {
    }

    @Override
    public void setSoLinger(boolean bl, int n) {
    }

    @Override
    public void setSoTimeout(int n) {
    }

    @Override
    public void shutdownInput() {
    }

    @Override
    public void shutdownOutput() {
    }

    static {
        int n = b = Platform.isSolaris() ? 2 : 1;
        if (Platform.isSolaris()) {
            System.loadLibrary("nsl");
            System.loadLibrary("socket");
        }
        if (!Platform.isWindows() && !Platform.isWindowsCE()) {
            Native.register((String)"c");
        }
    }

    class UnixSocketOutputStream
    extends OutputStream {
        UnixSocketOutputStream() {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            try {
                int n3;
                if (n > 0) {
                    int n4 = n2;
                    byte[] byArray2 = new byte[n2 < 10240 ? n2 : 10240];
                    do {
                        n3 = n4 < 10240 ? n4 : 10240;
                        System.arraycopy(byArray, n, byArray2, 0, n3);
                        n3 = UnixDomainSocket.send(UnixDomainSocket.this.f, byArray2, n3, 0);
                        if (n3 <= 0) continue;
                        n += n3;
                        n4 -= n3;
                    } while (n4 > 0 && n3 > 0);
                } else {
                    n3 = UnixDomainSocket.send(UnixDomainSocket.this.f, byArray, n2, 0);
                }
                if (n3 != n2) {
                    throw new IOException("can't write " + n2 + "bytes");
                }
                return;
            }
            catch (LastErrorException lastErrorException) {
                throw new IOException("native write() failed : " + UnixDomainSocket.b(lastErrorException));
            }
        }

        @Override
        public void write(int n) {
            this.write(new byte[]{(byte)n});
        }

        @Override
        public void write(byte[] byArray) {
            this.write(byArray, 0, byArray.length);
        }
    }

    class UnixSocketInputStream
    extends InputStream {
        UnixSocketInputStream() {
        }

        @Override
        public int read(byte[] byArray, int n, int n2) {
            try {
                if (n > 0) {
                    int n3 = 0;
                    int n4 = n2;
                    byte[] byArray2 = new byte[n2 < 10240 ? n2 : 10240];
                    do {
                        if ((n2 = UnixDomainSocket.recv(UnixDomainSocket.this.f, byArray2, n4 < 10240 ? n4 : 10240, 0)) <= 0) continue;
                        System.arraycopy(byArray2, 0, byArray, n, n2);
                        n3 += n2;
                        n += n2;
                        n4 -= n2;
                    } while (n4 > 0 && n2 > 0);
                    return n3;
                }
                return UnixDomainSocket.recv(UnixDomainSocket.this.f, byArray, n2, 0);
            }
            catch (LastErrorException lastErrorException) {
                throw new IOException("native read() failed : " + UnixDomainSocket.b(lastErrorException));
            }
        }

        @Override
        public int read() {
            byte[] byArray = new byte[1];
            int n = this.read(byArray);
            if (n == 0) {
                return -1;
            }
            return byArray[0] & 0xFF;
        }

        @Override
        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }
    }

    public static class SockAddr
    extends Structure {
        public short sun_family = 1;
        public byte[] sun_path;

        public SockAddr(String object) {
            object = ((String)object).getBytes();
            this.sun_path = new byte[((Object)object).length + 1];
            System.arraycopy(object, 0, this.sun_path, 0, Math.min(this.sun_path.length - 1, ((Object)object).length));
            this.allocateMemory();
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("sun_family", "sun_path");
        }
    }
}

