/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.HostAddress;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.authentication.AuthenticationPluginLoader;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.Credential;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.credential.CredentialPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.Buffer;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.ErrorPacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.ReadInitialHandShakePacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.read.dao.Results;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.SendClosePacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.SendHandshakeResponsePacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.SendSslConnectionRequestPacket;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.com.send.authentication.OldPasswordPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.failover.FailoverProxy;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.LruTraceCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.DecompressPacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.PacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.input.StandardPacketInputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.CompressPacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.PacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.io.output.StandardPacketOutputStream;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.MasterProtocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.ServerPrepareStatementCache;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.constant.HaMode;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.tls.TlsSocketPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.tls.TlsSocketPluginLoader;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public abstract class AbstractConnectProtocol
implements Protocol {
    private static final byte[] a = "SELECT @@max_allowed_packet,@@system_time_zone,@@time_zone,@@auto_increment_increment".getBytes(StandardCharsets.UTF_8);
    private static final byte[] b = "select @@innodb_read_only".getBytes(StandardCharsets.UTF_8);
    protected static final String CHECK_GALERA_STATE_QUERY = "show status like 'wsrep_local_state'";
    private static final Logger c = LoggerFactory.getLogger(AbstractConnectProtocol.class);
    protected final ReentrantLock lock;
    protected final UrlParser urlParser;
    protected final Options options;
    protected final LruTraceCache traceCache;
    private final String d;
    private final GlobalStateInfo e;
    public boolean hasWarnings = false;
    public Results activeStreamingResult = null;
    public short serverStatus;
    protected int autoIncrementIncrement;
    protected Socket socket;
    protected PacketOutputStream writer;
    protected boolean readOnly = false;
    protected PacketInputStream reader;
    protected FailoverProxy proxy;
    protected volatile boolean connected = false;
    protected boolean explicitClosed = false;
    protected String database;
    protected long serverThreadId;
    protected ServerPrepareStatementCache serverPrepareStatementCache;
    protected boolean eofDeprecated = false;
    protected long serverCapabilities;
    protected int socketTimeout;
    protected ExceptionFactory exceptionFactory;
    protected final List<String> galeraAllowedStates;
    private HostAddress f;
    private boolean g;
    private String h;
    private boolean i;
    private int j;
    private int k;
    private int l;
    private TimeZone m;

    public AbstractConnectProtocol(UrlParser urlParser, GlobalStateInfo globalStateInfo, ReentrantLock reentrantLock, LruTraceCache lruTraceCache) {
        urlParser.auroraPipelineQuirks();
        this.lock = reentrantLock;
        this.urlParser = urlParser;
        this.options = urlParser.getOptions();
        this.database = urlParser.getDatabase() == null ? "" : urlParser.getDatabase();
        this.d = urlParser.getUsername() == null ? "" : urlParser.getUsername();
        this.e = globalStateInfo;
        if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
            this.serverPrepareStatementCache = ServerPrepareStatementCache.newInstance(this.options.prepStmtCacheSize, this);
        }
        this.galeraAllowedStates = urlParser.getOptions().galeraAllowedState == null ? Collections.emptyList() : Arrays.asList(urlParser.getOptions().galeraAllowedState.split(","));
        this.traceCache = lruTraceCache;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void a(PacketInputStream packetInputStream, PacketOutputStream packetOutputStream, Socket socket) {
        try {
            try {
                long l = System.currentTimeMillis() + 10L;
                socket.shutdownOutput();
                socket.setSoTimeout(3);
                InputStream inputStream = socket.getInputStream();
                while (inputStream.read() != -1 && System.currentTimeMillis() < l) {
                }
            }
            catch (Throwable throwable) {}
            packetOutputStream.close();
            packetInputStream.close();
        }
        catch (IOException iOException) {
            try {
                socket.close();
                return;
            }
            catch (IOException iOException2) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                socket.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            socket.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static Socket a(String string, int n, Options options) {
        try {
            InetSocketAddress inetSocketAddress;
            Socket socket = Utils.createSocket(options, string);
            socket.setTcpNoDelay(options.tcpNoDelay);
            if (options.socketTimeout != null) {
                socket.setSoTimeout(options.socketTimeout);
            }
            if (options.tcpKeepAlive) {
                socket.setKeepAlive(true);
            }
            if (options.tcpRcvBuf != null) {
                socket.setReceiveBufferSize(options.tcpRcvBuf);
            }
            if (options.tcpSndBuf != null) {
                socket.setSendBufferSize(options.tcpSndBuf);
            }
            if (options.tcpAbortiveClose) {
                socket.setSoLinger(true, 0);
            }
            if (options.localSocketAddress != null) {
                inetSocketAddress = new InetSocketAddress(options.localSocketAddress, 0);
                socket.bind(inetSocketAddress);
            }
            if (!socket.isConnected()) {
                inetSocketAddress = options.pipe == null ? new InetSocketAddress(string, n) : null;
                socket.connect(inetSocketAddress, options.connectTimeout);
            }
            return socket;
        }
        catch (IOException iOException) {
            throw ExceptionFactory.INSTANCE.create(String.format("Socket fail to connect to host:%s, port:%s. %s", string, n, iOException.getMessage()), "08000", iOException);
        }
    }

    private static long a(Options options, long l, String string) {
        long l2 = 12493568L;
        if (options.allowLocalInfile) {
            l2 = 12493696L;
        }
        if (!options.useAffectedRows) {
            l2 |= 2L;
        }
        if (options.allowMultiQueries || options.rewriteBatchedStatements) {
            l2 |= 0x10000L;
        }
        if ((l & 0x1000000L) != 0L) {
            l2 |= 0x1000000L;
        }
        if (options.useBulkStmts && (l & 0x400000000L) != 0L) {
            l2 |= 0x400000000L;
        }
        if (options.useCompression) {
            if ((l & 0x20L) == 0L) {
                options.useCompression = false;
            } else {
                l2 |= 0x20L;
            }
        }
        if (options.interactiveClient) {
            l2 |= 0x400L;
        }
        if (!string.isEmpty() && !options.createDatabaseIfNotExist) {
            l2 |= 8L;
        }
        return l2;
    }

    private static void a(SSLSocket sSLSocket, Options stringArray) {
        if (stringArray.enabledSslProtocolSuites != null) {
            List<String> list = Arrays.asList(sSLSocket.getSupportedProtocols());
            String[] stringArray2 = stringArray = stringArray.enabledSslProtocolSuites.split("[,;\\s]+");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                if (list.contains(string)) continue;
                throw new SQLException("Unsupported SSL protocol '" + string + "'. Supported protocols : " + list.toString().replace("[", "").replace("]", ""));
            }
            sSLSocket.setEnabledProtocols(stringArray);
        }
    }

    private static void b(SSLSocket sSLSocket, Options stringArray) {
        if (stringArray.enabledSslCipherSuites != null) {
            List<String> list = Arrays.asList(sSLSocket.getSupportedCipherSuites());
            String[] stringArray2 = stringArray = stringArray.enabledSslCipherSuites.split("[,;\\s]+");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray2[i];
                if (list.contains(string)) continue;
                throw new SQLException("Unsupported SSL cipher '" + string + "'. Supported ciphers : " + list.toString().replace("[", "").replace("]", ""));
            }
            sSLSocket.setEnabledCipherSuites(stringArray);
        }
    }

    @Override
    public void close() {
        boolean bl = false;
        if (this.lock != null) {
            bl = this.lock.tryLock();
        }
        this.connected = false;
        try {
            this.skip();
        }
        catch (Exception exception) {}
        SendClosePacket.send(this.writer);
        AbstractConnectProtocol.a(this.reader, this.writer, this.socket);
        this.c();
        if (bl) {
            this.lock.unlock();
        }
    }

    @Override
    public void abort() {
        this.explicitClosed = true;
        boolean bl = false;
        if (this.lock != null) {
            bl = this.lock.tryLock();
        }
        this.connected = false;
        Object object = this;
        try {
            if (((AbstractConnectProtocol)object).activeStreamingResult != null) {
                ((AbstractConnectProtocol)object).activeStreamingResult.abort();
                ((AbstractConnectProtocol)object).activeStreamingResult = null;
            }
        }
        catch (Exception exception) {}
        if (!bl) {
            object = this;
            try {
                Throwable throwable = null;
                try (MasterProtocol masterProtocol = new MasterProtocol(((AbstractConnectProtocol)object).urlParser, new GlobalStateInfo(), new ReentrantLock(), ((AbstractConnectProtocol)object).traceCache);){
                    masterProtocol.setHostAddress(((AbstractConnectProtocol)object).getHostAddress());
                    masterProtocol.connect();
                    masterProtocol.executeQuery("KILL " + ((AbstractConnectProtocol)object).serverThreadId);
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
            }
            catch (SQLException sQLException) {}
            try {
                this.socket.setSoTimeout(10);
                this.socket.setSoLinger(true, 0);
            }
            catch (IOException iOException) {}
        } else {
            SendClosePacket.send(this.writer);
        }
        AbstractConnectProtocol.a(this.reader, this.writer, this.socket);
        this.c();
        if (bl) {
            this.lock.unlock();
        }
    }

    private void a() {
        try {
            Throwable throwable = null;
            try (MasterProtocol masterProtocol = new MasterProtocol(this.urlParser, new GlobalStateInfo(), new ReentrantLock(), this.traceCache);){
                masterProtocol.setHostAddress(this.getHostAddress());
                masterProtocol.connect();
                masterProtocol.executeQuery("KILL " + this.serverThreadId);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
        }
        catch (SQLException sQLException) {}
    }

    private void b() {
        try {
            if (this.activeStreamingResult != null) {
                this.activeStreamingResult.abort();
                this.activeStreamingResult = null;
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void skip() {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.loadFully(true, this);
            this.activeStreamingResult = null;
        }
    }

    private void c() {
        if (this.options.cachePrepStmts && this.options.useServerPrepStmts) {
            this.serverPrepareStatementCache.clear();
        }
        if (this.options.enablePacketDebug) {
            this.traceCache.clearMemory();
        }
    }

    @Override
    public void setServerStatus(short s) {
        this.serverStatus = s;
    }

    @Override
    public void removeHasMoreResults() {
        if (this.hasMoreResults()) {
            this.serverStatus = (short)(this.serverStatus ^ 8);
        }
    }

    @Override
    public void connect() {
        try {
            AbstractConnectProtocol abstractConnectProtocol = this;
            abstractConnectProtocol.a(abstractConnectProtocol.f, this.d);
            return;
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s", this.f, sQLException.getMessage() + this.getTraces()), "08000", sQLException);
        }
    }

    private void a(HostAddress object, String object2) {
        String string = object != null ? ((HostAddress)object).host : null;
        int n = object != null ? ((HostAddress)object).port : 3306;
        CredentialPlugin credentialPlugin = this.urlParser.getCredentialPlugin();
        object = credentialPlugin != null ? (Credential)credentialPlugin.initialize(this.options, (String)object2, (HostAddress)object).get() : new Credential((String)object2, this.urlParser.getPassword());
        this.socket = AbstractConnectProtocol.a(string, n, this.options);
        AbstractConnectProtocol abstractConnectProtocol = this;
        abstractConnectProtocol.a(abstractConnectProtocol.socket, this.options);
        try {
            object2 = new ReadInitialHandShakePacket(this.reader);
            this.serverThreadId = ((ReadInitialHandShakePacket)object2).getServerThreadId();
            this.h = ((ReadInitialHandShakePacket)object2).getServerVersion();
            this.i = ((ReadInitialHandShakePacket)object2).isServerMariaDb();
            this.serverCapabilities = ((ReadInitialHandShakePacket)object2).getServerCapabilities();
            this.reader.setServerThreadId(this.serverThreadId, null);
            this.writer.setServerThreadId(this.serverThreadId, null);
            this.c(((ReadInitialHandShakePacket)object2).getServerVersion());
            n = this.a(((ReadInitialHandShakePacket)object2).getServerLanguage() & 0xFF);
            long l = AbstractConnectProtocol.a(this.options, this.serverCapabilities, this.database);
            this.exceptionFactory = ExceptionFactory.of(this.serverThreadId, this.options);
            this.a(string, this.socket, this.options, ((ReadInitialHandShakePacket)object2).getServerCapabilities(), l, (byte)n, this.serverThreadId);
            String string2 = ((ReadInitialHandShakePacket)object2).getAuthenticationPluginType();
            if (credentialPlugin != null && credentialPlugin.defaultAuthenticationPluginType() != null) {
                string2 = credentialPlugin.defaultAuthenticationPluginType();
            }
            this.a((byte)n, l, string2, ((ReadInitialHandShakePacket)object2).getSeed(), this.options, this.database, (Credential)object, string);
            AbstractConnectProtocol abstractConnectProtocol2 = this;
            abstractConnectProtocol2.a(abstractConnectProtocol2.options);
        }
        catch (IOException iOException) {
            this.destroySocket();
            if (string == null) {
                throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to socket : %s", iOException.getMessage()), "08000", iOException);
            }
            throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s:%s : %s", string, this.socket.getPort(), iOException.getMessage()), "08000", iOException);
        }
        catch (SQLException sQLException) {
            this.destroySocket();
            throw sQLException;
        }
        this.connected = true;
        this.reader.setServerThreadId(this.serverThreadId, this.isMasterConnection());
        this.writer.setServerThreadId(this.serverThreadId, this.isMasterConnection());
        if (this.options.socketTimeout != null) {
            this.socketTimeout = this.options.socketTimeout;
        }
        if ((this.serverCapabilities & 0x1000000L) != 0L) {
            this.eofDeprecated = true;
        }
        this.e();
        if (this.isMasterConnection() && !this.galeraAllowedStates.isEmpty()) {
            this.d();
        }
        this.activeStreamingResult = null;
        this.g = false;
    }

    public void destroySocket() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {}
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {}
        }
        if (this.socket != null) {
            try {
                this.socket.close();
                return;
            }
            catch (IOException iOException) {}
        }
    }

    private void a(String string, Socket socket, Options options, long l, long l2, byte by, long l3) {
        if (Boolean.TRUE.equals(options.useSsl)) {
            if ((l & 0x800L) == 0L) {
                throw this.exceptionFactory.create("Trying to connect with ssl, but ssl not enabled in the server", "08000");
            }
            SendSslConnectionRequestPacket.send(this.writer, l2 |= 0x800L, by);
            TlsSocketPlugin tlsSocketPlugin = TlsSocketPluginLoader.get(options.tlsSocketType);
            Object object = tlsSocketPlugin.getSocketFactory(options);
            socket = tlsSocketPlugin.createSocket(socket, (SSLSocketFactory)object);
            AbstractConnectProtocol.a((SSLSocket)socket, options);
            AbstractConnectProtocol.b((SSLSocket)socket, options);
            ((SSLSocket)socket).setUseClientMode(true);
            ((SSLSocket)socket).startHandshake();
            if (!options.disableSslHostnameVerification && !options.trustServerCertificate) {
                object = ((SSLSocket)socket).getSession();
                try {
                    tlsSocketPlugin.verify(string, (SSLSession)object, options, l3);
                }
                catch (SSLException sSLException) {
                    throw this.exceptionFactory.create("SSL hostname verification failed : " + sSLException.getMessage() + "\nThis verification can be disabled using the option \"disableSslHostnameVerification\" but won't prevent man-in-the-middle attacks anymore", "08006");
                }
            }
            this.a(socket, options);
        }
    }

    private void a(byte by, long l, String string, byte[] byArray, Options options, String string2, Credential credential, String string3) {
        SendHandshakeResponsePacket.send(this.writer, credential, string3, string2, l, this.serverCapabilities, by, (byte)(Boolean.TRUE.equals(options.useSsl) ? 2 : 1), options, string, byArray);
        this.writer.permitTrace(false);
        Object object = this.reader.getPacket(false);
        AtomicInteger atomicInteger = new AtomicInteger(this.reader.getLastPacketSeq());
        block5: while (true) {
            switch (((Buffer)object).getByteAt(0) & 0xFF) {
                case 254: {
                    Object object2;
                    atomicInteger.set(this.reader.getLastPacketSeq());
                    if ((this.serverCapabilities & 0x80000L) != 0L) {
                        ((Buffer)object).readByte();
                        if (((Buffer)object).remaining() > 0) {
                            object2 = ((Buffer)object).readStringNullEnd(StandardCharsets.US_ASCII);
                            Object object3 = object;
                            byArray = ((Buffer)object3).readRawBytes(((Buffer)object3).remaining());
                        } else {
                            object2 = "mysql_old_password";
                            byArray = Utils.copyWithLength(byArray, 8);
                        }
                        object = AuthenticationPluginLoader.get((String)object2);
                    } else {
                        object = new OldPasswordPlugin();
                        byArray = Utils.copyWithLength(byArray, 8);
                    }
                    if (object.mustUseSsl() && options.useSsl == null) {
                        throw this.exceptionFactory.create("Connector use a plugin that require SSL without enabling ssl. For compatibility, this can still be disabled explicitly forcing 'useSsl=false' in connection string.plugin is = " + object.type(), "08004", 1251);
                    }
                    object.initialize(credential.getPassword(), byArray, options);
                    object = object.process(this.writer, this.reader, atomicInteger);
                    continue block5;
                }
                case 255: {
                    Object object2 = new ErrorPacket((Buffer)object);
                    if (credential.getPassword() != null && !credential.getPassword().isEmpty() && options.passwordCharacterEncoding == null && ((ErrorPacket)object2).getErrorCode() == 1045 && "28000".equals(((ErrorPacket)object2).getSqlState())) {
                        throw this.exceptionFactory.create(String.format("%s\nCurrent charset is %s. If password has been set using other charset, consider using option 'passwordCharacterEncoding'", ((ErrorPacket)object2).getMessage(), Charset.defaultCharset().displayName()), ((ErrorPacket)object2).getSqlState(), ((ErrorPacket)object2).getErrorCode());
                    }
                    throw this.exceptionFactory.create(((ErrorPacket)object2).getMessage(), ((ErrorPacket)object2).getSqlState(), ((ErrorPacket)object2).getErrorCode());
                }
                case 0: {
                    ((Buffer)object).skipByte();
                    ((Buffer)object).skipLengthEncodedNumeric();
                    ((Buffer)object).skipLengthEncodedNumeric();
                    this.serverStatus = ((Buffer)object).readShort();
                    break block5;
                }
                default: {
                    throw this.exceptionFactory.create("unexpected data during authentication (header=" + (((Buffer)object).getByteAt(0) & 0xFF), "08000");
                }
            }
            break;
        }
        this.writer.permitTrace(true);
    }

    private void a(Options options) {
        if (options.useCompression) {
            this.writer = new CompressPacketOutputStream(this.writer.getOutputStream(), options.maxQuerySizeToLog, this.serverThreadId);
            this.reader = new DecompressPacketInputStream(((StandardPacketInputStream)this.reader).getInputStream(), options.maxQuerySizeToLog, this.serverThreadId);
            if (options.enablePacketDebug) {
                this.writer.setTraceCache(this.traceCache);
                this.reader.setTraceCache(this.traceCache);
            }
        }
    }

    private void a(Socket socket, Options options) {
        try {
            this.writer = new StandardPacketOutputStream(socket.getOutputStream(), options, this.serverThreadId);
            this.reader = new StandardPacketInputStream(socket.getInputStream(), options, this.serverThreadId);
            if (options.enablePacketDebug) {
                this.writer.setTraceCache(this.traceCache);
                this.reader.setTraceCache(this.traceCache);
            }
            return;
        }
        catch (IOException iOException) {
            this.destroySocket();
            throw ExceptionFactory.INSTANCE.create("Socket error: " + iOException.getMessage(), "08000", iOException);
        }
    }

    private void d() {
        Object object;
        try {
            object = new Results();
            this.executeQuery(true, (Results)object, CHECK_GALERA_STATE_QUERY);
            ((Results)object).commandEnd();
            object = ((Results)object).getResultSet();
        }
        catch (SQLException sQLException) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create("fail to validate Galera state");
        }
        if (object == null || !object.next()) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create("fail to validate Galera state");
        }
        if (!this.galeraAllowedStates.contains(object.getString(2))) {
            throw ExceptionFactory.of((int)this.serverThreadId, this.options).create(String.format("fail to validate Galera state (State is %s)", object.getString(2)));
        }
    }

    private void e() {
        try {
            block18: {
                block17: {
                    if (this.options.usePipelineAuth.booleanValue() && (this.options.socketTimeout == null || this.options.socketTimeout == 0 || this.options.socketTimeout > 500)) {
                        this.socket.setSoTimeout(500);
                    }
                    boolean bl = true;
                    if (this.e != null && this.e.isAutocommit() == this.options.autocommit) {
                        bl = false;
                    }
                    if (bl) {
                        TreeMap<String, String> treeMap = new TreeMap<String, String>();
                        if (this.options.usePipelineAuth.booleanValue() && !this.options.createDatabaseIfNotExist) {
                            try {
                                this.f();
                                this.b(treeMap);
                            }
                            catch (SQLException sQLException) {
                                SQLException sQLException2 = sQLException;
                                if (sQLException.getSQLState() != null && sQLException2.getSQLState().startsWith("08")) {
                                    throw sQLException2;
                                }
                                this.d(treeMap);
                            }
                        } else {
                            this.d(treeMap);
                        }
                        this.writer.setMaxAllowedPacket(Integer.parseInt((String)treeMap.get("max_allowed_packet")));
                        this.autoIncrementIncrement = Integer.parseInt((String)treeMap.get("auto_increment_increment"));
                        this.a((String)treeMap.get("time_zone"), (String)treeMap.get("system_time_zone"));
                    } else {
                        this.writer.setMaxAllowedPacket((int)this.e.getMaxAllowedPacket());
                        this.autoIncrementIncrement = this.e.getAutoIncrementIncrement();
                        AbstractConnectProtocol abstractConnectProtocol = this;
                        abstractConnectProtocol.a(abstractConnectProtocol.e.getTimeZone(), this.e.getSystemTimeZone());
                    }
                    this.reader.setServerThreadId(this.serverThreadId, this.isMasterConnection());
                    this.writer.setServerThreadId(this.serverThreadId, this.isMasterConnection());
                    this.activeStreamingResult = null;
                    this.g = false;
                    if (!this.options.usePipelineAuth.booleanValue()) break block17;
                    if (this.options.socketTimeout != null) break block18;
                    this.socket.setSoTimeout(0);
                }
                return;
            }
            this.socket.setSoTimeout(this.options.socketTimeout);
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.destroySocket();
            String string = "Socket error during post connection queries: " + socketTimeoutException.getMessage();
            if (this.options.usePipelineAuth.booleanValue()) {
                string = string + "\nServer might not support pipelining, try disabling with option `usePipelineAuth` and `useBatchMultiSend`";
            }
            throw this.exceptionFactory.create(string, "08000", socketTimeoutException);
        }
        catch (IOException iOException) {
            this.destroySocket();
            throw this.exceptionFactory.create("Socket error during post connection queries: " + iOException.getMessage(), "08000", iOException);
        }
        catch (SQLException sQLException) {
            this.destroySocket();
            throw sQLException;
        }
    }

    private void f() {
        this.g();
        this.h();
        this.i();
    }

    private void g() {
        StringBuilder stringBuilder = new StringBuilder("autocommit=").append(this.options.autocommit ? "1" : "0");
        if ((this.serverCapabilities & 0x800000L) != 0L) {
            if (this.options.trackSchema) {
                stringBuilder.append(", session_track_schema=1");
            }
            if (this.options.rewriteBatchedStatements) {
                stringBuilder.append(", session_track_system_variables='auto_increment_increment' ");
            }
        }
        if (this.options.jdbcCompliantTruncation) {
            stringBuilder.append(", sql_mode = concat(@@sql_mode,',STRICT_TRANS_TABLES')");
        }
        if (this.options.sessionVariables != null && !this.options.sessionVariables.isEmpty()) {
            stringBuilder.append(",").append(Utils.parseSessionVariables(this.options.sessionVariables));
        }
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("set " + stringBuilder.toString());
        this.writer.flush();
    }

    private void h() {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write(a);
        this.writer.flush();
    }

    private void a(Map<String, String> map) {
        Object object = new Results();
        this.getResult((Results)object);
        ((Results)object).commandEnd();
        object = ((Results)object).getResultSet();
        if (object != null) {
            object.next();
            map.put("max_allowed_packet", object.getString(1));
            map.put("system_time_zone", object.getString(2));
            map.put("time_zone", object.getString(3));
            map.put("auto_increment_increment", object.getString(4));
            return;
        }
        throw this.exceptionFactory.create("Error reading SessionVariables results. Socket is connected ? " + this.socket.isConnected(), "08000");
    }

    private void a(String string) {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("CREATE DATABASE IF NOT EXISTS " + string);
        this.writer.flush();
    }

    private void b(String string) {
        this.writer.startPacket(0);
        this.writer.write(3);
        this.writer.write("USE " + string);
        this.writer.flush();
    }

    private void b(Map<String, String> map) {
        boolean bl;
        SQLException sQLException;
        block10: {
            block9: {
                sQLException = null;
                try {
                    this.getResult(new Results());
                }
                catch (SQLException sQLException2) {
                    SQLException sQLException3 = sQLException2;
                    sQLException = sQLException2;
                }
                bl = false;
                try {
                    this.a(map);
                }
                catch (SQLException sQLException4) {
                    if (sQLException != null && sQLException.getSQLState() != null && !sQLException.getSQLState().startsWith("08") && sQLException4.getSQLState() != null && sQLException4.getSQLState().startsWith("08")) {
                        throw new SQLException(sQLException.getMessage(), "08000", sQLException.getErrorCode(), sQLException);
                    }
                    if (sQLException != null) break block9;
                    sQLException = this.exceptionFactory.create("could not load system variables", "08000", sQLException4);
                    bl = true;
                }
            }
            try {
                this.readPipelineCheckMaster();
            }
            catch (SQLException sQLException5) {
                bl = false;
                if (sQLException != null) break block10;
                throw this.exceptionFactory.create("could not identified if server is master", "08000", sQLException5);
            }
        }
        if (bl) {
            this.c(map);
            this.connected = true;
            return;
        }
        if (sQLException != null) {
            throw sQLException;
        }
        this.connected = true;
    }

    private void c(Map<String, String> map) {
        try {
            Object object = new Results();
            this.executeQuery(true, (Results)object, "SHOW VARIABLES WHERE Variable_name in ('max_allowed_packet','system_time_zone','time_zone','auto_increment_increment')");
            ((Results)object).commandEnd();
            object = ((Results)object).getResultSet();
            if (object != null) {
                while (object.next()) {
                    if (c.isDebugEnabled()) {
                        c.debug("server data {} = {}", (Object)object.getString(1), (Object)object.getString(2));
                    }
                    map.put(object.getString(1), object.getString(2));
                }
                if (map.size() < 4) {
                    throw this.exceptionFactory.create("could not load system variables. socket connected: " + this.socket.isConnected(), "08000");
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            throw this.exceptionFactory.create("could not load system variables", "08000", sQLException);
        }
    }

    private void d(Map<String, String> object) {
        this.g();
        this.getResult(new Results());
        try {
            this.h();
            this.a((Map<String, String>)object);
        }
        catch (SQLException sQLException) {
            this.c((Map<String, String>)object);
        }
        this.i();
        this.readPipelineCheckMaster();
        if (this.options.createDatabaseIfNotExist && !this.database.isEmpty()) {
            object = MariaDbConnection.quoteIdentifier(this.database);
            this.a((String)object);
            this.getResult(new Results());
            this.b((String)object);
            this.getResult(new Results());
        }
    }

    @Override
    public boolean isClosed() {
        return !this.connected;
    }

    private void a(String string, String string2) {
        if (this.options.useLegacyDatetimeCode) {
            this.m = null;
            return;
        }
        String string3 = this.options.serverTimezone;
        if (string3 == null && "SYSTEM".equals(string3 = string)) {
            string3 = string2;
        }
        if (string3 != null && string3.length() >= 2 && (string3.startsWith("+") || string3.startsWith("-")) && Character.isDigit(string3.charAt(1))) {
            string3 = "GMT" + string3;
        }
        try {
            this.m = Utils.getTimeZone(string3);
            if (this.m.equals(TimeZone.getDefault())) {
                this.m = null;
            }
            return;
        }
        catch (SQLException sQLException) {
            if (this.options.serverTimezone != null) {
                throw this.exceptionFactory.create("The server time_zone '" + string3 + "' defined in the 'serverTimezone' parameter cannot be parsed by java TimeZone implementation. See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
            }
            throw this.exceptionFactory.create("The server time_zone '" + string3 + "' cannot be parsed. The server time zone must defined in the jdbc url string with the 'serverTimezone' parameter (or server time zone must be defined explicitly with sessionVariables=time_zone='Canada/Atlantic' for example).  See java.util.TimeZone#getAvailableIDs() for available TimeZone, depending on your JRE implementation.", "01S00");
        }
    }

    @Override
    public boolean checkIfMaster() {
        return this.isMasterConnection();
    }

    private byte a(int n) {
        if (n == 45 || n == 46 || n >= 224 && n <= 247) {
            return (byte)n;
        }
        if (this.getMajorServerVersion() == 5 && this.getMinorServerVersion() <= 1) {
            return 33;
        }
        if (n == 33) {
            return 45;
        }
        if (n == 83) {
            return 46;
        }
        if (n >= 192 && n <= 215) {
            return (byte)(n + 32);
        }
        return -32;
    }

    @Override
    public void readEofPacket() {
        Object object = this.reader.getPacket(true);
        switch (((Buffer)object).getByteAt(0)) {
            case -2: {
                ((Buffer)object).skipByte();
                this.hasWarnings = ((Buffer)object).readShort() > 0;
                this.serverStatus = ((Buffer)object).readShort();
                return;
            }
            case -1: {
                object = new ErrorPacket((Buffer)object);
                throw this.exceptionFactory.create("Could not connect: " + ((ErrorPacket)object).getMessage(), ((ErrorPacket)object).getSqlState(), ((ErrorPacket)object).getErrorCode());
            }
        }
        throw this.exceptionFactory.create("Unexpected packet type " + ((Buffer)object).getByteAt(0) + " instead of EOF", "08000");
    }

    @Override
    public void skipEofPacket() {
        Object object = this.reader.getPacket(true);
        switch (((Buffer)object).getByteAt(0)) {
            case -2: {
                return;
            }
            case -1: {
                object = new ErrorPacket((Buffer)object);
                throw this.exceptionFactory.create("Could not connect: " + ((ErrorPacket)object).getMessage(), ((ErrorPacket)object).getSqlState(), ((ErrorPacket)object).getErrorCode());
            }
        }
        throw this.exceptionFactory.create("Unexpected packet type " + ((Buffer)object).getByteAt(0) + " instead of EOF");
    }

    @Override
    public void setHostFailedWithoutProxy() {
        this.g = true;
        this.close();
    }

    @Override
    public UrlParser getUrlParser() {
        return this.urlParser;
    }

    @Override
    public boolean isMasterConnection() {
        return this.f == null || "master".equals(this.f.type);
    }

    private void i() {
        if (this.urlParser.getHaMode() == HaMode.AURORA) {
            this.writer.startPacket(0);
            this.writer.write(3);
            this.writer.write(b);
            this.writer.flush();
        }
    }

    public void readPipelineCheckMaster() {
    }

    @Override
    public boolean mustBeMasterConnection() {
        return true;
    }

    @Override
    public boolean noBackslashEscapes() {
        return (this.serverStatus & 0x200) != 0;
    }

    @Override
    public void connectWithoutProxy() {
        if (!this.isClosed()) {
            this.close();
        }
        List<HostAddress> list = this.urlParser.getHostAddresses();
        LinkedList<HostAddress> linkedList = new LinkedList<HostAddress>(list);
        if (this.urlParser.getHaMode().equals((Object)HaMode.LOADBALANCE)) {
            Collections.shuffle(linkedList);
        }
        if (linkedList.isEmpty()) {
            if (this.options.pipe != null) {
                try {
                    this.a((HostAddress)null, this.d);
                    return;
                }
                catch (SQLException sQLException) {
                    throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to named pipe '%s' : %s%s", this.options.pipe, sQLException.getMessage(), this.getTraces()), "08000", sQLException);
                }
            }
            throw ExceptionFactory.INSTANCE.create("No host is defined and pipe option is not set. Check if connection string respect format (jdbc:(mysql|mariadb):[replication:|loadbalance:|sequential:|aurora:]//<hostDescription>[,<hostDescription>...]/[database][?<key1>=<value1>[&<key2>=<value2>]])", "08000");
        }
        while (!linkedList.isEmpty()) {
            this.f = linkedList.poll();
            try {
                AbstractConnectProtocol abstractConnectProtocol = this;
                abstractConnectProtocol.a(abstractConnectProtocol.f, this.d);
                return;
            }
            catch (SQLException sQLException) {
                if (!linkedList.isEmpty()) continue;
                if (sQLException.getSQLState() != null) {
                    throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s : %s%s", HostAddress.toString(list), sQLException.getMessage(), this.getTraces()), sQLException.getSQLState(), sQLException.getErrorCode(), sQLException);
                }
                throw ExceptionFactory.INSTANCE.create(String.format("Could not connect to %s. %s%s", this.f, sQLException.getMessage(), this.getTraces()), "08000", sQLException);
            }
        }
    }

    @Override
    public boolean shouldReconnectWithoutProxy() {
        return (this.serverStatus & 1) == 0 && this.g && this.urlParser.getOptions().autoReconnect;
    }

    @Override
    public String getServerVersion() {
        return this.h;
    }

    @Override
    public boolean getReadonly() {
        return this.readOnly;
    }

    @Override
    public HostAddress getHostAddress() {
        return this.f;
    }

    @Override
    public void setHostAddress(HostAddress hostAddress) {
        this.f = hostAddress;
        this.readOnly = "replica".equals(this.f.type);
    }

    @Override
    public String getHost() {
        if (this.f == null) {
            return null;
        }
        return this.f.host;
    }

    @Override
    public FailoverProxy getProxy() {
        return this.proxy;
    }

    @Override
    public void setProxy(FailoverProxy failoverProxy) {
        this.proxy = failoverProxy;
    }

    @Override
    public int getPort() {
        if (this.f == null) {
            return 3306;
        }
        return this.f.port;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public String getUsername() {
        return this.d;
    }

    private void c(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '0' || c > '9') {
                switch (n2) {
                    case 0: {
                        this.j = n3;
                        break;
                    }
                    case 1: {
                        this.k = n3;
                        break;
                    }
                    case 2: {
                        this.l = n3;
                        return;
                    }
                }
                ++n2;
                n3 = 0;
                continue;
            }
            n3 = n3 * 10 + c - 48;
        }
        if (n2 == 2) {
            this.l = n3;
        }
    }

    @Override
    public int getMajorServerVersion() {
        return this.j;
    }

    @Override
    public int getMinorServerVersion() {
        return this.k;
    }

    @Override
    public boolean versionGreaterOrEqual(int n, int n2, int n3) {
        if (this.j > n) {
            return true;
        }
        if (this.j < n) {
            return false;
        }
        if (this.k > n2) {
            return true;
        }
        if (this.k < n2) {
            return false;
        }
        return this.l >= n3;
    }

    @Override
    public boolean getPinGlobalTxToPhysicalConnection() {
        return this.options.pinGlobalTxToPhysicalConnection;
    }

    @Override
    public boolean hasWarnings() {
        this.lock.lock();
        try {
            boolean bl = this.hasWarnings;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean isConnected() {
        this.lock.lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getServerThreadId() {
        return this.serverThreadId;
    }

    @Override
    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public boolean isExplicitClosed() {
        return this.explicitClosed;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.m;
    }

    @Override
    public Options getOptions() {
        return this.options;
    }

    @Override
    public void setHasWarnings(boolean bl) {
        this.hasWarnings = bl;
    }

    @Override
    public Results getActiveStreamingResult() {
        return this.activeStreamingResult;
    }

    @Override
    public void setActiveStreamingResult(Results results) {
        this.activeStreamingResult = results;
    }

    @Override
    public void removeActiveStreamingResult() {
        if (this.activeStreamingResult != null) {
            this.activeStreamingResult.removeFetchSize();
            this.activeStreamingResult = null;
        }
    }

    @Override
    public ReentrantLock getLock() {
        return this.lock;
    }

    @Override
    public boolean hasMoreResults() {
        return (this.serverStatus & 8) != 0;
    }

    @Override
    public ServerPrepareStatementCache prepareStatementCache() {
        return this.serverPrepareStatementCache;
    }

    @Override
    public abstract void executeQuery(String var1);

    @Override
    public void changeSocketTcpNoDelay(boolean bl) {
        try {
            this.socket.setTcpNoDelay(bl);
            return;
        }
        catch (SocketException socketException) {
            return;
        }
    }

    @Override
    public void changeSocketSoTimeout(int n) {
        this.socketTimeout = n;
        this.socket.setSoTimeout(this.socketTimeout);
    }

    @Override
    public boolean isServerMariaDb() {
        return this.i;
    }

    @Override
    public PacketInputStream getReader() {
        return this.reader;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public boolean sessionStateAware() {
        return (this.serverCapabilities & 0x800000L) != 0L;
    }

    @Override
    public String getTraces() {
        if (this.options.enablePacketDebug) {
            return this.traceCache.printStack();
        }
        return "";
    }
}

