/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls.HostnameVerifierImpl;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls.MariaDbX509KeyManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls.MariaDbX509TrustManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.tls.TlsSocketPlugin;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class DefaultTlsSocketPlugin
implements TlsSocketPlugin {
    private static final Logger a = LoggerFactory.getLogger(DefaultTlsSocketPlugin.class);

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyManager a(String string, String object, String string2, String object2) {
        InputStream inputStream = null;
        try {
            object = object == null ? null : ((String)object).toCharArray();
            try {
                inputStream = new URL(string).openStream();
            }
            catch (IOException iOException) {
                inputStream = new FileInputStream(string);
            }
            object2 = KeyStore.getInstance((String)(object2 != null ? object2 : KeyStore.getDefaultType()));
            ((KeyStore)object2).load(inputStream, (char[])object);
            object = string2 == null ? object : (Object)string2.toCharArray();
            object = new MariaDbX509KeyManager((KeyStore)object2, (char[])object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            try {
                throw ExceptionFactory.INSTANCE.create("Failed to create keyStore instance", "08000", generalSecurityException);
                catch (FileNotFoundException fileNotFoundException) {
                    throw ExceptionFactory.INSTANCE.create("Failed to find keyStore file. Option keyStore=" + string, "08000", fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw ExceptionFactory.INSTANCE.create("Failed to read keyStore file. Option keyStore=" + string, "08000", iOException);
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (inputStream == null) return object;
            inputStream.close();
            return object;
        }
        catch (IOException iOException) {}
        return object;
    }

    @Override
    public String name() {
        return "Default TLS socket factory";
    }

    @Override
    public String type() {
        return "DEFAULT";
    }

    @Override
    public SSLSocketFactory getSocketFactory(Options options) {
        Object object;
        TrustManager[] trustManagerArray = null;
        KeyManager[] keyManagerArray = null;
        if (options.trustServerCertificate || options.serverSslCert != null || options.trustStore != null) {
            trustManagerArray = new X509TrustManager[]{new MariaDbX509TrustManager(options)};
        }
        if (options.keyStore != null) {
            keyManagerArray = new KeyManager[]{DefaultTlsSocketPlugin.a(options.keyStore, options.keyStorePassword, options.keyPassword, options.keyStoreType)};
        } else {
            object = System.getProperty("javax.net.ssl.keyStore");
            String string = System.getProperty("javax.net.ssl.keyStorePassword");
            if (object != null) {
                try {
                    KeyManager[] keyManagerArray2 = new KeyManager[1];
                    String string2 = string;
                    keyManagerArray2[0] = DefaultTlsSocketPlugin.a((String)object, string2, string2, options.keyStoreType);
                    keyManagerArray = keyManagerArray2;
                }
                catch (SQLException sQLException) {
                    keyManagerArray = null;
                    a.error("Error loading keymanager from system properties", sQLException);
                }
            }
        }
        try {
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, null);
            return ((SSLContext)object).getSocketFactory();
        }
        catch (KeyManagementException keyManagementException) {
            throw ExceptionFactory.INSTANCE.create("Could not initialize SSL context", "08000", keyManagementException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw ExceptionFactory.INSTANCE.create("SSLContext TLS Algorithm not unknown", "08000", noSuchAlgorithmException);
        }
    }

    @Override
    public void verify(String string, SSLSession object, Options object2, long l) {
        object2 = new HostnameVerifierImpl();
        if (!((HostnameVerifierImpl)object2).verify(string, (SSLSession)object, l)) {
            object = object.getPeerCertificates();
            object = (X509Certificate)object[0];
            ((HostnameVerifierImpl)object2).verify(string, (X509Certificate)object, l);
        }
    }
}

