/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.tls;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.UUID;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.SqlStates;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class MariaDbX509TrustManager
implements X509TrustManager {
    private X509TrustManager a;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MariaDbX509TrustManager(Options object) {
        Object object2;
        KeyStore keyStore;
        block31: {
            if (object.trustServerCertificate) {
                return;
            }
            try {
                keyStore = KeyStore.getInstance(object.trustStoreType != null ? object.trustStoreType : KeyStore.getDefaultType());
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new SQLException("Failed to create keystore instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityException);
            }
            InputStream inputStream = null;
            try {
                if (object.trustStore != null) {
                    try {
                        object2 = object.trustStore;
                        try {
                            inputStream = new URL((String)object2).openStream();
                        }
                        catch (IOException iOException) {
                            inputStream = new FileInputStream((String)object2);
                        }
                        keyStore.load(inputStream, object.trustStorePassword == null ? null : object.trustStorePassword.toCharArray());
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new SQLException("Failed to create trustStore instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityException);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new SQLException("Failed to find trustStore file. trustStore=" + object.trustStore, SqlStates.CONNECTION_EXCEPTION.getSqlState(), fileNotFoundException);
                    }
                    catch (IOException iOException) {
                        throw new SQLException("Failed to read trustStore file. trustStore=" + object.trustStore, SqlStates.CONNECTION_EXCEPTION.getSqlState(), iOException);
                    }
                }
                if (object.serverSslCert.startsWith("-----BEGIN CERTIFICATE-----")) {
                    inputStream = new ByteArrayInputStream(object.serverSslCert.getBytes());
                } else if (object.serverSslCert.startsWith("classpath:")) {
                    object2 = object.serverSslCert.substring(10);
                    inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream((String)object2);
                } else {
                    try {
                        inputStream = new FileInputStream(object.serverSslCert);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new SQLException("Failed to find serverSslCert file. serverSslCert=" + object.serverSslCert, SqlStates.CONNECTION_EXCEPTION.getSqlState(), fileNotFoundException);
                    }
                }
                try {
                    keyStore.load(null);
                    object2 = CertificateFactory.getInstance("X.509");
                    object = ((CertificateFactory)object2).generateCertificates(inputStream);
                    for (Certificate certificate : object) {
                        keyStore.setCertificateEntry(UUID.randomUUID().toString(), certificate);
                    }
                }
                catch (IOException iOException) {
                    throw new SQLException("Failed load keyStore", SqlStates.CONNECTION_EXCEPTION.getSqlState(), iOException);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SQLException("Failed to store certificate from serverSslCert into a keyStore", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityException);
                }
                if (inputStream == null) break block31;
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        try {
            void var5_20;
            object2 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            ((TrustManagerFactory)object2).init(keyStore);
            object = ((TrustManagerFactory)object2).getTrustManagers();
            int n = ((TrustManager[])object).length;
            boolean bl = false;
            while (var5_20 < n) {
                TrustManager trustManager = object[var5_20];
                if (trustManager instanceof X509TrustManager) {
                    this.a = (X509TrustManager)trustManager;
                    break;
                }
                ++var5_20;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SQLException("Failed to create TrustManagerFactory default instance", SqlStates.CONNECTION_EXCEPTION.getSqlState(), noSuchAlgorithmException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SQLException("Failed to initialize trust manager", SqlStates.CONNECTION_EXCEPTION.getSqlState(), generalSecurityException);
        }
        if (this.a != null) return;
        throw new SQLException("No X509TrustManager found");
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.a == null) {
            return;
        }
        this.a.checkClientTrusted(x509CertificateArray, string);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
        if (this.a == null) {
            return;
        }
        this.a.checkServerTrusted(x509CertificateArray, string);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return null;
    }
}

