/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool;

import java.lang.management.ManagementFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.MariaDbPooledConnection;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.Logger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.logging.LoggerFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.protocol.Protocol;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.Utils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.exceptions.ExceptionFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.GlobalStateInfo;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.PoolMBean;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.Pools;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.MariaDbThreadFactory;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.util.Options;

public class Pool
implements AutoCloseable,
PoolMBean {
    private static final Logger a = LoggerFactory.getLogger(Pool.class);
    private static final int b = 0;
    private static final int c = 1;
    private final AtomicInteger d = new AtomicInteger();
    private final UrlParser e;
    private final Options f;
    private final AtomicInteger g = new AtomicInteger();
    private final AtomicInteger h = new AtomicInteger();
    private final LinkedBlockingDeque<MariaDbPooledConnection> i;
    private final ThreadPoolExecutor j;
    private final BlockingQueue<Runnable> k;
    private final String l;
    private final ScheduledThreadPoolExecutor m;
    private final ScheduledFuture n;
    private GlobalStateInfo o;
    private int p;
    private long q;
    private long r;

    public Pool(UrlParser object, int n, ScheduledThreadPoolExecutor object2) {
        this.e = object;
        this.f = ((UrlParser)object).getOptions();
        this.p = this.f.maxIdleTime;
        object = this;
        if (((Pool)object).f.poolName == null) {
            ((Pool)object).f.poolName = "MariaDB-pool";
        }
        ((Pool)object).l = ((Pool)object).f.poolName + "-" + n;
        this.k = new ArrayBlockingQueue<Runnable>(this.f.maxPoolSize);
        this.j = new ThreadPoolExecutor(1, 1, 10L, TimeUnit.SECONDS, this.k, new MariaDbThreadFactory(this.l + "-appender"));
        this.j.allowCoreThreadTimeOut(true);
        this.j.prestartCoreThread();
        this.i = new LinkedBlockingDeque();
        int n2 = Math.min(30, this.p / 2);
        this.m = object2;
        this.n = ((ScheduledThreadPoolExecutor)object2).scheduleAtFixedRate(this::c, n2, n2, TimeUnit.SECONDS);
        if (this.f.registerJmxPool) {
            try {
                Pool pool = this;
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                object2 = pool.l.replace(":", "_");
                object2 = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.pool:type=" + (String)object2);
                if (!mBeanServer.isRegistered((ObjectName)object2)) {
                    mBeanServer.registerMBean(pool, (ObjectName)object2);
                }
            }
            catch (Exception exception) {
                a.error("pool " + this.l + " not registered due to exception : " + exception.getMessage());
            }
        }
        try {
            for (int i = 0; i < this.f.minPoolSize; ++i) {
                this.d();
            }
            return;
        }
        catch (SQLException sQLException) {
            a.error("error initializing pool connection", sQLException);
            return;
        }
    }

    private void b() {
        if (this.h.get() < this.f.maxPoolSize && this.d.get() == 0) {
            this.j.prestartCoreThread();
            this.k.offer(() -> {
                if ((this.h.get() < this.f.minPoolSize || this.g.get() > 0) && this.h.get() < this.f.maxPoolSize) {
                    try {
                        this.d();
                        return;
                    }
                    catch (SQLException sQLException) {}
                }
            });
        }
    }

    private void c() {
        Iterator<MariaDbPooledConnection> iterator = this.i.descendingIterator();
        while (iterator.hasNext()) {
            MariaDbPooledConnection mariaDbPooledConnection = iterator.next();
            long l = System.nanoTime() - mariaDbPooledConnection.getLastUsed().get();
            boolean bl = l > TimeUnit.SECONDS.toNanos(this.p);
            boolean bl2 = false;
            if (this.o != null) {
                if (l > TimeUnit.SECONDS.toNanos(this.o.getWaitTimeout() - 45)) {
                    bl2 = true;
                }
                if (bl && this.h.get() > this.f.minPoolSize) {
                    bl2 = true;
                }
            } else if (bl) {
                bl2 = true;
            }
            if (!bl2 || !this.i.remove(mariaDbPooledConnection)) continue;
            this.h.decrementAndGet();
            Pool.a(mariaDbPooledConnection);
            this.b();
            if (!a.isDebugEnabled()) continue;
            a.debug("pool {} connection removed due to inactivity (total:{}, active:{}, pending:{})", this.l, this.h.get(), this.getActiveConnections(), this.g.get());
        }
    }

    private void d() {
        Object object = Utils.retrieveProxy(this.e, this.o);
        object = new MariaDbConnection((Protocol)object);
        MariaDbPooledConnection mariaDbPooledConnection = this.a((MariaDbConnection)object);
        if (this.f.staticGlobal) {
            if (this.o == null) {
                this.b((MariaDbConnection)object);
            }
            ((MariaDbConnection)object).setDefaultTransactionIsolation(this.o.getDefaultTransactionIsolation());
        } else {
            Object object2 = object;
            ((MariaDbConnection)object2).setDefaultTransactionIsolation(((MariaDbConnection)object2).getTransactionIsolation());
        }
        if (this.d.get() == 0 && this.h.incrementAndGet() <= this.f.maxPoolSize) {
            this.i.addFirst(mariaDbPooledConnection);
            if (a.isDebugEnabled()) {
                a.debug("pool {} new physical connection created (total:{}, active:{}, pending:{})", this.l, this.h.get(), this.getActiveConnections(), this.g.get());
            }
            return;
        }
        Pool.a(mariaDbPooledConnection);
    }

    private MariaDbPooledConnection e() {
        return this.a(0L, TimeUnit.NANOSECONDS);
    }

    private MariaDbPooledConnection a(long l, TimeUnit timeUnit) {
        Object object;
        while ((object = l == 0L ? this.i.pollFirst() : this.i.pollFirst(l, timeUnit)) != null) {
            Object object2;
            block7: {
                object2 = ((MariaDbPooledConnection)object).getConnection();
                try {
                    if (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - ((MariaDbPooledConnection)object).getLastUsed().get()) > (long)this.f.poolValidMinDelay) {
                        if (((MariaDbConnection)object2).isValid(10)) {
                            ((MariaDbPooledConnection)object).lastUsedToNow();
                            return object;
                        }
                        break block7;
                    }
                    ((MariaDbPooledConnection)object).lastUsedToNow();
                    return object;
                }
                catch (SQLException sQLException) {}
            }
            this.h.decrementAndGet();
            object2 = object;
            object = this;
            try {
                ((MariaDbPooledConnection)object2).abort(((Pool)object).m);
            }
            catch (SQLException sQLException) {}
            this.b();
            if (!a.isDebugEnabled()) continue;
            a.debug("pool {} connection removed from pool due to failed validation (total:{}, active:{}, pending:{})", this.l, this.h.get(), this.getActiveConnections(), this.g.get());
        }
        return null;
    }

    private static void a(MariaDbPooledConnection mariaDbPooledConnection) {
        try {
            mariaDbPooledConnection.close();
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private void b(MariaDbPooledConnection mariaDbPooledConnection) {
        try {
            mariaDbPooledConnection.abort(this.m);
            return;
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private MariaDbPooledConnection a(MariaDbConnection object) {
        object = new MariaDbPooledConnection((MariaDbConnection)object);
        ((MariaDbPooledConnection)object).addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent object) {
                object = (MariaDbPooledConnection)((EventObject)object).getSource();
                if (Pool.this.d.get() == 0) {
                    try {
                        if (!Pool.this.i.contains(object)) {
                            ((MariaDbPooledConnection)object).getConnection().reset();
                            Pool.this.i.addFirst(object);
                        }
                        return;
                    }
                    catch (SQLException sQLException) {
                        Pool.this.h.decrementAndGet();
                        Pool.a((MariaDbPooledConnection)object);
                        a.debug("connection removed from pool {} due to error during reset", (Object)Pool.this.l);
                        return;
                    }
                }
                try {
                    ((MariaDbPooledConnection)object).close();
                }
                catch (SQLException sQLException) {}
                Pool.this.h.decrementAndGet();
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent object) {
                object = (MariaDbPooledConnection)((EventObject)object).getSource();
                if (Pool.this.i.remove(object)) {
                    Pool.this.h.decrementAndGet();
                }
                Pool.a((MariaDbPooledConnection)object);
                Pool.this.b();
                a.debug("connection {} removed from pool {} due to having throw a Connection exception (total:{}, active:{}, pending:{})", ((MariaDbPooledConnection)object).getConnection().getServerThreadId(), Pool.this.l, Pool.this.h.get(), Pool.this.getActiveConnections(), Pool.this.g.get());
            }
        });
        return object;
    }

    public MariaDbConnection getConnection() {
        this.g.incrementAndGet();
        try {
            Pool pool = this;
            Object object = pool.a(pool.h.get() > 4 ? 0L : 50L, TimeUnit.MICROSECONDS);
            if (object != null) {
                object = ((MariaDbPooledConnection)object).getConnection();
                return object;
            }
            this.b();
            object = this.a(TimeUnit.MILLISECONDS.toNanos(this.f.connectTimeout), TimeUnit.NANOSECONDS);
            if (object != null) {
                object = ((MariaDbPooledConnection)object).getConnection();
                return object;
            }
            try {
                throw ExceptionFactory.INSTANCE.create(String.format("No connection available within the specified time (option 'connectTimeout': %s ms)", NumberFormat.getInstance().format(this.f.connectTimeout)));
            }
            catch (InterruptedException interruptedException) {
                throw ExceptionFactory.INSTANCE.create("Thread was interrupted", "70100", interruptedException);
            }
        }
        finally {
            this.g.decrementAndGet();
        }
    }

    public MariaDbConnection getConnection(String object, String string) {
        try {
            if ((this.e.getUsername() != null ? this.e.getUsername().equals(object) : object == null) && (this.e.getPassword() != null ? this.e.getPassword().equals(string) : string == null)) {
                return this.getConnection();
            }
            UrlParser urlParser = (UrlParser)this.e.clone();
            urlParser.setUsername((String)object);
            urlParser.setPassword(string);
            object = Utils.retrieveProxy(urlParser, this.o);
            return new MariaDbConnection((Protocol)object);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new SQLException("Error getting connection, parameters cannot be cloned", cloneNotSupportedException);
        }
    }

    private String a(int n) {
        if (this.f.poolName == null) {
            this.f.poolName = "MariaDB-pool";
        }
        return this.f.poolName + "-" + n;
    }

    public UrlParser getUrlParser() {
        return this.e;
    }

    @Override
    public void close() {
        Pool pool = this;
        synchronized (pool) {
            Pools.remove(this);
            this.d.set(1);
            this.g.set(0);
            this.n.cancel(false);
            this.j.shutdown();
            try {
                this.j.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {}
            if (a.isInfoEnabled()) {
                a.info("closing pool {} (total:{}, active:{}, pending:{})", this.l, this.h.get(), this.getActiveConnections(), this.g.get());
            }
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.h.get(), this.f.maxPoolSize, 10L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(this.f.maxPoolSize), new MariaDbThreadFactory(this.l + "-destroyer"));
            long l = System.nanoTime();
            do {
                this.a(threadPoolExecutor, this.i);
                if (this.h.get() <= 0) continue;
                Thread.sleep(0L, 1000);
            } while (this.h.get() > 0 && TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - l) < 10L);
            if (this.h.get() > 0 || this.i.isEmpty()) {
                this.a(threadPoolExecutor, this.i);
            }
            threadPoolExecutor.shutdown();
            try {
                Object object = this;
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                object = ((Pool)object).l.replace(":", "_");
                object = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.pool:type=" + (String)object);
                if (mBeanServer.isRegistered((ObjectName)object)) {
                    mBeanServer.unregisterMBean((ObjectName)object);
                }
            }
            catch (Exception exception) {}
            threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            return;
        }
    }

    private void a(ExecutorService executorService, Collection<MariaDbPooledConnection> collection) {
        Collection<MariaDbPooledConnection> collection2 = collection;
        synchronized (collection2) {
            for (MariaDbPooledConnection mariaDbPooledConnection : collection) {
                collection.remove(mariaDbPooledConnection);
                this.h.decrementAndGet();
                try {
                    mariaDbPooledConnection.abort(executorService);
                }
                catch (SQLException sQLException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void b(MariaDbConnection object) {
        Statement statement;
        block23: {
            statement = ((MariaDbConnection)object).createStatement();
            Throwable throwable = null;
            try {
                int n;
                Object object2 = "SELECT @@max_allowed_packet,@@wait_timeout,@@autocommit,@@auto_increment_increment,@@time_zone,@@system_time_zone,@@tx_isolation";
                if (!((MariaDbConnection)object).isServerMariaDb() && ((n = ((MariaDbConnection)object).getMetaData().getDatabaseMajorVersion()) >= 8 && ((MariaDbConnection)object).versionGreaterOrEqual(8, 0, 3) || n < 8 && ((MariaDbConnection)object).versionGreaterOrEqual(5, 7, 20))) {
                    object2 = "SELECT @@max_allowed_packet,@@wait_timeout,@@autocommit,@@auto_increment_increment,@@time_zone,@@system_time_zone,@@transaction_isolation";
                }
                ResultSet resultSet = statement.executeQuery((String)object2);
                object = null;
                try {
                    resultSet.next();
                    int n2 = Utils.transactionFromString(resultSet.getString(7));
                    this.o = new GlobalStateInfo(resultSet.getLong(1), resultSet.getInt(2), resultSet.getBoolean(3), resultSet.getInt(4), resultSet.getString(5), resultSet.getString(6), n2);
                    this.p = Math.min(this.f.maxIdleTime, this.o.getWaitTimeout() - 45);
                }
                catch (Throwable throwable2) {
                    object2 = throwable2;
                    object = throwable2;
                    throw object2;
                }
                finally {
                    if (resultSet != null) {
                        if (object != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable3) {
                                ((Throwable)object).addSuppressed(throwable3);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
                if (statement == null) return;
                if (throwable == null) break block23;
            }
            catch (Throwable throwable3) {
                try {
                    Throwable throwable6 = throwable3;
                    throwable = throwable3;
                    throw throwable6;
                }
                catch (Throwable throwable7) {
                    if (statement == null) throw throwable7;
                    if (throwable == null) {
                        statement.close();
                        throw throwable7;
                    }
                    try {
                        statement.close();
                        throw throwable7;
                    }
                    catch (Throwable throwable8) {
                        throwable.addSuppressed(throwable8);
                        throw throwable7;
                    }
                }
            }
            try {
                statement.close();
                return;
            }
            catch (Throwable throwable4) {
                throwable.addSuppressed(throwable4);
                return;
            }
        }
        statement.close();
    }

    public String getPoolTag() {
        return this.l;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (Pool)object;
        return this.l.equals(((Pool)object).l);
    }

    public int hashCode() {
        return this.l.hashCode();
    }

    public GlobalStateInfo getGlobalInfo() {
        return this.o;
    }

    @Override
    public long getActiveConnections() {
        return this.h.get() - this.i.size();
    }

    @Override
    public long getTotalConnections() {
        return this.h.get();
    }

    @Override
    public long getIdleConnections() {
        return this.i.size();
    }

    @Override
    public long getConnectionRequests() {
        return this.g.get();
    }

    private void f() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Object object = this.l.replace(":", "_");
        if (!mBeanServer.isRegistered((ObjectName)(object = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.pool:type=" + (String)object)))) {
            mBeanServer.registerMBean(this, (ObjectName)object);
        }
    }

    private void g() {
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        Object object = this.l.replace(":", "_");
        if (mBeanServer.isRegistered((ObjectName)(object = new ObjectName("us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.pool:type=" + (String)object)))) {
            mBeanServer.unregisterMBean((ObjectName)object);
        }
    }

    public List<Long> testGetConnectionIdleThreadIds() {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (MariaDbPooledConnection mariaDbPooledConnection : this.i) {
            arrayList.add(mariaDbPooledConnection.getConnection().getServerThreadId());
        }
        return arrayList;
    }

    @Override
    public void resetStaticGlobal() {
        this.o = null;
    }
}

