/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.UrlParser;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.pool.Pool;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.mariadb.internal.util.scheduler.MariaDbThreadFactory;

public class Pools {
    private static final AtomicInteger a = new AtomicInteger();
    private static final Map<UrlParser, Pool> b = new ConcurrentHashMap<UrlParser, Pool>();
    private static ScheduledThreadPoolExecutor c = null;

    public static Pool retrievePool(UrlParser urlParser) {
        if (!b.containsKey(urlParser)) {
            Map<UrlParser, Pool> map = b;
            synchronized (map) {
                if (!b.containsKey(urlParser)) {
                    if (c == null) {
                        c = new ScheduledThreadPoolExecutor(1, new MariaDbThreadFactory("MariaDbPool-maxTimeoutIdle-checker"));
                    }
                    Pool pool = new Pool(urlParser, a.incrementAndGet(), c);
                    b.put(urlParser, pool);
                    return pool;
                }
            }
        }
        return b.get(urlParser);
    }

    public static void remove(Pool pool) {
        if (b.containsKey(pool.getUrlParser())) {
            Map<UrlParser, Pool> map = b;
            synchronized (map) {
                if (b.containsKey(pool.getUrlParser())) {
                    b.remove(pool.getUrlParser());
                    if (b.isEmpty()) {
                        Pools.a();
                    }
                }
                return;
            }
        }
    }

    public static void close() {
        Map<UrlParser, Pool> map = b;
        synchronized (map) {
            for (Pool pool : b.values()) {
                try {
                    pool.close();
                }
                catch (InterruptedException interruptedException) {}
            }
            Pools.a();
            b.clear();
            return;
        }
    }

    public static void close(String string) {
        if (string == null) {
            return;
        }
        Map<UrlParser, Pool> map = b;
        synchronized (map) {
            for (Pool pool : b.values()) {
                if (!string.equals(pool.getUrlParser().getOptions().poolName)) continue;
                try {
                    pool.close();
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
            return;
        }
    }

    private static void a() {
        c.shutdown();
        try {
            c.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
        c = null;
    }
}

