/*
 * Decompiled with CFR 0.152.
 */
package us.lynuxcraft.deadsilenceiv.advancedchests.utils.storage;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.PluginBase;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.FileUtils;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.Pair;
import us.lynuxcraft.deadsilenceiv.advancedchests.utils.storage.YamlDataStorage;

public abstract class YamlDataFolder<I>
implements YamlDataStorage {
    protected PluginBase plugin;
    protected File folder;
    protected Map<I, Pair<File, YamlConfiguration>> data;

    public YamlDataFolder(PluginBase pluginBase, String string, Runnable runnable) {
        this.plugin = pluginBase;
        this.data = new HashMap<I, Pair<File, YamlConfiguration>>();
        this.folder = new File(pluginBase.getDataFolder().getPath() + File.separator + string);
        if (!this.folder.exists()) {
            this.folder.mkdirs();
            runnable.run();
        }
        this.a();
    }

    public YamlDataFolder(PluginBase pluginBase, String string) {
        this(pluginBase, string, null);
    }

    public abstract I getIdentifier(File var1);

    private void a() {
        File[] fileArray = this.folder.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (!FileUtils.getFileExtension(file.getName()).equals(".yml")) continue;
                I i = this.getIdentifier(file);
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
                this.data.put(i, new Pair<File, YamlConfiguration>(file, yamlConfiguration));
            }
        }
    }

    protected Pair<File, YamlConfiguration> getConfigData(I i) {
        for (I i2 : this.data.keySet()) {
            if (!i2.equals(i)) continue;
            return this.data.get(i);
        }
        return null;
    }

    protected Pair<File, YamlConfiguration> createAndSaveConfigDataInCache(I i) {
        Object object = new File(this.folder.getPath() + File.separator + i.toString() + ".yml");
        if (!((File)object).exists()) {
            FileUtils.create((File)object);
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)object);
        object = new Pair<File, YamlConfiguration>((File)object, yamlConfiguration);
        this.data.put(i, (Pair<File, YamlConfiguration>)object);
        return object;
    }

    public boolean delete(I i) {
        if (this.data.containsKey(i)) {
            File file = this.data.get(i).getKey();
            file.delete();
            this.data.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public PluginBase getPlugin() {
        return this.plugin;
    }

    public Map<I, Pair<File, YamlConfiguration>> getData() {
        return this.data;
    }
}

