/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.DimensionMismatchException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.MathInternalError;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.util.ArithmeticUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;
import net.advancedplugins.ae.libs.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinations
implements Iterable<int[]> {
    private final int n;
    private final int k;
    private final IterationOrder iterationOrder;

    public Combinations(int n, int n2) {
        this(n, n2, IterationOrder.LEXICOGRAPHIC);
    }

    private Combinations(int n, int n2, IterationOrder iterationOrder) {
        CombinatoricsUtils.checkBinomial(n, n2);
        this.n = n;
        this.k = n2;
        this.iterationOrder = iterationOrder;
    }

    public int getN() {
        return this.n;
    }

    public int getK() {
        return this.k;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterator<int[]> iterator() {
        try {
            try {
                if (this.k == 0) return new SingletonIterator(MathArrays.natural(this.k));
                if (this.k == this.n) {
                    return new SingletonIterator(MathArrays.natural(this.k));
                }
            }
            catch (MathInternalError mathInternalError) {
                throw Combinations.b(mathInternalError);
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
        try {
            switch (this.iterationOrder) {
                case LEXICOGRAPHIC: {
                    return new LexicographicIterator(this.n, this.k);
                }
                default: {
                    throw new MathInternalError();
                }
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
    }

    public Comparator<int[]> comparator() {
        return new LexicographicComparator(this.n, this.k);
    }

    private static MathInternalError b(MathInternalError mathInternalError) {
        return mathInternalError;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicComparator
    implements Comparator<int[]>,
    Serializable {
        private static final long serialVersionUID = 20130906L;
        private final int n;
        private final int k;

        LexicographicComparator(int n, int n2) {
            this.n = n;
            this.k = n2;
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            try {
                if (nArray.length != this.k) {
                    throw new DimensionMismatchException(nArray.length, this.k);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (nArray2.length != this.k) {
                    throw new DimensionMismatchException(nArray2.length, this.k);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            int[] nArray3 = MathArrays.copyOf(nArray);
            Arrays.sort(nArray3);
            int[] nArray4 = MathArrays.copyOf(nArray2);
            Arrays.sort(nArray4);
            long l = this.lexNorm(nArray3);
            long l2 = this.lexNorm(nArray4);
            try {
                if (l < l2) {
                    return -1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (l > l2) {
                    return 1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            return 0;
        }

        private long lexNorm(int[] nArray) {
            long l = 0L;
            int n = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                block5: {
                    int n2 = nArray[i];
                    try {
                        try {
                            if (n2 >= 0 && n2 < this.n) break block5;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw LexicographicComparator.b(dimensionMismatchException);
                        }
                        throw new OutOfRangeException(n2, (Number)0, this.n - 1);
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw LexicographicComparator.b(dimensionMismatchException);
                    }
                }
                l += (long)(nArray[i] * ArithmeticUtils.pow(this.n, i));
                if (n == 0) continue;
            }
            return l;
        }

        private static DimensionMismatchException b(DimensionMismatchException dimensionMismatchException) {
            return dimensionMismatchException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<int[]> {
        private final int[] singleton;
        private boolean more = true;

        SingletonIterator(int[] nArray) {
            this.singleton = nArray;
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            try {
                if (this.more) {
                    this.more = false;
                    return this.singleton;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw SingletonIterator.b(noSuchElementException);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicIterator
    implements Iterator<int[]> {
        private final int k;
        private final int[] c;
        private boolean more;
        private int j;

        LexicographicIterator(int n, int n2) {
            block9: {
                int n3;
                block8: {
                    this.more = true;
                    n3 = FastMath.b();
                    try {
                        try {
                            this.k = n2;
                            this.c = new int[n2 + 3];
                            if (n2 != 0 && n2 < n) break block8;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                        this.more = false;
                        return;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                for (int i = 1; i <= n2; ++i) {
                    try {
                        this.c[i] = i - 1;
                        if (n3 == 0) {
                            if (n3 == 0) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                this.c[n2 + 1] = n;
                this.c[n2 + 2] = 0;
                this.j = n2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.more;
        }

        @Override
        public int[] next() {
            int n;
            int n2;
            int n3;
            int[] nArray;
            block15: {
                int n4 = FastMath.c();
                try {
                    if (!this.more) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                nArray = new int[this.k];
                System.arraycopy(this.c, 1, nArray, 0, this.k);
                n3 = 0;
                if (this.j > 0) {
                    this.c[this.j] = n3 = this.j;
                    --this.j;
                    return nArray;
                }
                try {
                    if (this.c[1] + 1 < this.c[2]) {
                        this.c[1] = this.c[1] + 1;
                        return nArray;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                this.j = 2;
                boolean bl = false;
                while (!bl) {
                    block16: {
                        this.c[this.j - 1] = this.j - 2;
                        n3 = this.c[this.j] + 1;
                        try {
                            try {
                                n2 = n3;
                                n = this.c[this.j + 1];
                                if (n4 == 0) break block15;
                                if (n2 != n) break block16;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw LexicographicIterator.b(noSuchElementException);
                            }
                            ++this.j;
                            if (n4 != 0) continue;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                    }
                    bl = true;
                    if (n4 != 0) continue;
                }
                n2 = this.j;
                n = this.k;
            }
            try {
                if (n2 > n) {
                    this.more = false;
                    return nArray;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw LexicographicIterator.b(noSuchElementException);
            }
            this.c[this.j] = n3;
            --this.j;
            return nArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterationOrder
    extends Enum<IterationOrder> {
        public static final /* enum */ IterationOrder LEXICOGRAPHIC;
        private static final /* synthetic */ IterationOrder[] $VALUES;

        public static IterationOrder[] values() {
            return (IterationOrder[])$VALUES.clone();
        }

        public static IterationOrder valueOf(String string) {
            return Enum.valueOf(IterationOrder.class, string);
        }

        static {
            Object var1 = null;
            String string = IterationOrder.a(27, IterationOrder.a("Ip\u000f;\u001b~\"Wt\u0007:\u0011r"));
            LEXICOGRAPHIC = new IterationOrder();
            $VALUES = new IterationOrder[]{LEXICOGRAPHIC};
        }

        private static char[] a(String string) {
            char[] cArray = string.toCharArray();
            if (cArray.length < 2) {
                cArray = cArray;
                cArray[0] = (char)(cArray[0] ^ 0x7E);
            }
            return cArray;
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        private static String a(int n, char[] cArray) {
            char[] cArray2;
            block11: {
                int n2;
                int n3;
                int n4;
                block10: {
                    n4 = n;
                    cArray2 = cArray;
                    n3 = cArray.length;
                    n2 = 0;
                    if (!true) break block10;
                    n3 = n3;
                    if (n3 <= n2) break block11;
                }
                do {
                    int n5;
                    n4 = n4;
                    cArray2 = cArray2;
                    int n6 = n2;
                    switch (n2 % 7) {
                        case 0: {
                            n5 = 30;
                            break;
                        }
                        case 1: {
                            n5 = 46;
                            break;
                        }
                        case 2: {
                            n5 = 76;
                            break;
                        }
                        case 3: {
                            n5 = 105;
                            break;
                        }
                        case 4: {
                            n5 = 67;
                            break;
                        }
                        case 5: {
                            n5 = 42;
                            break;
                        }
                        default: {
                            n5 = 126;
                        }
                    }
                    cArray2[n6] = (char)(cArray2[n6] ^ (n4 ^ n5));
                    ++n2;
                    n3 = n3;
                } while (n3 > n2);
            }
            return new String(cArray2).intern();
        }
    }
}

