/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.impl.utils.hooks.plugins;

import com.archyx.aureliumskills.api.event.PlayerLootDropEvent;
import com.archyx.aureliumskills.api.event.TerraformBlockBreakEvent;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.impl.utils.ASManager;
import net.advancedplugins.ae.impl.utils.abilities.DropsSettings;
import net.advancedplugins.ae.impl.utils.abilities.SmeltMaterial;
import net.advancedplugins.ae.impl.utils.hooks.HookPlugin;
import net.advancedplugins.ae.impl.utils.hooks.PluginHookInstance;
import net.advancedplugins.ae.impl.utils.hooks.plugins.McMMOHook;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class AureliumSkillsHook
extends PluginHookInstance
implements Listener {
    private ConcurrentHashMap<Vector, BrokenBlockInformation> brokenBlocksMap = new ConcurrentHashMap();
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getName() {
        return HookPlugin.AURELIUMSKILLS.getPluginName();
    }

    @EventHandler
    public void onLoot(PlayerLootDropEvent playerLootDropEvent) {
        Vector vector = playerLootDropEvent.getLocation().getBlock().getLocation().toVector();
        if (!this.brokenBlocksMap.containsKey(vector)) {
            return;
        }
        BrokenBlockInformation brokenBlockInformation = this.brokenBlocksMap.get(vector);
        ItemStack itemStack = playerLootDropEvent.getItemStack();
        if (brokenBlockInformation.settings.isSmelt()) {
            itemStack = SmeltMaterial.material(itemStack, true);
            playerLootDropEvent.setItemStack(itemStack);
        }
        if (brokenBlockInformation.settings.isAddToInventory()) {
            playerLootDropEvent.setCancelled(true);
            playerLootDropEvent.setLocation(playerLootDropEvent.getLocation().add(0.0, 10.0, 0.0));
            playerLootDropEvent.setItemStack(new ItemStack(Material.AIR));
            ASManager.giveItem(brokenBlockInformation.player, itemStack);
        }
    }

    public boolean isTerraformEvent(BlockBreakEvent blockBreakEvent) {
        return blockBreakEvent instanceof TerraformBlockBreakEvent;
    }

    public void addBrokenBlockToMap(Block block, Player player, DropsSettings dropsSettings) {
        Location location = block.getLocation();
        String string = McMMOHook.b();
        this.brokenBlocksMap.put(location.toVector(), new BrokenBlockInformation(player, dropsSettings));
        this.executorService.schedule(() -> this.brokenBlocksMap.remove(location.toVector()), 200L, TimeUnit.MILLISECONDS);
        if (string == null) {
            AdvancedEffect.b(AdvancedEffect.c());
        }
    }

    class BrokenBlockInformation {
        public final Player player;
        public final DropsSettings settings;

        public BrokenBlockInformation(Player player, DropsSettings dropsSettings) {
            this.player = player;
            this.settings = dropsSettings;
        }
    }
}

