/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NumberIsTooLargeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;

public class UniformIntegerDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 20120109L;
    private final int lower;
    private final int upper;

    public UniformIntegerDistribution(int n, int n2) throws NumberIsTooLargeException {
        this(new Well19937c(), n, n2);
    }

    public UniformIntegerDistribution(RandomGenerator randomGenerator, int n, int n2) throws NumberIsTooLargeException {
        super(randomGenerator);
        if (n > n2) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_BOUND_NOT_BELOW_UPPER_BOUND, (Number)n, n2, true);
        }
        this.lower = n;
        this.upper = n2;
    }

    public double probability(int n) {
        block4: {
            try {
                try {
                    if (n >= this.lower && n <= this.upper) break block4;
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw UniformIntegerDistribution.b(numberIsTooLargeException);
                }
                return 0.0;
            }
            catch (NumberIsTooLargeException numberIsTooLargeException) {
                throw UniformIntegerDistribution.b(numberIsTooLargeException);
            }
        }
        return 1.0 / (double)(this.upper - this.lower + 1);
    }

    public double cumulativeProbability(int n) {
        try {
            if (n < this.lower) {
                return 0.0;
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw UniformIntegerDistribution.b(numberIsTooLargeException);
        }
        try {
            if (n > this.upper) {
                return 1.0;
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw UniformIntegerDistribution.b(numberIsTooLargeException);
        }
        return ((double)(n - this.lower) + 1.0) / ((double)(this.upper - this.lower) + 1.0);
    }

    public double getNumericalMean() {
        return 0.5 * (double)(this.lower + this.upper);
    }

    public double getNumericalVariance() {
        double d = this.upper - this.lower + 1;
        return (d * d - 1.0) / 12.0;
    }

    public int getSupportLowerBound() {
        return this.lower;
    }

    public int getSupportUpperBound() {
        return this.upper;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        int n = this.upper - this.lower + 1;
        String string = AbstractRealDistribution.b();
        if (n <= 0) {
            do {
                int n2;
                if ((n2 = this.random.nextInt()) < this.lower) continue;
                try {
                    if (n2 <= this.upper) {
                        return n2;
                    }
                }
                catch (NumberIsTooLargeException numberIsTooLargeException) {
                    throw UniformIntegerDistribution.b(numberIsTooLargeException);
                }
            } while (string == null);
        }
        return this.lower + this.random.nextInt(n);
    }

    private static NumberIsTooLargeException b(NumberIsTooLargeException numberIsTooLargeException) {
        return numberIsTooLargeException;
    }
}

