/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.impl.effects.effects.effects.AdvancedEffect;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Gamma;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class GammaDistribution
extends AbstractRealDistribution {
    public static final double f = 1.0E-9;
    private static final long serialVersionUID = 20120524L;
    private final double n;
    private final double o;
    private final double i;
    private final double k;
    private final double l;
    private final double m;
    private final double p;
    private final double g;
    private final double h;
    private final double j;

    public GammaDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public GammaDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        boolean bl = AbstractRealDistribution.b();
        super(randomGenerator);
        boolean bl2 = bl;
        try {
            if (d <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
        try {
            if (d2 <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d2);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
        this.n = d;
        this.o = d2;
        this.j = d3;
        this.i = d + 4.7421875 + 0.5;
        double d4 = Math.E / (Math.PI * 2 * this.i);
        this.m = d * FastMath.sqrt(d4) / Gamma.lanczos(d);
        this.p = FastMath.log(d) + 0.5 * FastMath.log(d4) - FastMath.log(Gamma.lanczos(d));
        this.k = this.m / d2 * FastMath.pow(this.i, -d) * FastMath.exp(d + 4.7421875);
        this.l = this.p - FastMath.log(d2) - FastMath.log(this.i) * d + d + 4.7421875;
        this.g = d + 4.7421875 - FastMath.log(Double.MAX_VALUE);
        this.h = FastMath.log(Double.MAX_VALUE) / (d - 1.0);
        if (!bl2) {
            int n = AdvancedEffect.b();
            AdvancedEffect.b(++n);
        }
    }

    @Deprecated
    public double getAlpha() {
        return this.n;
    }

    public double getShape() {
        return this.n;
    }

    @Deprecated
    public double getBeta() {
        return this.o;
    }

    public double getScale() {
        return this.o;
    }

    public double density(double d) {
        double d2;
        block5: {
            try {
                if (d < 0.0) {
                    return 0.0;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            d2 = d / this.o;
            try {
                if (!(d2 <= this.g) && !(FastMath.log(d2) >= this.h)) break block5;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            double d3 = (d2 - this.i) / this.i;
            double d4 = this.n * (FastMath.log1p(d3) - d3);
            double d5 = -d2 * 5.2421875 / this.i + 4.7421875 + d4;
            return this.m / d * FastMath.exp(d5);
        }
        return this.k * FastMath.exp(-d2) * FastMath.pow(d2, this.n - 1.0);
    }

    public double logDensity(double d) {
        double d2;
        block5: {
            try {
                if (d < 0.0) {
                    return Double.NEGATIVE_INFINITY;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            d2 = d / this.o;
            try {
                if (!(d2 <= this.g) && !(FastMath.log(d2) >= this.h)) break block5;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            double d3 = (d2 - this.i) / this.i;
            double d4 = this.n * (FastMath.log1p(d3) - d3);
            double d5 = -d2 * 5.2421875 / this.i + 4.7421875 + d4;
            return this.p - FastMath.log(d) + d5;
        }
        return this.l - d2 + FastMath.log(d2) * (this.n - 1.0);
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.a();
                if (!(d <= 0.0)) break block2;
                d2 = 0.0;
                if (!bl) break block3;
            }
            d2 = Gamma.regularizedGammaP(this.n, d / this.o);
        }
        return d2;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.j;
    }

    public double getNumericalMean() {
        return this.n * this.o;
    }

    public double getNumericalVariance() {
        return this.n * this.o * this.o;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public double sample() {
        boolean bl = AbstractRealDistribution.b();
        if (this.n < 1.0) {
            while (true) {
                double d;
                double d2;
                block16: {
                    double d3;
                    double d4;
                    double d5;
                    double d6;
                    if ((d6 = (d5 = 1.0 + this.n / Math.E) * (d4 = this.d.nextDouble())) <= 1.0) {
                        d2 = FastMath.pow(d6, 1.0 / this.n);
                        d3 = this.d.nextDouble();
                        try {
                            try {
                                double d7 = d3 - FastMath.exp(-d2);
                                d = d7 == 0.0 ? 0 : (d7 > 0.0 ? 1 : -1);
                                if (!bl) break block16;
                                if (d <= 0) return this.o * d2;
                            }
                            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                                throw GammaDistribution.b(notStrictlyPositiveException);
                            }
                            if (bl) continue;
                            return this.o * d2;
                        }
                        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                            throw GammaDistribution.b(notStrictlyPositiveException);
                        }
                    }
                    d2 = -1.0 * FastMath.log((d5 - d6) / this.n);
                    d3 = this.d.nextDouble();
                    double d8 = d3 - FastMath.pow(d2, this.n - 1.0);
                    d = d8 == 0.0 ? 0 : (d8 > 0.0 ? 1 : -1);
                }
                if (d <= 0 || !bl) return this.o * d2;
                continue;
                break;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
        }
        double d = this.n - 0.3333333333333333;
        double d9 = 1.0 / (3.0 * FastMath.sqrt(d));
        block11: while (true) {
            double d10 = this.d.nextGaussian();
            double d11 = (1.0 + d9 * d10) * (1.0 + d9 * d10) * (1.0 + d9 * d10);
            while (d11 <= 0.0) {
                if (!bl) continue;
                if (bl) continue block11;
            }
            double d12 = d10 * d10;
            double d13 = this.d.nextDouble();
            try {
                if (d13 < 1.0 - 0.0331 * d12 * d12) {
                    return this.o * d * d11;
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw GammaDistribution.b(notStrictlyPositiveException);
            }
            if (FastMath.log(d13) < 0.5 * d12 + d * (1.0 - d11 + FastMath.log(d11))) return this.o * d * d11;
            continue;
            break;
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw GammaDistribution.b(notStrictlyPositiveException);
        }
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

