/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractIntegerDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.OutOfRangeException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Beta;
import net.advancedplugins.ae.libs.apache.commons.math3.util.CombinatoricsUtils;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class PascalDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = 6751309484392813623L;
    private final int e;
    private final double c;
    private final double d;
    private final double f;

    public PascalDistribution(int n, double d) {
        this(new Well19937c(), n, d);
    }

    public PascalDistribution(RandomGenerator randomGenerator, int n, double d) {
        block5: {
            super(randomGenerator);
            if (n <= 0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SUCCESSES, n);
            }
            try {
                try {
                    if (!(d < 0.0) && !(d > 1.0)) break block5;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw PascalDistribution.b(notStrictlyPositiveException);
                }
                throw new OutOfRangeException(d, (Number)0, 1);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw PascalDistribution.b(notStrictlyPositiveException);
            }
        }
        this.e = n;
        this.c = d;
        this.d = FastMath.log(d);
        this.f = FastMath.log1p(-d);
    }

    public int getNumberOfSuccesses() {
        return this.e;
    }

    public double getProbabilityOfSuccess() {
        return this.c;
    }

    public double probability(int n) {
        double d;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.a();
                if (n >= 0) break block2;
                d = 0.0;
                if (!bl) break block3;
            }
            d = CombinatoricsUtils.binomialCoefficientDouble(n + this.e - 1, this.e - 1) * FastMath.pow(this.c, this.e) * FastMath.pow(1.0 - this.c, n);
        }
        return d;
    }

    public double logProbability(int n) {
        double d;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.b();
                if (n >= 0) break block2;
                d = Double.NEGATIVE_INFINITY;
                if (bl) break block3;
            }
            d = CombinatoricsUtils.binomialCoefficientLog(n + this.e - 1, this.e - 1) + this.d * (double)this.e + this.f * (double)n;
        }
        return d;
    }

    public double cumulativeProbability(int n) {
        double d;
        block3: {
            block2: {
                boolean bl = AbstractRealDistribution.b();
                if (n >= 0) break block2;
                d = 0.0;
                if (bl) break block3;
            }
            d = Beta.regularizedBeta(this.c, this.e, (double)n + 1.0);
        }
        return d;
    }

    public double getNumericalMean() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / d;
    }

    public double getNumericalVariance() {
        double d = this.getProbabilityOfSuccess();
        double d2 = this.getNumberOfSuccesses();
        return d2 * (1.0 - d) / (d * d);
    }

    public int getSupportLowerBound() {
        return 0;
    }

    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

