/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.ae.libs.apache.commons.math3.distribution;

import net.advancedplugins.ae.libs.apache.commons.math3.distribution.AbstractRealDistribution;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.NotStrictlyPositiveException;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.Localizable;
import net.advancedplugins.ae.libs.apache.commons.math3.exception.util.LocalizedFormats;
import net.advancedplugins.ae.libs.apache.commons.math3.random.RandomGenerator;
import net.advancedplugins.ae.libs.apache.commons.math3.random.Well19937c;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Beta;
import net.advancedplugins.ae.libs.apache.commons.math3.special.Gamma;
import net.advancedplugins.ae.libs.apache.commons.math3.util.FastMath;

public class TDistribution
extends AbstractRealDistribution {
    public static final double g = 1.0E-9;
    private static final long serialVersionUID = -5852615386664158222L;
    private final double i;
    private final double h;
    private final double f;

    public TDistribution(double d) {
        this(d, 1.0E-9);
    }

    public TDistribution(double d, double d2) {
        this(new Well19937c(), d, d2);
    }

    public TDistribution(RandomGenerator randomGenerator, double d) {
        this(randomGenerator, d, 1.0E-9);
    }

    public TDistribution(RandomGenerator randomGenerator, double d, double d2) {
        super(randomGenerator);
        if (d <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DEGREES_OF_FREEDOM, d);
        }
        this.i = d;
        this.h = d2;
        double d3 = d;
        double d4 = (d3 + 1.0) / 2.0;
        this.f = Gamma.logGamma(d4) - 0.5 * (FastMath.log(Math.PI) + FastMath.log(d3)) - Gamma.logGamma(d3 / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.i;
    }

    public double density(double d) {
        return FastMath.exp(this.logDensity(d));
    }

    public double logDensity(double d) {
        double d2 = this.i;
        double d3 = (d2 + 1.0) / 2.0;
        return this.f - d3 * FastMath.log(1.0 + d * d / d2);
    }

    public double cumulativeProbability(double d) {
        double d2;
        block3: {
            double d3;
            block4: {
                boolean bl;
                block2: {
                    bl = AbstractRealDistribution.a();
                    if (d != 0.0) break block2;
                    d2 = 0.5;
                    if (!bl) break block3;
                }
                d3 = Beta.regularizedBeta(this.i / (this.i + d * d), 0.5 * this.i, 0.5);
                if (!(d < 0.0)) break block4;
                d2 = 0.5 * d3;
                if (!bl) break block3;
            }
            d2 = 1.0 - 0.5 * d3;
        }
        return d2;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.h;
    }

    public double getNumericalMean() {
        double d = this.getDegreesOfFreedom();
        try {
            if (d > 1.0) {
                return 0.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw TDistribution.b(notStrictlyPositiveException);
        }
        return Double.NaN;
    }

    public double getNumericalVariance() {
        block7: {
            double d = this.getDegreesOfFreedom();
            try {
                if (d > 2.0) {
                    return d / (d - 2.0);
                }
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw TDistribution.b(notStrictlyPositiveException);
            }
            try {
                try {
                    if (!(d > 1.0) || !(d <= 2.0)) break block7;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw TDistribution.b(notStrictlyPositiveException);
                }
                return Double.POSITIVE_INFINITY;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw TDistribution.b(notStrictlyPositiveException);
            }
        }
        return Double.NaN;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }
}

