/*
 * Decompiled with CFR 0.152.
 */
package net.advancedplugins.items.impl.utils.nbt.backend;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import net.advancedplugins.items.impl.utils.nbt.backend.NBTCompound;
import net.advancedplugins.items.impl.utils.nbt.backend.NBTType;
import net.advancedplugins.items.impl.utils.nbt.backend.NbtApiException;
import net.advancedplugins.items.impl.utils.nbt.backend.ReflectionMethod;
import net.advancedplugins.items.impl.utils.nbt.utils.ReadWriteNBTList;

public abstract class NBTList<T>
implements List<T>,
ReadWriteNBTList<T> {
    private String a;
    private NBTCompound d;
    private NBTType b;
    protected Object c;
    private static final String[] e;

    protected NBTList(NBTCompound nBTCompound, String string, NBTType nBTType, Object object) {
        this.d = nBTCompound;
        this.a = string;
        this.b = nBTType;
        this.c = object;
    }

    public String getName() {
        return this.a;
    }

    public NBTCompound getParent() {
        return this.d;
    }

    private void validateClosed() {
        try {
            if (this.d.isClosed()) {
                throw new NbtApiException(e[1]);
            }
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
    }

    private void validateWritable() {
        try {
            if (this.getParent().isReadOnly()) {
                throw new NbtApiException(e[0]);
            }
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
    }

    protected void save() {
        this.validateClosed();
        this.d.set(this.a, this.c);
    }

    protected abstract Object asTag(T var1);

    @Override
    public boolean add(T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.d.getWriteLock().lock();
            ReflectionMethod.LIST_ADD.run(this.c, this.size(), this.asTag(t));
            this.save();
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    @Override
    public void add(int n, T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.d.getWriteLock().lock();
            ReflectionMethod.LIST_ADD.run(this.c, n, this.asTag(t));
            this.save();
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    @Override
    public T set(int n, T t) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.d.getWriteLock().lock();
            Object e = this.get(n);
            ReflectionMethod.LIST_SET.run(this.c, n, this.asTag(t));
            this.save();
            Object e2 = e;
            return (T)e2;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    @Override
    public T remove(int n) {
        this.validateClosed();
        this.validateWritable();
        try {
            this.d.getWriteLock().lock();
            Object e = this.get(n);
            ReflectionMethod.LIST_REMOVE_KEY.run(this.c, n);
            this.save();
            Object e2 = e;
            return (T)e2;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    @Override
    public int size() {
        this.validateClosed();
        try {
            this.d.getReadLock().lock();
            int n = (Integer)ReflectionMethod.LIST_SIZE.run(this.c, new Object[0]);
            return n;
        }
        catch (Exception exception) {
            throw new NbtApiException(exception);
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    @Override
    public NBTType getType() {
        return this.b;
    }

    @Override
    public boolean isEmpty() {
        boolean bl;
        try {
            bl = this.size() == 0;
        }
        catch (NbtApiException nbtApiException) {
            throw NBTList.b(nbtApiException);
        }
        return bl;
    }

    @Override
    public void clear() {
        int n = NBTCompound.c();
        while (!this.isEmpty()) {
            this.remove(0);
            if (n == 0) continue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean contains(Object object) {
        int n;
        block6: {
            int n2 = NBTCompound.b();
            this.validateClosed();
            int n3 = n2;
            try {
                int n4;
                this.d.getReadLock().lock();
                for (n4 = 0; n4 < this.size(); ++n4) {
                    try {
                        n = object.equals(this.get(n4));
                        if (n3 == 0) break block6;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    boolean bl = true;
                    this.d.getReadLock().unlock();
                    return bl;
                }
                n4 = 0;
                this.d.getReadLock().unlock();
                n = n4;
            }
            catch (Throwable throwable) {
                this.d.getReadLock().unlock();
                throw throwable;
            }
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int indexOf(Object object) {
        int n;
        block6: {
            int n2 = NBTCompound.c();
            this.validateClosed();
            int n3 = n2;
            try {
                int n4;
                this.d.getReadLock().lock();
                for (n4 = 0; n4 < this.size(); ++n4) {
                    try {
                        n = object.equals(this.get(n4));
                        if (n3 != 0) break block6;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    int n5 = n4;
                    this.d.getReadLock().unlock();
                    return n5;
                }
                n4 = -1;
                this.d.getReadLock().unlock();
                n = n4;
            }
            catch (Throwable throwable) {
                this.d.getReadLock().unlock();
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n = NBTCompound.c();
        this.validateClosed();
        int n2 = n;
        try {
            boolean bl;
            block10: {
                block9: {
                    this.d.getWriteLock().lock();
                    int n3 = this.size();
                    for (T t : collection) {
                        try {
                            this.add(t);
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n3 == this.size()) break block9;
                        bl = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int n, Collection<? extends T> collection) {
        int n2 = NBTCompound.c();
        this.validateClosed();
        int n3 = n2;
        try {
            boolean bl;
            block10: {
                block9: {
                    this.d.getWriteLock().lock();
                    int n4 = this.size();
                    for (T t : collection) {
                        try {
                            this.add(n++, t);
                            if (n3 == 0) {
                                if (n3 == 0) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n4 == this.size()) break block9;
                        bl = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        int n = NBTCompound.b();
        this.validateClosed();
        int n2 = n;
        try {
            boolean bl;
            block7: {
                this.d.getReadLock().lock();
                for (Object obj : collection) {
                    block8: {
                        try {
                            bl = this.contains(obj);
                            if (n2 == 0) break block7;
                            if (bl) break block8;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (n2 != 0) continue;
                }
                bl = true;
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object object) {
        int n;
        block5: {
            int n2 = NBTCompound.b();
            this.validateClosed();
            int n3 = n2;
            try {
                int n4;
                this.d.getReadLock().lock();
                int n5 = -1;
                for (n4 = 0; n4 < this.size(); ++n4) {
                    try {
                        n = object.equals(this.get(n4));
                        if (n3 == 0) break block5;
                        if (n == 0) continue;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                    n5 = n4;
                    if (n3 != 0) continue;
                }
                n4 = n5;
                this.d.getReadLock().unlock();
                n = n4;
            }
            catch (Throwable throwable) {
                this.d.getReadLock().unlock();
                throw throwable;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        int n = NBTCompound.b();
        this.validateClosed();
        int n2 = n;
        try {
            boolean bl;
            block10: {
                block9: {
                    this.d.getWriteLock().lock();
                    int n3 = this.size();
                    for (Object obj : collection) {
                        try {
                            this.remove(obj);
                            if (n2 != 0) {
                                if (n2 != 0) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n3 == this.size()) break block9;
                        bl = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        int n = NBTCompound.b();
        this.validateClosed();
        int n2 = n;
        try {
            boolean bl;
            int n3;
            block10: {
                this.d.getWriteLock().lock();
                int n4 = this.size();
                Iterator<?> iterator = collection.iterator();
                block7: while (true) {
                    boolean bl2 = iterator.hasNext();
                    block8: while (bl2) {
                        Object obj = iterator.next();
                        n3 = 0;
                        if (n2 == 0) break block10;
                        for (int i = v656483; i < this.size(); ++i) {
                            bl2 = obj.equals(this.get(i));
                            if (n2 == 0) continue block8;
                            try {
                                if (bl2) continue;
                                this.remove(i--);
                                continue;
                            }
                            catch (NbtApiException nbtApiException) {
                                throw NBTList.b(nbtApiException);
                            }
                        }
                        if (n2 != 0) continue block7;
                    }
                    break;
                }
                n3 = n4;
            }
            try {
                bl = n3 != this.size();
            }
            catch (NbtApiException nbtApiException) {
                throw NBTList.b(nbtApiException);
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object object) {
        int n = NBTCompound.c();
        this.validateClosed();
        int n2 = n;
        try {
            boolean bl;
            block10: {
                block9: {
                    this.d.getWriteLock().lock();
                    int n3 = this.size();
                    int n4 = -1;
                    while ((n4 = this.indexOf(object)) != -1) {
                        try {
                            this.remove(n4);
                            if (n2 == 0) {
                                if (n2 == 0) continue;
                                break;
                            }
                            break block9;
                        }
                        catch (NbtApiException nbtApiException) {
                            throw NBTList.b(nbtApiException);
                        }
                    }
                    try {
                        if (n3 == this.size()) break block9;
                        bl = true;
                        break block10;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.d.getWriteLock().unlock();
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int a = -1;

            @Override
            public boolean hasNext() {
                boolean bl;
                try {
                    bl = NBTList.this.size() > this.a + 1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 1.b(noSuchElementException);
                }
                return bl;
            }

            @Override
            public T next() {
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 1.b(noSuchElementException);
                }
                return NBTList.this.get(++this.a);
            }

            @Override
            public void remove() {
                NBTList.this.remove(this.a);
                --this.a;
            }

            private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
                return noSuchElementException;
            }
        };
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int n) {
        final NBTList nBTList = this;
        return new ListIterator<T>(){
            int a;
            private static final String c;
            {
                this.a = n - 1;
            }

            @Override
            public void add(T t) {
                nBTList.add(this.a, t);
            }

            @Override
            public boolean hasNext() {
                boolean bl;
                try {
                    bl = NBTList.this.size() > this.a + 1;
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return bl;
            }

            @Override
            public boolean hasPrevious() {
                boolean bl;
                block5: {
                    block4: {
                        try {
                            try {
                                if (this.a < 0 || this.a > NBTList.this.size()) break block4;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw 2.b(noSuchElementException);
                            }
                            bl = true;
                            break block5;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw 2.b(noSuchElementException);
                        }
                    }
                    bl = false;
                }
                return bl;
            }

            @Override
            public T next() {
                try {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return NBTList.this.get(++this.a);
            }

            @Override
            public int nextIndex() {
                return this.a + 1;
            }

            @Override
            public T previous() {
                try {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException(c + (this.a - 1));
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw 2.b(noSuchElementException);
                }
                return NBTList.this.get(this.a--);
            }

            @Override
            public int previousIndex() {
                return this.a - 1;
            }

            @Override
            public void remove() {
                nBTList.remove(this.a);
                --this.a;
            }

            @Override
            public void set(T t) {
                nBTList.set(this.a, t);
            }

            private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
                return noSuchElementException;
            }

            /*
             * Handled impossible loop by duplicating code
             * Enabled aggressive block sorting
             */
            static {
                char[] cArray;
                block12: {
                    int n9;
                    char[] cArray2;
                    int n2;
                    int n3;
                    block11: {
                        char[] cArray3 = "TD>S".toCharArray();
                        int n4 = cArray3.length;
                        n3 = 0;
                        n2 = 88;
                        cArray2 = cArray3;
                        n9 = n4;
                        if (n4 <= 1) break block11;
                        cArray = cArray2;
                        n9 = n9;
                        if (n9 <= n3) break block12;
                    }
                    do {
                        int n5 = n2;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n6 = n2;
                        int n7 = n3;
                        while (true) {
                            int n8;
                            switch (n3 % 7) {
                                case 0: {
                                    n8 = 69;
                                    break;
                                }
                                case 1: {
                                    n8 = 120;
                                    break;
                                }
                                case 2: {
                                    n8 = 92;
                                    break;
                                }
                                case 3: {
                                    n8 = 43;
                                    break;
                                }
                                case 4: {
                                    n8 = 22;
                                    break;
                                }
                                case 5: {
                                    n8 = 54;
                                    break;
                                }
                                default: {
                                    n8 = 117;
                                }
                            }
                            cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                            ++n3;
                            n2 = n5;
                            if (n5 != 0) break;
                            n5 = n2;
                            cArray2 = cArray2;
                            n7 = n2;
                            cArray4 = cArray2;
                            n6 = n2;
                        }
                        cArray = cArray2;
                        n9 = n9;
                    } while (n9 > n3);
                }
                c = new String(cArray).intern();
            }
        };
    }

    @Override
    public Object[] toArray() {
        int n = NBTCompound.c();
        this.validateClosed();
        int n2 = n;
        try {
            Object[] objectArray;
            block7: {
                this.d.getReadLock().lock();
                Object[] objectArray2 = new Object[this.size()];
                for (int i = 0; i < this.size(); ++i) {
                    try {
                        objectArray = objectArray2;
                        if (n2 == 0) {
                            objectArray[i] = this.get(i);
                            if (n2 == 0) continue;
                            break;
                        }
                        break block7;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                objectArray = objectArray2;
            }
            Object[] objectArray3 = objectArray;
            return objectArray3;
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <E> E[] toArray(E[] EArray) {
        int n = NBTCompound.c();
        this.validateClosed();
        int n2 = n;
        try {
            this.d.getReadLock().lock();
            Object[] objectArray = Arrays.copyOf(EArray, this.size());
            Arrays.fill(objectArray, null);
            Class<?> clazz = EArray.getClass().getComponentType();
            for (int i = 0; i < this.size(); ++i) {
                Object e = this.get(i);
                if (!clazz.isInstance(e)) throw new ArrayStoreException(NBTList.e[2]);
                try {
                    objectArray[i] = this.get(i);
                    if (n2 == 0) continue;
                    throw new ArrayStoreException(NBTList.e[2]);
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                catch (NbtApiException nbtApiException) {
                    throw NBTList.b(nbtApiException);
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<T> subList(int n, int n2) {
        int n3 = NBTCompound.c();
        this.validateClosed();
        int n4 = n3;
        try {
            ArrayList arrayList;
            block7: {
                this.d.getReadLock().lock();
                ArrayList arrayList2 = new ArrayList();
                for (int i = n; i < n2; ++i) {
                    try {
                        arrayList = arrayList2;
                        if (n4 == 0) {
                            arrayList.add(this.get(i));
                            if (n4 == 0) continue;
                            break;
                        }
                        break block7;
                    }
                    catch (NbtApiException nbtApiException) {
                        throw NBTList.b(nbtApiException);
                    }
                }
                arrayList = arrayList2;
            }
            ArrayList arrayList3 = arrayList;
            return arrayList3;
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    @Override
    public boolean removeIf(Predicate<? super T> predicate) {
        return List.super.removeIf(predicate);
    }

    public String toString() {
        this.validateClosed();
        try {
            this.d.getReadLock().lock();
            String string = this.c.toString();
            return string;
        }
        finally {
            this.d.getReadLock().unlock();
        }
    }

    private static NbtApiException b(NbtApiException nbtApiException) {
        return nbtApiException;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block13: {
            var5 = new String[3];
            var3_1 = 0;
            var2_2 = "\u0019H\u001f#&P2(N\u0002/,\u0017a)[\u0002'b\u0019/mH\u0013'&P.#V\u000ff/\u001f%(\u001b\u001c\u0019H\u001f#&P4>S\u0018!b\u0013-\"I\u0013\"b>\u0003\u0019\u001a\u0012'6\u0011`8\u0019R\u0013f#\u00023,CV\"-\u00152mT\u00192b\u001d 9Y\u001ef6\u0018$mU\u0014,'\u00135>\u001a\u00052-\u0002$)\u001a\u001f(b\u0004)(\u001a:/1\u0004o";
            var4_3 = "\u0019H\u001f#&P2(N\u0002/,\u0017a)[\u0002'b\u0019/mH\u0013'&P.#V\u000ff/\u001f%(\u001b\u001c\u0019H\u001f#&P4>S\u0018!b\u0013-\"I\u0013\"b>\u0003\u0019\u001a\u0012'6\u0011`8\u0019R\u0013f#\u00023,CV\"-\u00152mT\u00192b\u001d 9Y\u001ef6\u0018$mU\u0014,'\u00135>\u001a\u00052-\u0002$)\u001a\u001f(b\u0004)(\u001a:/1\u0004o".length();
            var1_4 = 37;
            var0_5 = -1;
lbl7:
            // 2 sources

            while (true) {
                continue;
                break;
            }
lbl9:
            // 1 sources

            while (true) {
                var5[var3_1++] = new String(v0).intern();
                if ((var0_5 += var1_4) < var4_3) {
                    var1_4 = var2_2.charAt(var0_5);
                    ** continue;
                }
                break block13;
                break;
            }
            v1 = ++var0_5;
            v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
            v3 = v2.length;
            var6_6 = 0;
            v4 = 12;
            v5 = v2;
            v6 = v3;
            if (v3 > 1) ** GOTO lbl67
            do {
                v7 = v4;
                v5 = v5;
                v8 = v5;
                v9 = v4;
                v10 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v11 = 65;
                            break;
                        }
                        case 1: {
                            v11 = 54;
                            break;
                        }
                        case 2: {
                            v11 = 122;
                            break;
                        }
                        case 3: {
                            v11 = 74;
                            break;
                        }
                        case 4: {
                            v11 = 78;
                            break;
                        }
                        case 5: {
                            v11 = 124;
                            break;
                        }
                        default: {
                            v11 = 77;
                        }
                    }
                    v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                    ++var6_6;
                    v4 = v7;
                    if (v7 != 0) break;
                    v7 = v4;
                    v5 = v5;
                    v10 = v4;
                    v8 = v5;
                    v9 = v4;
                }
lbl67:
                // 2 sources

                v0 = v5;
                v6 = v6;
            } while (v6 > var6_6);
            ** while (true)
        }
        NBTList.e = var5;
    }
}

