/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.analysis.solvers.BaseUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.exception.MaxCountExceededException;
import org.apache.commons.math3.exception.TooManyEvaluationsException;
import org.apache.commons.math3.util.IntegerSequence;
import org.apache.commons.math3.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseAbstractUnivariateSolver<FUNC extends UnivariateFunction>
implements BaseUnivariateSolver<FUNC> {
    private static final double k = 1.0E-14;
    private static final double a = 1.0E-15;
    private final double c;
    private final double j;
    private final double e;
    private IntegerSequence.Incrementor g;
    private double d;
    private double f;
    private double i;
    private FUNC b;
    private static int[] h;

    protected BaseAbstractUnivariateSolver(double d) {
        this(1.0E-14, d, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d, double d2) {
        this(d, d2, 1.0E-15);
    }

    protected BaseAbstractUnivariateSolver(double d, double d2, double d3) {
        this.j = d2;
        this.e = d;
        this.c = d3;
        this.g = IntegerSequence.Incrementor.create();
    }

    @Override
    public int getMaxEvaluations() {
        return this.g.getMaximalCount();
    }

    @Override
    public int getEvaluations() {
        return this.g.getCount();
    }

    public double getMin() {
        return this.d;
    }

    public double getMax() {
        return this.f;
    }

    public double getStartValue() {
        return this.i;
    }

    @Override
    public double getAbsoluteAccuracy() {
        return this.j;
    }

    @Override
    public double getRelativeAccuracy() {
        return this.e;
    }

    @Override
    public double getFunctionValueAccuracy() {
        return this.c;
    }

    protected double computeObjectiveValue(double d) {
        this.incrementEvaluationCount();
        return this.b.value(d);
    }

    protected void setup(int n, FUNC FUNC, double d, double d2, double d3) {
        MathUtils.checkNotNull(FUNC);
        this.d = d;
        this.f = d2;
        this.i = d3;
        this.b = FUNC;
        this.g = this.g.withMaximalCount(n).withStart(0);
    }

    @Override
    public double solve(int n, FUNC FUNC, double d, double d2, double d3) {
        this.setup(n, FUNC, d, d2, d3);
        return this.doSolve();
    }

    @Override
    public double solve(int n, FUNC FUNC, double d, double d2) {
        return this.solve(n, FUNC, d, d2, d + 0.5 * (d2 - d));
    }

    @Override
    public double solve(int n, FUNC FUNC, double d) {
        return this.solve(n, FUNC, Double.NaN, Double.NaN, d);
    }

    protected abstract double doSolve();

    protected boolean isBracketing(double d, double d2) {
        return UnivariateSolverUtils.isBracketing(this.b, d, d2);
    }

    protected boolean isSequence(double d, double d2, double d3) {
        return UnivariateSolverUtils.isSequence(d, d2, d3);
    }

    protected void verifyInterval(double d, double d2) {
        UnivariateSolverUtils.verifyInterval(d, d2);
    }

    protected void verifySequence(double d, double d2, double d3) {
        UnivariateSolverUtils.verifySequence(d, d2, d3);
    }

    protected void verifyBracketing(double d, double d2) {
        UnivariateSolverUtils.verifyBracketing(this.b, d, d2);
    }

    protected void incrementEvaluationCount() {
        try {
            this.g.increment();
        }
        catch (MaxCountExceededException maxCountExceededException) {
            throw new TooManyEvaluationsException(maxCountExceededException.getMax());
        }
    }

    public static void b(int[] nArray) {
        h = nArray;
    }

    public static int[] b() {
        return h;
    }

    static {
        if (BaseAbstractUnivariateSolver.b() != null) {
            BaseAbstractUnivariateSolver.b(new int[4]);
        }
    }
}

