/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.MathIllegalNumberException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class NormalDistribution
extends AbstractRealDistribution {
    public static final double k = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private static final double j = FastMath.sqrt(2.0);
    private final double i;
    private final double g;
    private final double h;
    private final double f;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public NormalDistribution(double d, double d2, double d3) {
        this(new Well19937c(), d, d2, d3);
    }

    public NormalDistribution(RandomGenerator randomGenerator, double d, double d2) {
        this(randomGenerator, d, d2, 1.0E-9);
    }

    public NormalDistribution(RandomGenerator randomGenerator, double d, double d2, double d3) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d2);
        }
        this.i = d;
        this.g = d2;
        this.h = FastMath.log(d2) + 0.5 * FastMath.log(Math.PI * 2);
        this.f = d3;
    }

    public double getMean() {
        return this.i;
    }

    public double getStandardDeviation() {
        return this.g;
    }

    public double density(double d) {
        return FastMath.exp(this.logDensity(d));
    }

    public double logDensity(double d) {
        double d2 = d - this.i;
        double d3 = d2 / this.g;
        return -0.5 * d3 * d3 - this.h;
    }

    public double cumulativeProbability(double d) {
        double d2;
        block4: {
            double d3;
            block6: {
                block5: {
                    d2 = d - this.i;
                    try {
                        try {
                            if (!(FastMath.abs(d2) > 40.0 * this.g)) break block4;
                            if (!(d2 < 0.0)) break block5;
                        }
                        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                            throw NormalDistribution.c(notStrictlyPositiveException);
                        }
                        d3 = 0.0;
                        break block6;
                    }
                    catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                        throw NormalDistribution.c(notStrictlyPositiveException);
                    }
                }
                d3 = 1.0;
            }
            return d3;
        }
        return 0.5 * Erf.erfc(-d2 / (this.g * j));
    }

    public double inverseCumulativeProbability(double d) {
        block4: {
            try {
                try {
                    if (!(d < 0.0) && !(d > 1.0)) break block4;
                }
                catch (OutOfRangeException outOfRangeException) {
                    throw NormalDistribution.c(outOfRangeException);
                }
                throw new OutOfRangeException(d, (Number)0, 1);
            }
            catch (OutOfRangeException outOfRangeException) {
                throw NormalDistribution.c(outOfRangeException);
            }
        }
        return this.i + this.g * j * Erf.erfInv(2.0 * d - 1.0);
    }

    @Deprecated
    public double cumulativeProbability(double d, double d2) {
        return this.probability(d, d2);
    }

    public double probability(double d, double d2) {
        try {
            if (d > d2) {
                throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d, d2, true);
            }
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            throw NormalDistribution.c(numberIsTooLargeException);
        }
        double d3 = this.g * j;
        double d4 = (d - this.i) / d3;
        double d5 = (d2 - this.i) / d3;
        return 0.5 * Erf.erf(d4, d5);
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.f;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double d = this.getStandardDeviation();
        return d * d;
    }

    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public boolean isSupportConnected() {
        return true;
    }

    public double sample() {
        return this.g * this.b.nextGaussian() + this.i;
    }

    private static MathIllegalNumberException c(MathIllegalNumberException mathIllegalNumberException) {
        return mathIllegalNumberException;
    }
}

