/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -140627372283420404L;
    private final int h;
    private final double f;
    private double i = Double.NaN;
    private boolean e = false;
    private double c = Double.NaN;
    private boolean d = false;
    private transient ZipfRejectionInversionSampler g;

    public ZipfDistribution(int n, double d) {
        this(new Well19937c(), n, d);
    }

    public ZipfDistribution(RandomGenerator randomGenerator, int n, double d) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n);
        }
        try {
            if (d <= 0.0) {
                throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.EXPONENT, d);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        this.h = n;
        this.f = d;
    }

    public int getNumberOfElements() {
        return this.h;
    }

    public double getExponent() {
        return this.f;
    }

    public double probability(int n) {
        block4: {
            try {
                try {
                    if (n > 0 && n <= this.h) break block4;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ZipfDistribution.b(notStrictlyPositiveException);
                }
                return 0.0;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw ZipfDistribution.b(notStrictlyPositiveException);
            }
        }
        return 1.0 / FastMath.pow((double)n, this.f) / this.generalizedHarmonic(this.h, this.f);
    }

    public double logProbability(int n) {
        block4: {
            try {
                try {
                    if (n > 0 && n <= this.h) break block4;
                }
                catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                    throw ZipfDistribution.b(notStrictlyPositiveException);
                }
                return Double.NEGATIVE_INFINITY;
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw ZipfDistribution.b(notStrictlyPositiveException);
            }
        }
        return -FastMath.log(n) * this.f - FastMath.log(this.generalizedHarmonic(this.h, this.f));
    }

    public double cumulativeProbability(int n) {
        try {
            if (n <= 0) {
                return 0.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        try {
            if (n >= this.h) {
                return 1.0;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.generalizedHarmonic(n, this.f) / this.generalizedHarmonic(this.h, this.f);
    }

    public double getNumericalMean() {
        try {
            if (!this.e) {
                this.i = this.calculateNumericalMean();
                this.e = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.i;
    }

    protected double calculateNumericalMean() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 1.0);
        double d3 = this.generalizedHarmonic(n, d);
        return d2 / d3;
    }

    public double getNumericalVariance() {
        try {
            if (!this.d) {
                this.c = this.calculateNumericalVariance();
                this.d = true;
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.c;
    }

    protected double calculateNumericalVariance() {
        int n = this.getNumberOfElements();
        double d = this.getExponent();
        double d2 = this.generalizedHarmonic(n, d - 2.0);
        double d3 = this.generalizedHarmonic(n, d - 1.0);
        double d4 = this.generalizedHarmonic(n, d);
        return d2 / d4 - d3 * d3 / (d4 * d4);
    }

    private double generalizedHarmonic(int n, double d) {
        double d2;
        block2: {
            double d3 = 0.0;
            int n2 = AbstractRealDistribution.a();
            for (int i = n; i > 0; --i) {
                d2 = d3 + 1.0 / FastMath.pow((double)i, d);
                if (n2 != 0) {
                    d3 = d2;
                    if (n2 != 0) continue;
                }
                break block2;
            }
            d2 = d3;
        }
        return d2;
    }

    public int getSupportLowerBound() {
        return 1;
    }

    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    public boolean isSupportConnected() {
        return true;
    }

    public int sample() {
        try {
            if (this.g == null) {
                this.g = new ZipfRejectionInversionSampler(this.h, this.f);
            }
        }
        catch (NotStrictlyPositiveException notStrictlyPositiveException) {
            throw ZipfDistribution.b(notStrictlyPositiveException);
        }
        return this.g.sample(this.a);
    }

    private static NotStrictlyPositiveException b(NotStrictlyPositiveException notStrictlyPositiveException) {
        return notStrictlyPositiveException;
    }

    static final class ZipfRejectionInversionSampler {
        private final double d;
        private final int c;
        private final double e;
        private final double a;
        private final double b;

        ZipfRejectionInversionSampler(int n, double d) {
            this.d = d;
            this.c = n;
            this.e = this.hIntegral(1.5) - 1.0;
            this.a = this.hIntegral((double)n + 0.5);
            this.b = 2.0 - this.hIntegralInverse(this.hIntegral(2.5) - this.h(2.0));
        }

        int sample(RandomGenerator randomGenerator) {
            double d;
            double d2;
            int n;
            int n2 = AbstractRealDistribution.b();
            do {
                if ((n = (int)((d2 = this.hIntegralInverse(d = this.a + randomGenerator.nextDouble() * (this.e - this.a))) + 0.5)) < 1) {
                    n = 1;
                    if (n2 != 0 || n2 == 0) continue;
                }
                if (n <= this.c) continue;
                n = this.c;
            } while (!((double)n - d2 <= this.b) && !(d >= this.hIntegral((double)n + 0.5) - this.h(n)));
            return n;
        }

        private double hIntegral(double d) {
            double d2 = FastMath.log(d);
            return ZipfRejectionInversionSampler.helper2((1.0 - this.d) * d2) * d2;
        }

        private double h(double d) {
            return FastMath.exp(-this.d * FastMath.log(d));
        }

        private double hIntegralInverse(double d) {
            double d2 = d * (1.0 - this.d);
            if (d2 < -1.0) {
                d2 = -1.0;
            }
            return FastMath.exp(ZipfRejectionInversionSampler.helper1(d2) * d);
        }

        static double helper1(double d) {
            if (FastMath.abs(d) > 1.0E-8) {
                return FastMath.log1p(d) / d;
            }
            return 1.0 - d * (0.5 - d * (0.3333333333333333 - d * 0.25));
        }

        static double helper2(double d) {
            if (FastMath.abs(d) > 1.0E-8) {
                return FastMath.expm1(d) / d;
            }
            return 1.0 + d * 0.5 * (1.0 + d * 0.3333333333333333 * (1.0 + d * 0.25));
        }
    }
}

