/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Combinations
implements Iterable<int[]> {
    private final int b;
    private final int c;
    private final IterationOrder a;

    public Combinations(int n, int n2) {
        this(n, n2, IterationOrder.LEXICOGRAPHIC);
    }

    private Combinations(int n, int n2, IterationOrder iterationOrder) {
        CombinatoricsUtils.checkBinomial(n, n2);
        this.b = n;
        this.c = n2;
        this.a = iterationOrder;
    }

    public int getN() {
        return this.b;
    }

    public int getK() {
        return this.c;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Iterator<int[]> iterator() {
        try {
            try {
                if (this.c == 0) return new SingletonIterator(MathArrays.natural(this.c));
                if (this.c == this.b) {
                    return new SingletonIterator(MathArrays.natural(this.c));
                }
            }
            catch (MathInternalError mathInternalError) {
                throw Combinations.b(mathInternalError);
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
        try {
            switch (this.a) {
                case LEXICOGRAPHIC: {
                    return new LexicographicIterator(this.b, this.c);
                }
                default: {
                    throw new MathInternalError();
                }
            }
        }
        catch (MathInternalError mathInternalError) {
            throw Combinations.b(mathInternalError);
        }
    }

    public Comparator<int[]> comparator() {
        return new LexicographicComparator(this.b, this.c);
    }

    private static MathInternalError b(MathInternalError mathInternalError) {
        return mathInternalError;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicComparator
    implements Comparator<int[]>,
    Serializable {
        private static final long serialVersionUID = 20130906L;
        private final int b;
        private final int a;

        LexicographicComparator(int n, int n2) {
            this.b = n;
            this.a = n2;
        }

        @Override
        public int compare(int[] nArray, int[] nArray2) {
            try {
                if (nArray.length != this.a) {
                    throw new DimensionMismatchException(nArray.length, this.a);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (nArray2.length != this.a) {
                    throw new DimensionMismatchException(nArray2.length, this.a);
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            int[] nArray3 = MathArrays.copyOf(nArray);
            Arrays.sort(nArray3);
            int[] nArray4 = MathArrays.copyOf(nArray2);
            Arrays.sort(nArray4);
            long l = this.lexNorm(nArray3);
            long l2 = this.lexNorm(nArray4);
            try {
                if (l < l2) {
                    return -1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            try {
                if (l > l2) {
                    return 1;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw LexicographicComparator.b(dimensionMismatchException);
            }
            return 0;
        }

        private long lexNorm(int[] nArray) {
            long l = 0L;
            String string = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                block5: {
                    int n = nArray[i];
                    try {
                        try {
                            if (n >= 0 && n < this.b) break block5;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw LexicographicComparator.b(dimensionMismatchException);
                        }
                        throw new OutOfRangeException(n, (Number)0, this.b - 1);
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw LexicographicComparator.b(dimensionMismatchException);
                    }
                }
                l += (long)(nArray[i] * ArithmeticUtils.pow(this.b, i));
                if (string == null) continue;
            }
            return l;
        }

        private static DimensionMismatchException b(DimensionMismatchException dimensionMismatchException) {
            return dimensionMismatchException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SingletonIterator
    implements Iterator<int[]> {
        private final int[] a;
        private boolean b = true;

        SingletonIterator(int[] nArray) {
            this.a = nArray;
        }

        @Override
        public boolean hasNext() {
            return this.b;
        }

        @Override
        public int[] next() {
            try {
                if (this.b) {
                    this.b = false;
                    return this.a;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw SingletonIterator.b(noSuchElementException);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LexicographicIterator
    implements Iterator<int[]> {
        private final int a;
        private final int[] d;
        private boolean b;
        private int c;

        LexicographicIterator(int n, int n2) {
            block9: {
                String string;
                block8: {
                    this.b = true;
                    this.a = n2;
                    string = FastMath.b();
                    try {
                        try {
                            this.d = new int[n2 + 3];
                            if (n2 != 0 && n2 < n) break block8;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                        this.b = false;
                        return;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                for (int i = 1; i <= n2; ++i) {
                    try {
                        this.d[i] = i - 1;
                        if (string == null) {
                            if (string == null) continue;
                            break;
                        }
                        break block9;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw LexicographicIterator.b(noSuchElementException);
                    }
                }
                this.d[n2 + 1] = n;
                this.d[n2 + 2] = 0;
                this.c = n2;
            }
        }

        @Override
        public boolean hasNext() {
            return this.b;
        }

        @Override
        public int[] next() {
            int n;
            int n2;
            int n3;
            int[] nArray;
            block15: {
                String string = FastMath.b();
                try {
                    if (!this.b) {
                        throw new NoSuchElementException();
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                nArray = new int[this.a];
                System.arraycopy(this.d, 1, nArray, 0, this.a);
                n3 = 0;
                if (this.c > 0) {
                    this.d[this.c] = n3 = this.c;
                    --this.c;
                    return nArray;
                }
                try {
                    if (this.d[1] + 1 < this.d[2]) {
                        this.d[1] = this.d[1] + 1;
                        return nArray;
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    throw LexicographicIterator.b(noSuchElementException);
                }
                this.c = 2;
                boolean bl = false;
                while (!bl) {
                    block16: {
                        this.d[this.c - 1] = this.c - 2;
                        n3 = this.d[this.c] + 1;
                        try {
                            try {
                                n2 = n3;
                                n = this.d[this.c + 1];
                                if (string != null) break block15;
                                if (n2 != n) break block16;
                            }
                            catch (NoSuchElementException noSuchElementException) {
                                throw LexicographicIterator.b(noSuchElementException);
                            }
                            ++this.c;
                            if (string == null) continue;
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            throw LexicographicIterator.b(noSuchElementException);
                        }
                    }
                    bl = true;
                    if (string == null) continue;
                }
                n2 = this.c;
                n = this.a;
            }
            try {
                if (n2 > n) {
                    this.b = false;
                    return nArray;
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                throw LexicographicIterator.b(noSuchElementException);
            }
            this.d[this.c] = n3;
            --this.c;
            return nArray;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static NoSuchElementException b(NoSuchElementException noSuchElementException) {
            return noSuchElementException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IterationOrder
    extends Enum<IterationOrder> {
        public static final /* enum */ IterationOrder LEXICOGRAPHIC;
        private static final /* synthetic */ IterationOrder[] a;

        public static IterationOrder[] values() {
            return (IterationOrder[])a.clone();
        }

        public static IterationOrder valueOf(String string) {
            return Enum.valueOf(IterationOrder.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            char[] cArray;
            block12: {
                int n;
                char[] cArray2;
                int n2;
                int n3;
                block11: {
                    Object var1 = null;
                    char[] cArray3 = "z.\t)v,ed*\u0001(| ".toCharArray();
                    int n4 = cArray3.length;
                    n3 = 0;
                    n2 = 23;
                    cArray2 = cArray3;
                    n = n4;
                    if (n4 <= 1) break block11;
                    cArray = cArray2;
                    n = n;
                    if (n <= n3) break block12;
                }
                do {
                    int n5 = n2;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n6 = n2;
                    int n7 = n3;
                    while (true) {
                        int n8;
                        switch (n3 % 7) {
                            case 0: {
                                n8 = 33;
                                break;
                            }
                            case 1: {
                                n8 = 124;
                                break;
                            }
                            case 2: {
                                n8 = 70;
                                break;
                            }
                            case 3: {
                                n8 = 119;
                                break;
                            }
                            case 4: {
                                n8 = 34;
                                break;
                            }
                            case 5: {
                                n8 = 116;
                                break;
                            }
                            default: {
                                n8 = 53;
                            }
                        }
                        cArray4[n7] = (char)(cArray4[n7] ^ (n6 ^ n8));
                        ++n3;
                        n2 = n5;
                        if (n5 != 0) break;
                        n5 = n2;
                        cArray2 = cArray2;
                        n7 = n2;
                        cArray4 = cArray2;
                        n6 = n2;
                    }
                    cArray = cArray2;
                    n = n;
                } while (n > n3);
            }
            String string = new String(cArray).intern();
            LEXICOGRAPHIC = new IterationOrder();
            a = new IterationOrder[]{LEXICOGRAPHIC};
        }
    }
}

