/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import net.advancedplugins.items.impl.commons.effects.effects.AdvancedEffect;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.NotANumberException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Precision;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MathArrays {
    private static final String[] c;

    private MathArrays() {
    }

    public static double[] scale(double d, double[] dArray) {
        double[] dArray2;
        block4: {
            double[] dArray3 = new double[dArray.length];
            String string = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray2 = dArray3;
                    if (string == null) {
                        dArray2[i] = dArray[i] * d;
                        if (string == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    public static void scaleInPlace(double d, double[] dArray) {
        int n = 0;
        String string = FastMath.b();
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d;
            if (string == null) continue;
        }
    }

    public static double[] ebeAdd(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            String string = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (string == null) {
                        int n = i;
                        dArray3[n] = dArray3[n] + dArray2[i];
                        if (string == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeSubtract(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            String string = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (string == null) {
                        int n = i;
                        dArray3[n] = dArray3[n] - dArray2[i];
                        if (string == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeMultiply(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            MathArrays.checkEqualLength(dArray, dArray2);
            double[] dArray4 = (double[])dArray.clone();
            String string = FastMath.b();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (string == null) {
                        int n = i;
                        dArray3[n] = dArray3[n] * dArray2[i];
                        if (string == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double[] ebeDivide(double[] dArray, double[] dArray2) {
        double[] dArray3;
        block4: {
            String string = FastMath.b();
            MathArrays.checkEqualLength(dArray, dArray2);
            String string2 = string;
            double[] dArray4 = (double[])dArray.clone();
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    dArray3 = dArray4;
                    if (string2 == null) {
                        int n = i;
                        dArray3[n] = dArray3[n] / dArray2[i];
                        if (string2 == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray3 = dArray4;
        }
        return dArray3;
    }

    public static double distance1(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            String string = FastMath.b();
            MathArrays.checkEqualLength(dArray, dArray2);
            String string2 = string;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d = d2 + FastMath.abs(dArray[i] - dArray2[i]);
                if (string2 == null) {
                    d2 = d;
                    if (string2 == null) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public static int distance1(int[] nArray, int[] nArray2) {
        int n;
        block2: {
            String string = FastMath.b();
            MathArrays.checkEqualLength(nArray, nArray2);
            int n2 = 0;
            String string2 = string;
            for (int i = 0; i < nArray.length; ++i) {
                n = n2 + FastMath.abs(nArray[i] - nArray2[i]);
                if (string2 == null) {
                    n2 = n;
                    if (string2 == null) continue;
                }
                break block2;
            }
            n = n2;
        }
        return n;
    }

    public static double distance(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            String string = FastMath.b();
            MathArrays.checkEqualLength(dArray, dArray2);
            String string2 = string;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                double d3 = dArray[i] - dArray2[i];
                d = d2 + d3 * d3;
                if (string2 == null) {
                    d2 = d;
                    if (string2 == null) continue;
                }
                break block2;
            }
            d = FastMath.sqrt(d2);
        }
        return d;
    }

    public static double cosAngle(double[] dArray, double[] dArray2) {
        return MathArrays.linearCombination(dArray, dArray2) / (MathArrays.safeNorm(dArray) * MathArrays.safeNorm(dArray2));
    }

    public static double distance(int[] nArray, int[] nArray2) {
        double d;
        block2: {
            MathArrays.checkEqualLength(nArray, nArray2);
            double d2 = 0.0;
            String string = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                double d3 = nArray[i] - nArray2[i];
                d = d2 + d3 * d3;
                if (string == null) {
                    d2 = d;
                    if (string == null) continue;
                }
                break block2;
            }
            d = FastMath.sqrt(d2);
        }
        return d;
    }

    public static double distanceInf(double[] dArray, double[] dArray2) {
        double d;
        block2: {
            String string = FastMath.b();
            MathArrays.checkEqualLength(dArray, dArray2);
            String string2 = string;
            double d2 = 0.0;
            for (int i = 0; i < dArray.length; ++i) {
                d = FastMath.max(d2, FastMath.abs(dArray[i] - dArray2[i]));
                if (string2 == null) {
                    d2 = d;
                    if (string2 == null) continue;
                }
                break block2;
            }
            d = d2;
        }
        return d;
    }

    public static int distanceInf(int[] nArray, int[] nArray2) {
        int n;
        block2: {
            MathArrays.checkEqualLength(nArray, nArray2);
            int n2 = 0;
            String string = FastMath.b();
            for (int i = 0; i < nArray.length; ++i) {
                n = FastMath.max(n2, FastMath.abs(nArray[i] - nArray2[i]));
                if (string == null) {
                    n2 = n;
                    if (string == null) continue;
                }
                break block2;
            }
            n = n2;
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static <T extends Comparable<? super T>> boolean isMonotonic(T[] var0, OrderDirection var1_1, boolean var2_2) {
        block23: {
            var4_3 = var0[0];
            var5_4 = var0.length;
            var3_6 = FastMath.b();
            for (var6_5 = 1; var6_5 < var5_4; ++var6_5) {
                try {
                    v0 = 3.b[var1_1.ordinal()];
                    if (var3_6 != null) break block23;
                }
                catch (DimensionMismatchException v1) {
                    throw MathArrays.b(v1);
                }
                {
                    ** switch (v0)
                }
lbl-1000:
                // 1 sources

                {
                    case 1: {
                        var7_7 = var4_3.compareTo(var0[var6_5]);
                        try {
                            try {
                                if (var2_2) {
                                    if (var7_7 < 0) break;
                                }
                                ** GOTO lbl25
                            }
                            catch (DimensionMismatchException v2) {
                                throw MathArrays.b(v2);
                            }
                            return false;
                        }
                        catch (DimensionMismatchException v3) {
                            throw MathArrays.b(v3);
                        }
lbl25:
                        // 1 sources

                        try {
                            if (var7_7 > 0) {
                                return false;
                            }
                            break;
                        }
                        catch (DimensionMismatchException v4) {
                            throw MathArrays.b(v4);
                        }
                    }
lbl31:
                    // 1 sources

                    case 2: {
                        var7_7 = var0[var6_5].compareTo(var4_3);
                        try {
                            try {
                                if (var2_2) {
                                    if (var7_7 < 0) break;
                                }
                                ** GOTO lbl44
                            }
                            catch (DimensionMismatchException v5) {
                                throw MathArrays.b(v5);
                            }
                            return false;
                        }
                        catch (DimensionMismatchException v6) {
                            throw MathArrays.b(v6);
                        }
lbl44:
                        // 1 sources

                        try {
                            if (var7_7 > 0) {
                                return false;
                            }
                            break;
                        }
                        catch (DimensionMismatchException v7) {
                            throw MathArrays.b(v7);
                        }
                    }
lbl50:
                    // 1 sources

                    default: {
                        throw new MathInternalError();
                    }
                }
                var4_3 = var0[var6_5];
                if (var3_6 == null) continue;
            }
            v0 = 1;
        }
        return (boolean)v0;
    }

    public static boolean isMonotonic(double[] dArray, OrderDirection orderDirection, boolean bl) {
        return MathArrays.checkOrder(dArray, orderDirection, bl, false);
    }

    public static boolean checkEqualLength(double[] dArray, double[] dArray2, boolean bl) {
        try {
            if (dArray.length == dArray2.length) {
                return true;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        try {
            if (bl) {
                throw new DimensionMismatchException(dArray.length, dArray2.length);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return false;
    }

    public static void checkEqualLength(double[] dArray, double[] dArray2) {
        MathArrays.checkEqualLength(dArray, dArray2, true);
    }

    public static boolean checkEqualLength(int[] nArray, int[] nArray2, boolean bl) {
        try {
            if (nArray.length == nArray2.length) {
                return true;
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        try {
            if (bl) {
                throw new DimensionMismatchException(nArray.length, nArray2.length);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return false;
    }

    public static void checkEqualLength(int[] nArray, int[] nArray2) {
        MathArrays.checkEqualLength(nArray, nArray2, true);
    }

    /*
     * Exception decompiling
     */
    public static boolean checkOrder(double[] var0, OrderDirection var1_1, boolean var2_2, boolean var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void checkOrder(double[] dArray, OrderDirection orderDirection, boolean bl) {
        MathArrays.checkOrder(dArray, orderDirection, bl, true);
    }

    public static void checkOrder(double[] dArray) {
        MathArrays.checkOrder(dArray, OrderDirection.INCREASING, true);
    }

    public static void checkRectangular(long[][] lArray) {
        MathUtils.checkNotNull(lArray);
        String string = FastMath.b();
        for (int i = 1; i < lArray.length; ++i) {
            try {
                if (lArray[i].length == lArray[0].length) continue;
                throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, lArray[i].length, lArray[0].length);
            }
            catch (NullArgumentException nullArgumentException) {
                throw MathArrays.b(nullArgumentException);
            }
        }
    }

    public static void checkPositive(double[] dArray) {
        String string = FastMath.b();
        for (int i = 0; i < dArray.length; ++i) {
            try {
                if (!(dArray[i] <= 0.0)) continue;
                throw new NotStrictlyPositiveException(dArray[i]);
            }
            catch (NotStrictlyPositiveException notStrictlyPositiveException) {
                throw MathArrays.b(notStrictlyPositiveException);
            }
        }
    }

    public static void checkNotNaN(double[] dArray) {
        String string = FastMath.b();
        for (int i = 0; i < dArray.length; ++i) {
            try {
                if (!Double.isNaN(dArray[i])) continue;
                throw new NotANumberException();
            }
            catch (NotANumberException notANumberException) {
                throw MathArrays.b(notANumberException);
            }
        }
    }

    public static void checkNonNegative(long[] lArray) {
        String string = FastMath.b();
        for (int i = 0; i < lArray.length; ++i) {
            try {
                if (lArray[i] >= 0L) continue;
                throw new NotPositiveException(lArray[i]);
            }
            catch (NotPositiveException notPositiveException) {
                throw MathArrays.b(notPositiveException);
            }
        }
    }

    public static void checkNonNegative(long[][] lArray) {
        int n = 0;
        String string = FastMath.b();
        block2: while (true) {
            int n2 = n;
            block3: while (n2 < lArray.length) {
                for (int i = 0; i < lArray[n].length; ++i) {
                    long l = lArray[n][i] - 0L;
                    n2 = l == 0L ? 0 : (l < 0L ? -1 : 1);
                    if (string != null) continue block3;
                    try {
                        if (n2 >= 0) continue;
                        throw new NotPositiveException(lArray[n][i]);
                    }
                    catch (NotPositiveException notPositiveException) {
                        throw MathArrays.b(notPositiveException);
                    }
                }
                ++n;
                if (string == null) continue block2;
            }
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static double safeNorm(double[] var0) {
        block15: {
            var2_1 = 3.834E-20;
            var4_2 = 1.304E19;
            var1_3 = FastMath.b();
            var6_4 = 0.0;
            var8_5 = 0.0;
            var10_6 = 0.0;
            var12_7 = 0.0;
            var14_8 = 0.0;
            var16_9 = var0.length;
            var18_10 = var4_2 / var16_9;
            for (var20_11 = 0; var20_11 < var0.length; ++var20_11) {
                block17: {
                    block18: {
                        var21_13 = FastMath.abs(var0[var20_11]);
                        try {
                            try {
                                block16: {
                                    try {
                                        try {
                                            v0 = var21_13 == var2_1 ? 0 : (var21_13 < var2_1 ? -1 : 1);
                                            if (var1_3 != null) break block15;
                                            if (v0 < 0) break block16;
                                        }
                                        catch (DimensionMismatchException v1) {
                                            throw MathArrays.b(v1);
                                        }
                                        if (!(var21_13 > var18_10)) break block17;
                                    }
                                    catch (DimensionMismatchException v2) {
                                        throw MathArrays.b(v2);
                                    }
                                }
                                if (var21_13 > var2_1) {
                                }
                                ** GOTO lbl46
                            }
                            catch (DimensionMismatchException v3) {
                                throw MathArrays.b(v3);
                            }
                            if (!(var21_13 > var12_7)) break block18;
                        }
                        catch (DimensionMismatchException v4) {
                            throw MathArrays.b(v4);
                        }
                        var23_14 = var12_7 / var21_13;
                        var6_4 = 1.0 + var6_4 * var23_14 * var23_14;
                        var12_7 = var21_13;
                        if (var1_3 == null) continue;
                    }
                    var23_14 = var21_13 / var12_7;
                    var6_4 += var23_14 * var23_14;
                    try {
                        if (var1_3 == null) continue;
lbl46:
                        // 2 sources

                        if (var21_13 > var14_8) {
                        }
                        ** GOTO lbl56
                    }
                    catch (DimensionMismatchException v5) {
                        throw MathArrays.b(v5);
                    }
                    var23_14 = var14_8 / var21_13;
                    var10_6 = 1.0 + var10_6 * var23_14 * var23_14;
                    var14_8 = var21_13;
                    try {
                        if (var1_3 == null) continue;
lbl56:
                        // 2 sources

                        if (var21_13 == 0.0) continue;
                    }
                    catch (DimensionMismatchException v6) {
                        throw MathArrays.b(v6);
                    }
                    var23_14 = var21_13 / var14_8;
                    var10_6 += var23_14 * var23_14;
                    if (var1_3 == null) continue;
                }
                var8_5 += var21_13 * var21_13;
                if (var1_3 == null) continue;
            }
            v0 = (cfr_temp_0 = var6_4 - 0.0) == 0.0 ? 0 : (cfr_temp_0 > 0.0 ? 1 : -1);
        }
        var20_12 = v0 != false ? var12_7 * Math.sqrt(var6_4 + var8_5 / var12_7 / var12_7) : (var8_5 == 0.0 ? var14_8 * Math.sqrt(var10_6) : (var8_5 >= var14_8 ? Math.sqrt(var8_5 * (1.0 + var14_8 / var8_5 * (var14_8 * var10_6))) : Math.sqrt(var14_8 * (var8_5 / var14_8 + var14_8 * var10_6))));
        return var20_12;
    }

    public static void sortInPlace(double[] dArray, double[] ... dArray2) {
        MathArrays.sortInPlace(dArray, OrderDirection.INCREASING, dArray2);
    }

    public static void sortInPlace(double[] dArray, OrderDirection orderDirection, double[] ... dArray2) {
        Object object;
        int n;
        int[] nArray;
        int n2;
        int n3;
        String string;
        block26: {
            Comparator<PairDoubleInteger> comparator;
            ArrayList<PairDoubleInteger> arrayList;
            block25: {
                block24: {
                    string = FastMath.b();
                    try {
                        if (dArray == null) {
                            throw new NullArgumentException();
                        }
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                    n3 = dArray2.length;
                    n2 = dArray.length;
                    for (int i = 0; i < n3; ++i) {
                        double[] dArray3 = dArray2[i];
                        try {
                            if (dArray3 == null) {
                                throw new NullArgumentException();
                            }
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                        try {
                            if (dArray3.length == n2) continue;
                            throw new DimensionMismatchException(dArray3.length, n2);
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                    }
                    arrayList = new ArrayList<PairDoubleInteger>(n2);
                    for (int i = 0; i < n2; ++i) {
                        try {
                            arrayList.add(new PairDoubleInteger(dArray[i], i));
                            if (string == null) {
                                if (string == null) continue;
                                break;
                            }
                            break block24;
                        }
                        catch (NullArgumentException nullArgumentException) {
                            throw MathArrays.b(nullArgumentException);
                        }
                    }
                    try {
                        if (orderDirection != OrderDirection.INCREASING) break block24;
                        comparator = new Comparator<PairDoubleInteger>(){

                            @Override
                            public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                                return Double.compare(pairDoubleInteger.getKey(), pairDoubleInteger2.getKey());
                            }
                        };
                        break block25;
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                }
                comparator = new Comparator<PairDoubleInteger>(){

                    @Override
                    public int compare(PairDoubleInteger pairDoubleInteger, PairDoubleInteger pairDoubleInteger2) {
                        return Double.compare(pairDoubleInteger2.getKey(), pairDoubleInteger.getKey());
                    }
                };
            }
            Comparator<PairDoubleInteger> comparator2 = comparator;
            Collections.sort(arrayList, comparator2);
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                object = (PairDoubleInteger)arrayList.get(n);
                try {
                    dArray[n] = ((PairDoubleInteger)object).getKey();
                    nArray[n] = ((PairDoubleInteger)object).getValue();
                    if (string == null) {
                        if (string == null) continue;
                        break;
                    }
                    break block26;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw MathArrays.b(nullArgumentException);
                }
            }
            n = 0;
        }
        while (n < n3) {
            block27: {
                object = dArray2[n];
                double[] dArray4 = (double[])object.clone();
                for (int i = 0; i < n2; ++i) {
                    try {
                        object[i] = dArray4[nArray[i]];
                        if (string == null) {
                            if (string == null) continue;
                            break;
                        }
                        break block27;
                    }
                    catch (NullArgumentException nullArgumentException) {
                        throw MathArrays.b(nullArgumentException);
                    }
                }
                ++n;
            }
            if (string == null) continue;
        }
    }

    public static int[] copyOf(int[] nArray) {
        return MathArrays.copyOf(nArray, nArray.length);
    }

    public static double[] copyOf(double[] dArray) {
        return MathArrays.copyOf(dArray, dArray.length);
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, FastMath.min(n, nArray.length));
        return nArray2;
    }

    public static double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, FastMath.min(n, dArray.length));
        return dArray2;
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        int n3 = n2 - n;
        double[] dArray2 = new double[n3];
        System.arraycopy(dArray, n, dArray2, 0, FastMath.min(n3, dArray.length - n));
        return dArray2;
    }

    public static double linearCombination(double[] dArray, double[] dArray2) {
        double d;
        double d2;
        double d3;
        int n;
        String string;
        block12: {
            double d4;
            double d5;
            double[] dArray3;
            block11: {
                String string2 = FastMath.b();
                MathArrays.checkEqualLength(dArray, dArray2);
                string = string2;
                n = dArray.length;
                try {
                    if (n == 1) {
                        return dArray[0] * dArray2[0];
                    }
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                dArray3 = new double[n];
                d5 = 0.0;
                for (int i = 0; i < n; ++i) {
                    double d6 = dArray[i];
                    double d7 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L);
                    double d8 = d6 - d7;
                    double d9 = dArray2[i];
                    double d10 = Double.longBitsToDouble(Double.doubleToRawLongBits(d9) & 0xFFFFFFFFF8000000L);
                    double d11 = d9 - d10;
                    dArray3[i] = d6 * d9;
                    double d12 = d8 * d11 - (dArray3[i] - d7 * d10 - d8 * d10 - d7 * d11);
                    d4 = d5 + d12;
                    if (string == null) {
                        d5 = d4;
                        if (string == null) continue;
                    }
                    break block11;
                }
                d4 = dArray3[0];
            }
            double d13 = d4;
            double d14 = dArray3[1];
            double d15 = d13 + d14;
            double d16 = d15 - d14;
            double d17 = d14 - (d15 - d16) + (d13 - d16);
            int n2 = n - 1;
            for (int i = 1; i < n2; ++i) {
                d14 = dArray3[i + 1];
                double d18 = d15 + d14;
                d16 = d18 - d14;
                d17 += d14 - (d18 - d16) + (d15 - d16);
                d3 = d18;
                if (string == null) {
                    d15 = d3;
                    if (string == null) continue;
                }
                break block12;
            }
            d3 = d15 + (d5 + d17);
        }
        if (Double.isNaN(d2 = d3)) {
            d2 = 0.0;
            for (int i = 0; i < n; ++i) {
                d = d2 + dArray[i] * dArray2[i];
                if (string == null) {
                    d2 = d;
                    if (string == null) continue;
                }
                break;
            }
        } else {
            d = d2;
        }
        return d;
    }

    public static double linearCombination(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14 = d * d2;
        double d15 = d3 * d4;
        double d16 = d14 + d15;
        double d17 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d18 = d - d17;
        double d19 = d18 * (d13 = d2 - (d12 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L))) - (d14 - d17 * d12 - d18 * d12 - d17 * d13);
        double d20 = d16 + (d19 + (d11 = (d10 = d3 - (d9 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L))) * (d8 = d4 - (d7 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L))) - (d15 - d9 * d7 - d10 * d7 - d9 * d8)) + (d6 = d15 - (d16 - (d5 = d16 - d15)) + (d14 - d5)));
        if (Double.isNaN(d20)) {
            d20 = d * d2 + d3 * d4;
        }
        return d20;
    }

    public static double linearCombination(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d9 = d - d8;
        double d10 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d11 = d2 - d10;
        double d12 = d * d2;
        double d13 = d9 * d11 - (d12 - d8 * d10 - d9 * d10 - d8 * d11);
        double d14 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L);
        double d15 = d3 - d14;
        double d16 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L);
        double d17 = d4 - d16;
        double d18 = d3 * d4;
        double d19 = d15 * d17 - (d18 - d14 * d16 - d15 * d16 - d14 * d17);
        double d20 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L);
        double d21 = d5 - d20;
        double d22 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L);
        double d23 = d6 - d22;
        double d24 = d5 * d6;
        double d25 = d21 * d23 - (d24 - d20 * d22 - d21 * d22 - d20 * d23);
        String string = FastMath.b();
        double d26 = d12 + d18;
        double d27 = d26 + d24;
        double d28 = d26 - d18;
        double d29 = d18 - (d26 - d28) + (d12 - d28);
        double d30 = d27 - d24;
        double d31 = d24 - (d27 - d30) + (d26 - d30);
        double d32 = d27 + (d13 + d19 + d25 + d29 + d31);
        if (Double.isNaN(d32)) {
            d32 = d * d2 + d3 * d4 + d5 * d6;
        }
        try {
            d7 = d32;
            if (AdvancedEffect.b() == null) {
                FastMath.b(c[0]);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return d7;
    }

    public static double linearCombination(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18 = Double.longBitsToDouble(Double.doubleToRawLongBits(d) & 0xFFFFFFFFF8000000L);
        double d19 = d - d18;
        double d20 = Double.longBitsToDouble(Double.doubleToRawLongBits(d2) & 0xFFFFFFFFF8000000L);
        double d21 = d2 - d20;
        double d22 = d * d2;
        double d23 = d19 * d21 - (d22 - d18 * d20 - d19 * d20 - d18 * d21);
        double d24 = Double.longBitsToDouble(Double.doubleToRawLongBits(d3) & 0xFFFFFFFFF8000000L);
        double d25 = d3 - d24;
        double d26 = Double.longBitsToDouble(Double.doubleToRawLongBits(d4) & 0xFFFFFFFFF8000000L);
        double d27 = d4 - d26;
        double d28 = d3 * d4;
        double d29 = d25 * d27 - (d28 - d24 * d26 - d25 * d26 - d24 * d27);
        double d30 = Double.longBitsToDouble(Double.doubleToRawLongBits(d5) & 0xFFFFFFFFF8000000L);
        double d31 = d5 - d30;
        double d32 = Double.longBitsToDouble(Double.doubleToRawLongBits(d6) & 0xFFFFFFFFF8000000L);
        double d33 = d6 - d32;
        double d34 = d5 * d6;
        double d35 = d31 * d33 - (d34 - d30 * d32 - d31 * d32 - d30 * d33);
        String string = FastMath.b();
        double d36 = d22 + d28;
        double d37 = d36 + d34;
        double d38 = d7 * d8;
        double d39 = d37 + d38;
        double d40 = Double.longBitsToDouble(Double.doubleToRawLongBits(d7) & 0xFFFFFFFFF8000000L);
        double d41 = d7 - d40;
        double d42 = d41 * (d17 = d8 - (d16 = Double.longBitsToDouble(Double.doubleToRawLongBits(d8) & 0xFFFFFFFFF8000000L))) - (d38 - d40 * d16 - d41 * d16 - d40 * d17);
        double d43 = d39 + (d23 + d29 + d35 + d42 + (d15 = d28 - (d36 - (d14 = d36 - d28)) + (d22 - d14)) + (d13 = d34 - (d37 - (d12 = d37 - d34)) + (d36 - d12)) + (d11 = d38 - (d39 - (d10 = d39 - d38)) + (d37 - d10)));
        if (Double.isNaN(d43)) {
            d43 = d * d2 + d3 * d4 + d5 * d6 + d7 * d8;
        }
        try {
            d9 = d43;
            if (string != null) {
                AdvancedEffect.b(c[1]);
            }
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            throw MathArrays.b(dimensionMismatchException);
        }
        return d9;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        boolean bl;
        block21: {
            String string;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        string = FastMath.b();
                        try {
                            try {
                                try {
                                    if (fArray != null && fArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (fArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = fArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (fArray.length != fArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < fArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equals(fArray[i], fArray2[i]);
                        if (string != null) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(float[] fArray, float[] fArray2) {
        boolean bl;
        block21: {
            String string;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        string = FastMath.b();
                        try {
                            try {
                                try {
                                    if (fArray != null && fArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (fArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = fArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (fArray.length != fArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < fArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equalsIncludingNaN(fArray[i], fArray2[i]);
                        if (string != null) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        boolean bl;
        block21: {
            String string;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        string = FastMath.b();
                        try {
                            try {
                                try {
                                    if (dArray != null && dArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (dArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = dArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (dArray.length != dArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equals(dArray[i], dArray2[i]);
                        if (string != null) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static boolean equalsIncludingNaN(double[] dArray, double[] dArray2) {
        boolean bl;
        block21: {
            String string;
            block18: {
                boolean bl2;
                boolean bl3;
                boolean bl4;
                block20: {
                    block19: {
                        string = FastMath.b();
                        try {
                            try {
                                try {
                                    if (dArray != null && dArray2 != null) break block18;
                                }
                                catch (DimensionMismatchException dimensionMismatchException) {
                                    throw MathArrays.b(dimensionMismatchException);
                                }
                                if (dArray != null) break block19;
                            }
                            catch (DimensionMismatchException dimensionMismatchException) {
                                throw MathArrays.b(dimensionMismatchException);
                            }
                            bl4 = true;
                            break block20;
                        }
                        catch (DimensionMismatchException dimensionMismatchException) {
                            throw MathArrays.b(dimensionMismatchException);
                        }
                    }
                    bl4 = false;
                }
                try {
                    bl3 = dArray2 == null;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                try {
                    bl2 = !(bl4 ^ bl3);
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
                return bl2;
            }
            try {
                if (dArray.length != dArray2.length) {
                    return false;
                }
            }
            catch (DimensionMismatchException dimensionMismatchException) {
                throw MathArrays.b(dimensionMismatchException);
            }
            for (int i = 0; i < dArray.length; ++i) {
                try {
                    try {
                        bl = Precision.equalsIncludingNaN(dArray[i], dArray2[i]);
                        if (string != null) break block21;
                        if (bl) continue;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                    return false;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            bl = true;
        }
        return bl;
    }

    public static double[] normalizeArray(double[] dArray, double d) {
        double[] dArray2;
        block23: {
            double d2;
            int n;
            double[] dArray3;
            int n2;
            double d3;
            String string;
            block21: {
                double d4;
                string = FastMath.b();
                try {
                    if (Double.isInfinite(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (Double.isNaN(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                d3 = 0.0;
                n2 = dArray.length;
                dArray3 = new double[n2];
                for (n = 0; n < n2; ++n) {
                    block22: {
                        try {
                            try {
                                d2 = (double)Double.isInfinite(dArray[n]);
                                if (string != null) break block21;
                                if (d2 == false) break block22;
                            }
                            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                                throw MathArrays.b(mathIllegalArgumentException);
                            }
                            throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, dArray[n], n);
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                    }
                    if (Double.isNaN(dArray[n])) continue;
                    d3 += dArray[n];
                    if (string == null) continue;
                }
                d2 = (d4 = d3 - 0.0) == 0.0 ? 0 : (d4 > 0.0 ? 1 : -1);
            }
            try {
                if (d2 == false) {
                    throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            for (n = 0; n < n2; ++n) {
                try {
                    block24: {
                        try {
                            try {
                                dArray2 = dArray;
                                if (string != null) break block23;
                                if (!Double.isNaN(dArray2[n])) break block24;
                            }
                            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                                throw MathArrays.b(mathIllegalArgumentException);
                            }
                            dArray3[n] = Double.NaN;
                            if (string == null) continue;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                    }
                    dArray3[n] = dArray[n] * d / d3;
                    continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    public static <T> T[] buildArray(Field<T> field, int n) {
        Object[] objectArray = (Object[])Array.newInstance(field.getRuntimeClass(), n);
        Arrays.fill(objectArray, field.getZero());
        return objectArray;
    }

    public static <T> T[][] buildArray(Field<T> field, int n, int n2) {
        Object[][] objectArray;
        block5: {
            Object[][] objectArray2;
            block7: {
                String string;
                block6: {
                    string = FastMath.b();
                    if (n2 >= 0) break block6;
                    T[] TArray = MathArrays.buildArray(field, 0);
                    objectArray2 = (Object[][])Array.newInstance(TArray.getClass(), n);
                    if (string == null) break block7;
                }
                objectArray2 = (Object[][])Array.newInstance(field.getRuntimeClass(), n, n2);
                for (int i = 0; i < n; ++i) {
                    try {
                        objectArray = objectArray2;
                        if (string == null) {
                            Arrays.fill(objectArray[i], field.getZero());
                            if (string == null) continue;
                            break;
                        }
                        break block5;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                }
            }
            objectArray = objectArray2;
        }
        return objectArray;
    }

    public static double[] convolve(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        String string;
        block7: {
            String string2 = FastMath.b();
            MathUtils.checkNotNull(dArray);
            string = string2;
            MathUtils.checkNotNull(dArray2);
            n2 = dArray.length;
            n = dArray2.length;
            try {
                try {
                    if (n2 != 0 && n != 0) break block7;
                }
                catch (NullArgumentException nullArgumentException) {
                    throw MathArrays.b(nullArgumentException);
                }
                throw new NoDataException();
            }
            catch (NullArgumentException nullArgumentException) {
                throw MathArrays.b(nullArgumentException);
            }
        }
        int n3 = n2 + n - 1;
        double[] dArray3 = new double[n3];
        int n4 = 0;
        block4: while (true) {
            int n5 = n4;
            block5: while (n5 < n3) {
                double d = 0.0;
                int n6 = FastMath.max(0, n4 + 1 - n2);
                int n7 = n4 - n6;
                while (n6 < n) {
                    n5 = n7;
                    if (string != null) continue block5;
                    if (n5 < 0) break;
                    d += dArray[n7--] * dArray2[n6++];
                    if (string == null) continue;
                }
                dArray3[n4] = d;
                ++n4;
                if (string == null) continue block4;
            }
            break;
        }
        return dArray3;
    }

    public static void shuffle(int[] nArray, int n, Position position) {
        MathArrays.shuffle(nArray, n, position, new Well19937c());
    }

    /*
     * Exception decompiling
     */
    public static void shuffle(int[] var0, int var1_1, Position var2_2, RandomGenerator var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void shuffle(int[] nArray, RandomGenerator randomGenerator) {
        MathArrays.shuffle(nArray, 0, Position.TAIL, randomGenerator);
    }

    public static void shuffle(int[] nArray) {
        MathArrays.shuffle(nArray, new Well19937c());
    }

    public static int[] natural(int n) {
        return MathArrays.sequence(n, 0, 1);
    }

    public static int[] sequence(int n, int n2, int n3) {
        int[] nArray;
        block4: {
            int[] nArray2 = new int[n];
            String string = FastMath.b();
            for (int i = 0; i < n; ++i) {
                try {
                    nArray = nArray2;
                    if (string == null) {
                        nArray[i] = n2 + i * n3;
                        if (string == null) continue;
                        break;
                    }
                    break block4;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            nArray = nArray2;
        }
        return nArray;
    }

    public static boolean verifyValues(double[] dArray, int n, int n2) {
        return MathArrays.verifyValues(dArray, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, int n, int n2, boolean bl) {
        block16: {
            try {
                if (dArray == null) {
                    throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n < 0) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.START_POSITION, n);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n2 < 0) {
                    throw new NotPositiveException((Localizable)LocalizedFormats.LENGTH, n2);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                if (n + n2 > dArray.length) {
                    throw new NumberIsTooLargeException((Localizable)LocalizedFormats.SUBARRAY_ENDS_AFTER_ARRAY_END, (Number)(n + n2), dArray.length, true);
                }
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
            try {
                try {
                    if (n2 != 0 || bl) break block16;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                return false;
            }
            catch (MathIllegalArgumentException mathIllegalArgumentException) {
                throw MathArrays.b(mathIllegalArgumentException);
            }
        }
        return true;
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2) {
        return MathArrays.verifyValues(dArray, dArray2, n, n2, false);
    }

    public static boolean verifyValues(double[] dArray, double[] dArray2, int n, int n2, boolean bl) {
        boolean bl2;
        block21: {
            String string;
            block20: {
                string = FastMath.b();
                try {
                    try {
                        if (dArray2 != null && dArray != null) break block20;
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw MathArrays.b(mathIllegalArgumentException);
                    }
                    throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY, new Object[0]);
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
            }
            MathArrays.checkEqualLength(dArray2, dArray);
            boolean bl3 = false;
            for (int i = n; i < n + n2; ++i) {
                double d;
                block22: {
                    d = dArray2[i];
                    try {
                        try {
                            bl2 = Double.isNaN(d);
                            if (string != null) break block21;
                            if (!bl2) break block22;
                        }
                        catch (MathIllegalArgumentException mathIllegalArgumentException) {
                            throw MathArrays.b(mathIllegalArgumentException);
                        }
                        throw new MathIllegalArgumentException(LocalizedFormats.NAN_ELEMENT_AT_INDEX, i);
                    }
                    catch (MathIllegalArgumentException mathIllegalArgumentException) {
                        throw MathArrays.b(mathIllegalArgumentException);
                    }
                }
                try {
                    if (Double.isInfinite(d)) {
                        throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, d, i);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (d < 0.0) {
                        throw new MathIllegalArgumentException(LocalizedFormats.NEGATIVE_ELEMENT_AT_INDEX, i, d);
                    }
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                try {
                    if (bl3 || !(d > 0.0)) continue;
                }
                catch (MathIllegalArgumentException mathIllegalArgumentException) {
                    throw MathArrays.b(mathIllegalArgumentException);
                }
                bl3 = true;
                if (string == null) continue;
            }
            bl2 = bl3;
        }
        try {
            if (!bl2) {
                throw new MathIllegalArgumentException(LocalizedFormats.WEIGHT_AT_LEAST_ONE_NON_ZERO, new Object[0]);
            }
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            throw MathArrays.b(mathIllegalArgumentException);
        }
        return MathArrays.verifyValues(dArray, n, n2, bl);
    }

    public static double[] concatenate(double[] ... dArray) {
        double[] dArray2;
        block5: {
            int n;
            String string;
            int n2;
            int n3;
            block4: {
                n3 = 0;
                double[][] dArray3 = dArray;
                n2 = dArray3.length;
                string = FastMath.b();
                for (int i = 0; i < n2; ++i) {
                    double[] dArray4 = dArray3[i];
                    n = n3 + dArray4.length;
                    if (string == null) {
                        n3 = n;
                        if (string == null) continue;
                    }
                    break block4;
                }
                n = 0;
            }
            int n4 = n;
            n2 = 0;
            double[] dArray5 = new double[n3];
            for (int i = 0; i < dArray.length; ++i) {
                n2 = dArray[i].length;
                dArray2 = dArray[i];
                if (string == null) {
                    System.arraycopy(dArray2, 0, dArray5, n4, n2);
                    n4 += n2;
                    if (string == null) continue;
                }
                break block5;
            }
            dArray2 = dArray5;
        }
        return dArray2;
    }

    public static double[] unique(double[] dArray) {
        double[] dArray2;
        block9: {
            int n;
            String string;
            TreeSet<Double> treeSet;
            block8: {
                treeSet = new TreeSet<Double>();
                string = FastMath.b();
                for (n = 0; n < dArray.length; ++n) {
                    try {
                        treeSet.add(dArray[n]);
                        if (string == null) {
                            if (string == null) continue;
                            break;
                        }
                        break block8;
                    }
                    catch (DimensionMismatchException dimensionMismatchException) {
                        throw MathArrays.b(dimensionMismatchException);
                    }
                }
                n = treeSet.size();
            }
            double[] dArray3 = new double[n];
            Iterator iterator = treeSet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                try {
                    dArray2 = dArray3;
                    if (string == null) {
                        dArray2[n - ++n2] = (Double)iterator.next();
                        if (string == null) continue;
                        break;
                    }
                    break block9;
                }
                catch (DimensionMismatchException dimensionMismatchException) {
                    throw MathArrays.b(dimensionMismatchException);
                }
            }
            dArray2 = dArray3;
        }
        return dArray2;
    }

    private static MathIllegalArgumentException b(MathIllegalArgumentException mathIllegalArgumentException) {
        return mathIllegalArgumentException;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String[] stringArray = new String[2];
        int n = 0;
        String string = ":\t\u0012\u0011%`\u0006<?dI0`";
        int n2 = ":\t\u0012\u0011%`\u0006<?dI0`".length();
        int n3 = 6;
        int n4 = -1;
        while (true) {
            char[] cArray;
            block14: {
                int n5;
                char[] cArray2;
                int n6;
                int n7;
                block13: {
                    int n8 = ++n4;
                    Object var6_6 = null;
                    char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                    int n9 = cArray3.length;
                    n7 = 0;
                    n6 = 77;
                    cArray2 = cArray3;
                    n5 = n9;
                    if (n9 <= 1) break block13;
                    cArray = cArray2;
                    n5 = n5;
                    if (n5 <= n7) break block14;
                }
                do {
                    int n10 = n6;
                    cArray2 = cArray2;
                    char[] cArray4 = cArray2;
                    int n11 = n6;
                    int n12 = n7;
                    while (true) {
                        int n13;
                        switch (n7 % 7) {
                            case 0: {
                                n13 = 16;
                                break;
                            }
                            case 1: {
                                n13 = 3;
                                break;
                            }
                            case 2: {
                                n13 = 28;
                                break;
                            }
                            case 3: {
                                n13 = 51;
                                break;
                            }
                            case 4: {
                                n13 = 60;
                                break;
                            }
                            case 5: {
                                n13 = 79;
                                break;
                            }
                            default: {
                                n13 = 84;
                            }
                        }
                        cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                        ++n7;
                        n6 = n10;
                        if (n10 != 0) break;
                        n10 = n6;
                        cArray2 = cArray2;
                        n12 = n6;
                        cArray4 = cArray2;
                        n11 = n6;
                    }
                    cArray = cArray2;
                    n5 = n5;
                } while (n5 > n7);
            }
            stringArray[n++] = new String(cArray).intern();
            if ((n4 += n3) >= n2) {
                c = stringArray;
                return;
            }
            n3 = string.charAt(n4);
        }
    }

    static class 3 {
        static final /* synthetic */ int[] b;
        static final /* synthetic */ int[] a;

        static {
            a = new int[Position.values().length];
            try {
                3.a[Position.TAIL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.a[Position.HEAD.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            b = new int[OrderDirection.values().length];
            try {
                3.b[OrderDirection.INCREASING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                3.b[OrderDirection.DECREASING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position HEAD;
        public static final /* enum */ Position TAIL;
        private static final /* synthetic */ Position[] a;

        public static Position[] values() {
            return (Position[])a.clone();
        }

        public static Position valueOf(String string) {
            return Enum.valueOf(Position.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "!~^|\u0004=zVt";
            int n2 = "!~^|\u0004=zVt".length();
            int n3 = 4;
            int n4 = -1;
            while (true) {
                char[] cArray;
                block14: {
                    int n5;
                    char[] cArray2;
                    int n6;
                    int n7;
                    block13: {
                        int n8 = ++n4;
                        Object var7_6 = null;
                        char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                        int n9 = cArray3.length;
                        n7 = 0;
                        n6 = 43;
                        cArray2 = cArray3;
                        n5 = n9;
                        if (n9 <= 1) break block13;
                        cArray = cArray2;
                        n5 = n5;
                        if (n5 <= n7) break block14;
                    }
                    do {
                        int n10 = n6;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n11 = n6;
                        int n12 = n7;
                        while (true) {
                            int n13;
                            switch (n7 % 7) {
                                case 0: {
                                    n13 = 94;
                                    break;
                                }
                                case 1: {
                                    n13 = 20;
                                    break;
                                }
                                case 2: {
                                    n13 = 60;
                                    break;
                                }
                                case 3: {
                                    n13 = 27;
                                    break;
                                }
                                case 4: {
                                    n13 = 31;
                                    break;
                                }
                                case 5: {
                                    n13 = 20;
                                    break;
                                }
                                default: {
                                    n13 = 103;
                                }
                            }
                            cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                            ++n7;
                            n6 = n10;
                            if (n10 != 0) break;
                            n10 = n6;
                            cArray2 = cArray2;
                            n12 = n6;
                            cArray4 = cArray2;
                            n11 = n6;
                        }
                        cArray = cArray2;
                        n5 = n5;
                    } while (n5 > n7);
                }
                stringArray[n++] = new String(cArray).intern();
                if ((n4 += n3) >= n2) {
                    String[] stringArray2 = stringArray;
                    HEAD = new Position();
                    TAIL = new Position();
                    a = new Position[]{HEAD, TAIL};
                    return;
                }
                n3 = string.charAt(n4);
            }
        }
    }

    private static class PairDoubleInteger {
        private final double a;
        private final int b;

        PairDoubleInteger(double d, int n) {
            this.a = d;
            this.b = n;
        }

        public double getKey() {
            return this.a;
        }

        public int getValue() {
            return this.b;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OrderDirection
    extends Enum<OrderDirection> {
        public static final /* enum */ OrderDirection INCREASING;
        public static final /* enum */ OrderDirection DECREASING;
        private static final /* synthetic */ OrderDirection[] a;

        public static OrderDirection[] values() {
            return (OrderDirection[])a.clone();
        }

        public static OrderDirection valueOf(String string) {
            return Enum.valueOf(OrderDirection.class, string);
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         */
        static {
            String[] stringArray = new String[2];
            int n = 0;
            String string = "3Uzm\u0007\u00179>^~\n>^zm\u0007\u00179>^~";
            int n2 = "3Uzm\u0007\u00179>^~\n>^zm\u0007\u00179>^~".length();
            int n3 = 10;
            int n4 = -1;
            while (true) {
                char[] cArray;
                block14: {
                    int n5;
                    char[] cArray2;
                    int n6;
                    int n7;
                    block13: {
                        int n8 = ++n4;
                        Object var7_6 = null;
                        char[] cArray3 = string.substring(n8, n8 + n3).toCharArray();
                        int n9 = cArray3.length;
                        n7 = 0;
                        n6 = 108;
                        cArray2 = cArray3;
                        n5 = n9;
                        if (n9 <= 1) break block13;
                        cArray = cArray2;
                        n5 = n5;
                        if (n5 <= n7) break block14;
                    }
                    do {
                        int n10 = n6;
                        cArray2 = cArray2;
                        char[] cArray4 = cArray2;
                        int n11 = n6;
                        int n12 = n7;
                        while (true) {
                            int n13;
                            switch (n7 % 7) {
                                case 0: {
                                    n13 = 27;
                                    break;
                                }
                                case 1: {
                                    n13 = 124;
                                    break;
                                }
                                case 2: {
                                    n13 = 85;
                                    break;
                                }
                                case 3: {
                                    n13 = 83;
                                    break;
                                }
                                case 4: {
                                    n13 = 46;
                                    break;
                                }
                                case 5: {
                                    n13 = 58;
                                    break;
                                }
                                default: {
                                    n13 = 6;
                                }
                            }
                            cArray4[n12] = (char)(cArray4[n12] ^ (n11 ^ n13));
                            ++n7;
                            n6 = n10;
                            if (n10 != 0) break;
                            n10 = n6;
                            cArray2 = cArray2;
                            n12 = n6;
                            cArray4 = cArray2;
                            n11 = n6;
                        }
                        cArray = cArray2;
                        n5 = n5;
                    } while (n5 > n7);
                }
                stringArray[n++] = new String(cArray).intern();
                if ((n4 += n3) >= n2) {
                    String[] stringArray2 = stringArray;
                    INCREASING = new OrderDirection();
                    DECREASING = new OrderDirection();
                    a = new OrderDirection[]{INCREASING, DECREASING};
                    return;
                }
                n3 = string.charAt(n4);
            }
        }
    }

    public static interface Function {
        public double evaluate(double[] var1);

        public double evaluate(double[] var1, int var2, int var3);
    }
}

