/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.block;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import me.extremall.advancedkits.libs.boostedyaml.block.Comments;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Block<T> {
    List<CommentLine> beforeKeyComments = new ArrayList<CommentLine>(0);
    List<CommentLine> inlineKeyComments = null;
    List<CommentLine> afterKeyComments = null;
    List<CommentLine> beforeValueComments = null;
    List<CommentLine> inlineValueComments = null;
    List<CommentLine> afterValueComments = null;
    private final T value;
    private boolean ignored;

    public Block(@Nullable Node node, @Nullable Node node2, @Nullable T t2) {
        this.value = t2;
        this.init(node, node2);
    }

    public Block(@Nullable T t2) {
        this(null, null, t2);
    }

    public Block(@Nullable Block<?> block, @Nullable T t2) {
        this.value = t2;
        if (block == null) {
            return;
        }
        this.beforeKeyComments = block.beforeKeyComments;
        this.inlineKeyComments = block.inlineKeyComments;
        this.afterKeyComments = block.afterKeyComments;
        this.beforeValueComments = block.beforeValueComments;
        this.inlineValueComments = block.inlineValueComments;
        this.afterValueComments = block.afterValueComments;
    }

    public void init(@Nullable Node node, @Nullable Node node2) {
        if (node != null) {
            List<Object> list = this.beforeKeyComments = node.getBlockComments() == null ? new ArrayList(0) : node.getBlockComments();
            if (node.getInLineComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(node.getInLineComments()));
            }
            if (node.getEndComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(node.getEndComments()));
            }
            this.collectComments(node, true);
        }
        if (node2 != null) {
            this.beforeValueComments = node2.getBlockComments();
            if (this.beforeKeyComments == null) {
                this.beforeKeyComments = new ArrayList<CommentLine>(0);
            }
            if (node2.getInLineComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(node2.getInLineComments()));
            }
            if (node2.getEndComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(node2.getEndComments()));
            }
            this.collectComments(node2, true);
        }
    }

    private void collectComments(@NotNull Node iterator, boolean bl2) {
        if (!bl2) {
            if (((Node)((Object)iterator)).getBlockComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(((Node)((Object)iterator)).getBlockComments()));
            }
            if (((Node)((Object)iterator)).getInLineComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(((Node)((Object)iterator)).getInLineComments()));
            }
            if (((Node)((Object)iterator)).getEndComments() != null) {
                this.beforeKeyComments.addAll(this.toBlockComments(((Node)((Object)iterator)).getEndComments()));
            }
        } else if (this.beforeKeyComments == null) {
            this.beforeKeyComments = new ArrayList<CommentLine>(0);
        }
        if (iterator instanceof SequenceNode) {
            iterator = (SequenceNode)((Object)iterator);
            for (Node node : ((SequenceNode)((Object)iterator)).getValue()) {
                this.collectComments(node, false);
            }
            return;
        }
        if (!bl2 && iterator instanceof MappingNode) {
            iterator = (MappingNode)((Object)iterator);
            for (NodeTuple nodeTuple : ((MappingNode)((Object)iterator)).getValue()) {
                this.collectComments(nodeTuple.getKeyNode(), false);
                this.collectComments(nodeTuple.getValueNode(), false);
            }
        }
    }

    private List<CommentLine> toBlockComments(@NotNull List<CommentLine> list) {
        int n2 = -1;
        for (CommentLine commentLine : list) {
            list.set(++n2, commentLine.getCommentType() != CommentType.IN_LINE ? commentLine : new CommentLine(commentLine.getStartMark(), commentLine.getEndMark(), commentLine.getValue(), CommentType.BLOCK));
        }
        return list;
    }

    @Nullable
    public List<String> getComments() {
        List<CommentLine> list = Comments.get(this, Comments.NodeType.KEY, Comments.Position.BEFORE);
        if (list == null) {
            return null;
        }
        return list.stream().map(CommentLine::getValue).collect(Collectors.toList());
    }

    public void setComments(@Nullable List<String> list) {
        Comments.set(this, Comments.NodeType.KEY, Comments.Position.BEFORE, list == null ? null : list.stream().map(string -> Comments.create(string, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void removeComments() {
        Comments.remove(this, Comments.NodeType.KEY, Comments.Position.BEFORE);
    }

    public void addComments(@NotNull List<String> list) {
        Comments.add(this, Comments.NodeType.KEY, Comments.Position.BEFORE, list.stream().map(string -> Comments.create(string, Comments.Position.BEFORE)).collect(Collectors.toList()));
    }

    public void addComment(@NotNull String string) {
        Comments.add(this, Comments.NodeType.KEY, Comments.Position.BEFORE, Comments.create(string, Comments.Position.BEFORE));
    }

    public void setIgnored(boolean bl2) {
        this.ignored = bl2;
    }

    public boolean isIgnored() {
        return this.ignored;
    }

    public abstract boolean isSection();

    public T getStoredValue() {
        return this.value;
    }
}

