/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.block.implementation;

import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import me.extremall.advancedkits.libs.boostedyaml.YamlDocument;
import me.extremall.advancedkits.libs.boostedyaml.block.Block;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.TerminatedBlock;
import me.extremall.advancedkits.libs.boostedyaml.engine.ExtendedConstructor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import me.extremall.advancedkits.libs.boostedyaml.settings.general.GeneralSettings;
import me.extremall.advancedkits.libs.boostedyaml.utils.conversion.ListConversions;
import me.extremall.advancedkits.libs.boostedyaml.utils.conversion.PrimitiveConversions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Section
extends Block<Map<Object, Block<?>>> {
    private YamlDocument root;
    private Section defaults = null;
    private Section parent;
    private Object name;
    private Route route;

    public Section(@NotNull YamlDocument yamlDocument, @Nullable Section section, @NotNull Route route, @Nullable Node node, @NotNull MappingNode mappingNode, @NotNull ExtendedConstructor extendedConstructor) {
        super(node, mappingNode, yamlDocument.getGeneralSettings().getDefaultMap());
        this.root = yamlDocument;
        this.parent = section;
        Route route2 = route;
        this.name = this.adaptKey(route2.get(route2.length() - 1));
        this.route = route;
        this.resetDefaults();
        this.init(yamlDocument, node, mappingNode, extendedConstructor);
    }

    public Section(@NotNull YamlDocument yamlDocument, @Nullable Section object, @NotNull Route route, @Nullable Block<?> object22, @NotNull Map<?, ?> object3) {
        super((Block<?>)object22, yamlDocument.getGeneralSettings().getDefaultMap());
        Object object2;
        this.root = yamlDocument;
        this.parent = object;
        Route route2 = route;
        this.name = this.adaptKey(route2.get(route2.length() - 1));
        this.route = route;
        this.resetDefaults();
        for (Map.Entry entry : object2.entrySet()) {
            object2 = this.adaptKey(entry.getKey());
            Object v2 = entry.getValue();
            ((Map)this.getStoredValue()).put(object2, v2 instanceof Map ? new Section(yamlDocument, this, route.add(object2), null, (Map)v2) : new TerminatedBlock(null, v2));
        }
    }

    public Section(@NotNull Map<Object, Block<?>> map) {
        super(map);
        this.root = null;
        this.parent = null;
        this.name = null;
        this.route = null;
        this.defaults = null;
    }

    protected void initEmpty(@NotNull YamlDocument yamlDocument) {
        if (!yamlDocument.isRoot()) {
            throw new IllegalStateException("Cannot init non-root section!");
        }
        super.init(null, null);
        this.root = yamlDocument;
        this.resetDefaults();
    }

    /*
     * WARNING - void declaration
     */
    protected void init(@NotNull YamlDocument yamlDocument, @Nullable Node object, @NotNull MappingNode object22, @NotNull ExtendedConstructor extendedConstructor) {
        super.init((Node)((Object)object), (Node)object22);
        this.root = yamlDocument;
        this.resetDefaults();
        for (NodeTuple nodeTuple : ((MappingNode)object22).getValue()) {
            Block block;
            void var4_6;
            Object object2 = this.adaptKey(var4_6.getConstructed(nodeTuple.getKeyNode()));
            Object object3 = var4_6.getConstructed(nodeTuple.getValueNode());
            Map map = (Map)this.getStoredValue();
            if (object3 instanceof Map) {
                Section section = this;
                block = new Section(yamlDocument, section, section.getSubRoute(object2), nodeTuple.getKeyNode(), (MappingNode)nodeTuple.getValueNode(), (ExtendedConstructor)var4_6);
            } else {
                block = new TerminatedBlock(nodeTuple.getKeyNode(), nodeTuple.getValueNode(), object3);
            }
            map.put(object2, block);
        }
    }

    public boolean isEmpty(boolean bl2) {
        if (((Map)this.getStoredValue()).isEmpty()) {
            return true;
        }
        if (!bl2) {
            return false;
        }
        for (Block block : ((Map)this.getStoredValue()).values()) {
            if (!(block instanceof TerminatedBlock) && (!(block instanceof Section) || ((Section)block).isEmpty(true))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSection() {
        return true;
    }

    public boolean isRoot() {
        return false;
    }

    @NotNull
    public YamlDocument getRoot() {
        return this.root;
    }

    public Section getParent() {
        return this.parent;
    }

    @Nullable
    public Object getName() {
        return this.name;
    }

    @Nullable
    public String getNameAsString() {
        if (this.name == null) {
            return null;
        }
        return this.name.toString();
    }

    @NotNull
    public Route getNameAsRoute() {
        return Route.from(this.name);
    }

    @Nullable
    public Route getRoute() {
        return this.route;
    }

    @Nullable
    public String getRouteAsString() {
        if (this.route == null) {
            return null;
        }
        return this.route.join(this.root.getGeneralSettings().getRouteSeparator());
    }

    @NotNull
    public Route getSubRoute(@NotNull Object object) {
        return Route.addTo(this.route, object);
    }

    @Nullable
    public Section getDefaults() {
        return this.defaults;
    }

    public boolean hasDefaults() {
        return this.defaults != null;
    }

    private void adapt(@NotNull YamlDocument yamlDocument, @Nullable Section section, @NotNull Route route) {
        if (this.parent != null && this.parent != section && ((Map)this.parent.getStoredValue()).get(this.name) == this) {
            this.parent.removeInternal(this.parent, this.name);
        }
        Route route2 = route;
        this.name = route2.get(route2.length() - 1);
        this.parent = section;
        this.adapt(yamlDocument, route);
    }

    private void adapt(@NotNull YamlDocument yamlDocument, @NotNull Route route) {
        this.root = yamlDocument;
        this.route = route;
        this.resetDefaults();
        for (Map.Entry entry : ((Map)this.getStoredValue()).entrySet()) {
            if (!(entry.getValue() instanceof Section)) continue;
            ((Section)entry.getValue()).adapt(yamlDocument, route.add(entry.getKey()));
        }
    }

    @NotNull
    public Object adaptKey(@NotNull Object object) {
        Objects.requireNonNull(object, "Sections cannot contain null keys!");
        if (this.root.getGeneralSettings().getKeyFormat() == GeneralSettings.KeyFormat.OBJECT) {
            return object;
        }
        return object.toString();
    }

    private void resetDefaults() {
        this.defaults = this.isRoot() ? this.root.getDefaults() : (this.parent == null || this.parent.defaults == null ? null : this.parent.defaults.getSection(Route.fromSingleKey(this.name), null));
    }

    private boolean canUseDefaults() {
        return this.hasDefaults() && this.root.getGeneralSettings().isUseDefaults();
    }

    @NotNull
    public Set<Route> getRoutes(boolean bl2) {
        Set<Route> set = this.root.getGeneralSettings().getDefaultSet();
        if (this.canUseDefaults()) {
            set.addAll(this.defaults.getRoutes(bl2));
        }
        this.addData((route, entry) -> set.add((Route)route), null, bl2);
        return set;
    }

    @NotNull
    public Set<String> getRoutesAsStrings(boolean bl2) {
        Set<String> set = this.root.getGeneralSettings().getDefaultSet();
        if (this.canUseDefaults()) {
            set.addAll(this.defaults.getRoutesAsStrings(bl2));
        }
        this.addData((string, entry) -> set.add((String)string), new StringBuilder(), this.root.getGeneralSettings().getRouteSeparator(), bl2);
        return set;
    }

    @NotNull
    public Set<Object> getKeys() {
        Set<Object> set = this.root.getGeneralSettings().getDefaultSet(((Map)this.getStoredValue()).size());
        if (this.canUseDefaults()) {
            set.addAll(this.defaults.getKeys());
        }
        set.addAll(((Map)this.getStoredValue()).keySet());
        return set;
    }

    @NotNull
    public Map<Route, Object> getRouteMappedValues(boolean bl2) {
        Map<Route, Object> map = this.root.getGeneralSettings().getDefaultMap();
        if (this.canUseDefaults()) {
            map.putAll(this.defaults.getRouteMappedValues(bl2));
        }
        this.addData((route, entry) -> map.put((Route)route, entry.getValue() instanceof Section ? entry.getValue() : ((Block)entry.getValue()).getStoredValue()), null, bl2);
        return map;
    }

    @NotNull
    public Map<String, Object> getStringRouteMappedValues(boolean bl2) {
        Map<String, Object> map = this.root.getGeneralSettings().getDefaultMap();
        if (this.canUseDefaults()) {
            map.putAll(this.defaults.getStringRouteMappedValues(bl2));
        }
        this.addData((string, entry) -> map.put((String)string, entry.getValue() instanceof Section ? entry.getValue() : ((Block)entry.getValue()).getStoredValue()), new StringBuilder(), this.root.getGeneralSettings().getRouteSeparator(), bl2);
        return map;
    }

    @NotNull
    public Map<Route, Block<?>> getRouteMappedBlocks(boolean bl2) {
        Map<Route, Block<?>> map = this.root.getGeneralSettings().getDefaultMap();
        if (this.canUseDefaults()) {
            map.putAll(this.defaults.getRouteMappedBlocks(bl2));
        }
        this.addData((route, entry) -> map.put((Route)route, (Block<?>)entry.getValue()), null, bl2);
        return map;
    }

    @NotNull
    public Map<String, Block<?>> getStringRouteMappedBlocks(boolean bl2) {
        Map<String, Block<?>> map = this.root.getGeneralSettings().getDefaultMap();
        if (this.canUseDefaults()) {
            map.putAll(this.defaults.getStringRouteMappedBlocks(bl2));
        }
        this.addData((string, entry) -> map.put((String)string, (Block<?>)entry.getValue()), new StringBuilder(), this.root.getGeneralSettings().getRouteSeparator(), bl2);
        return map;
    }

    private void addData(@NotNull BiConsumer<Route, Map.Entry<?, Block<?>>> biConsumer, @Nullable Route route, boolean bl2) {
        for (Map.Entry entry : ((Map)this.getStoredValue()).entrySet()) {
            Route route2 = Route.addTo(route, entry.getKey());
            biConsumer.accept(route2, entry);
            if (!bl2 || !(entry.getValue() instanceof Section)) continue;
            ((Section)entry.getValue()).addData(biConsumer, route2, true);
        }
    }

    private void addData(@NotNull BiConsumer<String, Map.Entry<?, Block<?>>> biConsumer, @NotNull StringBuilder stringBuilder, char c2, boolean bl2) {
        for (Map.Entry entry : ((Map)this.getStoredValue()).entrySet()) {
            int n2 = stringBuilder.length();
            if (n2 > 0) {
                stringBuilder.append(c2);
            }
            biConsumer.accept(stringBuilder.append(entry.getKey().toString()).toString(), entry);
            if (bl2 && entry.getValue() instanceof Section) {
                ((Section)entry.getValue()).addData(biConsumer, stringBuilder, c2, true);
            }
            stringBuilder.setLength(n2);
        }
    }

    public boolean contains(@NotNull Route route) {
        return this.getBlock(route) != null;
    }

    public boolean contains(@NotNull String string) {
        return this.getBlock(string) != null;
    }

    public Section createSection(@NotNull Route route) {
        Section section = this;
        for (int i2 = 0; i2 < route.length(); ++i2) {
            section = section.createSectionInternal(route.get(i2), null);
        }
        return section;
    }

    public Section createSection(@NotNull String string) {
        int n2;
        int n3 = 0;
        Section section = this;
        while ((n2 = string.indexOf(this.root.getGeneralSettings().getRouteSeparator(), n3)) != -1) {
            section = section.createSectionInternal(string.substring(n3, n2), null);
            n3 = n2 + 1;
        }
        return section.createSectionInternal(string.substring(n3), null);
    }

    private Section createSectionInternal(@NotNull Object object, @Nullable Block<?> block) {
        object = this.adaptKey(object);
        return this.getOptionalSection(Route.from(object)).orElseGet(() -> {
            Section section = this;
            block = new Section(this.root, section, section.getSubRoute(object), block, this.root.getGeneralSettings().getDefaultMap());
            ((Map)this.getStoredValue()).put(object, block);
            return block;
        });
    }

    public void repopulate(@NotNull Map<Object, Block<?>> map) {
        this.clear();
        map.forEach(this::setInternal);
    }

    public void setAll(@NotNull Map<Route, Object> map) {
        map.forEach(this::set);
    }

    public void set(@NotNull Route route, @Nullable Object object) {
        int n2 = -1;
        Section section = this;
        while (++n2 < route.length()) {
            if (n2 + 1 >= route.length()) {
                section.setInternal(this.adaptKey(route.get(n2)), object);
                return;
            }
            Object object2 = this.adaptKey(route.get(n2));
            Block block = ((Map)section.getStoredValue()).getOrDefault(object2, null);
            section = !(block instanceof Section) ? section.createSectionInternal(object2, block) : (Section)block;
        }
    }

    public void set(@NotNull String string, @Nullable Object object) {
        int n2 = 0;
        Section section = this;
        while (true) {
            int n3;
            if ((n3 = string.indexOf(this.root.getGeneralSettings().getRouteSeparator(), n2)) == -1) {
                section.setInternal(string.substring(n2), object);
                return;
            }
            section = section.createSection(string.substring(n2, n3));
            n2 = n3 + 1;
        }
    }

    private void setInternal(@NotNull Object object, @Nullable Object object2) {
        if (object2 instanceof Section) {
            Section section = (Section)object2;
            if (section.isRoot()) {
                throw new IllegalArgumentException("Cannot set root section as the value!");
            }
            if (section.getRoot().getGeneralSettings().getKeyFormat() != this.getRoot().getGeneralSettings().getKeyFormat()) {
                throw new IllegalArgumentException("Cannot move sections between files with different key formats!");
            }
            ((Map)this.getStoredValue()).put(object, section);
            Section section2 = this;
            section.adapt(this.root, section2, section2.getSubRoute(object));
            return;
        }
        if (object2 instanceof TerminatedBlock) {
            ((Map)this.getStoredValue()).put(object, (TerminatedBlock)object2);
            return;
        }
        if (object2 instanceof Map) {
            Section section = this;
            ((Map)this.getStoredValue()).put(object, new Section(this.root, section, section.getSubRoute(object), ((Map)this.getStoredValue()).getOrDefault(object, null), (Map)object2));
            return;
        }
        Block block = (Block)((Map)this.getStoredValue()).get(object);
        if (block == null) {
            ((Map)this.getStoredValue()).put(object, new TerminatedBlock(null, null, object2));
            return;
        }
        ((Map)this.getStoredValue()).put(object, new TerminatedBlock((Block<?>)block, object2));
    }

    public boolean remove(@NotNull Route route) {
        Section section = this;
        Route route2 = route;
        return section.removeInternal(section.getParent(route).orElse(null), this.adaptKey(route2.get(route2.length() - 1)));
    }

    public boolean remove(@NotNull String string) {
        Section section = this;
        String string2 = string;
        return section.removeInternal(section.getParent(string).orElse(null), string2.substring(string2.lastIndexOf(this.root.getGeneralSettings().getRouteSeparator()) + 1));
    }

    private boolean removeInternal(@Nullable Section section, @Nullable Object object) {
        if (section == null) {
            return false;
        }
        return ((Map)section.getStoredValue()).remove(object) != null;
    }

    public void clear() {
        ((Map)this.getStoredValue()).clear();
    }

    public Optional<Block<?>> getOptionalBlock(@NotNull Route route) {
        return this.getBlockInternal(route, false);
    }

    private Optional<Block<?>> getDirectOptionalBlock(@NotNull Object object) {
        return Optional.ofNullable(((Map)this.getStoredValue()).get(this.adaptKey(object)));
    }

    public Optional<Block<?>> getOptionalBlock(@NotNull String string) {
        if (string.indexOf(this.root.getGeneralSettings().getRouteSeparator()) != -1) {
            return this.getBlockInternalString(string, false);
        }
        return this.getDirectOptionalBlock(string);
    }

    public Block<?> getBlock(@NotNull Route route) {
        return this.getOptionalBlock(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBlock(route);
            }
            return null;
        });
    }

    public Block<?> getBlock(@NotNull String string) {
        return this.getOptionalBlock(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBlock(string);
            }
            return null;
        });
    }

    private Optional<Block<?>> getBlockInternalString(@NotNull String string, boolean bl2) {
        int n2;
        int n3 = 0;
        Section section = this;
        while ((n2 = string.indexOf(this.root.getGeneralSettings().getRouteSeparator(), n3)) != -1) {
            Block block = ((Map)section.getStoredValue()).getOrDefault(string.substring(n3, n2), null);
            if (!(block instanceof Section)) {
                return Optional.empty();
            }
            section = (Section)block;
            n3 = n2 + 1;
        }
        return Optional.ofNullable(bl2 ? section : (Block)((Map)section.getStoredValue()).get(string.substring(n3)));
    }

    private Optional<Block<?>> getBlockInternal(@NotNull Route route, boolean bl2) {
        int n2 = -1;
        Block block = this;
        while (++n2 < route.length() - 1) {
            if ((block = (Block)((Map)block.getStoredValue()).getOrDefault(this.adaptKey(route.get(n2)), null)) instanceof Section) continue;
            return Optional.empty();
        }
        return Optional.ofNullable(bl2 ? block : (Block)((Map)block.getStoredValue()).get(this.adaptKey(route.get(n2))));
    }

    public Optional<Section> getParent(@NotNull Route route) {
        return this.getBlockInternal(route, true).map(block -> {
            if (block instanceof Section) {
                return (Section)block;
            }
            return null;
        });
    }

    public Optional<Section> getParent(@NotNull String string) {
        return this.getBlockInternalString(string, true).map(block -> {
            if (block instanceof Section) {
                return (Section)block;
            }
            return null;
        });
    }

    public Optional<Object> getOptional(@NotNull Route route) {
        return this.getOptionalBlock(route).map(block -> {
            if (block instanceof Section) {
                return block;
            }
            return block.getStoredValue();
        });
    }

    public Optional<Object> getOptional(@NotNull String string) {
        return this.getOptionalBlock(string).map(block -> {
            if (block instanceof Section) {
                return block;
            }
            return block.getStoredValue();
        });
    }

    public Object get(@NotNull Route route) {
        return this.getOptional(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.get(route);
            }
            return this.root.getGeneralSettings().getDefaultObject();
        });
    }

    public Object get(@NotNull String string) {
        return this.getOptional(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.get(string);
            }
            return this.root.getGeneralSettings().getDefaultObject();
        });
    }

    public Object get(@NotNull Route route, @Nullable Object object) {
        return this.getOptional(route).orElse(object);
    }

    public Object get(@NotNull String string, @Nullable Object object) {
        return this.getOptional(string).orElse(object);
    }

    public <T> Optional<T> getAsOptional(@NotNull Route route, @NotNull Class<T> clazz) {
        return this.getOptional(route).map(object -> {
            if (clazz.isInstance(object)) {
                return object;
            }
            if (PrimitiveConversions.isNumber(object.getClass()) && PrimitiveConversions.isNumber(clazz)) {
                return PrimitiveConversions.convertNumber(object, clazz);
            }
            if (PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(object.getClass()) && PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(clazz)) {
                return object;
            }
            return null;
        });
    }

    public <T> Optional<T> getAsOptional(@NotNull String string, @NotNull Class<T> clazz) {
        return this.getOptional(string).map(object -> {
            if (clazz.isInstance(object)) {
                return object;
            }
            if (PrimitiveConversions.isNumber(object.getClass()) && PrimitiveConversions.isNumber(clazz)) {
                return PrimitiveConversions.convertNumber(object, clazz);
            }
            if (PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(object.getClass()) && PrimitiveConversions.NON_NUMERIC_CONVERSIONS.containsKey(clazz)) {
                return object;
            }
            return null;
        });
    }

    public <T> T getAs(@NotNull Route route, @NotNull Class<T> clazz) {
        return (T)this.getAsOptional(route, clazz).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getAs(route, clazz);
            }
            return null;
        });
    }

    public <T> T getAs(@NotNull String string, @NotNull Class<T> clazz) {
        return (T)this.getAsOptional(string, clazz).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getAs(string, clazz);
            }
            return null;
        });
    }

    public <T> T getAs(@NotNull Route route, @NotNull Class<T> clazz, @Nullable T t2) {
        return this.getAsOptional(route, clazz).orElse(t2);
    }

    public <T> T getAs(@NotNull String string, @NotNull Class<T> clazz, @Nullable T t2) {
        return this.getAsOptional(string, clazz).orElse(t2);
    }

    public <T> boolean is(@NotNull Route object, @NotNull Class<T> clazz) {
        object = this.get((Route)object);
        if (PrimitiveConversions.PRIMITIVES_TO_OBJECTS.containsKey(clazz)) {
            return PrimitiveConversions.PRIMITIVES_TO_OBJECTS.get(clazz).isInstance(object);
        }
        return clazz.isInstance(object);
    }

    public <T> boolean is(@NotNull String object, @NotNull Class<T> clazz) {
        object = this.get((String)object);
        if (PrimitiveConversions.PRIMITIVES_TO_OBJECTS.containsKey(clazz)) {
            return PrimitiveConversions.PRIMITIVES_TO_OBJECTS.get(clazz).isInstance(object);
        }
        return clazz.isInstance(object);
    }

    public Optional<Section> getOptionalSection(@NotNull Route route) {
        return this.getAsOptional(route, Section.class);
    }

    public Optional<Section> getOptionalSection(@NotNull String string) {
        return this.getAsOptional(string, Section.class);
    }

    public Section getSection(@NotNull Route route) {
        return this.getOptionalSection(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getSection(route);
            }
            return null;
        });
    }

    public Section getSection(@NotNull String string) {
        return this.getOptionalSection(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getSection(string);
            }
            return null;
        });
    }

    public Section getSection(@NotNull Route route, @Nullable Section section) {
        return this.getOptionalSection(route).orElse(section);
    }

    public Section getSection(@NotNull String string, @Nullable Section section) {
        return this.getOptionalSection(string).orElse(section);
    }

    public boolean isSection(@NotNull Route route) {
        return this.get(route) instanceof Section;
    }

    public boolean isSection(@NotNull String string) {
        return this.get(string) instanceof Section;
    }

    public Optional<String> getOptionalString(@NotNull Route route) {
        return this.getOptional(route).map(Object::toString);
    }

    public Optional<String> getOptionalString(@NotNull String string) {
        return this.getOptional(string).map(Object::toString);
    }

    public String getString(@NotNull Route route) {
        return this.getOptionalString(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getString(route);
            }
            return this.root.getGeneralSettings().getDefaultString();
        });
    }

    public String getString(@NotNull String string) {
        return this.getOptionalString(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getString(string);
            }
            return this.root.getGeneralSettings().getDefaultString();
        });
    }

    public String getString(@NotNull Route route, @Nullable String string) {
        return this.getOptionalString(route).orElse(string);
    }

    public String getString(@NotNull String string, @Nullable String string2) {
        return this.getOptionalString(string).orElse(string2);
    }

    public boolean isString(@NotNull Route route) {
        return this.get(route) instanceof String;
    }

    public boolean isString(@NotNull String string) {
        return this.get(string) instanceof String;
    }

    public <T extends Enum<T>> Optional<T> getOptionalEnum(@NotNull Route route, @NotNull Class<T> clazz) {
        return this.getOptional(route).map(object -> this.toEnum(object, clazz));
    }

    public <T extends Enum<T>> Optional<T> getOptionalEnum(@NotNull String string2, @NotNull Class<T> clazz) {
        return this.getOptionalString(string2).map(string -> this.toEnum(string, clazz));
    }

    public <T extends Enum<T>> T getEnum(@NotNull Route route, @NotNull Class<T> clazz) {
        return (T)this.getOptionalEnum(route, clazz).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getEnum(route, clazz);
            }
            return null;
        });
    }

    public <T extends Enum<T>> T getEnum(@NotNull String string, @NotNull Class<T> clazz) {
        return (T)this.getOptionalEnum(string, clazz).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getEnum(string, clazz);
            }
            return null;
        });
    }

    public <T extends Enum<T>> T getEnum(@NotNull Route route, @NotNull Class<T> clazz, @Nullable T t2) {
        return (T)((Enum)this.getOptionalEnum(route, clazz).orElse(t2));
    }

    public <T extends Enum<T>> T getEnum(@NotNull String string, @NotNull Class<T> clazz, @Nullable T t2) {
        return (T)((Enum)this.getOptionalEnum(string, clazz).orElse(t2));
    }

    public <T extends Enum<T>> boolean isEnum(@NotNull Route route, @NotNull Class<T> clazz) {
        Section section = this;
        return section.toEnum(section.get(route), clazz) != null;
    }

    public <T extends Enum<T>> boolean isEnum(@NotNull String string, @NotNull Class<T> clazz) {
        Section section = this;
        return section.toEnum(section.get(string), clazz) != null;
    }

    private <T extends Enum<T>> T toEnum(@Nullable Object object, @NotNull Class<T> clazz) {
        if (object == null) {
            return null;
        }
        if (clazz.isInstance(object)) {
            return (T)((Enum)object);
        }
        if (object instanceof Enum) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, object.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public Optional<Character> getOptionalChar(@NotNull Route route) {
        return this.getOptional(route).map(this::toChar);
    }

    public Optional<Character> getOptionalChar(@NotNull String string) {
        return this.getOptional(string).map(this::toChar);
    }

    public Character getChar(@NotNull Route route) {
        return this.getOptionalChar(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getChar(route);
            }
            return this.root.getGeneralSettings().getDefaultChar();
        });
    }

    public Character getChar(@NotNull String string) {
        return this.getOptionalChar(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getChar(string);
            }
            return this.root.getGeneralSettings().getDefaultChar();
        });
    }

    public Character getChar(@NotNull Route route, @Nullable Character c2) {
        return this.getOptionalChar(route).orElse(c2);
    }

    public Character getChar(@NotNull String string, @Nullable Character c2) {
        return this.getOptionalChar(string).orElse(c2);
    }

    public boolean isChar(@NotNull Route route) {
        Section section = this;
        return section.toChar(section.get(route)) != null;
    }

    public boolean isChar(@NotNull String string) {
        Section section = this;
        return section.toChar(section.get(string)) != null;
    }

    private Character toChar(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof Integer) {
            return Character.valueOf((char)((Integer)object).intValue());
        }
        if (object instanceof String && object.toString().length() == 1) {
            return Character.valueOf(object.toString().charAt(0));
        }
        return null;
    }

    public Optional<Number> getOptionalNumber(@NotNull Route route) {
        return this.getAsOptional(route, Number.class);
    }

    public Optional<Number> getOptionalNumber(@NotNull String string) {
        return this.getAsOptional(string, Number.class);
    }

    public Number getNumber(@NotNull Route route) {
        return this.getOptionalNumber(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getNumber(route);
            }
            return this.root.getGeneralSettings().getDefaultNumber();
        });
    }

    public Number getNumber(@NotNull String string) {
        return this.getOptionalNumber(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getNumber(string);
            }
            return this.root.getGeneralSettings().getDefaultNumber();
        });
    }

    public Number getNumber(@NotNull Route route, @Nullable Number number) {
        return this.getOptionalNumber(route).orElse(number);
    }

    public Number getNumber(@NotNull String string, @Nullable Number number) {
        return this.getOptionalNumber(string).orElse(number);
    }

    public boolean isNumber(@NotNull Route route) {
        return this.get(route) instanceof Number;
    }

    public boolean isNumber(@NotNull String string) {
        return this.get(string) instanceof Number;
    }

    public Optional<Integer> getOptionalInt(@NotNull Route route) {
        return PrimitiveConversions.toInt(this.getAs(route, Number.class));
    }

    public Optional<Integer> getOptionalInt(@NotNull String string) {
        return PrimitiveConversions.toInt(this.getAs(string, Number.class));
    }

    public Integer getInt(@NotNull Route route) {
        return this.getOptionalInt(route).orElseGet(() -> this.canUseDefaults() ? this.defaults.getInt(route).intValue() : this.root.getGeneralSettings().getDefaultNumber().intValue());
    }

    public Integer getInt(@NotNull String string) {
        return this.getOptionalInt(string).orElseGet(() -> this.canUseDefaults() ? this.defaults.getInt(string).intValue() : this.root.getGeneralSettings().getDefaultNumber().intValue());
    }

    public Integer getInt(@NotNull Route route, @Nullable Integer n2) {
        return this.getOptionalInt(route).orElse(n2);
    }

    public Integer getInt(@NotNull String string, @Nullable Integer n2) {
        return this.getOptionalInt(string).orElse(n2);
    }

    public boolean isInt(@NotNull Route route) {
        return this.get(route) instanceof Integer;
    }

    public boolean isInt(@NotNull String string) {
        return this.get(string) instanceof Integer;
    }

    public Optional<BigInteger> getOptionalBigInt(@NotNull Route route) {
        return PrimitiveConversions.toBigInt(this.getAs(route, Number.class));
    }

    public Optional<BigInteger> getOptionalBigInt(@NotNull String string) {
        return PrimitiveConversions.toBigInt(this.getAs(string, Number.class));
    }

    public BigInteger getBigInt(@NotNull Route route) {
        return this.getOptionalBigInt(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBigInt(route);
            }
            return BigInteger.valueOf(this.root.getGeneralSettings().getDefaultNumber().longValue());
        });
    }

    public BigInteger getBigInt(@NotNull String string) {
        return this.getOptionalBigInt(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBigInt(string);
            }
            return BigInteger.valueOf(this.root.getGeneralSettings().getDefaultNumber().longValue());
        });
    }

    public BigInteger getBigInt(@NotNull Route route, @Nullable BigInteger bigInteger) {
        return this.getOptionalBigInt(route).orElse(bigInteger);
    }

    public BigInteger getBigInt(@NotNull String string, @Nullable BigInteger bigInteger) {
        return this.getOptionalBigInt(string).orElse(bigInteger);
    }

    public boolean isBigInt(@NotNull Route route) {
        return this.get(route) instanceof BigInteger;
    }

    public boolean isBigInt(@NotNull String string) {
        return this.get(string) instanceof BigInteger;
    }

    public Optional<Boolean> getOptionalBoolean(@NotNull Route route) {
        return this.getAsOptional(route, Boolean.class);
    }

    public Optional<Boolean> getOptionalBoolean(@NotNull String string) {
        return this.getAsOptional(string, Boolean.class);
    }

    public Boolean getBoolean(@NotNull Route route) {
        return this.getOptionalBoolean(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBoolean(route);
            }
            return this.root.getGeneralSettings().getDefaultBoolean();
        });
    }

    public Boolean getBoolean(@NotNull String string) {
        return this.getOptionalBoolean(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBoolean(string);
            }
            return this.root.getGeneralSettings().getDefaultBoolean();
        });
    }

    public Boolean getBoolean(@NotNull Route route, @Nullable Boolean bl2) {
        return this.getOptionalBoolean(route).orElse(bl2);
    }

    public Boolean getBoolean(@NotNull String string, @Nullable Boolean bl2) {
        return this.getOptionalBoolean(string).orElse(bl2);
    }

    public boolean isBoolean(@NotNull Route route) {
        return this.get(route) instanceof Boolean;
    }

    public boolean isBoolean(@NotNull String string) {
        return this.get(string) instanceof Boolean;
    }

    public Optional<Double> getOptionalDouble(@NotNull Route route) {
        return PrimitiveConversions.toDouble(this.getAs(route, Number.class));
    }

    public Optional<Double> getOptionalDouble(@NotNull String string) {
        return PrimitiveConversions.toDouble(this.getAs(string, Number.class));
    }

    public Double getDouble(@NotNull Route route) {
        return this.getOptionalDouble(route).orElseGet(() -> this.canUseDefaults() ? this.defaults.getDouble(route).doubleValue() : this.root.getGeneralSettings().getDefaultNumber().doubleValue());
    }

    public Double getDouble(@NotNull String string) {
        return this.getOptionalDouble(string).orElseGet(() -> this.canUseDefaults() ? this.defaults.getDouble(string).doubleValue() : this.root.getGeneralSettings().getDefaultNumber().doubleValue());
    }

    public Double getDouble(@NotNull Route route, @Nullable Double d2) {
        return this.getOptionalDouble(route).orElse(d2);
    }

    public Double getDouble(@NotNull String string, @Nullable Double d2) {
        return this.getOptionalDouble(string).orElse(d2);
    }

    public boolean isDouble(@NotNull Route route) {
        return this.get(route) instanceof Double;
    }

    public boolean isDouble(@NotNull String string) {
        return this.get(string) instanceof Double;
    }

    public Optional<Float> getOptionalFloat(@NotNull Route route) {
        return PrimitiveConversions.toFloat(this.getAs(route, Number.class));
    }

    public Optional<Float> getOptionalFloat(@NotNull String string) {
        return PrimitiveConversions.toFloat(this.getAs(string, Number.class));
    }

    public Float getFloat(@NotNull Route route) {
        return this.getOptionalFloat(route).orElseGet(() -> Float.valueOf(this.canUseDefaults() ? this.defaults.getFloat(route).floatValue() : this.root.getGeneralSettings().getDefaultNumber().floatValue()));
    }

    public Float getFloat(@NotNull String string) {
        return this.getOptionalFloat(string).orElseGet(() -> Float.valueOf(this.canUseDefaults() ? this.defaults.getFloat(string).floatValue() : this.root.getGeneralSettings().getDefaultNumber().floatValue()));
    }

    public Float getFloat(@NotNull Route route, @Nullable Float f2) {
        return this.getOptionalFloat(route).orElse(f2);
    }

    public Float getFloat(@NotNull String string, @Nullable Float f2) {
        return this.getOptionalFloat(string).orElse(f2);
    }

    public boolean isFloat(@NotNull Route route) {
        return this.get(route) instanceof Float;
    }

    public boolean isFloat(@NotNull String string) {
        return this.get(string) instanceof Float;
    }

    public Optional<Byte> getOptionalByte(@NotNull Route route) {
        return PrimitiveConversions.toByte(this.getAs(route, Number.class));
    }

    public Optional<Byte> getOptionalByte(@NotNull String string) {
        return PrimitiveConversions.toByte(this.getAs(string, Number.class));
    }

    public Byte getByte(@NotNull Route route) {
        return this.getOptionalByte(route).orElseGet(() -> this.canUseDefaults() ? this.defaults.getByte(route).byteValue() : this.root.getGeneralSettings().getDefaultNumber().byteValue());
    }

    public Byte getByte(@NotNull String string) {
        return this.getOptionalByte(string).orElseGet(() -> this.canUseDefaults() ? this.defaults.getByte(string).byteValue() : this.root.getGeneralSettings().getDefaultNumber().byteValue());
    }

    public Byte getByte(@NotNull Route route, @Nullable Byte by) {
        return this.getOptionalByte(route).orElse(by);
    }

    public Byte getByte(@NotNull String string, @Nullable Byte by) {
        return this.getOptionalByte(string).orElse(by);
    }

    public boolean isByte(@NotNull Route route) {
        return this.get(route) instanceof Byte;
    }

    public boolean isByte(@NotNull String string) {
        return this.get(string) instanceof Byte;
    }

    public Optional<Long> getOptionalLong(@NotNull Route route) {
        return PrimitiveConversions.toLong(this.getAs(route, Number.class));
    }

    public Optional<Long> getOptionalLong(String string) {
        return PrimitiveConversions.toLong(this.getAs(string, Number.class));
    }

    public Long getLong(@NotNull Route route) {
        return this.getOptionalLong(route).orElseGet(() -> this.canUseDefaults() ? this.defaults.getLong(route).longValue() : this.root.getGeneralSettings().getDefaultNumber().longValue());
    }

    public Long getLong(@NotNull String string) {
        return this.getOptionalLong(string).orElseGet(() -> this.canUseDefaults() ? this.defaults.getLong(string).longValue() : this.root.getGeneralSettings().getDefaultNumber().longValue());
    }

    public Long getLong(@NotNull Route route, @Nullable Long l2) {
        return this.getOptionalLong(route).orElse(l2);
    }

    public Long getLong(@NotNull String string, @Nullable Long l2) {
        return this.getOptionalLong(string).orElse(l2);
    }

    public boolean isLong(@NotNull Route route) {
        return this.get(route) instanceof Long;
    }

    public boolean isLong(@NotNull String string) {
        return this.get(string) instanceof Long;
    }

    public Optional<Short> getOptionalShort(@NotNull Route route) {
        return PrimitiveConversions.toShort(this.getAs(route, Number.class));
    }

    public Optional<Short> getOptionalShort(@NotNull String string) {
        return PrimitiveConversions.toShort(this.getAs(string, Number.class));
    }

    public Short getShort(@NotNull Route route) {
        return this.getOptionalShort(route).orElseGet(() -> this.canUseDefaults() ? this.defaults.getShort(route).shortValue() : this.root.getGeneralSettings().getDefaultNumber().shortValue());
    }

    public Short getShort(@NotNull String string) {
        return this.getOptionalShort(string).orElseGet(() -> this.canUseDefaults() ? this.defaults.getShort(string).shortValue() : this.root.getGeneralSettings().getDefaultNumber().shortValue());
    }

    public Short getShort(@NotNull Route route, @Nullable Short s2) {
        return this.getOptionalShort(route).orElse(s2);
    }

    public Short getShort(@NotNull String string, @Nullable Short s2) {
        return this.getOptionalShort(string).orElse(s2);
    }

    public boolean isShort(@NotNull Route route) {
        return this.get(route) instanceof Short;
    }

    public boolean isShort(@NotNull String string) {
        return this.get(string) instanceof Short;
    }

    public boolean isDecimal(@NotNull Route object) {
        return (object = this.get((Route)object)) instanceof Double || object instanceof Float;
    }

    public boolean isDecimal(@NotNull String object) {
        return (object = this.get((String)object)) instanceof Double || object instanceof Float;
    }

    public Optional<List<?>> getOptionalList(@NotNull Route route) {
        return this.getAsOptional(route, List.class).map(list -> list);
    }

    public Optional<List<?>> getOptionalList(@NotNull String string) {
        return this.getAsOptional(string, List.class).map(list -> list);
    }

    public List<?> getList(@NotNull Route route) {
        return this.getOptionalList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<?> getList(@NotNull String string) {
        return this.getOptionalList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<?> getList(@NotNull Route route, @Nullable List<?> list) {
        return this.getOptionalList(route).orElse(list);
    }

    public List<?> getList(@NotNull String string, @Nullable List<?> list) {
        return this.getOptionalList(string).orElse(list);
    }

    public boolean isList(@NotNull Route route) {
        return this.get(route) instanceof List;
    }

    public boolean isList(@NotNull String string) {
        return this.get(string) instanceof List;
    }

    public Optional<List<String>> getOptionalStringList(@NotNull Route route) {
        return ListConversions.toStringList(this.getList(route, null));
    }

    public Optional<List<String>> getOptionalStringList(@NotNull String string) {
        return ListConversions.toStringList(this.getList(string, null));
    }

    public List<String> getStringList(@NotNull Route route, @Nullable List<String> list) {
        return this.getOptionalStringList(route).orElse(list);
    }

    public List<String> getStringList(@NotNull String string, @Nullable List<String> list) {
        return this.getOptionalStringList(string).orElse(list);
    }

    public List<String> getStringList(@NotNull Route route) {
        return this.getOptionalStringList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getStringList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<String> getStringList(@NotNull String string) {
        return this.getOptionalStringList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getStringList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Integer>> getOptionalIntList(@NotNull Route route) {
        return ListConversions.toIntList(this.getList(route, null));
    }

    public Optional<List<Integer>> getOptionalIntList(@NotNull String string) {
        return ListConversions.toIntList(this.getList(string, null));
    }

    public List<Integer> getIntList(@NotNull Route route, @Nullable List<Integer> list) {
        return this.getOptionalIntList(route).orElse(list);
    }

    public List<Integer> getIntList(@NotNull String string, @Nullable List<Integer> list) {
        return this.getOptionalIntList(string).orElse(list);
    }

    public List<Integer> getIntList(@NotNull Route route) {
        return this.getOptionalIntList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getIntList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Integer> getIntList(@NotNull String string) {
        return this.getOptionalIntList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getIntList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<BigInteger>> getOptionalBigIntList(@NotNull Route route) {
        return ListConversions.toBigIntList(this.getList(route, null));
    }

    public Optional<List<BigInteger>> getOptionalBigIntList(@NotNull String string) {
        return ListConversions.toBigIntList(this.getList(string, null));
    }

    public List<BigInteger> getBigIntList(@NotNull Route route, @Nullable List<BigInteger> list) {
        return this.getOptionalBigIntList(route).orElse(list);
    }

    public List<BigInteger> getBigIntList(@NotNull String string, @Nullable List<BigInteger> list) {
        return this.getOptionalBigIntList(string).orElse(list);
    }

    public List<BigInteger> getBigIntList(@NotNull Route route) {
        return this.getOptionalBigIntList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBigIntList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<BigInteger> getBigIntList(@NotNull String string) {
        return this.getOptionalBigIntList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getBigIntList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Byte>> getOptionalByteList(@NotNull Route route) {
        return ListConversions.toByteList(this.getList(route, null));
    }

    public Optional<List<Byte>> getOptionalByteList(@NotNull String string) {
        return ListConversions.toByteList(this.getList(string, null));
    }

    public List<Byte> getByteList(@NotNull Route route, @Nullable List<Byte> list) {
        return this.getOptionalByteList(route).orElse(list);
    }

    public List<Byte> getByteList(@NotNull String string, @Nullable List<Byte> list) {
        return this.getOptionalByteList(string).orElse(list);
    }

    public List<Byte> getByteList(@NotNull Route route) {
        return this.getOptionalByteList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getByteList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Byte> getByteList(@NotNull String string) {
        return this.getOptionalByteList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getByteList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Long>> getOptionalLongList(@NotNull Route route) {
        return ListConversions.toLongList(this.getList(route, null));
    }

    public Optional<List<Long>> getOptionalLongList(@NotNull String string) {
        return ListConversions.toLongList(this.getList(string, null));
    }

    public List<Long> getLongList(@NotNull Route route, @Nullable List<Long> list) {
        return this.getOptionalLongList(route).orElse(list);
    }

    public List<Long> getLongList(@NotNull String string, @Nullable List<Long> list) {
        return this.getOptionalLongList(string).orElse(list);
    }

    public List<Long> getLongList(@NotNull Route route) {
        return this.getOptionalLongList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getLongList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Long> getLongList(@NotNull String string) {
        return this.getOptionalLongList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getLongList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Double>> getOptionalDoubleList(@NotNull Route route) {
        return ListConversions.toDoubleList(this.getList(route, null));
    }

    public Optional<List<Double>> getOptionalDoubleList(@NotNull String string) {
        return ListConversions.toDoubleList(this.getList(string, null));
    }

    public List<Double> getDoubleList(@NotNull Route route, @Nullable List<Double> list) {
        return this.getOptionalDoubleList(route).orElse(list);
    }

    public List<Double> getDoubleList(@NotNull String string, @Nullable List<Double> list) {
        return this.getOptionalDoubleList(string).orElse(list);
    }

    public List<Double> getDoubleList(@NotNull Route route) {
        return this.getOptionalDoubleList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getDoubleList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Double> getDoubleList(@NotNull String string) {
        return this.getOptionalDoubleList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getDoubleList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Float>> getOptionalFloatList(@NotNull Route route) {
        return ListConversions.toFloatList(this.getList(route, null));
    }

    public Optional<List<Float>> getOptionalFloatList(@NotNull String string) {
        return ListConversions.toFloatList(this.getList(string, null));
    }

    public List<Float> getFloatList(@NotNull Route route, @Nullable List<Float> list) {
        return this.getOptionalFloatList(route).orElse(list);
    }

    public List<Float> getFloatList(@NotNull String string, @Nullable List<Float> list) {
        return this.getOptionalFloatList(string).orElse(list);
    }

    public List<Float> getFloatList(@NotNull Route route) {
        return this.getOptionalFloatList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getFloatList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Float> getFloatList(@NotNull String string) {
        return this.getOptionalFloatList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getFloatList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Short>> getOptionalShortList(@NotNull Route route) {
        return ListConversions.toShortList(this.getList(route, null));
    }

    public Optional<List<Short>> getOptionalShortList(@NotNull String string) {
        return ListConversions.toShortList(this.getList(string, null));
    }

    public List<Short> getShortList(@NotNull Route route, @Nullable List<Short> list) {
        return this.getOptionalShortList(route).orElse(list);
    }

    public List<Short> getShortList(@NotNull String string, @Nullable List<Short> list) {
        return this.getOptionalShortList(string).orElse(list);
    }

    public List<Short> getShortList(@NotNull Route route) {
        return this.getOptionalShortList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getShortList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Short> getShortList(@NotNull String string) {
        return this.getOptionalShortList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getShortList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public Optional<List<Map<?, ?>>> getOptionalMapList(@NotNull Route route) {
        return ListConversions.toMapList(this.getList(route, null));
    }

    public Optional<List<Map<?, ?>>> getOptionalMapList(@NotNull String string) {
        return ListConversions.toMapList(this.getList(string, null));
    }

    public List<Map<?, ?>> getMapList(@NotNull Route route, @Nullable List<Map<?, ?>> list) {
        return this.getOptionalMapList(route).orElse(list);
    }

    public List<Map<?, ?>> getMapList(@NotNull String string, @Nullable List<Map<?, ?>> list) {
        return this.getOptionalMapList(string).orElse(list);
    }

    public List<Map<?, ?>> getMapList(@NotNull Route route) {
        return this.getOptionalMapList(route).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getMapList(route);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }

    public List<Map<?, ?>> getMapList(@NotNull String string) {
        return this.getOptionalMapList(string).orElseGet(() -> {
            if (this.canUseDefaults()) {
                return this.defaults.getMapList(string);
            }
            return this.root.getGeneralSettings().getDefaultList();
        });
    }
}

