/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.dvs;

import java.util.Arrays;
import java.util.Objects;
import me.extremall.advancedkits.libs.boostedyaml.dvs.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    private final Pattern pattern;
    private final int[] cursors;
    private String id;

    Version(@Nullable String string, @NotNull Pattern pattern, int[] nArray) {
        this.id = string;
        this.pattern = pattern;
        this.cursors = nArray;
        if (string == null) {
            this.buildID();
        }
    }

    @Override
    public int compareTo(Version version) {
        if (!this.pattern.equals(version.pattern)) {
            throw new ClassCastException("Compared versions are not defined by the same pattern!");
        }
        for (int i2 = 0; i2 < this.cursors.length; ++i2) {
            int n2 = Integer.compare(this.cursors[i2], version.cursors[i2]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    public int getCursor(int n2) {
        return this.cursors[n2];
    }

    public void next() {
        for (int i2 = this.cursors.length - 1; i2 >= 0; --i2) {
            int n2 = this.cursors[i2];
            if (n2 + 1 < this.pattern.getSegment(i2).length()) {
                this.cursors[i2] = n2 + 1;
                break;
            }
            this.cursors[i2] = 0;
        }
        this.buildID();
    }

    private void buildID() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.cursors.length; ++i2) {
            stringBuilder.append(this.pattern.getSegment(i2).getElement(this.cursors[i2]));
        }
        this.id = stringBuilder.toString();
    }

    public String asID() {
        return this.id;
    }

    public Version copy() {
        return new Version(this.id, this.pattern, Arrays.copyOf(this.cursors, this.cursors.length));
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Version)) {
            return false;
        }
        object = (Version)object;
        return this.pattern.equals(((Version)object).pattern) && Arrays.equals(this.cursors, ((Version)object).cursors);
    }

    public int hashCode() {
        int n2 = Objects.hash(this.pattern);
        n2 = n2 * 31 + Arrays.hashCode(this.cursors);
        return n2;
    }

    public String toString() {
        return "Version{pattern=" + this.pattern + ", cursors=" + Arrays.toString(this.cursors) + ", id='" + this.id + '\'' + '}';
    }
}

