/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.CommentEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.Event;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.parser.Parser;

public class CommentEventsCollector {
    private List<CommentLine> commentLineList;
    private final Queue<Event> eventSource;
    private final CommentType[] expectedCommentTypes;

    public CommentEventsCollector(final Parser parser, CommentType ... commentTypeArray) {
        this.eventSource = new AbstractQueue<Event>(){

            @Override
            public boolean offer(Event event) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Event poll() {
                return parser.next();
            }

            @Override
            public Event peek() {
                return parser.peekEvent();
            }

            @Override
            public Iterator<Event> iterator() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException();
            }
        };
        this.expectedCommentTypes = commentTypeArray;
        this.commentLineList = new ArrayList<CommentLine>();
    }

    public CommentEventsCollector(Queue<Event> queue, CommentType ... commentTypeArray) {
        this.eventSource = queue;
        this.expectedCommentTypes = commentTypeArray;
        this.commentLineList = new ArrayList<CommentLine>();
    }

    private boolean isEventExpected(Event event) {
        if (event == null || event.getEventId() != Event.ID.Comment) {
            return false;
        }
        event = (CommentEvent)event;
        CommentType[] commentTypeArray = this.expectedCommentTypes;
        int n2 = this.expectedCommentTypes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            CommentType commentType = commentTypeArray[i2];
            if (((CommentEvent)event).getCommentType() != commentType) continue;
            return true;
        }
        return false;
    }

    public CommentEventsCollector collectEvents() {
        this.collectEvents(null);
        return this;
    }

    public Event collectEvents(Event event) {
        if (event != null) {
            if (this.isEventExpected(event)) {
                this.commentLineList.add(new CommentLine((CommentEvent)event));
            } else {
                return event;
            }
        }
        while (true) {
            CommentEventsCollector commentEventsCollector = this;
            if (!commentEventsCollector.isEventExpected(commentEventsCollector.eventSource.peek())) break;
            this.commentLineList.add(new CommentLine((CommentEvent)this.eventSource.poll()));
        }
        return null;
    }

    public Event collectEventsAndPoll(Event event) {
        if ((event = this.collectEvents(event)) != null) {
            return event;
        }
        return this.eventSource.poll();
    }

    public List<CommentLine> consume() {
        try {
            List<CommentLine> list = this.commentLineList;
            return list;
        }
        finally {
            this.commentLineList = new ArrayList<CommentLine>();
        }
    }

    public boolean isEmpty() {
        return this.commentLineList.isEmpty();
    }
}

