/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.constructor;

import java.math.BigInteger;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.ConstructNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.LoadSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.constructor.BaseConstructor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.ConstructorException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.DuplicateKeyException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.MissingEnvironmentVariableException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.resolver.JsonScalarResolver;

public class StandardConstructor
extends BaseConstructor {
    private static final Map<String, Boolean> BOOL_VALUES = new HashMap<String, Boolean>();

    public StandardConstructor(LoadSettings loadSettings) {
        super(loadSettings);
        this.tagConstructors.put(Tag.NULL, new ConstructYamlNull());
        this.tagConstructors.put(Tag.BOOL, new ConstructYamlBool());
        this.tagConstructors.put(Tag.INT, new ConstructYamlInt());
        this.tagConstructors.put(Tag.FLOAT, new ConstructYamlFloat());
        this.tagConstructors.put(Tag.BINARY, new ConstructYamlBinary());
        this.tagConstructors.put(Tag.SET, new ConstructYamlSet());
        this.tagConstructors.put(Tag.STR, new ConstructYamlStr());
        this.tagConstructors.put(Tag.SEQ, new ConstructYamlSeq());
        this.tagConstructors.put(Tag.MAP, new ConstructYamlMap());
        this.tagConstructors.put(Tag.ENV_TAG, new ConstructEnv());
        this.tagConstructors.put(new Tag(UUID.class), new ConstructUuidClass());
        this.tagConstructors.put(new Tag(Optional.class), new ConstructOptionalClass());
        this.tagConstructors.putAll(loadSettings.getTagConstructors());
    }

    protected void flattenMapping(MappingNode mappingNode) {
        this.processDuplicateKeys(mappingNode);
    }

    protected void processDuplicateKeys(MappingNode mappingNode) {
        List<NodeTuple> list = mappingNode.getValue();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>(list.size());
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n2 = 0;
        for (NodeTuple nodeTuple : list) {
            Object object = nodeTuple.getKeyNode();
            Integer n3 = hashMap.put(object = this.constructKey((Node)object, mappingNode.getStartMark(), nodeTuple.getKeyNode().getStartMark()), n2);
            if (n3 != null) {
                if (!this.settings.getAllowDuplicateKeys()) {
                    throw new DuplicateKeyException(mappingNode.getStartMark(), object, nodeTuple.getKeyNode().getStartMark());
                }
                treeSet.add(n3);
            }
            ++n2;
        }
        Iterator<NodeTuple> iterator = treeSet.descendingIterator();
        while (iterator.hasNext()) {
            list.remove((Integer)((Object)iterator.next()));
        }
    }

    private Object constructKey(Node object, Optional<Mark> optional, Optional<Mark> optional2) {
        if ((object = this.constructObject((Node)object)) != null) {
            try {
                object.hashCode();
            }
            catch (Exception exception) {
                throw new ConstructorException("while constructing a mapping", optional, "found unacceptable key " + object, optional2, exception);
            }
        }
        return object;
    }

    @Override
    protected void constructMapping2ndStep(MappingNode mappingNode, Map<Object, Object> map) {
        this.flattenMapping(mappingNode);
        super.constructMapping2ndStep(mappingNode, map);
    }

    @Override
    protected void constructSet2ndStep(MappingNode mappingNode, Set<Object> set) {
        this.flattenMapping(mappingNode);
        super.constructSet2ndStep(mappingNode, set);
    }

    static {
        BOOL_VALUES.put("true", Boolean.TRUE);
        BOOL_VALUES.put("false", Boolean.FALSE);
    }

    public class ConstructEnv
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            Optional<Object> optional = StandardConstructor.this.settings.getEnvConfig();
            if (optional.isPresent()) {
                optional = optional.get();
                object = JsonScalarResolver.ENV_FORMAT.matcher((CharSequence)object);
                ((Matcher)object).matches();
                String string = ((Matcher)object).group(1);
                String string2 = ((Matcher)object).group(3);
                string2 = string2 != null ? string2 : "";
                object = ((Matcher)object).group(2);
                String string3 = this.getEnv(string);
                optional = optional.getValueFor(string, (String)object, string2, string3);
                if (optional.isPresent()) {
                    return optional.get();
                }
                return this.apply(string, (String)object, string2, string3);
            }
            return object;
        }

        public String apply(String string, String string2, String string3, String string4) {
            if (string4 != null && !string4.isEmpty()) {
                return string4;
            }
            if (string2 != null) {
                if (string2.equals("?") && string4 == null) {
                    throw new MissingEnvironmentVariableException("Missing mandatory variable " + string + ": " + string3);
                }
                if (string2.equals(":?")) {
                    if (string4 == null) {
                        throw new MissingEnvironmentVariableException("Missing mandatory variable " + string + ": " + string3);
                    }
                    if (string4.isEmpty()) {
                        throw new MissingEnvironmentVariableException("Empty mandatory variable " + string + ": " + string3);
                    }
                }
                if (string2.startsWith(":") ? string4 == null || string4.isEmpty() : string4 == null) {
                    return string3;
                }
            }
            return "";
        }

        public String getEnv(String string) {
            return System.getenv(string);
        }
    }

    public class ConstructYamlMap
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            MappingNode mappingNode = (MappingNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.createDefaultMap(mappingNode.getValue().size());
            }
            return StandardConstructor.this.constructMapping(mappingNode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (node.isRecursive()) {
                StandardConstructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
                return;
            }
            throw new YamlEngineException("Unexpected recursive mapping structure. Node: " + node);
        }
    }

    public class ConstructYamlSeq
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            SequenceNode sequenceNode = (SequenceNode)node;
            if (node.isRecursive()) {
                return StandardConstructor.this.settings.getDefaultList().apply(sequenceNode.getValue().size());
            }
            return StandardConstructor.this.constructSequence(sequenceNode);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (node.isRecursive()) {
                StandardConstructor.this.constructSequenceStep2((SequenceNode)node, (List)object);
                return;
            }
            throw new YamlEngineException("Unexpected recursive sequence structure. Node: " + node);
        }
    }

    public class ConstructYamlStr
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            return StandardConstructor.this.constructScalar((ScalarNode)node);
        }
    }

    public class ConstructYamlSet
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node.isRecursive()) {
                if (StandardConstructor.this.constructedObjects.containsKey(node)) {
                    return StandardConstructor.this.constructedObjects.get(node);
                }
                return StandardConstructor.this.createDefaultSet(((MappingNode)node).getValue().size());
            }
            return StandardConstructor.this.constructSet((MappingNode)node);
        }

        @Override
        public void constructRecursive(Node node, Object object) {
            if (node.isRecursive()) {
                StandardConstructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
                return;
            }
            throw new YamlEngineException("Unexpected recursive set structure. Node: " + node);
        }
    }

    public class ConstructOptionalClass
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            if (((Node)object).getNodeType() != NodeType.SCALAR) {
                throw new ConstructorException("while constructing Optional", Optional.empty(), "found non scalar node", ((Node)object).getStartMark());
            }
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            Tag tag = StandardConstructor.this.settings.getScalarResolver().resolve((String)object, Boolean.TRUE);
            if (tag.equals(Tag.NULL)) {
                return Optional.empty();
            }
            return Optional.of(object);
        }
    }

    public class ConstructUuidClass
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            return UUID.fromString((String)object);
        }
    }

    public class ConstructYamlBinary
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object).replaceAll("\\s", "");
            return Base64.getDecoder().decode((String)object);
        }
    }

    public class ConstructYamlFloat
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            int n2 = 1;
            char c2 = ((String)object).charAt(0);
            if (c2 == '-') {
                n2 = -1;
                object = ((String)object).substring(1);
            } else if (c2 == '+') {
                object = ((String)object).substring(1);
            }
            if (".inf".equals(object)) {
                return n2 == -1 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if (".nan".equals(object)) {
                return Double.NaN;
            }
            object = Double.valueOf((String)object);
            return (Double)object * (double)n2;
        }
    }

    public class ConstructYamlInt
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            return this.createIntNumber((String)object);
        }

        protected Number createIntNumber(String string) {
            Number number;
            try {
                number = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    number = Long.valueOf(string);
                }
                catch (NumberFormatException numberFormatException2) {
                    number = new BigInteger(string);
                }
            }
            return number;
        }
    }

    public class ConstructYamlBool
    implements ConstructNode {
        @Override
        public Object construct(Node object) {
            object = StandardConstructor.this.constructScalar((ScalarNode)object);
            return BOOL_VALUES.get(((String)object).toLowerCase());
        }
    }

    public class ConstructYamlNull
    implements ConstructNode {
        @Override
        public Object construct(Node node) {
            if (node != null) {
                StandardConstructor.this.constructScalar((ScalarNode)node);
            }
            return null;
        }
    }
}

