/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.Mark;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;

public class MappingNode
extends CollectionNode<NodeTuple> {
    private List<NodeTuple> value;

    public MappingNode(Tag tag, boolean bl2, List<NodeTuple> list, FlowStyle flowStyle, Optional<Mark> optional, Optional<Mark> optional2) {
        super(tag, flowStyle, optional, optional2);
        Objects.requireNonNull(list);
        this.value = list;
        this.resolved = bl2;
    }

    public MappingNode(Tag tag, List<NodeTuple> list, FlowStyle flowStyle) {
        this(tag, true, list, flowStyle, Optional.empty(), Optional.empty());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.MAPPING;
    }

    @Override
    public List<NodeTuple> getValue() {
        return this.value;
    }

    public void setValue(List<NodeTuple> list) {
        this.value = list;
    }

    public String toString() {
        CharSequence charSequence = new StringBuilder();
        for (NodeTuple nodeTuple : this.getValue()) {
            ((StringBuilder)charSequence).append("{ key=");
            ((StringBuilder)charSequence).append(nodeTuple.getKeyNode());
            ((StringBuilder)charSequence).append("; value=");
            if (nodeTuple.getValueNode() instanceof CollectionNode) {
                ((StringBuilder)charSequence).append(System.identityHashCode(nodeTuple.getValueNode()));
            } else {
                ((StringBuilder)charSequence).append(nodeTuple);
            }
            ((StringBuilder)charSequence).append(" }");
        }
        charSequence = ((StringBuilder)charSequence).toString();
        return "<" + this.getClass().getName() + " (tag=" + this.getTag() + ", values=" + (String)charSequence + ")>";
    }
}

