/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.representer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.AnchorNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.CollectionNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;

public abstract class BaseRepresenter {
    public final Map<Class<?>, RepresentToNode> representers = new HashMap();
    protected RepresentToNode nullRepresenter;
    public final Map<Class<?>, RepresentToNode> parentClassRepresenters = new LinkedHashMap();
    protected ScalarStyle defaultScalarStyle = ScalarStyle.PLAIN;
    protected FlowStyle defaultFlowStyle = FlowStyle.AUTO;
    protected final Map<Object, Node> representedObjects = new IdentityHashMap<Object, Node>(){

        @Override
        public Node put(Object object, Node node) {
            return super.put(object, new AnchorNode(node));
        }
    };
    protected Object objectToRepresent;

    public Node represent(Object object) {
        object = this.representData(object);
        this.representedObjects.clear();
        this.objectToRepresent = null;
        return object;
    }

    protected Optional<RepresentToNode> findRepresenterFor(Object object) {
        Class<?> clazz = object.getClass();
        if (this.representers.containsKey(clazz)) {
            return Optional.of(this.representers.get(clazz));
        }
        for (Map.Entry entry : this.parentClassRepresenters.entrySet()) {
            if (!((Class)entry.getKey()).isInstance(object)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    public final Node representData(Object object) {
        this.objectToRepresent = object;
        if (this.representedObjects.containsKey(this.objectToRepresent)) {
            return this.representedObjects.get(this.objectToRepresent);
        }
        if (object == null) {
            return this.nullRepresenter.representData(null);
        }
        RepresentToNode representToNode = this.findRepresenterFor(object).orElseThrow(() -> new YamlEngineException("Representer is not defined for " + object.getClass()));
        return representToNode.representData(object);
    }

    protected Node representScalar(Tag tag, String string, ScalarStyle scalarStyle) {
        if (scalarStyle == ScalarStyle.PLAIN) {
            scalarStyle = this.defaultScalarStyle;
        }
        return new ScalarNode(tag, string, scalarStyle);
    }

    protected Node representScalar(Tag tag, String string) {
        return this.representScalar(tag, string, ScalarStyle.PLAIN);
    }

    protected Node representSequence(Tag object, Iterable<?> object2, FlowStyle flowStyle) {
        int n2 = 10;
        if (object2 instanceof List) {
            n2 = ((List)object2).size();
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(n2);
        object = new SequenceNode((Tag)object, arrayList, flowStyle);
        this.representedObjects.put(this.objectToRepresent, (Node)object);
        FlowStyle flowStyle2 = FlowStyle.FLOW;
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            if (!((object3 = this.representData(object3)) instanceof ScalarNode) || !((ScalarNode)object3).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            arrayList.add((Node)object3);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                ((CollectionNode)object).setFlowStyle(this.defaultFlowStyle);
            } else {
                ((CollectionNode)object).setFlowStyle(flowStyle2);
            }
        }
        return object;
    }

    protected NodeTuple representMappingEntry(Map.Entry<?, ?> entry) {
        return new NodeTuple(this.representData(entry.getKey()), this.representData(entry.getValue()));
    }

    protected Node representMapping(Tag object, Map<?, ?> object2, FlowStyle flowStyle) {
        ArrayList<NodeTuple> arrayList = new ArrayList<NodeTuple>(object2.size());
        object = new MappingNode((Tag)object, arrayList, flowStyle);
        this.representedObjects.put(this.objectToRepresent, (Node)object);
        FlowStyle flowStyle2 = FlowStyle.FLOW;
        for (Map.Entry entry : object2.entrySet()) {
            NodeTuple object3 = this.representMappingEntry(entry);
            if (!(object3.getKeyNode() instanceof ScalarNode) || !((ScalarNode)object3.getKeyNode()).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            if (!(object3.getValueNode() instanceof ScalarNode) || !((ScalarNode)object3.getValueNode()).isPlain()) {
                flowStyle2 = FlowStyle.BLOCK;
            }
            arrayList.add(object3);
        }
        if (flowStyle == FlowStyle.AUTO) {
            if (this.defaultFlowStyle != FlowStyle.AUTO) {
                ((CollectionNode)object).setFlowStyle(this.defaultFlowStyle);
            } else {
                ((CollectionNode)object).setFlowStyle(flowStyle2);
            }
        }
        return object;
    }
}

