/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.representer;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.RepresentToNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.FlowStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.NonPrintableStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.exceptions.YamlEngineException;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.representer.BaseRepresenter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.scanner.StreamReader;

public class StandardRepresenter
extends BaseRepresenter {
    protected Map<Class<? extends Object>, Tag> classTags;
    protected DumpSettings settings;
    public static final Pattern MULTILINE_PATTERN = Pattern.compile("\n|\u0085|\u2028|\u2029");

    public StandardRepresenter(DumpSettings dumpSettings) {
        this.defaultFlowStyle = dumpSettings.getDefaultFlowStyle();
        this.defaultScalarStyle = dumpSettings.getDefaultScalarStyle();
        this.nullRepresenter = new RepresentNull();
        this.representers.put(String.class, new RepresentString());
        this.representers.put(Boolean.class, new RepresentBoolean());
        this.representers.put(Character.class, new RepresentString());
        this.representers.put(UUID.class, new RepresentUuid());
        this.representers.put(Optional.class, new RepresentOptional());
        this.representers.put(byte[].class, new RepresentByteArray());
        RepresentPrimitiveArray representPrimitiveArray = new RepresentPrimitiveArray();
        this.representers.put(short[].class, representPrimitiveArray);
        this.representers.put(int[].class, representPrimitiveArray);
        this.representers.put(long[].class, representPrimitiveArray);
        this.representers.put(float[].class, representPrimitiveArray);
        this.representers.put(double[].class, representPrimitiveArray);
        this.representers.put(char[].class, representPrimitiveArray);
        this.representers.put(boolean[].class, representPrimitiveArray);
        this.parentClassRepresenters.put(Number.class, new RepresentNumber());
        this.parentClassRepresenters.put(List.class, new RepresentList());
        this.parentClassRepresenters.put(Map.class, new RepresentMap());
        this.parentClassRepresenters.put(Set.class, new RepresentSet());
        this.parentClassRepresenters.put(Iterator.class, new RepresentIterator());
        this.parentClassRepresenters.put(new Object[0].getClass(), new RepresentArray());
        this.parentClassRepresenters.put(Enum.class, new RepresentEnum());
        this.classTags = new HashMap<Class<? extends Object>, Tag>();
        this.settings = dumpSettings;
    }

    protected Tag getTag(Class<?> clazz, Tag tag) {
        if (this.classTags.containsKey(clazz)) {
            return this.classTags.get(clazz);
        }
        return tag;
    }

    public Tag addClassTag(Class<? extends Object> clazz, Tag tag) {
        if (tag == null) {
            throw new NullPointerException("Tag must be provided.");
        }
        return this.classTags.put(clazz, tag);
    }

    protected class RepresentOptional
    implements RepresentToNode {
        protected RepresentOptional() {
        }

        @Override
        public Node representData(Object object) {
            if (((Optional)(object = (Optional)object)).isPresent()) {
                object = StandardRepresenter.this.represent(((Optional)object).get());
                ((Node)object).setTag(new Tag(Optional.class));
                return object;
            }
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }

    protected class RepresentUuid
    implements RepresentToNode {
        protected RepresentUuid() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), new Tag(UUID.class)), object.toString());
        }
    }

    protected class RepresentByteArray
    implements RepresentToNode {
        protected RepresentByteArray() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(Tag.BINARY, Base64.getEncoder().encodeToString((byte[])object), ScalarStyle.LITERAL);
        }
    }

    protected class RepresentEnum
    implements RepresentToNode {
        protected RepresentEnum() {
        }

        @Override
        public Node representData(Object object) {
            Tag tag = new Tag(object.getClass());
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), tag), ((Enum)object).name());
        }
    }

    protected class RepresentSet
    implements RepresentToNode {
        protected RepresentSet() {
        }

        @Override
        public Node representData(Object object) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            Object object2 = (Set)object;
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Object e2 = object2.next();
                linkedHashMap.put(e2, null);
            }
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(object.getClass(), Tag.SET), linkedHashMap, FlowStyle.AUTO);
        }
    }

    protected class RepresentMap
    implements RepresentToNode {
        protected RepresentMap() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representMapping(StandardRepresenter.this.getTag(object.getClass(), Tag.MAP), (Map)object, FlowStyle.AUTO);
        }
    }

    protected class RepresentPrimitiveArray
    implements RepresentToNode {
        protected RepresentPrimitiveArray() {
        }

        @Override
        public Node representData(Object object) {
            Class<?> clazz = object.getClass().getComponentType();
            if (Byte.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asByteList(object), FlowStyle.AUTO);
            }
            if (Short.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asShortList(object), FlowStyle.AUTO);
            }
            if (Integer.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asIntList(object), FlowStyle.AUTO);
            }
            if (Long.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asLongList(object), FlowStyle.AUTO);
            }
            if (Float.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asFloatList(object), FlowStyle.AUTO);
            }
            if (Double.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asDoubleList(object), FlowStyle.AUTO);
            }
            if (Character.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asCharList(object), FlowStyle.AUTO);
            }
            if (Boolean.TYPE == clazz) {
                return StandardRepresenter.this.representSequence(Tag.SEQ, this.asBooleanList(object), FlowStyle.AUTO);
            }
            throw new YamlEngineException("Unexpected primitive '" + clazz.getCanonicalName() + "'");
        }

        private List<Byte> asByteList(Object object) {
            object = (byte[])object;
            ArrayList<Byte> arrayList = new ArrayList<Byte>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((byte)object[i2]);
            }
            return arrayList;
        }

        private List<Short> asShortList(Object object) {
            object = (short[])object;
            ArrayList<Short> arrayList = new ArrayList<Short>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((short)object[i2]);
            }
            return arrayList;
        }

        private List<Integer> asIntList(Object object) {
            object = (int[])object;
            ArrayList<Integer> arrayList = new ArrayList<Integer>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((int)object[i2]);
            }
            return arrayList;
        }

        private List<Long> asLongList(Object object) {
            object = (long[])object;
            ArrayList<Long> arrayList = new ArrayList<Long>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((long)object[i2]);
            }
            return arrayList;
        }

        private List<Float> asFloatList(Object object) {
            object = (float[])object;
            ArrayList<Float> arrayList = new ArrayList<Float>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add(Float.valueOf((float)object[i2]));
            }
            return arrayList;
        }

        private List<Double> asDoubleList(Object object) {
            object = (double[])object;
            ArrayList<Double> arrayList = new ArrayList<Double>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((double)object[i2]);
            }
            return arrayList;
        }

        private List<Character> asCharList(Object object) {
            object = (char[])object;
            ArrayList<Character> arrayList = new ArrayList<Character>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add(Character.valueOf((char)object[i2]));
            }
            return arrayList;
        }

        private List<Boolean> asBooleanList(Object object) {
            object = (boolean[])object;
            ArrayList<Boolean> arrayList = new ArrayList<Boolean>(((Object)object).length);
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                arrayList.add((boolean)object[i2]);
            }
            return arrayList;
        }
    }

    protected class RepresentArray
    implements RepresentToNode {
        protected RepresentArray() {
        }

        @Override
        public Node representData(Object object) {
            object = object;
            object = Arrays.asList(object);
            return StandardRepresenter.this.representSequence(Tag.SEQ, (Iterable<?>)object, FlowStyle.AUTO);
        }
    }

    static class IteratorWrapper
    implements Iterable<Object> {
        private final Iterator<Object> iter;

        public IteratorWrapper(Iterator<Object> iterator) {
            this.iter = iterator;
        }

        @Override
        public Iterator<Object> iterator() {
            return this.iter;
        }
    }

    protected class RepresentIterator
    implements RepresentToNode {
        protected RepresentIterator() {
        }

        @Override
        public Node representData(Object object) {
            Iterator iterator = (Iterator)object;
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(object.getClass(), Tag.SEQ), new IteratorWrapper(iterator), FlowStyle.AUTO);
        }
    }

    protected class RepresentList
    implements RepresentToNode {
        protected RepresentList() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representSequence(StandardRepresenter.this.getTag(object.getClass(), Tag.SEQ), (List)object, FlowStyle.AUTO);
        }
    }

    protected class RepresentNumber
    implements RepresentToNode {
        protected RepresentNumber() {
        }

        @Override
        public Node representData(Object object) {
            Object object2;
            Tag tag;
            if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long || object instanceof BigInteger) {
                tag = Tag.INT;
                object2 = object.toString();
            } else {
                object2 = (Number)object;
                tag = Tag.FLOAT;
                object2 = object2.equals(Double.NaN) ? ".NaN" : (object2.equals(Double.POSITIVE_INFINITY) ? ".inf" : (object2.equals(Double.NEGATIVE_INFINITY) ? "-.inf" : object2.toString()));
            }
            return StandardRepresenter.this.representScalar(StandardRepresenter.this.getTag(object.getClass(), tag), (String)object2);
        }
    }

    protected class RepresentBoolean
    implements RepresentToNode {
        protected RepresentBoolean() {
        }

        @Override
        public Node representData(Object object) {
            object = Boolean.TRUE.equals(object) ? "true" : "false";
            return StandardRepresenter.this.representScalar(Tag.BOOL, (String)object);
        }
    }

    protected class RepresentString
    implements RepresentToNode {
        protected RepresentString() {
        }

        @Override
        public Node representData(Object object) {
            Tag tag = Tag.STR;
            Object object2 = ScalarStyle.PLAIN;
            object = object.toString();
            if (StandardRepresenter.this.settings.getNonPrintableStyle() == NonPrintableStyle.BINARY && !StreamReader.isPrintable((String)object)) {
                tag = Tag.BINARY;
                object2 = ((String)object).getBytes(StandardCharsets.UTF_8);
                String string = new String((byte[])object2, StandardCharsets.UTF_8);
                if (!string.equals(object)) {
                    throw new YamlEngineException("invalid string value has occurred");
                }
                object = Base64.getEncoder().encodeToString((byte[])object2);
                object2 = ScalarStyle.LITERAL;
            }
            if (StandardRepresenter.this.defaultScalarStyle == ScalarStyle.PLAIN && MULTILINE_PATTERN.matcher((CharSequence)object).find()) {
                object2 = ScalarStyle.LITERAL;
            }
            return StandardRepresenter.this.representScalar(tag, (String)object, (ScalarStyle)((Object)object2));
        }
    }

    protected class RepresentNull
    implements RepresentToNode {
        protected RepresentNull() {
        }

        @Override
        public Node representData(Object object) {
            return StandardRepresenter.this.representScalar(Tag.NULL, "null");
        }
    }
}

