/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.serializer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.api.DumpSettings;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.comments.CommentLine;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.Anchor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.emitter.Emitable;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.AliasEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.CommentEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.DocumentEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.DocumentStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.Event;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.ImplicitTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.MappingEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.MappingStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.ScalarEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.SequenceEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.SequenceStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.StreamEndEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.events.StreamStartEvent;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.AnchorNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeTuple;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.NodeType;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.SequenceNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;

public class Serializer {
    private final DumpSettings settings;
    private final Emitable emitable;
    private final Set<Node> serializedNodes;
    private final Map<Node, Anchor> anchors;

    public Serializer(DumpSettings dumpSettings, Emitable emitable) {
        this.settings = dumpSettings;
        this.emitable = emitable;
        this.serializedNodes = new HashSet<Node>();
        this.anchors = new HashMap<Node, Anchor>();
    }

    public void serializeDocument(Node node) {
        this.emitable.emit(new DocumentStartEvent(this.settings.isExplicitStart(), this.settings.getYamlDirective(), this.settings.getTagDirective()));
        this.anchorNode(node);
        this.settings.getExplicitRootTag().ifPresent(node::setTag);
        this.serializeNode(node);
        this.emitable.emit(new DocumentEndEvent(this.settings.isExplicitEnd()));
        this.serializedNodes.clear();
        this.anchors.clear();
    }

    public void emitStreamStart() {
        this.emitable.emit(new StreamStartEvent());
    }

    public void emitStreamEnd() {
        this.emitable.emit(new StreamEndEvent());
    }

    private void anchorNode(Node iterator) {
        if (((Node)((Object)iterator)).getNodeType() == NodeType.ANCHOR) {
            iterator = ((AnchorNode)((Object)iterator)).getRealNode();
        }
        if (this.anchors.containsKey(iterator)) {
            this.anchors.computeIfAbsent((Node)((Object)iterator), arg_0 -> this.lambda$anchorNode$0((Node)((Object)iterator), arg_0));
            return;
        }
        Node node = iterator;
        this.anchors.put(node, node.getAnchor().isPresent() ? this.settings.getAnchorGenerator().nextAnchor((Node)((Object)iterator)) : null);
        switch (((Node)((Object)iterator)).getNodeType()) {
            case SEQUENCE: {
                iterator = (SequenceNode)((Object)iterator);
                iterator = ((SequenceNode)((Object)iterator)).getValue();
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    this.anchorNode(node2);
                }
                return;
            }
            case MAPPING: {
                iterator = (MappingNode)((Object)iterator);
                Object object = ((MappingNode)((Object)iterator)).getValue();
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    object = (NodeTuple)iterator.next();
                    Node node3 = ((NodeTuple)object).getKeyNode();
                    object = ((NodeTuple)object).getValueNode();
                    this.anchorNode(node3);
                    this.anchorNode((Node)object);
                }
                break;
            }
        }
    }

    private void serializeNode(Node node) {
        if (node.getNodeType() == NodeType.ANCHOR) {
            node = ((AnchorNode)node).getRealNode();
        }
        Object object = Optional.ofNullable(this.anchors.get(node));
        if (this.serializedNodes.contains(node)) {
            this.emitable.emit(new AliasEvent((Optional<Anchor>)object));
            return;
        }
        this.serializedNodes.add(node);
        switch (node.getNodeType()) {
            case SCALAR: {
                ScalarNode scalarNode = (ScalarNode)node;
                this.serializeComments(node.getBlockComments());
                Object node2 = this.settings.getScalarResolver().resolve(scalarNode.getValue(), Boolean.TRUE);
                Tag tag = this.settings.getScalarResolver().resolve(scalarNode.getValue(), Boolean.FALSE);
                node2 = new ImplicitTuple(node.getTag().equals(node2), node.getTag().equals(tag));
                object = new ScalarEvent((Optional<Anchor>)object, Optional.of(node.getTag().getValue()), (ImplicitTuple)node2, scalarNode.getValue(), scalarNode.getScalarStyle());
                this.emitable.emit((Event)object);
                this.serializeComments(node.getInLineComments());
                this.serializeComments(node.getEndComments());
                return;
            }
            case SEQUENCE: {
                SequenceNode object3 = (SequenceNode)node;
                this.serializeComments(node.getBlockComments());
                boolean node3 = node.getTag().equals(Tag.SEQ);
                this.emitable.emit(new SequenceStartEvent((Optional<Anchor>)object, Optional.of(node.getTag().getValue()), node3, object3.getFlowStyle()));
                object = object3.getValue();
                Iterator<Node> bl3 = object.iterator();
                while (bl3.hasNext()) {
                    Node node2 = bl3.next();
                    this.serializeNode(node2);
                }
                this.emitable.emit(new SequenceEndEvent());
                this.serializeComments(node.getInLineComments());
                this.serializeComments(node.getEndComments());
                return;
            }
        }
        this.serializeComments(node.getBlockComments());
        boolean object4 = node.getTag().equals(Tag.MAP);
        Node node3 = (MappingNode)node;
        List<NodeTuple> list = node3.getValue();
        if (node3.getTag() != Tag.COMMENT) {
            this.emitable.emit(new MappingStartEvent((Optional<Anchor>)object, Optional.of(node3.getTag().getValue()), object4, node3.getFlowStyle(), Optional.empty(), Optional.empty()));
            for (NodeTuple nodeTuple : list) {
                node3 = nodeTuple.getKeyNode();
                Node node4 = nodeTuple.getValueNode();
                this.serializeNode(node3);
                this.serializeNode(node4);
            }
            this.emitable.emit(new MappingEndEvent());
            this.serializeComments(node.getInLineComments());
            this.serializeComments(node.getEndComments());
        }
    }

    private void serializeComments(List<CommentLine> object) {
        if (object == null) {
            return;
        }
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (CommentLine)object.next();
            object2 = new CommentEvent(((CommentLine)object2).getCommentType(), ((CommentLine)object2).getValue(), ((CommentLine)object2).getStartMark(), ((CommentLine)object2).getEndMark());
            this.emitable.emit((Event)object2);
        }
    }

    private /* synthetic */ Anchor lambda$anchorNode$0(Node node, Node node2) {
        return this.settings.getAnchorGenerator().nextAnchor(node);
    }
}

