/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.boostedyaml.updater.operators;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.extremall.advancedkits.libs.boostedyaml.YamlDocument;
import me.extremall.advancedkits.libs.boostedyaml.block.Block;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.Section;
import me.extremall.advancedkits.libs.boostedyaml.block.implementation.TerminatedBlock;
import me.extremall.advancedkits.libs.boostedyaml.engine.ExtendedConstructor;
import me.extremall.advancedkits.libs.boostedyaml.engine.ExtendedRepresenter;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.common.ScalarStyle;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.constructor.BaseConstructor;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.MappingNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Node;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.ScalarNode;
import me.extremall.advancedkits.libs.boostedyaml.libs.org.snakeyaml.engine.v2.nodes.Tag;
import me.extremall.advancedkits.libs.boostedyaml.route.Route;
import me.extremall.advancedkits.libs.boostedyaml.settings.general.GeneralSettings;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.MergeRule;
import me.extremall.advancedkits.libs.boostedyaml.settings.updater.UpdaterSettings;
import org.jetbrains.annotations.NotNull;

public class Merger {
    private static final Merger INSTANCE = new Merger();

    public static void merge(@NotNull Section section, @NotNull Section section2, @NotNull UpdaterSettings updaterSettings) {
        INSTANCE.iterate(section, section2, updaterSettings);
    }

    private void iterate(Section section, Section iterator, UpdaterSettings updaterSettings) {
        Object object2;
        Object object3;
        HashSet hashSet = new HashSet(((Map)section.getStoredValue()).keySet());
        boolean bl2 = updaterSettings.getOptionSorting() == UpdaterSettings.OptionSorting.SORT_BY_DEFAULTS;
        Map<Object, Block<?>> map = bl2 ? section.getRoot().getGeneralSettings().getDefaultMap() : null;
        for (Map.Entry entry : ((Map)((Block)((Object)iterator)).getStoredValue()).entrySet()) {
            object3 = entry.getKey();
            object2 = Route.from(object3);
            hashSet.remove(object3);
            Block block = section.getOptionalBlock((Route)object2).orElse(null);
            Block object4 = (Block)entry.getValue();
            if (block != null) {
                if (block.isIgnored()) {
                    block.setIgnored(false);
                    if (block instanceof Section) {
                        this.resetIgnored((Section)block);
                    }
                    if (!bl2) continue;
                    map.put(object3, block);
                    continue;
                }
                boolean bl3 = block instanceof Section;
                boolean bl4 = object4 instanceof Section;
                if (bl4 && bl3) {
                    this.iterate((Section)block, (Section)object4, updaterSettings);
                    if (!bl2) continue;
                    map.put(object3, block);
                    continue;
                }
                if (bl2) {
                    map.put(object3, this.getPreservedValue(updaterSettings.getMergeRules(), block, () -> this.cloneBlock(object4, section), bl3, bl4));
                    continue;
                }
                section.set((Route)object2, this.getPreservedValue(updaterSettings.getMergeRules(), block, () -> this.cloneBlock(object4, section), bl3, bl4));
                continue;
            }
            if (bl2) {
                map.put(object3, this.cloneBlock(object4, section));
                continue;
            }
            section.set((Route)object2, this.cloneBlock(object4, section));
        }
        if (updaterSettings.isKeepAll()) {
            if (bl2) {
                hashSet.forEach(object -> map.put(object, (Block<?>)((Map)section.getStoredValue()).get(object)));
                section.repopulate(map);
            }
            return;
        }
        for (Object object4 : hashSet) {
            object3 = Route.fromSingleKey(object4);
            object2 = section.getOptionalBlock((Route)object3).orElse(null);
            if (object2 != null && ((Block)object2).isIgnored()) {
                ((Block)object2).setIgnored(false);
                if (object2 instanceof Section) {
                    this.resetIgnored((Section)object2);
                }
                if (!bl2) continue;
                map.put(object4, (Block<?>)object2);
                continue;
            }
            if (bl2) continue;
            section.remove((Route)object3);
        }
        if (bl2) {
            section.repopulate(map);
        }
    }

    private void resetIgnored(@NotNull Section section) {
        ((Map)section.getStoredValue()).values().forEach(block -> {
            block.setIgnored(false);
            if (block instanceof Section) {
                this.resetIgnored((Section)block);
            }
        });
    }

    @NotNull
    private Block<?> cloneBlock(@NotNull Block<?> block, @NotNull Section section) {
        if (block instanceof Section) {
            return this.cloneSection((Section)block, section);
        }
        return this.cloneTerminated((TerminatedBlock)block, section);
    }

    @NotNull
    private Section cloneSection(@NotNull Section section, @NotNull Section section2) {
        if (section.getRoute() == null) {
            throw new IllegalArgumentException("Cannot clone the root!");
        }
        Object object = section.getRoot();
        Object object2 = ((YamlDocument)object).getGeneralSettings();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter((GeneralSettings)object2, ((YamlDocument)object).getDumperSettings().buildEngineSettings());
        object = new ExtendedConstructor(((YamlDocument)object).getLoaderSettings().buildEngineSettings((GeneralSettings)object2), ((GeneralSettings)object2).getSerializer());
        object2 = extendedRepresenter.represent(section);
        ((BaseConstructor)object).constructSingleDocument(Optional.of(object2));
        section = new Section(section2.getRoot(), section2, section.getRoute(), this.moveComments((Node)object2), (MappingNode)object2, (ExtendedConstructor)object);
        ((ExtendedConstructor)object).clear();
        return section;
    }

    @NotNull
    private TerminatedBlock cloneTerminated(@NotNull TerminatedBlock terminatedBlock, @NotNull Section object) {
        object = ((Section)object).getRoot();
        Object object2 = ((YamlDocument)object).getGeneralSettings();
        ExtendedRepresenter extendedRepresenter = new ExtendedRepresenter((GeneralSettings)object2, ((YamlDocument)object).getDumperSettings().buildEngineSettings());
        object = new ExtendedConstructor(((YamlDocument)object).getLoaderSettings().buildEngineSettings((GeneralSettings)object2), ((GeneralSettings)object2).getSerializer());
        object2 = extendedRepresenter.represent(terminatedBlock.getStoredValue());
        ((BaseConstructor)object).constructSingleDocument(Optional.of(object2));
        terminatedBlock = new TerminatedBlock((Block<?>)terminatedBlock, ((ExtendedConstructor)object).getConstructed((Node)object2));
        ((ExtendedConstructor)object).clear();
        return terminatedBlock;
    }

    private Node moveComments(@NotNull Node node) {
        ScalarNode scalarNode = new ScalarNode(Tag.STR, "", ScalarStyle.PLAIN);
        scalarNode.setBlockComments(node.getBlockComments());
        scalarNode.setInLineComments(node.getInLineComments());
        scalarNode.setEndComments(node.getEndComments());
        node.setBlockComments(Collections.emptyList());
        node.setInLineComments(null);
        node.setEndComments(null);
        return scalarNode;
    }

    @NotNull
    private Block<?> getPreservedValue(@NotNull Map<MergeRule, Boolean> map, @NotNull Block<?> block, @NotNull Supplier<Block<?>> supplier, boolean bl2, boolean bl3) {
        if (map.get((Object)MergeRule.getFor(bl2, bl3)).booleanValue()) {
            return block;
        }
        return supplier.get();
    }
}

