/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fastuuid.uuid;

import java.util.Arrays;
import java.util.UUID;

public class FastUUID {
    private static final boolean USE_JDK_UUID_TO_STRING;
    private static final int UUID_STRING_LENGTH = 36;
    private static final char[] HEX_DIGITS;
    private static final long[] HEX_VALUES;

    private FastUUID() {
    }

    public static UUID parseUUID(CharSequence charSequence) {
        if (charSequence.length() != 36 || charSequence.charAt(8) != '-' || charSequence.charAt(13) != '-' || charSequence.charAt(18) != '-' || charSequence.charAt(23) != '-') {
            throw new IllegalArgumentException("Illegal UUID string: " + charSequence);
        }
        long l2 = FastUUID.getHexValueForChar(charSequence.charAt(0)) << 60;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(1)) << 56;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(2)) << 52;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(3)) << 48;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(4)) << 44;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(5)) << 40;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(6)) << 36;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(7)) << 32;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(9)) << 28;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(10)) << 24;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(11)) << 20;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(12)) << 16;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(14)) << 12;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(15)) << 8;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(16)) << 4;
        l2 |= FastUUID.getHexValueForChar(charSequence.charAt(17));
        long l3 = FastUUID.getHexValueForChar(charSequence.charAt(19)) << 60;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(20)) << 56;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(21)) << 52;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(22)) << 48;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(24)) << 44;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(25)) << 40;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(26)) << 36;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(27)) << 32;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(28)) << 28;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(29)) << 24;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(30)) << 20;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(31)) << 16;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(32)) << 12;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(33)) << 8;
        l3 |= FastUUID.getHexValueForChar(charSequence.charAt(34)) << 4;
        return new UUID(l2, l3 |= FastUUID.getHexValueForChar(charSequence.charAt(35)));
    }

    public static String toString(UUID object) {
        if (USE_JDK_UUID_TO_STRING) {
            return ((UUID)object).toString();
        }
        long l2 = ((UUID)object).getMostSignificantBits();
        long l3 = ((UUID)object).getLeastSignificantBits();
        char[] cArray = new char[36];
        object = cArray;
        cArray[0] = HEX_DIGITS[(int)((l2 & 0xF000000000000000L) >>> 60)];
        object[1] = HEX_DIGITS[(int)((l2 & 0xF00000000000000L) >>> 56)];
        object[2] = HEX_DIGITS[(int)((l2 & 0xF0000000000000L) >>> 52)];
        object[3] = HEX_DIGITS[(int)((l2 & 0xF000000000000L) >>> 48)];
        object[4] = HEX_DIGITS[(int)((l2 & 0xF00000000000L) >>> 44)];
        object[5] = HEX_DIGITS[(int)((l2 & 0xF0000000000L) >>> 40)];
        object[6] = HEX_DIGITS[(int)((l2 & 0xF000000000L) >>> 36)];
        object[7] = HEX_DIGITS[(int)((l2 & 0xF00000000L) >>> 32)];
        object[8] = 45;
        object[9] = HEX_DIGITS[(int)((l2 & 0xF0000000L) >>> 28)];
        object[10] = HEX_DIGITS[(int)((l2 & 0xF000000L) >>> 24)];
        object[11] = HEX_DIGITS[(int)((l2 & 0xF00000L) >>> 20)];
        object[12] = HEX_DIGITS[(int)((l2 & 0xF0000L) >>> 16)];
        object[13] = 45;
        object[14] = HEX_DIGITS[(int)((l2 & 0xF000L) >>> 12)];
        object[15] = HEX_DIGITS[(int)((l2 & 0xF00L) >>> 8)];
        object[16] = HEX_DIGITS[(int)((l2 & 0xF0L) >>> 4)];
        object[17] = HEX_DIGITS[(int)(l2 & 0xFL)];
        object[18] = 45;
        object[19] = HEX_DIGITS[(int)((l3 & 0xF000000000000000L) >>> 60)];
        object[20] = HEX_DIGITS[(int)((l3 & 0xF00000000000000L) >>> 56)];
        object[21] = HEX_DIGITS[(int)((l3 & 0xF0000000000000L) >>> 52)];
        object[22] = HEX_DIGITS[(int)((l3 & 0xF000000000000L) >>> 48)];
        object[23] = 45;
        object[24] = HEX_DIGITS[(int)((l3 & 0xF00000000000L) >>> 44)];
        object[25] = HEX_DIGITS[(int)((l3 & 0xF0000000000L) >>> 40)];
        object[26] = HEX_DIGITS[(int)((l3 & 0xF000000000L) >>> 36)];
        object[27] = HEX_DIGITS[(int)((l3 & 0xF00000000L) >>> 32)];
        object[28] = HEX_DIGITS[(int)((l3 & 0xF0000000L) >>> 28)];
        object[29] = HEX_DIGITS[(int)((l3 & 0xF000000L) >>> 24)];
        object[30] = HEX_DIGITS[(int)((l3 & 0xF00000L) >>> 20)];
        object[31] = HEX_DIGITS[(int)((l3 & 0xF0000L) >>> 16)];
        object[32] = HEX_DIGITS[(int)((l3 & 0xF000L) >>> 12)];
        object[33] = HEX_DIGITS[(int)((l3 & 0xF00L) >>> 8)];
        object[34] = HEX_DIGITS[(int)((l3 & 0xF0L) >>> 4)];
        object[35] = HEX_DIGITS[(int)(l3 & 0xFL)];
        return new String((char[])object);
    }

    static long getHexValueForChar(char c2) {
        try {
            if (HEX_VALUES[c2] < 0L) {
                throw new IllegalArgumentException("Illegal hexadecimal digit: " + c2);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Illegal hexadecimal digit: " + c2);
        }
        return HEX_VALUES[c2];
    }

    static {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(System.getProperty("java.specification.version"));
        }
        catch (NumberFormatException numberFormatException) {}
        USE_JDK_UUID_TO_STRING = n2 >= 9;
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        HEX_VALUES = new long[128];
        Arrays.fill(HEX_VALUES, -1L);
        FastUUID.HEX_VALUES[48] = 0L;
        FastUUID.HEX_VALUES[49] = 1L;
        FastUUID.HEX_VALUES[50] = 2L;
        FastUUID.HEX_VALUES[51] = 3L;
        FastUUID.HEX_VALUES[52] = 4L;
        FastUUID.HEX_VALUES[53] = 5L;
        FastUUID.HEX_VALUES[54] = 6L;
        FastUUID.HEX_VALUES[55] = 7L;
        FastUUID.HEX_VALUES[56] = 8L;
        FastUUID.HEX_VALUES[57] = 9L;
        FastUUID.HEX_VALUES[97] = 10L;
        FastUUID.HEX_VALUES[98] = 11L;
        FastUUID.HEX_VALUES[99] = 12L;
        FastUUID.HEX_VALUES[100] = 13L;
        FastUUID.HEX_VALUES[101] = 14L;
        FastUUID.HEX_VALUES[102] = 15L;
        FastUUID.HEX_VALUES[65] = 10L;
        FastUUID.HEX_VALUES[66] = 11L;
        FastUUID.HEX_VALUES[67] = 12L;
        FastUUID.HEX_VALUES[68] = 13L;
        FastUUID.HEX_VALUES[69] = 14L;
        FastUUID.HEX_VALUES[70] = 15L;
    }
}

