/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.fcommons.collection;

import java.util.Locale;
import me.extremall.advancedkits.libs.fcommons.Preconditions;
import org.jetbrains.annotations.NotNull;

public final class CaseInsensitiveString {
    private final String originalString;
    private final String uppercaseString;

    public CaseInsensitiveString(@NotNull String string) {
        Preconditions.notNull(string, "string");
        this.originalString = string;
        this.uppercaseString = string.toUpperCase(Locale.ROOT);
    }

    public final String getOriginalString() {
        return this.originalString;
    }

    public final boolean equalsIgnoreCase(String string) {
        return string != null && string.toUpperCase(Locale.ROOT).equals(this.uppercaseString);
    }

    public final String toString() {
        return this.originalString;
    }

    public final int hashCode() {
        return this.uppercaseString.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return ((CaseInsensitiveString)object).uppercaseString.equals(this.uppercaseString);
    }
}

