/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import me.extremall.advancedkits.libs.gson.FieldNamingPolicy;
import me.extremall.advancedkits.libs.gson.FieldNamingStrategy;
import me.extremall.advancedkits.libs.gson.GsonBuilder;
import me.extremall.advancedkits.libs.gson.InstanceCreator;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonIOException;
import me.extremall.advancedkits.libs.gson.JsonNull;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.LongSerializationPolicy;
import me.extremall.advancedkits.libs.gson.ReflectionAccessFilter;
import me.extremall.advancedkits.libs.gson.ToNumberPolicy;
import me.extremall.advancedkits.libs.gson.ToNumberStrategy;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.TypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.ConstructorConstructor;
import me.extremall.advancedkits.libs.gson.internal.Excluder;
import me.extremall.advancedkits.libs.gson.internal.LazilyParsedNumber;
import me.extremall.advancedkits.libs.gson.internal.Primitives;
import me.extremall.advancedkits.libs.gson.internal.Streams;
import me.extremall.advancedkits.libs.gson.internal.bind.ArrayTypeAdapter;
import me.extremall.advancedkits.libs.gson.internal.bind.CollectionTypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.bind.DateTypeAdapter;
import me.extremall.advancedkits.libs.gson.internal.bind.JsonAdapterAnnotationTypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.bind.JsonTreeReader;
import me.extremall.advancedkits.libs.gson.internal.bind.JsonTreeWriter;
import me.extremall.advancedkits.libs.gson.internal.bind.MapTypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.bind.NumberTypeAdapter;
import me.extremall.advancedkits.libs.gson.internal.bind.ObjectTypeAdapter;
import me.extremall.advancedkits.libs.gson.internal.bind.ReflectiveTypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.bind.SerializationDelegatingTypeAdapter;
import me.extremall.advancedkits.libs.gson.internal.bind.TypeAdapters;
import me.extremall.advancedkits.libs.gson.internal.sql.SqlTypesSupport;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.gson.stream.MalformedJsonException;

public final class Gson {
    static final boolean DEFAULT_JSON_NON_EXECUTABLE = false;
    static final boolean DEFAULT_LENIENT = false;
    static final boolean DEFAULT_PRETTY_PRINT = false;
    static final boolean DEFAULT_ESCAPE_HTML = true;
    static final boolean DEFAULT_SERIALIZE_NULLS = false;
    static final boolean DEFAULT_COMPLEX_MAP_KEYS = false;
    static final boolean DEFAULT_SPECIALIZE_FLOAT_VALUES = false;
    static final boolean DEFAULT_USE_JDK_UNSAFE = true;
    static final String DEFAULT_DATE_PATTERN = null;
    static final FieldNamingStrategy DEFAULT_FIELD_NAMING_STRATEGY = FieldNamingPolicy.IDENTITY;
    static final ToNumberStrategy DEFAULT_OBJECT_TO_NUMBER_STRATEGY = ToNumberPolicy.DOUBLE;
    static final ToNumberStrategy DEFAULT_NUMBER_TO_NUMBER_STRATEGY = ToNumberPolicy.LAZILY_PARSED_NUMBER;
    private static final String JSON_NON_EXECUTABLE_PREFIX = ")]}'\n";
    private final ThreadLocal<Map<TypeToken<?>, TypeAdapter<?>>> threadLocalAdapterResults = new ThreadLocal();
    private final ConcurrentMap<TypeToken<?>, TypeAdapter<?>> typeTokenCache = new ConcurrentHashMap();
    private final ConstructorConstructor constructorConstructor;
    private final JsonAdapterAnnotationTypeAdapterFactory jsonAdapterFactory;
    final List<TypeAdapterFactory> factories;
    final Excluder excluder;
    final FieldNamingStrategy fieldNamingStrategy;
    final Map<Type, InstanceCreator<?>> instanceCreators;
    final boolean serializeNulls;
    final boolean complexMapKeySerialization;
    final boolean generateNonExecutableJson;
    final boolean htmlSafe;
    final boolean prettyPrinting;
    final boolean lenient;
    final boolean serializeSpecialFloatingPointValues;
    final boolean useJdkUnsafe;
    final String datePattern;
    final int dateStyle;
    final int timeStyle;
    final LongSerializationPolicy longSerializationPolicy;
    final List<TypeAdapterFactory> builderFactories;
    final List<TypeAdapterFactory> builderHierarchyFactories;
    final ToNumberStrategy objectToNumberStrategy;
    final ToNumberStrategy numberToNumberStrategy;
    final List<ReflectionAccessFilter> reflectionFilters;

    public Gson() {
        this(Excluder.DEFAULT, DEFAULT_FIELD_NAMING_STRATEGY, Collections.emptyMap(), false, false, false, true, false, false, false, true, LongSerializationPolicy.DEFAULT, DEFAULT_DATE_PATTERN, 2, 2, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), DEFAULT_OBJECT_TO_NUMBER_STRATEGY, DEFAULT_NUMBER_TO_NUMBER_STRATEGY, Collections.emptyList());
    }

    Gson(Excluder excluder, FieldNamingStrategy fieldNamingStrategy, Map<Type, InstanceCreator<?>> object, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9, LongSerializationPolicy longSerializationPolicy, String string, int n2, int n3, List<TypeAdapterFactory> list, List<TypeAdapterFactory> list2, List<TypeAdapterFactory> list3, ToNumberStrategy toNumberStrategy, ToNumberStrategy toNumberStrategy2, List<ReflectionAccessFilter> list4) {
        this.excluder = excluder;
        this.fieldNamingStrategy = fieldNamingStrategy;
        this.instanceCreators = object;
        this.constructorConstructor = new ConstructorConstructor((Map<Type, InstanceCreator<?>>)object, bl9, list4);
        this.serializeNulls = bl2;
        this.complexMapKeySerialization = bl3;
        this.generateNonExecutableJson = bl4;
        this.htmlSafe = bl5;
        this.prettyPrinting = bl6;
        this.lenient = bl7;
        this.serializeSpecialFloatingPointValues = bl8;
        this.useJdkUnsafe = bl9;
        this.longSerializationPolicy = longSerializationPolicy;
        this.datePattern = string;
        this.dateStyle = n2;
        this.timeStyle = n3;
        this.builderFactories = list;
        this.builderHierarchyFactories = list2;
        this.objectToNumberStrategy = toNumberStrategy;
        this.numberToNumberStrategy = toNumberStrategy2;
        this.reflectionFilters = list4;
        object = new ArrayList<TypeAdapterFactory>();
        object.add(TypeAdapters.JSON_ELEMENT_FACTORY);
        object.add(ObjectTypeAdapter.getFactory(toNumberStrategy));
        object.add(excluder);
        object.addAll(list3);
        object.add(TypeAdapters.STRING_FACTORY);
        object.add(TypeAdapters.INTEGER_FACTORY);
        object.add(TypeAdapters.BOOLEAN_FACTORY);
        object.add(TypeAdapters.BYTE_FACTORY);
        object.add(TypeAdapters.SHORT_FACTORY);
        TypeAdapter<Number> typeAdapter = Gson.longAdapter(longSerializationPolicy);
        object.add(TypeAdapters.newFactory(Long.TYPE, Long.class, typeAdapter));
        object.add(TypeAdapters.newFactory(Double.TYPE, Double.class, this.doubleAdapter(bl8)));
        object.add(TypeAdapters.newFactory(Float.TYPE, Float.class, this.floatAdapter(bl8)));
        object.add(NumberTypeAdapter.getFactory(toNumberStrategy2));
        object.add(TypeAdapters.ATOMIC_INTEGER_FACTORY);
        object.add(TypeAdapters.ATOMIC_BOOLEAN_FACTORY);
        object.add(TypeAdapters.newFactory(AtomicLong.class, Gson.atomicLongAdapter(typeAdapter)));
        object.add(TypeAdapters.newFactory(AtomicLongArray.class, Gson.atomicLongArrayAdapter(typeAdapter)));
        object.add(TypeAdapters.ATOMIC_INTEGER_ARRAY_FACTORY);
        object.add(TypeAdapters.CHARACTER_FACTORY);
        object.add(TypeAdapters.STRING_BUILDER_FACTORY);
        object.add(TypeAdapters.STRING_BUFFER_FACTORY);
        object.add(TypeAdapters.newFactory(BigDecimal.class, TypeAdapters.BIG_DECIMAL));
        object.add(TypeAdapters.newFactory(BigInteger.class, TypeAdapters.BIG_INTEGER));
        object.add(TypeAdapters.newFactory(LazilyParsedNumber.class, TypeAdapters.LAZILY_PARSED_NUMBER));
        object.add(TypeAdapters.URL_FACTORY);
        object.add(TypeAdapters.URI_FACTORY);
        object.add(TypeAdapters.UUID_FACTORY);
        object.add(TypeAdapters.CURRENCY_FACTORY);
        object.add(TypeAdapters.LOCALE_FACTORY);
        object.add(TypeAdapters.INET_ADDRESS_FACTORY);
        object.add(TypeAdapters.BIT_SET_FACTORY);
        object.add(DateTypeAdapter.FACTORY);
        object.add(TypeAdapters.CALENDAR_FACTORY);
        if (SqlTypesSupport.SUPPORTS_SQL_TYPES) {
            object.add(SqlTypesSupport.TIME_FACTORY);
            object.add(SqlTypesSupport.DATE_FACTORY);
            object.add(SqlTypesSupport.TIMESTAMP_FACTORY);
        }
        object.add(ArrayTypeAdapter.FACTORY);
        object.add(TypeAdapters.CLASS_FACTORY);
        object.add(new CollectionTypeAdapterFactory(this.constructorConstructor));
        object.add(new MapTypeAdapterFactory(this.constructorConstructor, bl3));
        this.jsonAdapterFactory = new JsonAdapterAnnotationTypeAdapterFactory(this.constructorConstructor);
        object.add(this.jsonAdapterFactory);
        object.add(TypeAdapters.ENUM_FACTORY);
        object.add(new ReflectiveTypeAdapterFactory(this.constructorConstructor, fieldNamingStrategy, excluder, this.jsonAdapterFactory, list4));
        this.factories = Collections.unmodifiableList(object);
    }

    public final GsonBuilder newBuilder() {
        return new GsonBuilder(this);
    }

    @Deprecated
    public final Excluder excluder() {
        return this.excluder;
    }

    public final FieldNamingStrategy fieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }

    public final boolean serializeNulls() {
        return this.serializeNulls;
    }

    public final boolean htmlSafe() {
        return this.htmlSafe;
    }

    private TypeAdapter<Number> doubleAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.DOUBLE;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Double read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextDouble();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                double d2 = number.doubleValue();
                Gson.checkValidFloatingPoint(d2);
                jsonWriter.value(d2);
            }
        };
    }

    private TypeAdapter<Number> floatAdapter(boolean bl2) {
        if (bl2) {
            return TypeAdapters.FLOAT;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Float read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return Float.valueOf((float)jsonReader.nextDouble());
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                float f2 = number.floatValue();
                Gson.checkValidFloatingPoint(f2);
                number = number instanceof Float ? (Number)number : (Number)Float.valueOf(f2);
                jsonWriter.value(number);
            }
        };
    }

    static void checkValidFloatingPoint(double d2) {
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            throw new IllegalArgumentException(d2 + " is not a valid double value as per JSON specification. To override this behavior, use GsonBuilder.serializeSpecialFloatingPointValues() method.");
        }
    }

    private static TypeAdapter<Number> longAdapter(LongSerializationPolicy longSerializationPolicy) {
        if (longSerializationPolicy == LongSerializationPolicy.DEFAULT) {
            return TypeAdapters.LONG;
        }
        return new TypeAdapter<Number>(){

            @Override
            public Number read(JsonReader jsonReader) {
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    return null;
                }
                return jsonReader.nextLong();
            }

            @Override
            public void write(JsonWriter jsonWriter, Number number) {
                if (number == null) {
                    jsonWriter.nullValue();
                    return;
                }
                jsonWriter.value(number.toString());
            }
        };
    }

    private static TypeAdapter<AtomicLong> atomicLongAdapter(final TypeAdapter<Number> typeAdapter) {
        return new TypeAdapter<AtomicLong>(){

            @Override
            public void write(JsonWriter jsonWriter, AtomicLong atomicLong) {
                typeAdapter.write(jsonWriter, atomicLong.get());
            }

            @Override
            public AtomicLong read(JsonReader object) {
                object = (Number)typeAdapter.read((JsonReader)object);
                return new AtomicLong(((Number)object).longValue());
            }
        }.nullSafe();
    }

    private static TypeAdapter<AtomicLongArray> atomicLongArrayAdapter(final TypeAdapter<Number> typeAdapter) {
        return new TypeAdapter<AtomicLongArray>(){

            @Override
            public void write(JsonWriter jsonWriter, AtomicLongArray atomicLongArray) {
                jsonWriter.beginArray();
                int n2 = atomicLongArray.length();
                for (int i2 = 0; i2 < n2; ++i2) {
                    typeAdapter.write(jsonWriter, atomicLongArray.get(i2));
                }
                jsonWriter.endArray();
            }

            @Override
            public AtomicLongArray read(JsonReader jsonReader) {
                ArrayList<Long> arrayList = new ArrayList<Long>();
                jsonReader.beginArray();
                while (jsonReader.hasNext()) {
                    long l2 = ((Number)typeAdapter.read(jsonReader)).longValue();
                    arrayList.add(l2);
                }
                jsonReader.endArray();
                int n2 = arrayList.size();
                AtomicLongArray atomicLongArray = new AtomicLongArray(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    atomicLongArray.set(i2, (Long)arrayList.get(i2));
                }
                return atomicLongArray;
            }
        }.nullSafe();
    }

    /*
     * WARNING - void declaration
     */
    public final <T> TypeAdapter<T> getAdapter(TypeToken<T> typeToken) {
        void var4_7;
        Objects.requireNonNull(typeToken, "type must not be null");
        HashMap<TypeToken<T>, TypeAdapter<T>> hashMap = (TypeAdapter)this.typeTokenCache.get(typeToken);
        if (hashMap != null) {
            return hashMap;
        }
        hashMap = this.threadLocalAdapterResults.get();
        boolean bl2 = false;
        if (hashMap == null) {
            hashMap = new HashMap<TypeToken<T>, TypeAdapter<T>>();
            this.threadLocalAdapterResults.set(hashMap);
            bl2 = true;
        } else {
            TypeAdapter typeAdapter2 = (TypeAdapter)hashMap.get(typeToken);
            if (typeAdapter2 != null) {
                return typeAdapter2;
            }
        }
        Object var4_6 = null;
        try {
            FutureTypeAdapter<T> futureTypeAdapter = new FutureTypeAdapter<T>();
            hashMap.put(typeToken, futureTypeAdapter);
            for (TypeAdapterFactory typeAdapterFactory : this.factories) {
                TypeAdapter<T> typeAdapter = typeAdapterFactory.create(this, typeToken);
                if (typeAdapter == null) continue;
                futureTypeAdapter.setDelegate(typeAdapter);
                hashMap.put(typeToken, typeAdapter);
                break;
            }
        }
        finally {
            if (bl2) {
                this.threadLocalAdapterResults.remove();
            }
        }
        if (var4_7 == null) {
            throw new IllegalArgumentException("GSON (2.10.1) cannot handle " + typeToken);
        }
        if (bl2) {
            this.typeTokenCache.putAll(hashMap);
        }
        return var4_7;
    }

    public final <T> TypeAdapter<T> getDelegateAdapter(TypeAdapterFactory typeAdapterFactory, TypeToken<T> typeToken) {
        if (!this.factories.contains(typeAdapterFactory)) {
            typeAdapterFactory = this.jsonAdapterFactory;
        }
        boolean bl2 = false;
        for (TypeAdapterFactory typeAdapterFactory2 : this.factories) {
            if (!bl2) {
                if (typeAdapterFactory2 != typeAdapterFactory) continue;
                bl2 = true;
                continue;
            }
            TypeAdapter<T> typeAdapter = typeAdapterFactory2.create(this, typeToken);
            if (typeAdapter == null) continue;
            return typeAdapter;
        }
        throw new IllegalArgumentException("GSON cannot serialize " + typeToken);
    }

    public final <T> TypeAdapter<T> getAdapter(Class<T> clazz) {
        return this.getAdapter(TypeToken.get(clazz));
    }

    public final JsonElement toJsonTree(Object object) {
        if (object == null) {
            return JsonNull.INSTANCE;
        }
        Object object2 = object;
        return this.toJsonTree(object2, object2.getClass());
    }

    public final JsonElement toJsonTree(Object object, Type type) {
        JsonTreeWriter jsonTreeWriter = new JsonTreeWriter();
        this.toJson(object, type, jsonTreeWriter);
        return jsonTreeWriter.get();
    }

    public final String toJson(Object object) {
        if (object == null) {
            return this.toJson(JsonNull.INSTANCE);
        }
        Object object2 = object;
        return this.toJson(object2, object2.getClass());
    }

    public final String toJson(Object object, Type type) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(object, type, stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(Object object, Appendable appendable) {
        if (object != null) {
            Object object2 = object;
            this.toJson(object2, object2.getClass(), appendable);
            return;
        }
        this.toJson((JsonElement)JsonNull.INSTANCE, appendable);
    }

    public final void toJson(Object object, Type type, Appendable object2) {
        try {
            object2 = this.newJsonWriter(Streams.writerForAppendable((Appendable)object2));
            this.toJson(object, type, (JsonWriter)object2);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final void toJson(Object object, Type object2, JsonWriter jsonWriter) {
        object2 = this.getAdapter(TypeToken.get((Type)object2));
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            ((TypeAdapter)object2).write(jsonWriter, object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public final String toJson(JsonElement jsonElement) {
        StringWriter stringWriter = new StringWriter();
        this.toJson(jsonElement, (Appendable)stringWriter);
        return stringWriter.toString();
    }

    public final void toJson(JsonElement jsonElement, Appendable object) {
        try {
            object = this.newJsonWriter(Streams.writerForAppendable((Appendable)object));
            this.toJson(jsonElement, (JsonWriter)object);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final JsonWriter newJsonWriter(Writer closeable) {
        if (this.generateNonExecutableJson) {
            ((Writer)closeable).write(JSON_NON_EXECUTABLE_PREFIX);
        }
        closeable = new JsonWriter((Writer)closeable);
        if (this.prettyPrinting) {
            ((JsonWriter)closeable).setIndent("  ");
        }
        ((JsonWriter)closeable).setHtmlSafe(this.htmlSafe);
        ((JsonWriter)closeable).setLenient(this.lenient);
        ((JsonWriter)closeable).setSerializeNulls(this.serializeNulls);
        return closeable;
    }

    public final JsonReader newJsonReader(Reader closeable) {
        closeable = new JsonReader((Reader)closeable);
        ((JsonReader)closeable).setLenient(this.lenient);
        return closeable;
    }

    public final void toJson(JsonElement jsonElement, JsonWriter jsonWriter) {
        boolean bl2 = jsonWriter.isLenient();
        jsonWriter.setLenient(true);
        boolean bl3 = jsonWriter.isHtmlSafe();
        jsonWriter.setHtmlSafe(this.htmlSafe);
        boolean bl4 = jsonWriter.getSerializeNulls();
        jsonWriter.setSerializeNulls(this.serializeNulls);
        try {
            Streams.write(jsonElement, jsonWriter);
            return;
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonWriter.setLenient(bl2);
            jsonWriter.setHtmlSafe(bl3);
            jsonWriter.setSerializeNulls(bl4);
        }
    }

    public final <T> T fromJson(String string, Class<T> clazz) {
        string = this.fromJson(string, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(string);
    }

    public final <T> T fromJson(String string, Type type) {
        return (T)this.fromJson(string, TypeToken.get(type));
    }

    public final <T> T fromJson(String object, TypeToken<T> typeToken) {
        if (object == null) {
            return null;
        }
        object = new StringReader((String)object);
        return this.fromJson((Reader)object, typeToken);
    }

    public final <T> T fromJson(Reader reader, Class<T> clazz) {
        reader = this.fromJson(reader, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(reader);
    }

    public final <T> T fromJson(Reader reader, Type type) {
        return (T)this.fromJson(reader, TypeToken.get(type));
    }

    public final <T> T fromJson(Reader closeable, TypeToken<T> typeToken) {
        closeable = this.newJsonReader((Reader)closeable);
        typeToken = this.fromJson((JsonReader)closeable, typeToken);
        Gson.assertFullConsumption(typeToken, (JsonReader)closeable);
        return (T)typeToken;
    }

    private static void assertFullConsumption(Object object, JsonReader jsonReader) {
        try {
            if (object != null && jsonReader.peek() != JsonToken.END_DOCUMENT) {
                throw new JsonSyntaxException("JSON document was not fully consumed.");
            }
            return;
        }
        catch (MalformedJsonException malformedJsonException) {
            throw new JsonSyntaxException(malformedJsonException);
        }
        catch (IOException iOException) {
            throw new JsonIOException(iOException);
        }
    }

    public final <T> T fromJson(JsonReader jsonReader, Type type) {
        return (T)this.fromJson(jsonReader, TypeToken.get(type));
    }

    public final <T> T fromJson(JsonReader jsonReader, TypeToken<T> object) {
        boolean bl2 = true;
        boolean bl3 = jsonReader.isLenient();
        jsonReader.setLenient(true);
        try {
            jsonReader.peek();
            bl2 = false;
            object = this.getAdapter((TypeToken<T>)object);
            object = ((TypeAdapter)object).read(jsonReader);
            return (T)object;
        }
        catch (EOFException eOFException) {
            if (bl2) {
                T t2 = null;
                return t2;
            }
            throw new JsonSyntaxException(eOFException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new JsonSyntaxException(illegalStateException);
        }
        catch (IOException iOException) {
            throw new JsonSyntaxException(iOException);
        }
        catch (AssertionError assertionError) {
            throw new AssertionError("AssertionError (GSON 2.10.1): " + ((Throwable)((Object)assertionError)).getMessage(), (Throwable)((Object)assertionError));
        }
        finally {
            jsonReader.setLenient(bl3);
        }
    }

    public final <T> T fromJson(JsonElement jsonElement, Class<T> clazz) {
        jsonElement = this.fromJson(jsonElement, TypeToken.get(clazz));
        return Primitives.wrap(clazz).cast(jsonElement);
    }

    public final <T> T fromJson(JsonElement jsonElement, Type type) {
        return (T)this.fromJson(jsonElement, TypeToken.get(type));
    }

    public final <T> T fromJson(JsonElement jsonElement, TypeToken<T> typeToken) {
        if (jsonElement == null) {
            return null;
        }
        return this.fromJson((JsonReader)new JsonTreeReader(jsonElement), typeToken);
    }

    public final String toString() {
        return "{serializeNulls:" + this.serializeNulls + ",factories:" + this.factories + ",instanceCreators:" + this.constructorConstructor + "}";
    }

    static class FutureTypeAdapter<T>
    extends SerializationDelegatingTypeAdapter<T> {
        private TypeAdapter<T> delegate = null;

        FutureTypeAdapter() {
        }

        public void setDelegate(TypeAdapter<T> typeAdapter) {
            if (this.delegate != null) {
                throw new AssertionError((Object)"Delegate is already set");
            }
            this.delegate = typeAdapter;
        }

        private TypeAdapter<T> delegate() {
            TypeAdapter<T> typeAdapter = this.delegate;
            if (typeAdapter == null) {
                throw new IllegalStateException("Adapter for type with cyclic dependency has been used before dependency has been resolved");
            }
            return typeAdapter;
        }

        @Override
        public TypeAdapter<T> getSerializationDelegate() {
            return this.delegate();
        }

        @Override
        public T read(JsonReader jsonReader) {
            return this.delegate().read(jsonReader);
        }

        @Override
        public void write(JsonWriter jsonWriter, T t2) {
            this.delegate().write(jsonWriter, t2);
        }
    }
}

