/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import me.extremall.advancedkits.libs.gson.ExclusionStrategy;
import me.extremall.advancedkits.libs.gson.FieldAttributes;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.TypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.annotations.Expose;
import me.extremall.advancedkits.libs.gson.annotations.Since;
import me.extremall.advancedkits.libs.gson.annotations.Until;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;

public final class Excluder
implements Cloneable,
TypeAdapterFactory {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected final Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public final Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        this.clone().version = d2;
        return excluder;
    }

    public final Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        this.clone().modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public final Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        this.clone().serializeInnerClasses = false;
        return excluder;
    }

    public final Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        this.clone().requireExpose = true;
        return excluder;
    }

    public final Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl2, boolean bl3) {
        Excluder excluder = this.clone();
        if (bl2) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl3) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public final <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> typeToken) {
        boolean bl2;
        Class<T> clazz = typeToken.getRawType();
        boolean bl3 = this.excludeClassChecks(clazz);
        final boolean bl4 = bl3 || this.excludeClassInStrategy(clazz, true);
        boolean bl5 = bl2 = bl3 || this.excludeClassInStrategy(clazz, false);
        if (!bl4 && !bl2) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader jsonReader) {
                if (bl2) {
                    jsonReader.skipValue();
                    return null;
                }
                return this.delegate().read(jsonReader);
            }

            @Override
            public void write(JsonWriter jsonWriter, T t2) {
                if (bl4) {
                    jsonWriter.nullValue();
                    return;
                }
                this.delegate().write(jsonWriter, t2);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter typeAdapter = this.delegate;
                if (typeAdapter != null) {
                    return typeAdapter;
                }
                this.delegate = gson.getDelegateAdapter(Excluder.this, typeToken);
                return this.delegate;
            }
        };
    }

    public final boolean excludeField(Field object, boolean bl2) {
        Object object2;
        if ((this.modifiers & ((Field)object).getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(((Field)object).getAnnotation(Since.class), ((Field)object).getAnnotation(Until.class))) {
            return true;
        }
        if (((Field)object).isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((object2 = ((Field)object).getAnnotation(Expose.class)) == null || (bl2 ? !object2.serialize() : !object2.deserialize()))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(((Field)object).getType())) {
            return true;
        }
        if (this.isAnonymousOrNonStaticLocal(((Field)object).getType())) {
            return true;
        }
        object2 = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!object2.isEmpty()) {
            object = new FieldAttributes((Field)object);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                object2 = (ExclusionStrategy)iterator.next();
                if (!object2.shouldSkipField((FieldAttributes)object)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean excludeClassChecks(Class<?> clazz) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && this.isInnerClass(clazz)) {
            return true;
        }
        return this.isAnonymousOrNonStaticLocal(clazz);
    }

    public final boolean excludeClass(Class<?> clazz, boolean bl2) {
        return this.excludeClassChecks(clazz) || this.excludeClassInStrategy(clazz, bl2);
    }

    private boolean excludeClassInStrategy(Class<?> clazz, boolean bl2) {
        Object object = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        object = object.iterator();
        while (object.hasNext()) {
            ExclusionStrategy exclusionStrategy = (ExclusionStrategy)object.next();
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean isAnonymousOrNonStaticLocal(Class<?> clazz) {
        return !Enum.class.isAssignableFrom(clazz) && !this.isStatic(clazz) && (clazz.isAnonymousClass() || clazz.isLocalClass());
    }

    private boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !this.isStatic(clazz);
    }

    private boolean isStatic(Class<?> clazz) {
        return (clazz.getModifiers() & 8) != 0;
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        if (since != null) {
            double d2 = since.value();
            return this.version >= d2;
        }
        return true;
    }

    private boolean isValidUntil(Until until) {
        if (until != null) {
            double d2 = until.value();
            return this.version < d2;
        }
        return true;
    }
}

