/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson.internal.bind;

import java.lang.reflect.Type;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonDeserializationContext;
import me.extremall.advancedkits.libs.gson.JsonDeserializer;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.gson.JsonSerializationContext;
import me.extremall.advancedkits.libs.gson.JsonSerializer;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.TypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.internal.$Gson$Preconditions;
import me.extremall.advancedkits.libs.gson.internal.Streams;
import me.extremall.advancedkits.libs.gson.internal.bind.SerializationDelegatingTypeAdapter;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;

public final class TreeTypeAdapter<T>
extends SerializationDelegatingTypeAdapter<T> {
    private final JsonSerializer<T> serializer;
    private final JsonDeserializer<T> deserializer;
    final Gson gson;
    private final TypeToken<T> typeToken;
    private final TypeAdapterFactory skipPast;
    private final GsonContextImpl context = new GsonContextImpl();
    private final boolean nullSafe;
    private volatile TypeAdapter<T> delegate;

    public TreeTypeAdapter(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory typeAdapterFactory, boolean bl2) {
        this.serializer = jsonSerializer;
        this.deserializer = jsonDeserializer;
        this.gson = gson;
        this.typeToken = typeToken;
        this.skipPast = typeAdapterFactory;
        this.nullSafe = bl2;
    }

    public TreeTypeAdapter(JsonSerializer<T> jsonSerializer, JsonDeserializer<T> jsonDeserializer, Gson gson, TypeToken<T> typeToken, TypeAdapterFactory typeAdapterFactory) {
        this(jsonSerializer, jsonDeserializer, gson, typeToken, typeAdapterFactory, true);
    }

    @Override
    public final T read(JsonReader object) {
        if (this.deserializer == null) {
            return this.delegate().read((JsonReader)object);
        }
        object = Streams.parse((JsonReader)object);
        if (this.nullSafe && ((JsonElement)object).isJsonNull()) {
            return null;
        }
        return this.deserializer.deserialize((JsonElement)object, this.typeToken.getType(), this.context);
    }

    @Override
    public final void write(JsonWriter jsonWriter, T object) {
        if (this.serializer == null) {
            this.delegate().write(jsonWriter, object);
            return;
        }
        if (this.nullSafe && object == null) {
            jsonWriter.nullValue();
            return;
        }
        object = this.serializer.serialize(object, this.typeToken.getType(), this.context);
        Streams.write((JsonElement)object, jsonWriter);
    }

    private TypeAdapter<T> delegate() {
        TypeAdapter<T> typeAdapter = this.delegate;
        if (typeAdapter != null) {
            return typeAdapter;
        }
        this.delegate = this.gson.getDelegateAdapter(this.skipPast, this.typeToken);
        return this.delegate;
    }

    @Override
    public final TypeAdapter<T> getSerializationDelegate() {
        if (this.serializer != null) {
            return this;
        }
        return this.delegate();
    }

    public static TypeAdapterFactory newFactory(TypeToken<?> typeToken, Object object) {
        return new SingleTypeFactory(object, typeToken, false, null);
    }

    public static TypeAdapterFactory newFactoryWithMatchRawType(TypeToken<?> typeToken, Object object) {
        boolean bl2 = typeToken.getType() == typeToken.getRawType();
        return new SingleTypeFactory(object, typeToken, bl2, null);
    }

    public static TypeAdapterFactory newTypeHierarchyFactory(Class<?> clazz, Object object) {
        return new SingleTypeFactory(object, null, false, clazz);
    }

    final class GsonContextImpl
    implements JsonDeserializationContext,
    JsonSerializationContext {
        private GsonContextImpl() {
        }

        @Override
        public final JsonElement serialize(Object object) {
            return TreeTypeAdapter.this.gson.toJsonTree(object);
        }

        @Override
        public final JsonElement serialize(Object object, Type type) {
            return TreeTypeAdapter.this.gson.toJsonTree(object, type);
        }

        public final <R> R deserialize(JsonElement jsonElement, Type type) {
            return (R)TreeTypeAdapter.this.gson.fromJson(jsonElement, type);
        }
    }

    static final class SingleTypeFactory
    implements TypeAdapterFactory {
        private final TypeToken<?> exactType;
        private final boolean matchRawType;
        private final Class<?> hierarchyType;
        private final JsonSerializer<?> serializer;
        private final JsonDeserializer<?> deserializer;

        SingleTypeFactory(Object object, TypeToken<?> typeToken, boolean bl2, Class<?> clazz) {
            this.serializer = object instanceof JsonSerializer ? (JsonSerializer)object : null;
            this.deserializer = object instanceof JsonDeserializer ? (JsonDeserializer)object : null;
            $Gson$Preconditions.checkArgument(this.serializer != null || this.deserializer != null);
            this.exactType = typeToken;
            this.matchRawType = bl2;
            this.hierarchyType = clazz;
        }

        @Override
        public final <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            boolean bl2;
            boolean bl3 = this.exactType != null ? this.exactType.equals(typeToken) || this.matchRawType && this.exactType.getType() == typeToken.getRawType() : (bl2 = this.hierarchyType.isAssignableFrom(typeToken.getRawType()));
            if (bl3) {
                return new TreeTypeAdapter(this.serializer, this.deserializer, gson, typeToken, this);
            }
            return null;
        }
    }
}

