/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.gson.internal.sql;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonSyntaxException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.TypeAdapterFactory;
import me.extremall.advancedkits.libs.gson.reflect.TypeToken;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (typeToken.getRawType() == Time.class) {
                return new SqlTimeTypeAdapter();
            }
            return null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    @Override
    public final Time read(JsonReader jsonReader) {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        try {
            SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
            synchronized (sqlTimeTypeAdapter) {
                Date date = this.format.parse(string);
                return new Time(date.getTime());
            }
        }
        catch (ParseException parseException) {
            throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Time; at path " + jsonReader.getPreviousPath(), parseException);
        }
    }

    @Override
    public final void write(JsonWriter jsonWriter, Time object) {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        SqlTimeTypeAdapter sqlTimeTypeAdapter = this;
        synchronized (sqlTimeTypeAdapter) {
            object = this.format.format((Date)object);
        }
        jsonWriter.value((String)object);
    }
}

