/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.metrics.dropwizard;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import java.sql.SQLException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import me.extremall.advancedkits.libs.hikari.hikari.HikariConfig;
import me.extremall.advancedkits.libs.hikari.hikari.pool.HikariPool;

public final class CodahaleHealthChecker {
    public static void registerHealthChecks(HikariPool object, HikariConfig hikariConfig, HealthCheckRegistry healthCheckRegistry) {
        Properties properties = hikariConfig.getHealthCheckProperties();
        MetricRegistry metricRegistry = (MetricRegistry)hikariConfig.getMetricRegistry();
        long l2 = Long.parseLong(properties.getProperty("connectivityCheckTimeoutMs", String.valueOf(hikariConfig.getConnectionTimeout())));
        healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "ConnectivityCheck"}), (HealthCheck)new ConnectivityHealthCheck((HikariPool)object, l2));
        long l3 = Long.parseLong(properties.getProperty("expected99thPercentileMs", "0"));
        if (metricRegistry != null && l3 > 0L && !(object = metricRegistry.getTimers((string, metric) -> string.equals(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Wait"})))).isEmpty()) {
            object = (Timer)object.entrySet().iterator().next().getValue();
            healthCheckRegistry.register(MetricRegistry.name((String)hikariConfig.getPoolName(), (String[])new String[]{"pool", "Connection99Percent"}), (HealthCheck)new Connection99Percent((Timer)object, l3));
        }
    }

    private CodahaleHealthChecker() {
    }

    static class Connection99Percent
    extends HealthCheck {
        private final Timer waitTimer;
        private final long expected99thPercentile;

        Connection99Percent(Timer timer, long l2) {
            this.waitTimer = timer;
            this.expected99thPercentile = l2;
        }

        protected HealthCheck.Result check() {
            long l2 = TimeUnit.NANOSECONDS.toMillis(Math.round(this.waitTimer.getSnapshot().get99thPercentile()));
            if (l2 <= this.expected99thPercentile) {
                return HealthCheck.Result.healthy();
            }
            return HealthCheck.Result.unhealthy((String)"99th percentile connection wait time of %dms exceeds the threshold %dms", (Object[])new Object[]{l2, this.expected99thPercentile});
        }
    }

    static class ConnectivityHealthCheck
    extends HealthCheck {
        private final HikariPool pool;
        private final long checkTimeoutMs;

        ConnectivityHealthCheck(HikariPool hikariPool, long l2) {
            this.pool = hikariPool;
            this.checkTimeoutMs = l2 > 0L && l2 != Integer.MAX_VALUE ? l2 : TimeUnit.SECONDS.toMillis(10L);
        }

        protected HealthCheck.Result check() {
            HealthCheck.Result result;
            block8: {
                Object object = this.pool.getConnection(this.checkTimeoutMs);
                try {
                    result = HealthCheck.Result.healthy();
                    if (object == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException sQLException) {
                        object = sQLException;
                        return HealthCheck.Result.unhealthy((Throwable)sQLException);
                    }
                }
                object.close();
            }
            return result;
        }
    }
}

