/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.extremall.advancedkits.libs.hikari.hikari.HikariConfig;
import me.extremall.advancedkits.libs.hikari.hikari.SQLExceptionOverride;
import me.extremall.advancedkits.libs.hikari.hikari.metrics.IMetricsTracker;
import me.extremall.advancedkits.libs.hikari.hikari.pool.HikariPool;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolEntry;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyConnection;
import me.extremall.advancedkits.libs.hikari.hikari.util.ClockSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.DriverDataSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.PropertyElf;
import me.extremall.advancedkits.libs.hikari.hikari.util.UtilityElf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PoolBase {
    private final Logger logger = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate metricsTracker;
    protected final String poolName;
    volatile String catalog;
    final AtomicReference<Exception> lastConnectionFailure;
    long connectionTimeout;
    long validationTimeout;
    SQLExceptionOverride exceptionOverride;
    private static final String[] RESET_STATES = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int UNINITIALIZED = -1;
    private static final int TRUE = 1;
    private static final int FALSE = 0;
    private int networkTimeout;
    private int isNetworkTimeoutSupported;
    private int isQueryTimeoutSupported;
    private int defaultTransactionIsolation;
    private int transactionIsolation;
    private Executor netTimeoutExecutor;
    private DataSource dataSource;
    private final String schema;
    private final boolean isReadOnly;
    private final boolean isAutoCommit;
    private final boolean isUseJdbc4Validation;
    private final boolean isIsolateInternalQueries;
    private volatile boolean isValidChecked;

    PoolBase(HikariConfig hikariConfig) {
        this.config = hikariConfig;
        this.networkTimeout = -1;
        this.catalog = hikariConfig.getCatalog();
        this.schema = hikariConfig.getSchema();
        this.isReadOnly = hikariConfig.isReadOnly();
        this.isAutoCommit = hikariConfig.isAutoCommit();
        this.exceptionOverride = UtilityElf.createInstance(hikariConfig.getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.transactionIsolation = UtilityElf.getTransactionIsolation(hikariConfig.getTransactionIsolation());
        this.isQueryTimeoutSupported = -1;
        this.isNetworkTimeoutSupported = -1;
        this.isUseJdbc4Validation = hikariConfig.getConnectionTestQuery() == null;
        this.isIsolateInternalQueries = hikariConfig.isIsolateInternalQueries();
        this.poolName = hikariConfig.getPoolName();
        this.connectionTimeout = hikariConfig.getConnectionTimeout();
        this.validationTimeout = hikariConfig.getValidationTimeout();
        this.lastConnectionFailure = new AtomicReference();
        this.initializeDataSource();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void recycle(PoolEntry var1);

    void quietlyCloseConnection(Connection connection, String string) {
        if (connection != null) {
            try {
                this.logger.debug("{} - Closing connection {}: {}", new Object[]{this.poolName, connection, string});
                try {
                    this.setNetworkTimeout(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {
                }
                finally {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.logger.debug("{} - Closing connection {} failed", new Object[]{this.poolName, connection, exception});
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean isConnectionAlive(Connection connection) {
        try {
            try {
                this.setNetworkTimeout(connection, this.validationTimeout);
                int n2 = (int)Math.max(1000L, this.validationTimeout) / 1000;
                if (this.isUseJdbc4Validation) {
                    boolean bl2 = connection.isValid(n2);
                    return bl2;
                }
                try (Statement statement = connection.createStatement();){
                    if (this.isNetworkTimeoutSupported != 1) {
                        this.setQueryTimeout(statement, n2);
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                this.setNetworkTimeout(connection, this.networkTimeout);
                if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.lastConnectionFailure.set(exception);
            this.logger.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", new Object[]{this.poolName, connection, exception.getMessage()});
            return false;
        }
    }

    Exception getLastConnectionFailure() {
        return this.lastConnectionFailure.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.dataSource;
    }

    PoolEntry newPoolEntry() {
        PoolBase poolBase = this;
        return new PoolEntry(this.newConnection(), poolBase, poolBase.isReadOnly, this.isAutoCommit);
    }

    void resetConnectionState(Connection connection, ProxyConnection proxyConnection, int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0 && proxyConnection.getReadOnlyState() != this.isReadOnly) {
            connection.setReadOnly(this.isReadOnly);
            n3 = 1;
        }
        if ((n2 & 2) != 0 && proxyConnection.getAutoCommitState() != this.isAutoCommit) {
            connection.setAutoCommit(this.isAutoCommit);
            n3 |= 2;
        }
        if ((n2 & 4) != 0 && proxyConnection.getTransactionIsolationState() != this.transactionIsolation) {
            connection.setTransactionIsolation(this.transactionIsolation);
            n3 |= 4;
        }
        if ((n2 & 8) != 0 && this.catalog != null && !this.catalog.equals(proxyConnection.getCatalogState())) {
            connection.setCatalog(this.catalog);
            n3 |= 8;
        }
        if ((n2 & 0x10) != 0 && proxyConnection.getNetworkTimeoutState() != this.networkTimeout) {
            this.setNetworkTimeout(connection, this.networkTimeout);
            n3 |= 0x10;
        }
        if ((n2 & 0x20) != 0 && this.schema != null && !this.schema.equals(proxyConnection.getSchemaState())) {
            connection.setSchema(this.schema);
            n3 |= 0x20;
        }
        if (n3 != 0 && this.logger.isDebugEnabled()) {
            this.logger.debug("{} - Reset ({}) on connection {}", new Object[]{this.poolName, this.stringFromResetBits(n3), connection});
        }
    }

    void shutdownNetworkTimeoutExecutor() {
        if (this.netTimeoutExecutor instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.netTimeoutExecutor).shutdownNow();
        }
    }

    long getLoginTimeout() {
        try {
            if (this.dataSource != null) {
                return this.dataSource.getLoginTimeout();
            }
            return TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void handleMBeans(HikariPool hikariPool, boolean bl2) {
        block9: {
            if (!this.config.isRegisterMbeans()) {
                return;
            }
            try {
                ObjectName objectName;
                ObjectName objectName2;
                MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
                if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                    objectName2 = new ObjectName("me.extremall.advancedkits.libs.hikari.hikari:type=PoolConfig,name=" + this.poolName);
                    objectName = new ObjectName("me.extremall.advancedkits.libs.hikari.hikari:type=Pool,name=" + this.poolName);
                } else {
                    objectName2 = new ObjectName("me.extremall.advancedkits.libs.hikari.hikari:type=PoolConfig (" + this.poolName + ")");
                    objectName = new ObjectName("me.extremall.advancedkits.libs.hikari.hikari:type=Pool (" + this.poolName + ")");
                }
                if (bl2) {
                    if (!mBeanServer.isRegistered(objectName2)) {
                        mBeanServer.registerMBean(this.config, objectName2);
                        mBeanServer.registerMBean(hikariPool, objectName);
                    } else {
                        this.logger.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                    }
                    break block9;
                }
                if (mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.unregisterMBean(objectName2);
                    mBeanServer.unregisterMBean(objectName);
                }
                return;
            }
            catch (Exception exception) {
                this.logger.warn("{} - Failed to {} management beans.", new Object[]{this.poolName, bl2 ? "register" : "unregister", exception});
            }
        }
    }

    private void initializeDataSource() {
        String string = this.config.getJdbcUrl();
        Object object = this.config.getUsername();
        String string2 = this.config.getPassword();
        String string3 = this.config.getDataSourceClassName();
        String string4 = this.config.getDriverClassName();
        String string5 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string3 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string3, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string4, properties, (String)object, string2);
        } else if (string5 != null && dataSource == null) {
            try {
                object = new InitialContext();
                dataSource = (DataSource)((InitialContext)object).lookup(string5);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.setLoginTimeout(dataSource);
            this.createNetworkTimeoutExecutor(dataSource, string3, string);
        }
        this.dataSource = dataSource;
    }

    private Connection newConnection() {
        long l2 = ClockSource.currentTime();
        Connection connection = null;
        try {
            Object object = this.config.getUsername();
            String string = this.config.getPassword();
            connection = object == null ? this.dataSource.getConnection() : this.dataSource.getConnection((String)object, string);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            this.setupConnection(connection);
            this.lastConnectionFailure.set(null);
            object = connection;
            return object;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.quietlyCloseConnection(connection, "(Failed to create/setup connection)");
            } else if (this.getLastConnectionFailure() == null) {
                this.logger.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.lastConnectionFailure.set(exception);
            throw exception;
        }
        finally {
            if (this.metricsTracker != null) {
                this.metricsTracker.recordConnectionCreated(ClockSource.elapsedMillis(l2));
            }
        }
    }

    private void setupConnection(Connection connection) {
        try {
            if (this.networkTimeout == -1) {
                this.networkTimeout = this.getAndSetNetworkTimeout(connection, this.validationTimeout);
            } else {
                this.setNetworkTimeout(connection, this.validationTimeout);
            }
            if (connection.isReadOnly() != this.isReadOnly) {
                connection.setReadOnly(this.isReadOnly);
            }
            if (connection.getAutoCommit() != this.isAutoCommit) {
                connection.setAutoCommit(this.isAutoCommit);
            }
            this.checkDriverSupport(connection);
            if (this.transactionIsolation != this.defaultTransactionIsolation) {
                connection.setTransactionIsolation(this.transactionIsolation);
            }
            if (this.catalog != null) {
                connection.setCatalog(this.catalog);
            }
            if (this.schema != null) {
                connection.setSchema(this.schema);
            }
            this.executeSql(connection, this.config.getConnectionInitSql(), true);
            this.setNetworkTimeout(connection, this.networkTimeout);
            return;
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void checkDriverSupport(Connection connection) {
        if (!this.isValidChecked) {
            this.checkValidationSupport(connection);
            this.checkDefaultIsolation(connection);
            this.isValidChecked = true;
        }
    }

    private void checkValidationSupport(Connection connection) {
        try {
            if (!this.isUseJdbc4Validation) {
                this.executeSql(connection, this.config.getConnectionTestQuery(), false);
                return;
            }
            connection.isValid(1);
        }
        catch (AbstractMethodError | Exception throwable) {
            this.logger.error("{} - Failed to execute{} connection test query ({}).", new Object[]{this.poolName, this.isUseJdbc4Validation ? " isValid() for connection, configure" : "", throwable.getMessage()});
            throw throwable;
        }
    }

    private void checkDefaultIsolation(Connection connection) {
        try {
            this.defaultTransactionIsolation = connection.getTransactionIsolation();
            if (this.transactionIsolation == -1) {
                this.transactionIsolation = this.defaultTransactionIsolation;
            }
            return;
        }
        catch (SQLException sQLException) {
            this.logger.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
            if (sQLException.getSQLState() != null && !sQLException.getSQLState().startsWith("08")) {
                throw sQLException;
            }
            return;
        }
    }

    private void setQueryTimeout(Statement statement, int n2) {
        block3: {
            if (this.isQueryTimeoutSupported != 0) {
                try {
                    statement.setQueryTimeout(n2);
                    this.isQueryTimeoutSupported = 1;
                    return;
                }
                catch (Exception exception) {
                    if (this.isQueryTimeoutSupported != -1) break block3;
                    this.isQueryTimeoutSupported = 0;
                    this.logger.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int getAndSetNetworkTimeout(Connection connection, long l2) {
        block4: {
            if (this.isNetworkTimeoutSupported != 0) {
                try {
                    int n2 = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.netTimeoutExecutor, (int)l2);
                    this.isNetworkTimeoutSupported = 1;
                    return n2;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.isNetworkTimeoutSupported != -1) break block4;
                    this.isNetworkTimeoutSupported = 0;
                    this.logger.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.validationTimeout < TimeUnit.SECONDS.toMillis(1L)) {
                        this.logger.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.validationTimeout % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.logger.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void setNetworkTimeout(Connection connection, long l2) {
        if (this.isNetworkTimeoutSupported == 1) {
            connection.setNetworkTimeout(this.netTimeoutExecutor, (int)l2);
        }
    }

    private void executeSql(Connection connection, String string, boolean bl2) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.isIsolateInternalQueries && !this.isAutoCommit) {
                if (bl2) {
                    connection.commit();
                    return;
                }
                connection.rollback();
            }
        }
    }

    private void createNetworkTimeoutExecutor(DataSource object, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || object != null && object.getClass().getName().contains("Mysql")) {
            this.netTimeoutExecutor = new SynchronousExecutor();
            return;
        }
        object = this.config.getThreadFactory();
        object = object != null ? object : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
        object = (ThreadPoolExecutor)Executors.newCachedThreadPool((ThreadFactory)object);
        ((ThreadPoolExecutor)object).setKeepAliveTime(15L, TimeUnit.SECONDS);
        ((ThreadPoolExecutor)object).allowCoreThreadTimeOut(true);
        this.netTimeoutExecutor = object;
    }

    private void setLoginTimeout(DataSource dataSource) {
        if (this.connectionTimeout != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.connectionTimeout)));
                return;
            }
            catch (Exception exception) {
                this.logger.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private String stringFromResetBits(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < RESET_STATES.length; ++i2) {
            if ((n2 & 1 << i2) == 0) continue;
            stringBuilder.append(RESET_STATES[i2]).append(", ");
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2.setLength(stringBuilder2.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker tracker;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.tracker = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.tracker.recordConnectionUsageMillis(poolEntry.getMillisSinceBorrowed());
        }

        @Override
        public void recordConnectionCreated(long l2) {
            this.tracker.recordConnectionCreatedMillis(l2);
        }

        @Override
        public void recordBorrowTimeoutStats(long l2) {
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l2));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l2) {
            long l3;
            poolEntry.lastBorrowed = l3 = ClockSource.currentTime();
            this.tracker.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l2, l3));
        }

        @Override
        public void recordConnectionTimeout() {
            this.tracker.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.tracker.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long l2) {
        }

        default public void recordBorrowTimeoutStats(long l2) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long l2) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
                return;
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
                return;
            }
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long serialVersionUID = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

