/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import me.extremall.advancedkits.libs.hikari.hikari.SQLExceptionOverride;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolEntry;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyFactory;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyLeakTask;
import me.extremall.advancedkits.libs.hikari.hikari.util.ClockSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.FastList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProxyConnection
implements Connection {
    static final int DIRTY_BIT_READONLY = 1;
    static final int DIRTY_BIT_AUTOCOMMIT = 2;
    static final int DIRTY_BIT_ISOLATION = 4;
    static final int DIRTY_BIT_CATALOG = 8;
    static final int DIRTY_BIT_NETTIMEOUT = 16;
    static final int DIRTY_BIT_SCHEMA = 32;
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyConnection.class);
    private static final Set<String> ERROR_STATES = new HashSet<String>();
    private static final Set<Integer> ERROR_CODES;
    protected Connection delegate;
    private final PoolEntry poolEntry;
    private final ProxyLeakTask leakTask;
    private final FastList<Statement> openStatements;
    private int dirtyBits;
    private long lastAccess;
    private boolean isCommitStateDirty;
    private boolean isReadOnly;
    private boolean isAutoCommit;
    private int networkTimeout;
    private int transactionIsolation;
    private String dbcatalog;
    private String dbschema;

    protected ProxyConnection(PoolEntry poolEntry, Connection connection, FastList<Statement> fastList, ProxyLeakTask proxyLeakTask, long l2, boolean bl2, boolean bl3) {
        this.poolEntry = poolEntry;
        this.delegate = connection;
        this.openStatements = fastList;
        this.leakTask = proxyLeakTask;
        this.lastAccess = l2;
        this.isReadOnly = bl2;
        this.isAutoCommit = bl3;
    }

    public final String toString() {
        return this.getClass().getSimpleName() + '@' + System.identityHashCode(this) + " wrapping " + this.delegate;
    }

    final boolean getAutoCommitState() {
        return this.isAutoCommit;
    }

    final String getCatalogState() {
        return this.dbcatalog;
    }

    final String getSchemaState() {
        return this.dbschema;
    }

    final int getTransactionIsolationState() {
        return this.transactionIsolation;
    }

    final boolean getReadOnlyState() {
        return this.isReadOnly;
    }

    final int getNetworkTimeoutState() {
        return this.networkTimeout;
    }

    final PoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    final SQLException checkException(SQLException sQLException) {
        boolean bl2 = false;
        SQLException sQLException2 = sQLException;
        SQLExceptionOverride sQLExceptionOverride = this.poolEntry.getPoolBase().exceptionOverride;
        for (int n2 = 0; this.delegate != ClosedConnection.CLOSED_CONNECTION && sQLException2 != null && n2 < 10; sQLException2 = sQLException2.getNextException(), ++n2) {
            String string = sQLException2.getSQLState();
            if ((string == null || !string.startsWith("08")) && !(sQLException2 instanceof SQLTimeoutException) && !ERROR_STATES.contains(string) && !ERROR_CODES.contains(sQLException2.getErrorCode())) continue;
            if (sQLExceptionOverride != null && sQLExceptionOverride.adjudicate(sQLException2) == SQLExceptionOverride.Override.DO_NOT_EVICT) break;
            bl2 = true;
            break;
        }
        if (bl2) {
            SQLException sQLException3 = sQLException2 != null ? sQLException2 : sQLException;
            LOGGER.warn("{} - Connection {} marked as broken because of SQLSTATE({}), ErrorCode({})", new Object[]{this.poolEntry.getPoolName(), this.delegate, sQLException3.getSQLState(), sQLException3.getErrorCode(), sQLException3});
            this.leakTask.cancel();
            this.poolEntry.evict("(connection is broken)");
            this.delegate = ClosedConnection.CLOSED_CONNECTION;
        }
        return sQLException;
    }

    final synchronized void untrackStatement(Statement statement) {
        this.openStatements.remove(statement);
    }

    final void markCommitStateDirty() {
        if (this.isAutoCommit) {
            this.lastAccess = ClockSource.currentTime();
            return;
        }
        this.isCommitStateDirty = true;
    }

    void cancelLeakTask() {
        this.leakTask.cancel();
    }

    private synchronized <T extends Statement> T trackStatement(T t2) {
        this.openStatements.add(t2);
        return t2;
    }

    private synchronized void closeStatements() {
        int n2 = this.openStatements.size();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2 && this.delegate != ClosedConnection.CLOSED_CONNECTION; ++i2) {
                try {
                    Statement statement = this.openStatements.get(i2);
                    if (statement == null) continue;
                    statement.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    LOGGER.warn("{} - Connection {} marked as broken because of an exception closing open statements during Connection.close()", (Object)this.poolEntry.getPoolName(), (Object)this.delegate);
                    this.leakTask.cancel();
                    this.poolEntry.evict("(exception closing Statements during Connection.close())");
                    this.delegate = ClosedConnection.CLOSED_CONNECTION;
                }
            }
            this.openStatements.clear();
        }
    }

    @Override
    public final void close() {
        this.closeStatements();
        if (this.delegate != ClosedConnection.CLOSED_CONNECTION) {
            this.leakTask.cancel();
            try {
                if (this.isCommitStateDirty && !this.isAutoCommit) {
                    this.delegate.rollback();
                    this.lastAccess = ClockSource.currentTime();
                    LOGGER.debug("{} - Executed rollback on connection {} due to dirty commit state on close().", (Object)this.poolEntry.getPoolName(), (Object)this.delegate);
                }
                if (this.dirtyBits != 0) {
                    ProxyConnection proxyConnection = this;
                    this.poolEntry.resetConnectionState(proxyConnection, proxyConnection.dirtyBits);
                    this.lastAccess = ClockSource.currentTime();
                }
                this.delegate.clearWarnings();
                return;
            }
            catch (SQLException sQLException) {
                if (!this.poolEntry.isMarkedEvicted()) {
                    throw this.checkException(sQLException);
                }
                return;
            }
            finally {
                this.delegate = ClosedConnection.CLOSED_CONNECTION;
                this.poolEntry.recycle(this.lastAccess);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.delegate == ClosedConnection.CLOSED_CONNECTION;
    }

    @Override
    public Statement createStatement() {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.createStatement()));
    }

    @Override
    public Statement createStatement(int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.createStatement(n2, n3)));
    }

    @Override
    public Statement createStatement(int n2, int n3, int n4) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.createStatement(n2, n3, n4)));
    }

    @Override
    public CallableStatement prepareCall(String string) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareCall(string)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareCall(string, n2, n3)));
    }

    @Override
    public CallableStatement prepareCall(String string, int n2, int n3, int n4) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyCallableStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareCall(string, n2, n3, n4)));
    }

    @Override
    public PreparedStatement prepareStatement(String string) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string, n2)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string, n2, n3)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n2, int n3, int n4) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string, n2, n3, n4)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, int[] nArray) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string, nArray)));
    }

    @Override
    public PreparedStatement prepareStatement(String string, String[] stringArray) {
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyPreparedStatement(proxyConnection, proxyConnection.trackStatement(this.delegate.prepareStatement(string, stringArray)));
    }

    @Override
    public DatabaseMetaData getMetaData() {
        this.markCommitStateDirty();
        ProxyConnection proxyConnection = this;
        return ProxyFactory.getProxyDatabaseMetaData(proxyConnection, proxyConnection.delegate.getMetaData());
    }

    @Override
    public void commit() {
        this.delegate.commit();
        this.isCommitStateDirty = false;
        this.lastAccess = ClockSource.currentTime();
    }

    @Override
    public void rollback() {
        this.delegate.rollback();
        this.isCommitStateDirty = false;
        this.lastAccess = ClockSource.currentTime();
    }

    @Override
    public void rollback(Savepoint savepoint) {
        this.delegate.rollback(savepoint);
        this.isCommitStateDirty = false;
        this.lastAccess = ClockSource.currentTime();
    }

    @Override
    public void setAutoCommit(boolean bl2) {
        this.delegate.setAutoCommit(bl2);
        this.isAutoCommit = bl2;
        this.dirtyBits |= 2;
    }

    @Override
    public void setReadOnly(boolean bl2) {
        this.delegate.setReadOnly(bl2);
        this.isReadOnly = bl2;
        this.isCommitStateDirty = false;
        this.dirtyBits |= 1;
    }

    @Override
    public void setTransactionIsolation(int n2) {
        this.delegate.setTransactionIsolation(n2);
        this.transactionIsolation = n2;
        this.dirtyBits |= 4;
    }

    @Override
    public void setCatalog(String string) {
        this.delegate.setCatalog(string);
        this.dbcatalog = string;
        this.dirtyBits |= 8;
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n2) {
        this.delegate.setNetworkTimeout(executor, n2);
        this.networkTimeout = n2;
        this.dirtyBits |= 0x10;
    }

    @Override
    public void setSchema(String string) {
        this.delegate.setSchema(string);
        this.dbschema = string;
        this.dirtyBits |= 0x20;
    }

    @Override
    public final boolean isWrapperFor(Class<?> clazz) {
        return clazz.isInstance(this.delegate) || this.delegate != null && this.delegate.isWrapperFor(clazz);
    }

    @Override
    public final <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this.delegate)) {
            return (T)this.delegate;
        }
        if (this.delegate != null) {
            return this.delegate.unwrap(clazz);
        }
        throw new SQLException("Wrapped connection is not an instance of " + clazz);
    }

    static {
        ERROR_STATES.add("0A000");
        ERROR_STATES.add("57P01");
        ERROR_STATES.add("57P02");
        ERROR_STATES.add("57P03");
        ERROR_STATES.add("01002");
        ERROR_STATES.add("JZ0C0");
        ERROR_STATES.add("JZ0C1");
        ERROR_CODES = new HashSet<Integer>();
        ERROR_CODES.add(500150);
        ERROR_CODES.add(2399);
    }

    static final class ClosedConnection {
        static final Connection CLOSED_CONNECTION = ClosedConnection.getClosedConnection();

        private ClosedConnection() {
        }

        private static Connection getClosedConnection() {
            InvocationHandler invocationHandler = (object, method, objectArray) -> {
                object = method.getName();
                if ("isClosed".equals(object)) {
                    return Boolean.TRUE;
                }
                if ("isValid".equals(object)) {
                    return Boolean.FALSE;
                }
                if ("abort".equals(object)) {
                    return Void.TYPE;
                }
                if ("close".equals(object)) {
                    return Void.TYPE;
                }
                if ("toString".equals(object)) {
                    return ClosedConnection.class.getCanonicalName();
                }
                throw new SQLException("Connection is closed");
            };
            return (Connection)Proxy.newProxyInstance(Connection.class.getClassLoader(), new Class[]{Connection.class}, invocationHandler);
        }
    }
}

