/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.pool;

import java.util.concurrent.ScheduledExecutorService;
import me.extremall.advancedkits.libs.hikari.hikari.pool.PoolEntry;
import me.extremall.advancedkits.libs.hikari.hikari.pool.ProxyLeakTask;

class ProxyLeakTaskFactory {
    private ScheduledExecutorService executorService;
    private long leakDetectionThreshold;

    ProxyLeakTaskFactory(long l2, ScheduledExecutorService scheduledExecutorService) {
        this.executorService = scheduledExecutorService;
        this.leakDetectionThreshold = l2;
    }

    ProxyLeakTask schedule(PoolEntry poolEntry) {
        if (this.leakDetectionThreshold == 0L) {
            return ProxyLeakTask.NO_LEAK;
        }
        return this.scheduleNewTask(poolEntry);
    }

    void updateLeakDetectionThreshold(long l2) {
        this.leakDetectionThreshold = l2;
    }

    private ProxyLeakTask scheduleNewTask(PoolEntry object) {
        object = new ProxyLeakTask((PoolEntry)object);
        ((ProxyLeakTask)object).schedule(this.executorService, this.leakDetectionThreshold);
        return object;
    }
}

