/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.util;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import java.util.stream.Collectors;
import me.extremall.advancedkits.libs.hikari.hikari.util.ClockSource;
import me.extremall.advancedkits.libs.hikari.hikari.util.FastList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConcurrentBag<T extends IConcurrentBagEntry>
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    private final CopyOnWriteArrayList<T> sharedList;
    private final boolean weakThreadLocals;
    private final ThreadLocal<List<Object>> threadList;
    private final IBagStateListener listener;
    private final AtomicInteger waiters;
    private volatile boolean closed;
    private final SynchronousQueue<T> handoffQueue;

    public ConcurrentBag(IBagStateListener iBagStateListener) {
        this.listener = iBagStateListener;
        this.weakThreadLocals = this.useWeakThreadLocals();
        this.handoffQueue = new SynchronousQueue(true);
        this.waiters = new AtomicInteger();
        this.sharedList = new CopyOnWriteArrayList();
        if (this.weakThreadLocals) {
            this.threadList = ThreadLocal.withInitial(() -> new ArrayList(16));
            return;
        }
        this.threadList = ThreadLocal.withInitial(() -> new FastList(IConcurrentBagEntry.class, 16));
    }

    public T borrow(long l2, TimeUnit object) {
        int n2;
        List<Object> list = this.threadList.get();
        for (n2 = list.size() - 1; n2 >= 0; --n2) {
            Iterator<T> iterator = list.remove(n2);
            IConcurrentBagEntry iConcurrentBagEntry = this.weakThreadLocals ? (IConcurrentBagEntry)((WeakReference)((Object)iterator)).get() : (IConcurrentBagEntry)((Object)iterator);
            if (iConcurrentBagEntry == null || !iConcurrentBagEntry.compareAndSet(0, 1)) continue;
            return (T)iConcurrentBagEntry;
        }
        n2 = this.waiters.incrementAndGet();
        try {
            long l3;
            for (IConcurrentBagEntry iConcurrentBagEntry : this.sharedList) {
                if (!iConcurrentBagEntry.compareAndSet(0, 1)) continue;
                if (n2 > 1) {
                    this.listener.addBagItem(n2 - 1);
                }
                object = iConcurrentBagEntry;
                return (T)object;
            }
            this.listener.addBagItem(n2);
            l2 = ((TimeUnit)((Object)object)).toNanos(l2);
            do {
                l3 = ClockSource.currentTime();
                object = (IConcurrentBagEntry)this.handoffQueue.poll(l2, TimeUnit.NANOSECONDS);
                if (object != null && !object.compareAndSet(0, 1)) continue;
                Object object2 = object;
                return (T)object2;
            } while ((l2 -= ClockSource.elapsedNanos(l3)) > 10000L);
            T t2 = null;
            return t2;
        }
        finally {
            this.waiters.decrementAndGet();
        }
    }

    public void requite(T t2) {
        t2.setState(0);
        int n2 = 0;
        while (this.waiters.get() > 0) {
            if (t2.getState() != 0 || this.handoffQueue.offer(t2)) {
                return;
            }
            if ((n2 & 0xFF) == 255) {
                LockSupport.parkNanos(TimeUnit.MICROSECONDS.toNanos(10L));
            } else {
                Thread.yield();
            }
            ++n2;
        }
        List<Object> list = this.threadList.get();
        if (list.size() < 50) {
            list.add(this.weakThreadLocals ? new WeakReference<T>(t2) : t2);
        }
    }

    public void add(T t2) {
        if (this.closed) {
            LOGGER.info("ConcurrentBag has been closed, ignoring add()");
            throw new IllegalStateException("ConcurrentBag has been closed, ignoring add()");
        }
        this.sharedList.add(t2);
        while (this.waiters.get() > 0 && t2.getState() == 0 && !this.handoffQueue.offer(t2)) {
            Thread.yield();
        }
    }

    public boolean remove(T t2) {
        if (!(t2.compareAndSet(1, -1) || t2.compareAndSet(-2, -1) || this.closed)) {
            LOGGER.warn("Attempt to remove an object from the bag that was not borrowed or reserved: {}", t2);
            return false;
        }
        boolean bl2 = this.sharedList.remove(t2);
        if (!bl2 && !this.closed) {
            LOGGER.warn("Attempt to remove an object from the bag that does not exist: {}", t2);
        }
        this.threadList.get().remove(t2);
        return bl2;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public List<T> values(int n2) {
        List list = this.sharedList.stream().filter(iConcurrentBagEntry -> iConcurrentBagEntry.getState() == n2).collect(Collectors.toList());
        Collections.reverse(list);
        return list;
    }

    public List<T> values() {
        return (List)this.sharedList.clone();
    }

    public boolean reserve(T t2) {
        return t2.compareAndSet(0, -2);
    }

    public void unreserve(T t2) {
        if (t2.compareAndSet(-2, 0)) {
            while (this.waiters.get() > 0 && !this.handoffQueue.offer(t2)) {
                Thread.yield();
            }
        } else {
            LOGGER.warn("Attempt to relinquish an object to the bag that was not reserved: {}", t2);
        }
    }

    public int getWaitingThreadCount() {
        return this.waiters.get();
    }

    public int getCount(int n2) {
        int n3 = 0;
        for (IConcurrentBagEntry iConcurrentBagEntry : this.sharedList) {
            if (iConcurrentBagEntry.getState() != n2) continue;
            ++n3;
        }
        return n3;
    }

    public int[] getStateCounts() {
        int[] nArray = new int[6];
        for (IConcurrentBagEntry iConcurrentBagEntry : this.sharedList) {
            int n2 = iConcurrentBagEntry.getState();
            nArray[n2] = nArray[n2] + 1;
        }
        nArray[4] = this.sharedList.size();
        nArray[5] = this.waiters.get();
        return nArray;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        this.sharedList.forEach(iConcurrentBagEntry -> LOGGER.info(iConcurrentBagEntry.toString()));
    }

    private boolean useWeakThreadLocals() {
        try {
            if (System.getProperty("me.extremall.advancedkits.libs.hikari.hikari.useWeakReferences") != null) {
                return Boolean.getBoolean("me.extremall.advancedkits.libs.hikari.hikari.useWeakReferences");
            }
            return this.getClass().getClassLoader() != ClassLoader.getSystemClassLoader();
        }
        catch (SecurityException securityException) {
            return true;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem(int var1);
    }

    public static interface IConcurrentBagEntry {
        public static final int STATE_NOT_IN_USE = 0;
        public static final int STATE_IN_USE = 1;
        public static final int STATE_REMOVED = -1;
        public static final int STATE_RESERVED = -2;

        public boolean compareAndSet(int var1, int var2);

        public void setState(int var1);

        public int getState();
    }
}

