/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.hikari.hikari.util;

import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.extremall.advancedkits.libs.hikari.hikari.util.IsolationLevel;

public final class UtilityElf {
    private UtilityElf() {
    }

    public static String getNullIfEmpty(String string) {
        if (string == null) {
            return null;
        }
        if (string.trim().isEmpty()) {
            return null;
        }
        return string.trim();
    }

    public static void quietlySleep(long l2) {
        try {
            Thread.sleep(l2);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public static boolean safeIsAssignableFrom(Object object, String object2) {
        try {
            object2 = Class.forName((String)object2);
            return ((Class)object2).isAssignableFrom(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static <T> T createInstance(String object, Class<T> clazz, Object ... objectArray) {
        if (object == null) {
            return null;
        }
        try {
            object = UtilityElf.class.getClassLoader().loadClass((String)object);
            if (objectArray.length == 0) {
                return clazz.cast(((Class)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            Class[] classArray = new Class[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                classArray[i2] = objectArray[i2].getClass();
            }
            Constructor constructor = ((Class)object).getConstructor(classArray);
            return clazz.cast(constructor.newInstance(objectArray));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(int n2, String string, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(string, true);
        }
        Object object = new LinkedBlockingQueue<Runnable>(n2);
        object = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)object, threadFactory, rejectedExecutionHandler);
        ((ThreadPoolExecutor)object).allowCoreThreadTimeOut(true);
        return object;
    }

    public static ThreadPoolExecutor createThreadPoolExecutor(BlockingQueue<Runnable> object, String string, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        if (threadFactory == null) {
            threadFactory = new DefaultThreadFactory(string, true);
        }
        object = new ThreadPoolExecutor(1, 1, 5L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)object, threadFactory, rejectedExecutionHandler);
        ((ThreadPoolExecutor)object).allowCoreThreadTimeOut(true);
        return object;
    }

    public static int getTransactionIsolation(String string) {
        if (string != null) {
            try {
                String string2 = string.toUpperCase(Locale.ENGLISH);
                return IsolationLevel.valueOf(string2).getLevelId();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    int n2 = Integer.parseInt(string);
                    for (IsolationLevel isolationLevel : IsolationLevel.values()) {
                        if (isolationLevel.getLevelId() != n2) continue;
                        return isolationLevel.getLevelId();
                    }
                    throw new IllegalArgumentException("Invalid transaction isolation value: " + string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid transaction isolation value: " + string, numberFormatException);
                }
            }
        }
        return -1;
    }

    public static final class DefaultThreadFactory
    implements ThreadFactory {
        private final String threadName;
        private final boolean daemon;

        public DefaultThreadFactory(String string, boolean bl2) {
            this.threadName = string;
            this.daemon = bl2;
        }

        @Override
        public final Thread newThread(Runnable runnable) {
            runnable = new Thread(runnable, this.threadName);
            ((Thread)runnable).setDaemon(this.daemon);
            return runnable;
        }
    }
}

