/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar;
import me.extremall.advancedkits.libs.kyori.adventure.identity.Identity;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.permission.PermissionChecker;
import me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.Facet;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetBase;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetPointers;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.Knob;
import me.extremall.advancedkits.libs.kyori.adventure.pointer.Pointers;
import me.extremall.advancedkits.libs.kyori.adventure.sound.Sound;
import me.extremall.advancedkits.libs.kyori.adventure.sound.SoundStop;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.util.TriState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BukkitFacet<V extends CommandSender>
extends FacetBase<V> {
    protected BukkitFacet(@Nullable Class<? extends V> clazz) {
        super(clazz);
    }

    static final class PlayerPointers
    extends BukkitFacet<Player>
    implements Facet.Pointers<Player> {
        PlayerPointers() {
            super(Player.class);
        }

        @Override
        public final void contributePointers(Player player, Pointers.Builder builder) {
            builder.withDynamic(Identity.UUID, () -> ((Player)player).getUniqueId());
            builder.withDynamic(Identity.DISPLAY_NAME, () -> BukkitComponentSerializer.legacy().deserializeOrNull(player.getDisplayName()));
            builder.withStatic(FacetPointers.TYPE, FacetPointers.Type.PLAYER);
            builder.withDynamic(FacetPointers.WORLD, () -> Key.key(player.getWorld().getName()));
        }
    }

    static final class ConsoleCommandSenderPointers
    extends BukkitFacet<ConsoleCommandSender>
    implements Facet.Pointers<ConsoleCommandSender> {
        ConsoleCommandSenderPointers() {
            super(ConsoleCommandSender.class);
        }

        @Override
        public final void contributePointers(ConsoleCommandSender consoleCommandSender, Pointers.Builder builder) {
            builder.withStatic(FacetPointers.TYPE, FacetPointers.Type.CONSOLE);
        }
    }

    static final class CommandSenderPointers
    extends BukkitFacet<CommandSender>
    implements Facet.Pointers<CommandSender> {
        CommandSenderPointers() {
            super(CommandSender.class);
        }

        @Override
        public final void contributePointers(CommandSender commandSender, Pointers.Builder builder) {
            builder.withDynamic(Identity.NAME, () -> ((CommandSender)commandSender).getName());
            builder.withStatic(PermissionChecker.POINTER, string -> {
                if (commandSender.isPermissionSet(string)) {
                    if (commandSender.hasPermission(string)) {
                        return TriState.TRUE;
                    }
                    return TriState.FALSE;
                }
                return TriState.NOT_SET;
            });
        }
    }

    static final class TabList
    extends Message<Player>
    implements Facet.TabList<Player, String> {
        private static final boolean SUPPORTED = MinecraftReflection.hasMethod(Player.class, "setPlayerListHeader", String.class);

        TabList() {
            super(Player.class);
        }

        @Override
        public final boolean isSupported() {
            return SUPPORTED && super.isSupported();
        }

        @Override
        public final void send(Player player, @Nullable String string, @Nullable String string2) {
            if (string != null && string2 != null) {
                player.setPlayerListHeaderFooter(string, string2);
                return;
            }
            if (string != null) {
                player.setPlayerListHeader(string);
                return;
            }
            if (string2 != null) {
                player.setPlayerListFooter(string2);
            }
        }
    }

    static final class ViaHook
    implements Function<Player, UserConnection> {
        ViaHook() {
        }

        @Override
        public final UserConnection apply(@NotNull Player player) {
            return Via.getManager().getConnectionManager().getConnectedClient(player.getUniqueId());
        }
    }

    static class BossBar
    extends Message<Player>
    implements Facet.BossBar<Player> {
        protected final org.bukkit.boss.BossBar bar = Bukkit.createBossBar((String)"", (BarColor)BarColor.PINK, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]);

        protected BossBar(@NotNull Collection<Player> object) {
            super(Player.class);
            this.bar.setVisible(false);
            object = object.iterator();
            while (object.hasNext()) {
                Player player = (Player)object.next();
                this.bar.addPlayer(player);
            }
        }

        @Override
        public void bossBarInitialized(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar) {
            Facet.BossBar.super.bossBarInitialized(bossBar);
            this.bar.setVisible(true);
        }

        @Override
        public void bossBarNameChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull Component component, @NotNull Component component2) {
            if (!this.bar.getPlayers().isEmpty()) {
                BossBar bossBar2 = this;
                this.bar.setTitle(bossBar2.createMessage((Player)bossBar2.bar.getPlayers().get(0), component2));
            }
        }

        @Override
        public void bossBarProgressChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, float f2, float f3) {
            this.bar.setProgress((double)f3);
        }

        @Override
        public void bossBarColorChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull BossBar.Color color, @NotNull BossBar.Color color2) {
            bossBar = this.color(color2);
            if (bossBar != null) {
                this.bar.setColor((BarColor)bossBar);
            }
        }

        @Nullable
        private BarColor color(@NotNull BossBar.Color color) {
            if (color == BossBar.Color.PINK) {
                return BarColor.PINK;
            }
            if (color == BossBar.Color.BLUE) {
                return BarColor.BLUE;
            }
            if (color == BossBar.Color.RED) {
                return BarColor.RED;
            }
            if (color == BossBar.Color.GREEN) {
                return BarColor.GREEN;
            }
            if (color == BossBar.Color.YELLOW) {
                return BarColor.YELLOW;
            }
            if (color == BossBar.Color.PURPLE) {
                return BarColor.PURPLE;
            }
            if (color == BossBar.Color.WHITE) {
                return BarColor.WHITE;
            }
            Knob.logUnsupported(this, (Object)color);
            return null;
        }

        @Override
        public void bossBarOverlayChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull BossBar.Overlay overlay, @NotNull BossBar.Overlay overlay2) {
            bossBar = this.style(overlay2);
            if (bossBar != null) {
                this.bar.setStyle((BarStyle)bossBar);
            }
        }

        @Nullable
        private BarStyle style(@NotNull BossBar.Overlay overlay) {
            if (overlay == BossBar.Overlay.PROGRESS) {
                return BarStyle.SOLID;
            }
            if (overlay == BossBar.Overlay.NOTCHED_6) {
                return BarStyle.SEGMENTED_6;
            }
            if (overlay == BossBar.Overlay.NOTCHED_10) {
                return BarStyle.SEGMENTED_10;
            }
            if (overlay == BossBar.Overlay.NOTCHED_12) {
                return BarStyle.SEGMENTED_12;
            }
            if (overlay == BossBar.Overlay.NOTCHED_20) {
                return BarStyle.SEGMENTED_20;
            }
            Knob.logUnsupported(this, (Object)overlay);
            return null;
        }

        @Override
        public void bossBarFlagsChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar iterator, @NotNull Set<BossBar.Flag> set, @NotNull Set<BossBar.Flag> object2) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                BossBar.Flag flag = iterator.next();
                BarFlag barFlag = this.flag(flag);
                if (barFlag == null) continue;
                this.bar.removeFlag(barFlag);
            }
            for (BossBar.Flag flag : set) {
                BarFlag barFlag = this.flag(flag);
                if (barFlag == null) continue;
                this.bar.addFlag(barFlag);
            }
        }

        @Nullable
        private BarFlag flag(@NotNull BossBar.Flag flag) {
            if (flag == BossBar.Flag.DARKEN_SCREEN) {
                return BarFlag.DARKEN_SKY;
            }
            if (flag == BossBar.Flag.PLAY_BOSS_MUSIC) {
                return BarFlag.PLAY_BOSS_MUSIC;
            }
            if (flag == BossBar.Flag.CREATE_WORLD_FOG) {
                return BarFlag.CREATE_FOG;
            }
            Knob.logUnsupported(this, (Object)flag);
            return null;
        }

        @Override
        public void addViewer(@NotNull Player player) {
            this.bar.addPlayer(player);
        }

        @Override
        public void removeViewer(@NotNull Player player) {
            this.bar.removePlayer(player);
        }

        @Override
        public boolean isEmpty() {
            return !this.bar.isVisible() || this.bar.getPlayers().isEmpty();
        }

        @Override
        public void close() {
            this.bar.removeAll();
        }
    }

    static class BossBarBuilder
    extends BukkitFacet<Player>
    implements Facet.BossBar.Builder<Player, BossBar> {
        private static final boolean SUPPORTED = MinecraftReflection.hasClass("org.bukkit.boss.BossBar");

        protected BossBarBuilder() {
            super(Player.class);
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public @NotNull BossBar createBossBar(@NotNull Collection<Player> collection) {
            return new BossBar(collection);
        }
    }

    static class SoundWithCategory
    extends Sound {
        private static final boolean SUPPORTED = MinecraftReflection.hasMethod(Player.class, "stopSound", String.class, MinecraftReflection.findClass("org.bukkit.SoundCategory"));

        SoundWithCategory() {
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && SUPPORTED;
        }

        @Override
        public void playSound(@NotNull Player player, @NotNull me.extremall.advancedkits.libs.kyori.adventure.sound.Sound sound, @NotNull Vector vector) {
            SoundCategory soundCategory = this.category(sound.source());
            if (soundCategory == null) {
                super.playSound(player, sound, vector);
                return;
            }
            String string = SoundWithCategory.name(sound.name());
            player.playSound(vector.toLocation(player.getWorld()), string, soundCategory, sound.volume(), sound.pitch());
        }

        @Override
        public void stopSound(@NotNull Player player, @NotNull SoundStop object) {
            SoundCategory soundCategory = this.category(object.source());
            if (soundCategory == null) {
                super.stopSound(player, (SoundStop)object);
                return;
            }
            object = SoundWithCategory.name(object.sound());
            player.stopSound((String)object, soundCategory);
        }

        @Nullable
        private SoundCategory category( @Nullable Sound.Source source) {
            if (source == null) {
                return null;
            }
            if (source == Sound.Source.MASTER) {
                return SoundCategory.MASTER;
            }
            if (source == Sound.Source.MUSIC) {
                return SoundCategory.MUSIC;
            }
            if (source == Sound.Source.RECORD) {
                return SoundCategory.RECORDS;
            }
            if (source == Sound.Source.WEATHER) {
                return SoundCategory.WEATHER;
            }
            if (source == Sound.Source.BLOCK) {
                return SoundCategory.BLOCKS;
            }
            if (source == Sound.Source.HOSTILE) {
                return SoundCategory.HOSTILE;
            }
            if (source == Sound.Source.NEUTRAL) {
                return SoundCategory.NEUTRAL;
            }
            if (source == Sound.Source.PLAYER) {
                return SoundCategory.PLAYERS;
            }
            if (source == Sound.Source.AMBIENT) {
                return SoundCategory.AMBIENT;
            }
            if (source == Sound.Source.VOICE) {
                return SoundCategory.VOICE;
            }
            Knob.logUnsupported(this, (Object)source);
            return null;
        }
    }

    static class Sound
    extends Position
    implements Facet.Sound<Player, Vector> {
        private static final boolean KEY_SUPPORTED = MinecraftReflection.hasClass("org.bukkit.NamespacedKey");
        private static final boolean STOP_SUPPORTED = MinecraftReflection.hasMethod(Player.class, "stopSound", String.class);
        private static final MethodHandle STOP_ALL_SUPPORTED = MinecraftReflection.findMethod(Player.class, "stopAllSounds", Void.TYPE, new Class[0]);

        Sound() {
        }

        @Override
        public void playSound(@NotNull Player player, @NotNull me.extremall.advancedkits.libs.kyori.adventure.sound.Sound sound, @NotNull Vector vector) {
            String string = Sound.name(sound.name());
            vector = vector.toLocation(player.getWorld());
            player.playSound((Location)vector, string, sound.volume(), sound.pitch());
        }

        @Override
        public void stopSound(@NotNull Player player, @NotNull SoundStop object) {
            if (STOP_SUPPORTED) {
                if (((String)(object = Sound.name(object.sound()))).isEmpty() && STOP_ALL_SUPPORTED != null) {
                    try {
                        STOP_ALL_SUPPORTED.invoke(player);
                        return;
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        Knob.logError(throwable, "Could not invoke stopAllSounds on %s", player);
                        return;
                    }
                }
                player.stopSound((String)object);
            }
        }

        @NotNull
        protected static String name(@Nullable Key key) {
            if (key == null) {
                return "";
            }
            if (KEY_SUPPORTED) {
                return key.asString();
            }
            return key.value();
        }
    }

    static class Position
    extends BukkitFacet<Player>
    implements Facet.Position<Player, Vector> {
        protected Position() {
            super(Player.class);
        }

        @Override
        @NotNull
        public Vector createPosition(@NotNull Player player) {
            return player.getLocation().toVector();
        }

        @Override
        @NotNull
        public Vector createPosition(double d2, double d3, double d4) {
            return new Vector(d2, d3, d4);
        }
    }

    static class Chat
    extends Message<CommandSender>
    implements Facet.Chat<CommandSender, String> {
        protected Chat() {
            super(CommandSender.class);
        }

        @Override
        public void sendMessage(@NotNull CommandSender commandSender, @NotNull Identity identity, @NotNull String string, @NotNull Object object) {
            commandSender.sendMessage(string);
        }
    }

    static class Message<V extends CommandSender>
    extends BukkitFacet<V>
    implements Facet.Message<V, String> {
        protected Message(@Nullable Class<? extends V> clazz) {
            super(clazz);
        }

        @Override
        @NotNull
        public String createMessage(@NotNull V v2, @NotNull Component component) {
            return BukkitComponentSerializer.legacy().serialize(component);
        }
    }
}

