/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicReference;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.platform.bukkit.MinecraftReflection;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.ComponentSerializer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public final class MinecraftComponentSerializer
implements ComponentSerializer<Component, Component, Object> {
    private static final MinecraftComponentSerializer INSTANCE = new MinecraftComponentSerializer();
    @Nullable
    private static final Class<?> CLASS_JSON_DESERIALIZER = MinecraftReflection.findClass("com.google.gson.JsonDeserializer");
    @Nullable
    private static final Class<?> CLASS_CHAT_COMPONENT = MinecraftReflection.findClass(MinecraftReflection.findNmsClassName("IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.IChatBaseComponent"), MinecraftReflection.findMcClassName("network.chat.Component"));
    private static final AtomicReference<RuntimeException> INITIALIZATION_ERROR = new AtomicReference<UnsupportedOperationException>(new UnsupportedOperationException());
    private static final Object MC_TEXT_GSON;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE;
    private static final MethodHandle TEXT_SERIALIZER_DESERIALIZE_TREE;
    private static final MethodHandle TEXT_SERIALIZER_SERIALIZE_TREE;
    private static final boolean SUPPORTED;

    public static boolean isSupported() {
        return SUPPORTED;
    }

    @NotNull
    public static MinecraftComponentSerializer get() {
        return INSTANCE;
    }

    @Override
    @NotNull
    public final Component deserialize(@NotNull Object object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        try {
            if (TEXT_SERIALIZER_SERIALIZE_TREE != null) {
                object = TEXT_SERIALIZER_SERIALIZE_TREE.invoke(object);
            } else if (MC_TEXT_GSON != null) {
                object = ((Gson)MC_TEXT_GSON).toJsonTree(object);
            } else {
                return BukkitComponentSerializer.gson().deserialize(TEXT_SERIALIZER_SERIALIZE.invoke(object));
            }
            return BukkitComponentSerializer.gson().serializer().fromJson((JsonElement)object, Component.class);
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    @Override
    @NotNull
    public final Object serialize(@NotNull Component object) {
        if (!SUPPORTED) {
            throw INITIALIZATION_ERROR.get();
        }
        if (TEXT_SERIALIZER_DESERIALIZE_TREE != null || MC_TEXT_GSON != null) {
            object = BukkitComponentSerializer.gson().serializer().toJsonTree(object);
            try {
                if (TEXT_SERIALIZER_DESERIALIZE_TREE != null) {
                    return TEXT_SERIALIZER_DESERIALIZE_TREE.invoke((JsonElement)object);
                }
                return ((Gson)MC_TEXT_GSON).fromJson((JsonElement)object, CLASS_CHAT_COMPONENT);
            }
            catch (Throwable throwable) {
                throw new UnsupportedOperationException(throwable);
            }
        }
        try {
            return TEXT_SERIALIZER_DESERIALIZE.invoke((String)BukkitComponentSerializer.gson().serialize(object));
        }
        catch (Throwable throwable) {
            throw new UnsupportedOperationException(throwable);
        }
    }

    static {
        Object object = null;
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        MethodHandle methodHandle4 = null;
        try {
            if (CLASS_CHAT_COMPONENT != null) {
                Field object22;
                Class<?> clazz = Arrays.stream(CLASS_CHAT_COMPONENT.getClasses()).filter(classArray -> {
                    if (CLASS_JSON_DESERIALIZER != null) {
                        return CLASS_JSON_DESERIALIZER.isAssignableFrom((Class<?>)classArray);
                    }
                    for (Class<?> clazz : classArray.getInterfaces()) {
                        if (!clazz.getSimpleName().equals("JsonDeserializer")) continue;
                        return true;
                    }
                    return false;
                }).findAny().orElse(MinecraftReflection.findNmsClass("ChatSerializer"));
                if (clazz != null && (object22 = (Field)Arrays.stream(clazz.getDeclaredFields()).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> field.getType().equals(Gson.class)).findFirst().orElse(null)) != null) {
                    object22.setAccessible(true);
                    object = object22.get(null);
                }
                ArrayList arrayList = new ArrayList();
                if (clazz != null) {
                    arrayList.add(clazz);
                }
                arrayList.addAll(Arrays.asList(CLASS_CHAT_COMPONENT.getClasses()));
                for (Class clazz2 : arrayList) {
                    Method[] methodArray = clazz2.getDeclaredMethods();
                    Method method2 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(String.class)).min(Comparator.comparing(Method::getName)).orElse(null);
                    Method method3 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(String.class)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    Method method4 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> CLASS_CHAT_COMPONENT.isAssignableFrom(method.getReturnType())).filter(method -> method.getParameterCount() == 1 && method.getParameterTypes()[0].equals(JsonElement.class)).findFirst().orElse(null);
                    Method method5 = Arrays.stream(methodArray).filter(method -> Modifier.isStatic(method.getModifiers())).filter(method -> method.getReturnType().equals(JsonElement.class)).filter(method -> method.getParameterCount() == 1 && CLASS_CHAT_COMPONENT.isAssignableFrom(method.getParameterTypes()[0])).findFirst().orElse(null);
                    if (method2 != null) {
                        methodHandle = MinecraftReflection.lookup().unreflect(method2);
                    }
                    if (method3 != null) {
                        methodHandle2 = MinecraftReflection.lookup().unreflect(method3);
                    }
                    if (method4 != null) {
                        methodHandle3 = MinecraftReflection.lookup().unreflect(method4);
                    }
                    if (method5 == null) continue;
                    methodHandle4 = MinecraftReflection.lookup().unreflect(method5);
                }
            }
        }
        catch (Throwable throwable) {
            INITIALIZATION_ERROR.set(new UnsupportedOperationException("Error occurred during initialization", throwable));
        }
        MC_TEXT_GSON = object;
        TEXT_SERIALIZER_DESERIALIZE = methodHandle;
        TEXT_SERIALIZER_SERIALIZE = methodHandle2;
        TEXT_SERIALIZER_DESERIALIZE_TREE = methodHandle3;
        TEXT_SERIALIZER_SERIALIZE_TREE = methodHandle4;
        SUPPORTED = MC_TEXT_GSON != null || TEXT_SERIALIZER_DESERIALIZE != null && TEXT_SERIALIZER_SERIALIZE != null || TEXT_SERIALIZER_DESERIALIZE_TREE != null && TEXT_SERIALIZER_SERIALIZE_TREE != null;
    }
}

