/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.platform.facet;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import me.extremall.advancedkits.libs.kyori.adventure.audience.Audience;
import me.extremall.advancedkits.libs.kyori.adventure.audience.MessageType;
import me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar;
import me.extremall.advancedkits.libs.kyori.adventure.chat.ChatType;
import me.extremall.advancedkits.libs.kyori.adventure.chat.SignedMessage;
import me.extremall.advancedkits.libs.kyori.adventure.identity.Identity;
import me.extremall.advancedkits.libs.kyori.adventure.inventory.Book;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.Facet;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetAudienceProvider;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetBossBarListener;
import me.extremall.advancedkits.libs.kyori.adventure.pointer.Pointers;
import me.extremall.advancedkits.libs.kyori.adventure.sound.Sound;
import me.extremall.advancedkits.libs.kyori.adventure.sound.SoundStop;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.flattener.ComponentFlattener;
import me.extremall.advancedkits.libs.kyori.adventure.title.Title;
import me.extremall.advancedkits.libs.kyori.adventure.title.TitlePart;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FacetAudience<V>
implements Closeable,
Audience {
    @NotNull
    protected final FacetAudienceProvider<V, FacetAudience<V>> provider;
    @NotNull
    private final Set<V> viewers;
    @Nullable
    private V viewer;
    private volatile Pointers pointers;
    private final @Nullable Facet.Chat<V, Object> chat;
    private final @Nullable Facet.ActionBar<V, Object> actionBar;
    private final @Nullable Facet.Title<V, Object, Object, Object> title;
    private final @Nullable Facet.Sound<V, Object> sound;
    private final @Nullable Facet.EntitySound<V, Object> entitySound;
    private final @Nullable Facet.Book<V, Object, Object> book;
    private final @Nullable Facet.BossBar.Builder<V, Facet.BossBar<V>> bossBar;
    @Nullable
    private final Map<BossBar, Facet.BossBar<V>> bossBars;
    private final @Nullable Facet.TabList<V, Object> tabList;
    @NotNull
    private final Collection<? extends Facet.Pointers<V>> pointerProviders;

    public FacetAudience(@NotNull FacetAudienceProvider object, @NotNull Collection<? extends V> collection112, @Nullable Collection<? extends Facet.Chat> collection2, @Nullable Collection<? extends Facet.ActionBar> collection3, @Nullable Collection<? extends Facet.Title> collection4, @Nullable Collection<? extends Facet.Sound> collection5, @Nullable Collection<? extends Facet.EntitySound> collection6, @Nullable Collection<? extends Facet.Book> collection7, @Nullable Collection<? extends Facet.BossBar.Builder> collection8, @Nullable Collection<? extends Facet.TabList> collection9, @Nullable Collection<? extends Facet.Pointers> collection10) {
        this.provider = (FacetAudienceProvider)Objects.requireNonNull(object, "audience provider");
        this.viewers = new CopyOnWriteArraySet<V>();
        for (Collection<Object> collection112 : Objects.requireNonNull(collection112, "viewers")) {
            this.addViewer(collection112);
        }
        this.refresh();
        this.chat = Facet.of(collection2, this.viewer);
        this.actionBar = Facet.of(collection3, this.viewer);
        this.title = Facet.of(collection4, this.viewer);
        this.sound = Facet.of(collection5, this.viewer);
        this.entitySound = Facet.of(collection6, this.viewer);
        this.book = Facet.of(collection7, this.viewer);
        this.bossBar = Facet.of(collection8, this.viewer);
        this.bossBars = this.bossBar == null ? null : Collections.synchronizedMap(new IdentityHashMap(4));
        this.tabList = Facet.of(collection9, this.viewer);
        this.pointerProviders = collection10 == null ? Collections.emptyList() : collection10;
    }

    public void addViewer(@NotNull V v2) {
        if (this.viewers.add(v2) && this.viewer == null) {
            this.viewer = v2;
            this.refresh();
        }
    }

    public void removeViewer(@NotNull V v2) {
        if (this.viewers.remove(v2) && this.viewer == v2) {
            this.viewer = this.viewers.isEmpty() ? null : this.viewers.iterator().next();
            this.refresh();
        }
        if (this.bossBars == null) {
            return;
        }
        for (Facet.BossBar<V> bossBar : this.bossBars.values()) {
            bossBar.removeViewer(v2);
        }
    }

    public void refresh() {
        FacetAudience facetAudience = this;
        synchronized (facetAudience) {
            this.pointers = null;
        }
        if (this.bossBars == null) {
            return;
        }
        for (Map.Entry entry : this.bossBars.entrySet()) {
            BossBar bossBar = (BossBar)entry.getKey();
            Facet.BossBar object = (Facet.BossBar)entry.getValue();
            BossBar bossBar2 = bossBar;
            object.bossBarNameChanged(bossBar2, bossBar2.name(), bossBar.name());
        }
    }

    @Override
    public void sendMessage(@NotNull Identity identity, @NotNull Component object, @NotNull MessageType messageType) {
        if (this.chat == null) {
            return;
        }
        if ((object = this.createMessage((Component)object, this.chat)) == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.chat.sendMessage(v2, identity, object, (Object)messageType);
        }
    }

    @Override
    public void sendMessage(@NotNull Component object, @NotNull ChatType.Bound bound) {
        if (this.chat == null) {
            return;
        }
        if ((object = this.createMessage((Component)object, this.chat)) == null) {
            return;
        }
        Component component = this.provider.componentRenderer.render(bound.name(), this);
        Component component22 = null;
        if (bound.target() != null) {
            component22 = this.provider.componentRenderer.render(bound.target(), this);
        }
        bound = bound.type().bind(component, component22);
        for (Component component22 : this.viewers) {
            this.chat.sendMessage(component22, Identity.nil(), object, bound);
        }
    }

    @Override
    public void sendMessage(@NotNull SignedMessage examinable, @NotNull ChatType.Bound bound) {
        if (examinable.isSystem()) {
            examinable = examinable.unsignedContent() != null ? examinable.unsignedContent() : Component.text(examinable.message());
            this.sendMessage((Component)examinable, bound);
            return;
        }
        Audience.super.sendMessage((SignedMessage)examinable, bound);
    }

    @Override
    public void sendActionBar(@NotNull Component object) {
        if (this.actionBar == null) {
            return;
        }
        if ((object = this.createMessage((Component)object, this.actionBar)) == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.actionBar.sendMessage(v2, object);
        }
    }

    @Override
    public void playSound(@NotNull Sound sound) {
        if (this.sound == null) {
            return;
        }
        for (V v2 : this.viewers) {
            Object p2 = this.sound.createPosition(v2);
            if (p2 == null) continue;
            this.sound.playSound(v2, sound, p2);
        }
    }

    @Override
    public void playSound(@NotNull Sound sound, @NotNull Sound.Emitter object) {
        if (this.entitySound == null) {
            return;
        }
        if (object == Sound.Emitter.self()) {
            for (Object e2 : this.viewers) {
                Object object2 = this.entitySound.createForSelf(e2, sound);
                if (object2 == null) continue;
                this.entitySound.playSound(e2, object2);
            }
            return;
        }
        if ((object = this.entitySound.createForEmitter(sound, (Sound.Emitter)object)) == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.entitySound.playSound(v2, object);
        }
    }

    @Override
    public void playSound(@NotNull Sound sound, double d2, double d3, double d4) {
        if (this.sound == null) {
            return;
        }
        Object p2 = this.sound.createPosition(d2, d3, d4);
        for (V v2 : this.viewers) {
            this.sound.playSound(v2, sound, p2);
        }
    }

    @Override
    public void stopSound(@NotNull SoundStop soundStop) {
        if (this.sound == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.sound.stopSound(v2, soundStop);
        }
    }

    @Override
    public void openBook(@NotNull Book object) {
        if (this.book == null) {
            return;
        }
        String string = this.toPlain(object.title());
        String string2 = this.toPlain(object.author());
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Component object2 : object.pages()) {
            Object object3 = this.createMessage(object2, this.book);
            if (object3 == null) continue;
            linkedList.add(object3);
        }
        if (string == null || string2 == null || linkedList.isEmpty()) {
            return;
        }
        object = this.book.createBook(string, string2, linkedList);
        if (object == null) {
            return;
        }
        for (Object object3 : this.viewers) {
            this.book.openBook(object3, object);
        }
    }

    private String toPlain(Component component) {
        if (component == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ComponentFlattener.basic().flatten(this.provider.componentRenderer.render(component, this), stringBuilder::append);
        return stringBuilder.toString();
    }

    @Override
    public void showTitle(@NotNull Title examinable) {
        if (this.title == null) {
            return;
        }
        Iterator<V> iterator = this.createMessage(examinable.title(), this.title);
        Object object4 = this.createMessage(examinable.subtitle(), this.title);
        int n2 = (examinable = examinable.times()) == null ? -1 : this.title.toTicks(examinable.fadeIn());
        int n3 = examinable == null ? -1 : this.title.toTicks(examinable.stay());
        @Nullable int n4 = examinable == null ? -1 : this.title.toTicks(examinable.fadeOut());
        Object object2 = this.title.createTitleCollection();
        if (n2 != -1 || n3 != -1 || n4 != -1) {
            this.title.contributeTimes(object2, n2, n3, n4);
        }
        this.title.contributeSubtitle(object2, object4);
        this.title.contributeTitle(object2, iterator);
        @Nullable Object object3 = this.title.completeTitle(object2);
        if (object3 == null) {
            return;
        }
        for (Object object4 : this.viewers) {
            this.title.showTitle(object4, object3);
        }
    }

    @Override
    public <T> void sendTitlePart(@NotNull TitlePart<T> object, @NotNull T object2) {
        if (this.title == null) {
            return;
        }
        Objects.requireNonNull(object2, "value");
        Object object3 = this.title.createTitleCollection();
        if (object == TitlePart.TITLE) {
            object = this.createMessage((Component)object2, this.title);
            if (object != null) {
                this.title.contributeTitle(object3, object);
            }
        } else if (object == TitlePart.SUBTITLE) {
            object = this.createMessage((Component)object2, this.title);
            if (object != null) {
                this.title.contributeSubtitle(object3, object);
            }
        } else if (object == TitlePart.TIMES) {
            object = (Title.Times)object2;
            int n2 = this.title.toTicks(object.fadeIn());
            int n3 = this.title.toTicks(object.stay());
            int n4 = this.title.toTicks(object.fadeOut());
            if (n2 != -1 || n3 != -1 || n4 != -1) {
                this.title.contributeTimes(object3, n2, n3, n4);
            }
        } else {
            throw new IllegalArgumentException("Unknown TitlePart '" + object + "'");
        }
        Object object4 = this.title.completeTitle(object3);
        if (object4 == null) {
            return;
        }
        for (Object e2 : this.viewers) {
            this.title.showTitle(e2, object4);
        }
    }

    @Override
    public void clearTitle() {
        if (this.title == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.title.clearTitle(v2);
        }
    }

    @Override
    public void resetTitle() {
        if (this.title == null) {
            return;
        }
        for (V v2 : this.viewers) {
            this.title.resetTitle(v2);
        }
    }

    @Override
    public void showBossBar(@NotNull BossBar bossBar3) {
        Facet.BossBar<BossBar> bossBar2;
        if (this.bossBar == null || this.bossBars == null) {
            return;
        }
        Map<BossBar, Facet.BossBar<V>> map = this.bossBars;
        synchronized (map) {
            bossBar2 = this.bossBars.get(bossBar3);
            if (bossBar2 == null) {
                bossBar2 = new FacetBossBarListener<V>(this.bossBar.createBossBar(this.viewers), component -> this.provider.componentRenderer.render((Component)component, this));
                this.bossBars.put(bossBar3, bossBar2);
            }
        }
        if (bossBar2.isEmpty()) {
            bossBar2.bossBarInitialized(bossBar3);
            bossBar3.addListener(bossBar2);
        }
        for (BossBar bossBar3 : this.viewers) {
            bossBar2.addViewer(bossBar3);
        }
    }

    @Override
    public void hideBossBar(@NotNull BossBar bossBar) {
        if (this.bossBars == null) {
            return;
        }
        Facet.BossBar<V> bossBar2 = this.bossBars.get(bossBar);
        if (bossBar2 == null) {
            return;
        }
        for (V v2 : this.viewers) {
            bossBar2.removeViewer(v2);
        }
        if (bossBar2.isEmpty() && this.bossBars.remove(bossBar) != null) {
            bossBar.removeListener(bossBar2);
            bossBar2.close();
        }
    }

    @Override
    public void sendPlayerListHeader(@NotNull Component object) {
        if (this.tabList != null) {
            if ((object = this.createMessage((Component)object, this.tabList)) == null) {
                return;
            }
            for (V v2 : this.viewers) {
                this.tabList.send(v2, object, null);
            }
        }
    }

    @Override
    public void sendPlayerListFooter(@NotNull Component object) {
        if (this.tabList != null) {
            if ((object = this.createMessage((Component)object, this.tabList)) == null) {
                return;
            }
            for (V v2 : this.viewers) {
                this.tabList.send(v2, null, object);
            }
        }
    }

    @Override
    public void sendPlayerListHeaderAndFooter(@NotNull Component object, @NotNull Component object2) {
        if (this.tabList != null) {
            object = this.createMessage((Component)object, this.tabList);
            object2 = this.createMessage((Component)object2, this.tabList);
            if (object == null || object2 == null) {
                return;
            }
            for (V v2 : this.viewers) {
                this.tabList.send(v2, object, object2);
            }
        }
    }

    @Override
    @NotNull
    public Pointers pointers() {
        if (this.pointers == null) {
            FacetAudience facetAudience = this;
            synchronized (facetAudience) {
                if (this.pointers == null) {
                    V v2 = this.viewer;
                    if (v2 == null) {
                        return Pointers.empty();
                    }
                    Pointers.Builder builder = Pointers.builder();
                    this.contributePointers(builder);
                    for (Facet.Pointers<V> pointers : this.pointerProviders) {
                        if (!pointers.isApplicable(v2)) continue;
                        pointers.contributePointers(v2, builder);
                    }
                    this.pointers = (Pointers)builder.build();
                    return this.pointers;
                }
            }
        }
        return this.pointers;
    }

    @ApiStatus.OverrideOnly
    protected void contributePointers(Pointers.Builder builder) {
    }

    @Override
    public void close() {
        if (this.bossBars != null) {
            for (BossBar object : new LinkedList<BossBar>(this.bossBars.keySet())) {
                this.hideBossBar(object);
            }
            this.bossBars.clear();
        }
        for (Object object : this.viewers) {
            this.removeViewer(object);
        }
        this.viewers.clear();
    }

    @Nullable
    private Object createMessage(@NotNull Component component, @NotNull Facet.Message<V, Object> message) {
        component = this.provider.componentRenderer.render(component, this);
        V v2 = this.viewer;
        if (v2 == null) {
            return null;
        }
        return message.createMessage(v2, component);
    }
}

