/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.platform.viaversion;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonParser;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import java.util.function.Function;
import me.extremall.advancedkits.libs.kyori.adventure.audience.MessageType;
import me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar;
import me.extremall.advancedkits.libs.kyori.adventure.identity.Identity;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.Facet;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.FacetBase;
import me.extremall.advancedkits.libs.kyori.adventure.platform.facet.Knob;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViaFacet<V>
extends FacetBase<V>
implements Facet.Message<V, String> {
    private static final String PACKAGE = "com.viaversion.viaversion";
    private static final int SUPPORTED_VIA_MAJOR_VERSION = 4;
    private static final boolean SUPPORTED;
    private final Function<V, UserConnection> connectionFunction;
    private final int minProtocol;

    public ViaFacet(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function, int n2) {
        super(clazz);
        this.connectionFunction = function;
        this.minProtocol = n2;
    }

    @Override
    public boolean isSupported() {
        return super.isSupported() && SUPPORTED && this.connectionFunction != null && this.minProtocol >= 0;
    }

    @Override
    public boolean isApplicable(@NotNull V v2) {
        return super.isApplicable(v2) && this.minProtocol > Via.getAPI().getServerVersion().lowestSupportedVersion() && this.findProtocol(v2) >= this.minProtocol;
    }

    @Nullable
    public UserConnection findConnection(@NotNull V v2) {
        return this.connectionFunction.apply(v2);
    }

    public int findProtocol(@NotNull V object) {
        if ((object = this.findConnection(object)) != null) {
            return object.getProtocolInfo().getProtocolVersion();
        }
        return -1;
    }

    @Override
    @NotNull
    public String createMessage(@NotNull V v2, @NotNull Component component) {
        int n2 = this.findProtocol(v2);
        if (n2 >= 713) {
            return (String)GsonComponentSerializer.gson().serialize(component);
        }
        return (String)GsonComponentSerializer.colorDownsamplingGson().serialize(component);
    }

    static {
        boolean bl2 = false;
        try {
            Class.forName("com.viaversion.viaversion.api.ViaAPI").getDeclaredMethod("majorVersion", new Class[0]);
            bl2 = Via.getAPI().majorVersion() == 4;
        }
        catch (Throwable throwable) {}
        SUPPORTED = bl2 && Knob.isEnabled("viaversion", true);
    }

    public static final class TabList<V>
    extends ProtocolBased<V>
    implements Facet.TabList<V, String> {
        public TabList(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super("1_16", "1_15_2", 713, "TAB_LIST", clazz, function);
        }

        @Override
        public final void send(V object, @Nullable String string, @Nullable String string2) {
            object = this.createPacket(object);
            object.write(Type.COMPONENT, (Object)this.parse(string));
            object.write(Type.COMPONENT, (Object)this.parse(string2));
            this.sendPacket((PacketWrapper)object);
        }
    }

    public static final class BossBar<V>
    extends ProtocolBased<V>
    implements Facet.BossBarPacket<V> {
        private final Set<V> viewers;
        private UUID id;
        private String title;
        private float health;
        private int color;
        private int overlay;
        private byte flags;

        private BossBar(@NotNull String string, @NotNull String string2, @NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function, Collection<V> collection) {
            super(string, string2, 356, "BOSSBAR", clazz, function);
            this.viewers = new CopyOnWriteArraySet<V>(collection);
        }

        @Override
        public final void bossBarInitialized(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar) {
            Facet.BossBarPacket.super.bossBarInitialized(bossBar);
            this.id = UUID.randomUUID();
            this.broadcastPacket(0);
        }

        @Override
        public final void bossBarNameChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull Component component, @NotNull Component component2) {
            if (!this.viewers.isEmpty()) {
                this.title = this.createMessage((Object)this.viewers.iterator().next(), component2);
                this.broadcastPacket(3);
            }
        }

        @Override
        public final void bossBarProgressChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, float f2, float f3) {
            this.health = f3;
            this.broadcastPacket(2);
        }

        @Override
        public final void bossBarColorChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull BossBar.Color color, @NotNull BossBar.Color color2) {
            this.color = this.createColor(color2);
            this.broadcastPacket(4);
        }

        @Override
        public final void bossBarOverlayChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull BossBar.Overlay overlay, @NotNull BossBar.Overlay overlay2) {
            this.overlay = this.createOverlay(overlay2);
            this.broadcastPacket(4);
        }

        @Override
        public final void bossBarFlagsChanged(@NotNull me.extremall.advancedkits.libs.kyori.adventure.bossbar.BossBar bossBar, @NotNull Set<BossBar.Flag> set, @NotNull Set<BossBar.Flag> set2) {
            this.flags = this.createFlag(this.flags, set, set2);
            this.broadcastPacket(5);
        }

        public final void sendPacket(@NotNull V object, int n2) {
            object = this.createPacket(object);
            object.write(Type.UUID, (Object)this.id);
            object.write((Type)Type.VAR_INT, (Object)n2);
            if (n2 == 0 || n2 == 3) {
                BossBar bossBar = this;
                object.write(Type.COMPONENT, (Object)bossBar.parse(bossBar.title));
            }
            if (n2 == 0 || n2 == 2) {
                object.write((Type)Type.FLOAT, (Object)Float.valueOf(this.health));
            }
            if (n2 == 0 || n2 == 4) {
                object.write((Type)Type.VAR_INT, (Object)this.color);
                object.write((Type)Type.VAR_INT, (Object)this.overlay);
            }
            if (n2 == 0 || n2 == 5) {
                object.write((Type)Type.BYTE, (Object)this.flags);
            }
            this.sendPacket((PacketWrapper)object);
        }

        public final void broadcastPacket(int n2) {
            if (this.isEmpty()) {
                return;
            }
            for (V v2 : this.viewers) {
                this.sendPacket(v2, n2);
            }
        }

        @Override
        public final void addViewer(@NotNull V v2) {
            if (this.viewers.add(v2)) {
                this.sendPacket(v2, 0);
            }
        }

        @Override
        public final void removeViewer(@NotNull V v2) {
            if (this.viewers.remove(v2)) {
                this.sendPacket(v2, 1);
            }
        }

        @Override
        public final boolean isEmpty() {
            return this.id == null || this.viewers.isEmpty();
        }

        @Override
        public final void close() {
            this.broadcastPacket(1);
            this.viewers.clear();
        }

        public static class Builder1_9_To_1_15<V>
        extends ViaFacet<V>
        implements Facet.BossBar.Builder<V, Facet.BossBar<V>> {
            public Builder1_9_To_1_15(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
                super(clazz, function, 356);
            }

            @Override
            public @NotNull Facet.BossBar<V> createBossBar(@NotNull Collection<V> collection) {
                return new BossBar("1_9", "1_8", this.viewerClass, this::findConnection, collection);
            }
        }

        public static class Builder<V>
        extends ViaFacet<V>
        implements Facet.BossBar.Builder<V, Facet.BossBar<V>> {
            public Builder(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
                super(clazz, function, 713);
            }

            @Override
            public @NotNull Facet.BossBar<V> createBossBar(@NotNull Collection<V> collection) {
                return new BossBar("1_16", "1_15_2", this.viewerClass, this::findConnection, collection);
            }
        }
    }

    public static class Title<V>
    extends ProtocolBased<V>
    implements Facet.TitlePacket<V, String, List<Consumer<PacketWrapper>>, Consumer<V>> {
        protected Title(@NotNull String string, @NotNull String string2, int n2, @NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super(string, string2, n2, "TITLE", clazz, function);
        }

        public Title(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            this("1_16", "1_15_2", 713, clazz, function);
        }

        @Override
        @NotNull
        public List<Consumer<PacketWrapper>> createTitleCollection() {
            return new ArrayList<Consumer<PacketWrapper>>();
        }

        @Override
        public void contributeTitle(@NotNull List<Consumer<PacketWrapper>> list, @NotNull String string) {
            list.add(packetWrapper -> {
                packetWrapper.write((Type)Type.VAR_INT, (Object)0);
                packetWrapper.write(Type.COMPONENT, (Object)this.parse(string));
            });
        }

        @Override
        public void contributeSubtitle(@NotNull List<Consumer<PacketWrapper>> list, @NotNull String string) {
            list.add(packetWrapper -> {
                packetWrapper.write((Type)Type.VAR_INT, (Object)1);
                packetWrapper.write(Type.COMPONENT, (Object)this.parse(string));
            });
        }

        @Override
        public void contributeTimes(@NotNull List<Consumer<PacketWrapper>> list, int n2, int n3, int n4) {
            list.add(packetWrapper -> {
                packetWrapper.write((Type)Type.VAR_INT, (Object)3);
                packetWrapper.write((Type)Type.INT, (Object)n2);
                packetWrapper.write((Type)Type.INT, (Object)n3);
                packetWrapper.write((Type)Type.INT, (Object)n4);
            });
        }

        @Override
        @Nullable
        public Consumer<V> completeTitle(@NotNull List<Consumer<PacketWrapper>> list) {
            return object -> {
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    PacketWrapper packetWrapper = this.createPacket(object);
                    ((Consumer)list.get(i2)).accept(packetWrapper);
                    this.sendPacket(packetWrapper);
                }
            };
        }

        @Override
        public void showTitle(@NotNull V v2, @NotNull Consumer<V> consumer) {
            consumer.accept(v2);
        }

        @Override
        public void clearTitle(@NotNull V object) {
            object = this.createPacket(object);
            object.write((Type)Type.VAR_INT, (Object)4);
            this.sendPacket((PacketWrapper)object);
        }

        @Override
        public void resetTitle(@NotNull V object) {
            object = this.createPacket(object);
            object.write((Type)Type.VAR_INT, (Object)5);
            this.sendPacket((PacketWrapper)object);
        }
    }

    public static class ActionBarTitle<V>
    extends ProtocolBased<V>
    implements Facet.ActionBar<V, String> {
        public ActionBarTitle(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super("1_11", "1_10", 310, "TITLE", clazz, function);
        }

        @Override
        public void sendMessage(@NotNull V object, @NotNull String string) {
            object = this.createPacket(object);
            object.write((Type)Type.VAR_INT, (Object)2);
            object.write(Type.COMPONENT, (Object)this.parse(string));
            this.sendPacket((PacketWrapper)object);
        }
    }

    public static class ActionBar<V>
    extends Chat<V>
    implements Facet.ActionBar<V, String> {
        public ActionBar(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super(clazz, function);
        }

        @Override
        public byte createMessageType(@NotNull MessageType messageType) {
            return 2;
        }

        @Override
        public void sendMessage(@NotNull V v2, @NotNull String string) {
            this.sendMessage(v2, Identity.nil(), string, (Object)MessageType.CHAT);
        }
    }

    public static class Chat<V>
    extends ProtocolBased<V>
    implements Facet.ChatPacket<V, String> {
        public Chat(@NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super("1_16", "1_15_2", 713, "CHAT_MESSAGE", clazz, function);
        }

        @Override
        public void sendMessage(@NotNull V object, @NotNull Identity identity, @NotNull String string, @NotNull Object object2) {
            object = this.createPacket(object);
            object.write(Type.COMPONENT, (Object)this.parse(string));
            object.write((Type)Type.BYTE, (Object)this.createMessageType(object2 instanceof MessageType ? (MessageType)((Object)object2) : MessageType.SYSTEM));
            object.write(Type.UUID, (Object)identity.uuid());
            this.sendPacket((PacketWrapper)object);
        }
    }

    public static class ProtocolBased<V>
    extends ViaFacet<V> {
        private final Class<? extends Protocol<?, ?, ?, ?>> protocolClass;
        private final Class<? extends ClientboundPacketType> packetClass;
        private final int packetId;

        protected ProtocolBased(@NotNull String clientboundPacketTypeArray, @NotNull String object, int n2, @NotNull String string, @NotNull Class<? extends V> clazz, @NotNull Function<V, UserConnection> function) {
            super(clazz, function, n2);
            String string2 = MessageFormat.format("{0}.protocols.protocol{1}to{2}.Protocol{1}To{2}", ViaFacet.PACKAGE, clientboundPacketTypeArray, object);
            clientboundPacketTypeArray = MessageFormat.format("{0}.protocols.protocol{1}to{2}.ClientboundPackets{1}", ViaFacet.PACKAGE, clientboundPacketTypeArray, object);
            object = null;
            clazz = null;
            int n3 = -1;
            try {
                object = Class.forName(string2);
                clazz = Class.forName((String)clientboundPacketTypeArray);
                for (ClientboundPacketType clientboundPacketType : (ClientboundPacketType[])clazz.getEnumConstants()) {
                    if (!clientboundPacketType.getName().equals(string)) continue;
                    n3 = clientboundPacketType.getId();
                    break;
                }
            }
            catch (Throwable throwable) {}
            this.protocolClass = object;
            this.packetClass = clazz;
            this.packetId = n3;
        }

        @Override
        public boolean isSupported() {
            return super.isSupported() && this.protocolClass != null && this.packetClass != null && this.packetId >= 0;
        }

        public PacketWrapper createPacket(@NotNull V v2) {
            return PacketWrapper.create((int)this.packetId, null, (UserConnection)this.findConnection(v2));
        }

        public void sendPacket(@NotNull PacketWrapper packetWrapper) {
            if (packetWrapper.user() == null) {
                return;
            }
            try {
                packetWrapper.scheduleSend(this.protocolClass);
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Knob.logError(throwable, "Failed to send ViaVersion packet: %s %s", packetWrapper.user(), packetWrapper);
                return;
            }
        }

        @NotNull
        public JsonElement parse(@NotNull String string) {
            return JsonParser.parseString((String)string);
        }
    }
}

