/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.regex.Matcher;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.text.BlockNBTComponentImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.NBTComponentBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.ScopedComponent;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface BlockNBTComponent
extends NBTComponent<BlockNBTComponent, Builder>,
ScopedComponent<BlockNBTComponent> {
    @NotNull
    public Pos pos();

    @Contract(pure=true)
    @NotNull
    public BlockNBTComponent pos(@NotNull Pos var1);

    @Contract(pure=true)
    @NotNull
    default public BlockNBTComponent localPos(double d2, double d3, double d4) {
        return this.pos(LocalPos.localPos(d2, d3, d4));
    }

    @Contract(pure=true)
    @NotNull
    default public BlockNBTComponent worldPos(@NotNull WorldPos.Coordinate coordinate, @NotNull WorldPos.Coordinate coordinate2, @NotNull WorldPos.Coordinate coordinate3) {
        return this.pos(WorldPos.worldPos(coordinate, coordinate2, coordinate3));
    }

    @Contract(pure=true)
    @NotNull
    default public BlockNBTComponent absoluteWorldPos(int n2, int n3, int n4) {
        return this.worldPos(WorldPos.Coordinate.absolute(n2), WorldPos.Coordinate.absolute(n3), WorldPos.Coordinate.absolute(n4));
    }

    @Contract(pure=true)
    @NotNull
    default public BlockNBTComponent relativeWorldPos(int n2, int n3, int n4) {
        return this.worldPos(WorldPos.Coordinate.relative(n2), WorldPos.Coordinate.relative(n3), WorldPos.Coordinate.relative(n4));
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.concat(Stream.of(ExaminableProperty.of("pos", this.pos())), NBTComponent.super.examinableProperties());
    }

    public static interface WorldPos
    extends Pos {
        @NotNull
        public static WorldPos worldPos(@NotNull Coordinate coordinate, @NotNull Coordinate coordinate2, @NotNull Coordinate coordinate3) {
            return new BlockNBTComponentImpl.WorldPosImpl(coordinate, coordinate2, coordinate3);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static WorldPos of(@NotNull Coordinate coordinate, @NotNull Coordinate coordinate2, @NotNull Coordinate coordinate3) {
            return new BlockNBTComponentImpl.WorldPosImpl(coordinate, coordinate2, coordinate3);
        }

        @NotNull
        public Coordinate x();

        @NotNull
        public Coordinate y();

        @NotNull
        public Coordinate z();

        public static interface Coordinate
        extends Examinable {
            @NotNull
            public static Coordinate absolute(int n2) {
                return Coordinate.coordinate(n2, Type.ABSOLUTE);
            }

            @NotNull
            public static Coordinate relative(int n2) {
                return Coordinate.coordinate(n2, Type.RELATIVE);
            }

            @NotNull
            public static Coordinate coordinate(int n2, @NotNull Type type) {
                return new BlockNBTComponentImpl.WorldPosImpl.CoordinateImpl(n2, type);
            }

            @Deprecated
            @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
            @NotNull
            public static Coordinate of(int n2, @NotNull Type type) {
                return new BlockNBTComponentImpl.WorldPosImpl.CoordinateImpl(n2, type);
            }

            public int value();

            @NotNull
            public Type type();

            public static enum Type {
                ABSOLUTE,
                RELATIVE;

            }
        }
    }

    public static interface LocalPos
    extends Pos {
        @NotNull
        public static LocalPos localPos(double d2, double d3, double d4) {
            return new BlockNBTComponentImpl.LocalPosImpl(d2, d3, d4);
        }

        @Deprecated
        @ApiStatus.ScheduledForRemoval(inVersion="5.0.0")
        @NotNull
        public static LocalPos of(double d2, double d3, double d4) {
            return new BlockNBTComponentImpl.LocalPosImpl(d2, d3, d4);
        }

        public double left();

        public double up();

        public double forwards();
    }

    public static interface Pos
    extends Examinable {
        @NotNull
        public static Pos fromString(@NotNull String string) throws IllegalArgumentException {
            Matcher matcher = BlockNBTComponentImpl.Tokens.LOCAL_PATTERN.matcher(string);
            if (matcher.matches()) {
                return LocalPos.localPos(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(3)), Double.parseDouble(matcher.group(5)));
            }
            matcher = BlockNBTComponentImpl.Tokens.WORLD_PATTERN.matcher(string);
            if (matcher.matches()) {
                return WorldPos.worldPos(BlockNBTComponentImpl.Tokens.deserializeCoordinate(matcher.group(1), matcher.group(2)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(matcher.group(3), matcher.group(4)), BlockNBTComponentImpl.Tokens.deserializeCoordinate(matcher.group(5), matcher.group(6)));
            }
            throw new IllegalArgumentException("Cannot convert position specification '" + string + "' into a position");
        }

        @NotNull
        public String asString();
    }

    public static interface Builder
    extends NBTComponentBuilder<BlockNBTComponent, Builder> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder pos(@NotNull Pos var1);

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder localPos(double d2, double d3, double d4) {
            return this.pos(LocalPos.localPos(d2, d3, d4));
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder worldPos(@NotNull WorldPos.Coordinate coordinate, @NotNull WorldPos.Coordinate coordinate2, @NotNull WorldPos.Coordinate coordinate3) {
            return this.pos(WorldPos.worldPos(coordinate, coordinate2, coordinate3));
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder absoluteWorldPos(int n2, int n3, int n4) {
            return this.worldPos(WorldPos.Coordinate.absolute(n2), WorldPos.Coordinate.absolute(n3), WorldPos.Coordinate.absolute(n4));
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        default public Builder relativeWorldPos(int n2, int n3, int n4) {
            return this.worldPos(WorldPos.Coordinate.relative(n2), WorldPos.Coordinate.relative(n3), WorldPos.Coordinate.relative(n4));
        }
    }
}

